/*
 * Decompiled with CFR 0.152.
 */
package jfig.utils;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import jfig.utils.Format;

public class Xspline {
    Point[] points;
    double[] sfactors;
    private int npoints;
    private int[] _x;
    private int[] _y;
    final double LOW_PRECISION;
    final double HIGH_PRECISION;
    final double MAX_SPLINE_STEP;

    public void setPoints(Point[] pointArray, double[] dArray) {
        this.points = pointArray;
        this.sfactors = dArray;
        this.npoints = 0;
    }

    public Point[] getComputedPointArray() {
        Point[] pointArray = new Point[this.npoints];
        int n = 0;
        while (n < this.npoints) {
            pointArray[n] = new Point(this._x[n], this._y[n]);
            ++n;
        }
        return pointArray;
    }

    public void compute_open_spline() {
        double d = 1.0;
        if (this.points.length > 3) {
            Point point = this.points[0];
            double d2 = this.sfactors[0];
            Point point2 = this.points[0];
            double d3 = this.sfactors[0];
            Point point3 = this.points[1];
            double d4 = this.sfactors[1];
            Point point4 = this.points[2];
            double d5 = this.sfactors[2];
            int n = 0;
            int n2 = this.points.length - 3;
            n = 0;
            while (true) {
                this.spline_segment_loop(n, point, point2, point3, point4, d3, d4, d);
                if (n >= n2) break;
                point = point2;
                d2 = d3;
                point2 = point3;
                d3 = d4;
                point3 = point4;
                d4 = d5;
                point4 = this.points[n + 3];
                d5 = this.sfactors[n + 3];
                ++n;
            }
            point = point2;
            d2 = d3;
            point2 = point3;
            d3 = d4;
            point3 = point4;
            d4 = d5;
            this.spline_segment_loop(n + 1, point, point2, point3, point4, d3, d4, d);
            this.addPoint(this.points[this.points.length - 1].x, this.points[this.points.length - 1].y);
        } else if (this.points.length == 3) {
            Point point = this.points[0];
            Point point5 = this.points[0];
            Point point6 = this.points[1];
            Point point7 = this.points[2];
            double d6 = this.sfactors[0];
            double d7 = this.sfactors[1];
            this.spline_segment_loop(0, point, point5, point6, point7, d6, d7, d);
            point = this.points[0];
            point5 = this.points[1];
            point6 = this.points[2];
            point7 = this.points[2];
            d6 = this.sfactors[1];
            d7 = this.sfactors[2];
            this.spline_segment_loop(1, point, point5, point6, point7, d6, d7, d);
            this.addPoint(this.points[this.points.length - 1].x, this.points[this.points.length - 1].y);
        }
    }

    public void compute_closed_spline() {
        double d;
        Point point;
        double d2 = 1.0;
        Point point2 = this.points[0];
        double d3 = this.sfactors[0];
        Point point3 = this.points[1];
        double d4 = this.sfactors[1];
        Point point4 = this.points[2];
        double d5 = this.sfactors[2];
        if (this.points.length == 3) {
            point = this.points[0];
            d = this.sfactors[0];
        } else {
            point = this.points[3];
            d = this.sfactors[3];
        }
        int n = 0;
        int n2 = this.points.length - 4;
        if (this.points.length > 3) {
            n = 0;
            while (true) {
                this.spline_segment_loop(n, point2, point3, point4, point, d4, d5, d2);
                if (n >= n2) break;
                point2 = point3;
                d3 = d4;
                point3 = point4;
                d4 = d5;
                point4 = point;
                d5 = d;
                point = this.points[n + 4];
                d = this.sfactors[n + 4];
                ++n;
            }
            point2 = point3;
            d3 = d4;
            point3 = point4;
            d4 = d5;
            point4 = point;
            d5 = d;
            point = this.points[0];
            d = this.sfactors[0];
            this.spline_segment_loop(n, point2, point3, point4, point, d4, d5, d2);
            point2 = point3;
            d3 = d4;
            point3 = point4;
            d4 = d5;
            point4 = point;
            d5 = d;
            point = this.points[1];
            d = this.sfactors[1];
            this.spline_segment_loop(n, point2, point3, point4, point, d4, d5, d2);
            point2 = point3;
            d3 = d4;
            point3 = point4;
            d4 = d5;
            point4 = point;
            d5 = d;
            point = this.points[2];
            d = this.sfactors[2];
            this.spline_segment_loop(n, point2, point3, point4, point, d4, d5, d2);
        } else {
            point2 = this.points[0];
            d3 = this.sfactors[0];
            point3 = this.points[1];
            d4 = this.sfactors[1];
            point4 = this.points[2];
            d5 = this.sfactors[2];
            this.spline_segment_loop(0, point2, point3, point4, point2, d4, d5, d2);
            this.spline_segment_loop(0, point3, point4, point2, point3, d5, d3, d2);
            this.spline_segment_loop(0, point4, point2, point3, point4, d3, d4, d2);
        }
        this.addPoint(this._x[0], this._y[0]);
    }

    void spline_segment_loop(int n, Point point, Point point2, Point point3, Point point4, double d, double d2, double d3) {
        double d4 = this.step_computing(n, point, point2, point3, point4, d, d2, d3);
        this.spline_segment_computing(d4, n, point, point2, point3, point4, d, d2);
    }

    public double step_computing(int n, Point point, Point point2, Point point3, Point point4, double d, double d2, double d3) {
        double d4;
        double d5;
        double d6;
        double d7;
        if (d == 0.0 && d2 == 0.0) {
            return 1.0;
        }
        Point point5 = new Point();
        Point point6 = new Point();
        Point point7 = new Point();
        double d8 = 0.0;
        if (d > 0.0) {
            if (d2 < 0.0) {
                d7 = this.positive_s1_influence_a0(n, 0.0, d);
                d6 = this.positive_s1_influence_a2(n, 0.0, d);
                d5 = this.g_blend(1.0, this.Q(d2));
                d4 = this.h_blend(-1.0, this.Q(d2));
            } else {
                d7 = this.positive_s1_influence_a0(n, 0.0, d);
                d6 = this.positive_s1_influence_a2(n, 0.0, d);
                d5 = this.positive_s2_influence_a1(n, 0.0, d2);
                d4 = this.positive_s2_influence_a3(n, 0.0, d2);
            }
            this.point_computing(d7, d5, d6, d4, point, point2, point3, point4, point5);
        } else {
            point5.x = point2.x;
            point5.y = point2.y;
        }
        if (d2 > 0.0) {
            if (d < 0.0) {
                d7 = this.h_blend(-1.0, this.Q(d));
                d6 = this.g_blend(1.0, this.Q(d));
                d5 = this.positive_s2_influence_a1(n, 1.0, d2);
                d4 = this.positive_s2_influence_a3(n, 1.0, d2);
            } else {
                d7 = this.positive_s1_influence_a0(n, 1.0, d);
                d6 = this.positive_s1_influence_a2(n, 1.0, d);
                d5 = this.positive_s2_influence_a1(n, 1.0, d2);
                d4 = this.positive_s2_influence_a3(n, 1.0, d2);
            }
            this.point_computing(d7, d5, d6, d4, point, point2, point3, point4, point6);
        } else {
            point6.x = point3.x;
            point6.y = point3.y;
        }
        if (d2 > 0.0) {
            if (d < 0.0) {
                d7 = this.h_blend(-0.5, this.Q(d));
                d6 = this.g_blend(0.5, this.Q(d));
                d5 = this.positive_s2_influence_a1(n, 0.5, d2);
                d4 = this.positive_s2_influence_a3(n, 0.5, d2);
            } else {
                d7 = this.positive_s1_influence_a0(n, 0.5, d);
                d6 = this.positive_s1_influence_a2(n, 0.5, d);
                d5 = this.positive_s2_influence_a1(n, 0.5, d2);
                d4 = this.positive_s2_influence_a3(n, 0.5, d2);
            }
        } else if (d < 0.0) {
            d7 = this.h_blend(-0.5, this.Q(d));
            d6 = this.g_blend(0.5, this.Q(d));
            d5 = this.g_blend(0.5, this.Q(d2));
            d4 = this.h_blend(-0.5, this.Q(d2));
        } else {
            d7 = this.positive_s1_influence_a0(n, 0.5, d);
            d6 = this.positive_s1_influence_a2(n, 0.5, d);
            d5 = this.g_blend(0.5, this.Q(d2));
            d4 = this.h_blend(-0.5, this.Q(d2));
        }
        this.point_computing(d7, d5, d6, d4, point, point2, point3, point4, point7);
        double d9 = point5.x - point7.x;
        double d10 = point5.y - point7.y;
        double d11 = point6.x - point7.x;
        double d12 = point6.y - point7.y;
        double d13 = d9 * d11 + d10 * d12;
        double d14 = Math.sqrt((d9 * d9 + d10 * d10) * (d11 * d11 + d12 * d12));
        double d15 = d14 == 0.0 ? 0.0 : d13 / d14;
        int n2 = point6.x - point5.x;
        int n3 = point6.y - point5.y;
        double d16 = Math.sqrt(n2 * n2 + n3 * n3);
        double d17 = Math.sqrt(d16) / 2.0;
        d8 = (d17 += (double)((int)((1.0 + d15) * 10.0))) == 0.0 ? 1.0 : d3 / d17;
        if (d8 > 0.2 || d8 == 0.0) {
            d8 = 0.2;
        }
        return d8;
    }

    private void spline_segment_computing(double d, int n, Point point, Point point2, Point point3, Point point4, double d2, double d3) {
        if (d2 < 0.0) {
            if (d3 < 0.0) {
                double d4 = 0.0;
                while (d4 < 1.0) {
                    double d5 = this.h_blend(-d4, this.Q(d2));
                    double d6 = this.g_blend(d4, this.Q(d2));
                    double d7 = this.g_blend(1.0 - d4, this.Q(d3));
                    double d8 = this.h_blend(d4 - 1.0, this.Q(d3));
                    this.point_adding(d5, d7, d6, d8, point, point2, point3, point4);
                    d4 += d;
                }
            } else {
                double d9 = 0.0;
                while (d9 < 1.0) {
                    double d10 = this.h_blend(-d9, this.Q(d2));
                    double d11 = this.g_blend(d9, this.Q(d2));
                    double d12 = this.positive_s2_influence_a1(n, d9, d3);
                    double d13 = this.positive_s2_influence_a3(n, d9, d3);
                    this.point_adding(d10, d12, d11, d13, point, point2, point3, point4);
                    d9 += d;
                }
            }
        } else if (d3 < 0.0) {
            double d14 = 0.0;
            while (d14 < 1.0) {
                double d15 = this.positive_s1_influence_a0(n, d14, d2);
                double d16 = this.positive_s1_influence_a2(n, d14, d2);
                double d17 = this.g_blend(1.0 - d14, this.Q(d3));
                double d18 = this.h_blend(d14 - 1.0, this.Q(d3));
                this.point_adding(d15, d17, d16, d18, point, point2, point3, point4);
                d14 += d;
            }
        } else {
            double d19 = 0.0;
            while (d19 < 1.0) {
                double d20 = this.positive_s1_influence_a0(n, d19, d2);
                double d21 = this.positive_s1_influence_a2(n, d19, d2);
                double d22 = this.positive_s2_influence_a1(n, d19, d3);
                double d23 = this.positive_s2_influence_a3(n, d19, d3);
                this.point_adding(d20, d22, d21, d23, point, point2, point3, point4);
                d19 += d;
            }
        }
    }

    private final double Q(double d) {
        return -d;
    }

    private final double f_blend(double d, double d2) {
        double d3 = 2.0 * d2 * d2;
        double d4 = d / d2;
        double d5 = d4 * d4;
        return d4 * d5 * (10.0 - d3 + (2.0 * d3 - 15.0) * d4 + (6.0 - d3) * d5);
    }

    private final double g_blend(double d, double d2) {
        return d * (d2 + d * (2.0 * d2 + d * (8.0 - 12.0 * d2 + d * (14.0 * d2 - 11.0 + d * (4.0 - 5.0 * d2)))));
    }

    private final double h_blend(double d, double d2) {
        double d3 = d * d;
        return d * (d2 + d * (2.0 * d2 + d3 * (-2.0 * d2 - d * d2)));
    }

    private final double positive_s1_influence_a0(int n, double d, double d2) {
        double d3 = (double)(n + 1) + d2;
        return d + (double)n + 1.0 < d3 ? this.f_blend(d + (double)n + 1.0 - d3, (double)n - d3) : 0.0;
    }

    private final double positive_s1_influence_a2(int n, double d, double d2) {
        double d3 = (double)(n + 1) - d2;
        return this.f_blend(d + (double)n + 1.0 - d3, (double)(n + 2) - d3);
    }

    private final double positive_s2_influence_a1(int n, double d, double d2) {
        double d3 = (double)(n + 2) + d2;
        return this.f_blend(d + (double)n + 1.0 - d3, (double)(n + 1) - d3);
    }

    private final double positive_s2_influence_a3(int n, double d, double d2) {
        double d3 = (double)(n + 2) - d2;
        return d + (double)n + 1.0 > d3 ? this.f_blend(d + (double)n + 1.0 - d3, (double)(n + 3) - d3) : 0.0;
    }

    private final void point_adding(double d, double d2, double d3, double d4, Point point, Point point2, Point point3, Point point4) {
        double d5 = d + d2 + d3 + d4;
        double d6 = d * (double)point.x + d2 * (double)point2.x + d3 * (double)point3.x + d4 * (double)point4.x;
        double d7 = d * (double)point.y + d2 * (double)point2.y + d3 * (double)point3.y + d4 * (double)point4.y;
        this.addPoint((int)Math.round(d6 / d5), (int)Math.round(d7 / d5));
    }

    private final void point_computing(double d, double d2, double d3, double d4, Point point, Point point2, Point point3, Point point4, Point point5) {
        double d5 = d + d2 + d3 + d4;
        double d6 = d * (double)point.x + d2 * (double)point2.x + d3 * (double)point3.x + d4 * (double)point4.x;
        double d7 = d * (double)point.y + d2 * (double)point2.y + d3 * (double)point3.y + d4 * (double)point4.y;
        point5.x = (int)Math.round(d6 / d5);
        point5.y = (int)Math.round(d7 / d5);
    }

    void addPoint(int n, int n2) {
        if (this.npoints == 0) {
            this._x = new int[300];
            this._y = new int[300];
        } else if (this.npoints >= this._x.length) {
            int[] nArray = new int[2 * this._x.length];
            int[] nArray2 = new int[2 * this._y.length];
            int n3 = 0;
            while (n3 < this._x.length) {
                nArray[n3] = this._x[n3];
                nArray2[n3] = this._y[n3];
                ++n3;
            }
            this._x = nArray;
            this._y = nArray2;
        }
        if (this.npoints > 0 && n == this._x[this.npoints - 1] && n2 == this._y[this.npoints - 1]) {
            return;
        }
        this._x[this.npoints] = n;
        this._y[this.npoints] = n2;
        ++this.npoints;
    }

    public void drawSpline(Graphics graphics) {
        graphics.setColor(Color.black);
        graphics.fillOval(this.points[0].x - 3, this.points[0].y - 3, 6, 6);
        int n = 0;
        while (n < this.sfactors.length) {
            String string = new Format("%3.1f").form(this.sfactors[n]);
            graphics.drawString(string, this.points[n].x + 5, this.points[n].y);
            ++n;
        }
        graphics.setColor(Color.blue);
        n = 1;
        while (n < this.points.length) {
            graphics.drawLine(this.points[n - 1].x, this.points[n - 1].y, this.points[n].x, this.points[n].y);
            ++n;
        }
        graphics.setColor(Color.orange);
        n = this.points.length - 1;
        graphics.drawLine(this.points[n].x, this.points[n].y, this.points[0].x, this.points[0].y);
        graphics.setColor(Color.red);
        int n2 = 1;
        while (n2 < this.npoints) {
            graphics.drawLine(this._x[n2 - 1], this._y[n2 - 1], this._x[n2], this._y[n2]);
            ++n2;
        }
    }

    public static void msg(String string) {
        System.out.println(string);
    }

    public static void main(String[] stringArray) {
        Xspline.msg("X-spline test...");
        Point[] pointArray = new Point[]{new Point(100, 100), new Point(300, 100), new Point(300, 300), new Point(100, 250), new Point(200, 150)};
        double[] dArray = new double[]{0.0, 1.0, 1.0, 1.0, 0.0};
        Xspline xspline = new Xspline(pointArray, dArray);
        xspline.compute_open_spline();
        Xspline xspline2 = xspline;
        if (xspline2 == null) {
            throw null;
        }
        DemoFrame demoFrame = xspline2.new DemoFrame();
        demoFrame.setSize(400, 400);
        demoFrame.setXspline(xspline);
        demoFrame.show();
        Xspline xspline3 = xspline;
        if (xspline3 == null) {
            throw null;
        }
        RandomOpenSplineGenerator randomOpenSplineGenerator = xspline3.new RandomOpenSplineGenerator(xspline, demoFrame);
        demoFrame.addMouseListener(randomOpenSplineGenerator);
        Xspline xspline4 = new Xspline(pointArray, dArray);
        xspline4.compute_closed_spline();
        Xspline xspline5 = xspline;
        if (xspline5 == null) {
            throw null;
        }
        DemoFrame demoFrame2 = xspline5.new DemoFrame();
        demoFrame2.setSize(400, 400);
        demoFrame2.setXspline(xspline4);
        demoFrame2.show();
        Xspline xspline6 = xspline4;
        if (xspline6 == null) {
            throw null;
        }
        RandomClosedSplineGenerator randomClosedSplineGenerator = xspline6.new RandomClosedSplineGenerator(xspline4, demoFrame2);
        demoFrame2.addMouseListener(randomClosedSplineGenerator);
    }

    public Xspline(Point[] pointArray, double[] dArray) {
        this.LOW_PRECISION = 1.0;
        this.HIGH_PRECISION = 0.5;
        this.MAX_SPLINE_STEP = 0.2;
        this.points = pointArray;
        this.sfactors = dArray;
        this.npoints = 0;
    }

    class DemoFrame
    extends Frame {
        Xspline xspline = null;

        public void setXspline(Xspline xspline) {
            this.xspline = xspline;
        }

        public void paint(Graphics graphics) {
            this.xspline.drawSpline(graphics);
        }
    }

    class RandomOpenSplineGenerator
    extends MouseAdapter {
        Xspline xspline;
        Component component;

        public void mouseClicked(MouseEvent mouseEvent) {
            this.newRandomOpenSpline();
            this.component.repaint();
        }

        public void newRandomOpenSpline() {
            Point[] pointArray = new Point[3];
            pointArray[0] = new Point(50 + (int)(300.0 * Math.random()), 50 + (int)(300.0 * Math.random()));
            int n = 1;
            while (n < pointArray.length) {
                pointArray[n] = new Point(this.clip(pointArray[n - 1].x - 100 + (int)(200.0 * Math.random())), this.clip(pointArray[n - 1].y - 100 + (int)(200.0 * Math.random())));
                ++n;
            }
            double[] dArray = new double[pointArray.length];
            int n2 = 1;
            while (n2 < dArray.length - 1) {
                dArray[n2] = -1.0 + 2.0 * Math.random();
                ++n2;
            }
            dArray[pointArray.length - 1] = 0.0;
            dArray[0] = 0.0;
            this.xspline.setPoints(pointArray, dArray);
            this.xspline.compute_open_spline();
        }

        public int clip(int n) {
            if (n < 50) {
                return 50;
            }
            if (n > 350) {
                return 350;
            }
            return n;
        }

        public RandomOpenSplineGenerator(Xspline xspline2, Component component) {
            this.xspline = xspline2;
            this.component = component;
        }
    }

    class RandomClosedSplineGenerator
    extends MouseAdapter {
        Xspline xspline;
        Component component;

        public void mouseClicked(MouseEvent mouseEvent) {
            this.newRandomClosedSpline();
            this.component.repaint();
        }

        public void newRandomClosedSpline() {
            Point[] pointArray = new Point[3 + (int)(4.0 * Math.random())];
            double d = Math.PI * 2 / (double)pointArray.length;
            int n = 0;
            while (n < pointArray.length) {
                pointArray[n] = new Point(this.clip(200 + (int)(100.0 * Math.cos((double)n * d))), this.clip(200 + (int)(100.0 * Math.sin((double)n * d))));
                ++n;
            }
            double[] dArray = new double[pointArray.length];
            int n2 = 0;
            while (n2 < dArray.length) {
                dArray[n2] = -1.0 + 2.0 * Math.random();
                ++n2;
            }
            this.xspline.setPoints(pointArray, dArray);
            this.xspline.compute_closed_spline();
        }

        public int clip(int n) {
            if (n < 50) {
                return 50;
            }
            if (n > 350) {
                return 350;
            }
            return n;
        }

        public RandomClosedSplineGenerator(Xspline xspline2, Component component) {
            this.xspline = xspline2;
            this.component = component;
        }
    }
}

