/*
 * Decompiled with CFR 0.152.
 */
package jfig.utils;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import jfig.canvas.FigCanvas;
import jfig.canvas.FigSwingCanvas;
import jfig.gui.JFigViewerBean;
import jfig.objects.FigCompound;
import jfig.utils.LP2;

public class TeXtoPNGConverter {
    String texFileName;
    String outFileName;
    JFrame dummy;
    JFigViewerBean bean;
    FigCanvas canvas;
    LP2 parser;

    public void createBean() {
        this.dummy = new JFrame();
        this.bean = new JFigViewerBean();
        this.bean.setGridMode(0);
        this.bean.setShowRulers(false);
        this.bean.getFigCanvas().changeRubberbandMode(0);
        this.bean.setAntiAlias(true);
        this.bean.setPreferredSize(new Dimension(200, 50));
        this.bean.doZoom11();
        this.dummy.getContentPane().add("Center", this.bean);
        this.dummy.show();
        this.dummy.setVisible(false);
    }

    public String readTeX() {
        try {
            FileInputStream fileInputStream = new FileInputStream(this.texFileName);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            String string = bufferedReader.readLine();
            bufferedReader.close();
            return string;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "";
        }
    }

    public void parse(String string) {
        this.parse(string, 2, 17, 0, false);
    }

    public void parse(String string, int n, int n2, int n3, boolean bl) {
        this.parser = new LP2();
        this.parser.setFontIndex(n);
        this.parser.setFontPtSize(n2);
        this.parser.setColorIndex(n3);
        this.parser.setEnableDisplayBoxes(bl);
        this.parser.setEnableDumpTokens(false);
        this.parser.parse(string);
        FigCompound figCompound = new FigCompound();
        this.parser.convertToFig(figCompound);
        figCompound.setTrafo(this.bean.getFigCanvas().getTrafo());
        figCompound.move(300, 900);
        figCompound.update_bbox();
        int n4 = 2;
        int n5 = n4 + (figCompound.getBbox().getXr() - figCompound.getBbox().getXl()) / 32;
        int n6 = n4 + (figCompound.getBbox().getYb() - figCompound.getBbox().getYt()) / 32;
        this.bean.getObjectList().deleteAll();
        this.bean.getObjectList().insert(figCompound);
        this.bean.setPreferredSize(new Dimension(n5, n6));
        this.bean.setMinimumSize(new Dimension(n5, n6));
        this.dummy.pack();
        ((FigSwingCanvas)this.bean.getFigCanvas()).setZoomFitBorderWidth(3);
        this.bean.doZoomFit();
        TeXtoPNGConverter.msg("...preferred size: " + n5 + "x" + n6 + ".");
        this.bean.doFullRedraw();
    }

    public void writePNG() {
        try {
            Object object;
            this.canvas = this.bean.getFigCanvas();
            int n = this.bean.getPreferredSize().width;
            int n2 = this.bean.getPreferredSize().height;
            BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
            TeXtoPNGConverter.msg("...drawing objects ...");
            Graphics graphics = bufferedImage.getGraphics();
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, n, n2);
            graphics.setColor(Color.black);
            try {
                object = new RenderingHints(null);
                ((RenderingHints)object).put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                ((RenderingHints)object).put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                ((Graphics2D)graphics).setRenderingHints((Map<?, ?>)object);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.canvas.drawAllObjects(graphics);
            TeXtoPNGConverter.msg("...encoding image...");
            TeXtoPNGConverter.msg("...writing image to file...");
            object = new FileOutputStream(this.outFileName);
            ImageIO.write((RenderedImage)bufferedImage, "PNG", (OutputStream)object);
            ((FileOutputStream)object).close();
            TeXtoPNGConverter.msg("ok.");
        }
        catch (Exception exception) {
            TeXtoPNGConverter.msg("-E- Internal error in writePNG: " + exception);
            exception.printStackTrace();
        }
    }

    public void parseTeXandWritePNG(String string, String string2) {
        this.parseTeXandWritePNG(string, 2, 17, 0, false, string2);
    }

    public void parseTeXandWritePNG(String string, int n, int n2, int n3, boolean bl, String string2) {
        if (this.dummy == null) {
            this.createBean();
        }
        this.parse(string, n, n2, n3, bl);
        this.outFileName = string2;
        this.writePNG();
    }

    public static void msg(String string) {
        System.out.println(string);
    }

    public static void usage() {
        System.out.println("Usage: java jfig.utils.TeXtoPNGConverter inputfile.tex outputfile.png\nwhere inputfile.tex contains TeX-formatted input \nand the generated PNG image is written to outputfile.png\n");
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 2) {
            TeXtoPNGConverter.usage();
        }
        try {
            TeXtoPNGConverter teXtoPNGConverter = new TeXtoPNGConverter();
            teXtoPNGConverter.texFileName = stringArray[0];
            teXtoPNGConverter.outFileName = stringArray[1];
            teXtoPNGConverter.createBean();
            String string = teXtoPNGConverter.readTeX();
            teXtoPNGConverter.parse(string);
            teXtoPNGConverter.writePNG();
            System.exit(0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

