/*
 * Decompiled with CFR 0.152.
 */
package jfig.utils;

import java.awt.Color;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import jfig.utils.ExceptionTracer;

public class SetupManager {
    static SetupManager _setupManager = null;
    static Properties properties;
    static Properties globals;
    static Properties userprops;
    static Properties locals;
    static boolean debug;
    private static /* synthetic */ Class class$Ljfig$utils$SetupManager;

    public static SetupManager getSetupManager() {
        if (_setupManager == null) {
            _setupManager = new SetupManager();
        }
        return _setupManager;
    }

    public static Properties getProperties() {
        return properties;
    }

    public static String getProperty(String string, String string2) {
        return properties.getProperty(string, string2);
    }

    public static String getProperty(String string) {
        return properties.getProperty(string);
    }

    public static int getInteger(String string, int n) {
        String string2 = SetupManager.getProperty(string);
        if (string2 == null) {
            return n;
        }
        try {
            int n2 = Integer.parseInt(string2);
            return n2;
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public static boolean getBoolean(String string, boolean bl) {
        String string2 = SetupManager.getProperty(string);
        if (string2 == null) {
            return bl;
        }
        if (string2.trim().toLowerCase().equals("true")) {
            return true;
        }
        if (string2.trim().toLowerCase().equals("false")) {
            return false;
        }
        return bl;
    }

    public static double getDouble(String string, double d) {
        String string2 = SetupManager.getProperty(string);
        try {
            return Double.valueOf(string2.trim());
        }
        catch (Exception exception) {
            return d;
        }
    }

    public static Color getColor(String string, Color color) {
        String string2 = SetupManager.getProperty(string);
        if (string2 == null) {
            return color;
        }
        try {
            Color color2 = new Color(Integer.decode(string2));
            return color2;
        }
        catch (Exception exception) {
            SetupManager.message("-E- Illegal Color String '" + string2 + "' for key: " + string);
            return color;
        }
    }

    public static void setProperty(String string, String string2) {
        if (string != null && string2 != null) {
            properties.put(string, string2);
        }
    }

    public static void loadAllProperties(String string) {
        SetupManager.loadGlobalProperties(string);
        SetupManager.loadUserProperties(string);
        SetupManager.loadLocalProperties(string);
    }

    public static void loadGlobalProperties(String string) {
        if (debug) {
            SetupManager.message("-I- loading global props: " + string);
        }
        SetupManager.getSetupManager();
        globals = new Properties();
        InputStream inputStream = null;
        try {
            if (!string.startsWith("/")) {
                string = "/" + string;
            }
            inputStream = (class$Ljfig$utils$SetupManager != null ? class$Ljfig$utils$SetupManager : (class$Ljfig$utils$SetupManager = SetupManager.class$("jfig.utils.SetupManager"))).getResourceAsStream(string);
            globals.load(inputStream);
        }
        catch (Exception exception) {
            ExceptionTracer.message("-W- Couldn't load global properties from '" + string + "'");
        }
        SetupManager.merge(properties, globals);
    }

    public static void loadUserProperties(String string) {
        SetupManager.getSetupManager();
        userprops = new Properties();
        FileInputStream fileInputStream = null;
        String string2 = null;
        try {
            string2 = properties.getProperty("user.home") + properties.getProperty("file.separator") + string;
            if (debug) {
                SetupManager.message("-I- loading user props: " + string2);
            }
            fileInputStream = new FileInputStream(string2);
            userprops.load(fileInputStream);
            fileInputStream.close();
        }
        catch (Exception exception) {
            ExceptionTracer.message("-W- Couldn't load user properties from '" + string2 + "'");
        }
        SetupManager.merge(properties, userprops);
    }

    public static void loadLocalProperties(String string) {
        SetupManager.getSetupManager();
        FileInputStream fileInputStream = null;
        String string2 = null;
        try {
            string2 = properties.getProperty("user.dir") + properties.getProperty("file.separator") + string;
            if (debug) {
                SetupManager.message("-I- loading local props: " + string2);
            }
            fileInputStream = new FileInputStream(string2);
            SetupManager.loadLocalProperties(fileInputStream);
        }
        catch (Exception exception) {
            ExceptionTracer.message("-W- Couldn't load local properties from stream '" + string2 + "'");
        }
    }

    public static void loadLocalProperties(InputStream inputStream) {
        locals = new Properties();
        try {
            locals.load(inputStream);
            inputStream.close();
        }
        catch (Exception exception) {
            ExceptionTracer.message("-W- Couldn't load local properties from stream '" + inputStream + "'");
        }
        SetupManager.merge(properties, locals);
    }

    public static void loadURLProperties(String string) {
        SetupManager.getSetupManager();
        locals = new Properties();
        try {
            URL uRL = new URL(string);
            uRL.openConnection();
            InputStream inputStream = uRL.openStream();
            locals.load(inputStream);
            inputStream.close();
        }
        catch (Exception exception) {
            ExceptionTracer.message("-W- got: " + exception);
            ExceptionTracer.message("-W- Couldn't load properties from '" + string + "'");
        }
        SetupManager.merge(properties, locals);
    }

    public static void save(OutputStream outputStream, String string) {
        try {
            properties.store(outputStream, string);
        }
        catch (Exception exception) {
            SetupManager.message("-E- Failed to save the properties: " + exception);
            exception.printStackTrace();
        }
    }

    public static void saveUserProperties(String string, String string2) {
        block2: {
            FileOutputStream fileOutputStream = null;
            String string3 = null;
            try {
                string3 = string2;
                fileOutputStream = new FileOutputStream(string3);
                Properties properties = new Properties();
                SetupManager.merge(properties, userprops);
                SetupManager.merge(properties, locals);
                properties.store(fileOutputStream, string);
                fileOutputStream.flush();
                ((OutputStream)fileOutputStream).close();
                SetupManager.message("-I- Saved setup to file '" + string3 + "'");
            }
            catch (Exception exception) {
                if (!debug) break block2;
                SetupManager.message("-W- Couldn't load local properties from '" + string3 + "'");
                SetupManager.message("-W- loadLocalProperites: " + exception);
            }
        }
    }

    public static void saveLocalProperties(String string, String string2) {
        FileOutputStream fileOutputStream = null;
        String string3 = null;
        try {
            string3 = SetupManager.getProperty("user.dir") + SetupManager.getProperty("file.separator") + string2;
            fileOutputStream = new FileOutputStream(string3);
            Properties properties = new Properties();
            SetupManager.merge(properties, userprops);
            SetupManager.merge(properties, locals);
            properties.store(fileOutputStream, string);
            fileOutputStream.flush();
            ((OutputStream)fileOutputStream).close();
            SetupManager.message("-I- Saved setup to file '" + string3 + "'");
        }
        catch (Exception exception) {
            SetupManager.message("-E- Couldn't load local properties from '" + string3 + "'");
            SetupManager.message("-E- loadLocalProperites: " + exception);
        }
    }

    public static void merge(Properties properties, Properties properties2) {
        String string = null;
        Enumeration<?> enumeration = properties2.propertyNames();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            properties.put(string, properties2.getProperty(string));
        }
    }

    public static void list(PrintStream printStream) {
        printStream.println(SetupManager.getSetupManager().toString() + "[");
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            printStream.println(string + " " + SetupManager.getProperty(string));
        }
        printStream.println("]");
    }

    public static void message(String string) {
        System.out.println(string);
    }

    public String toString() {
        return "jfig.gui.SetupManager";
    }

    public static void main(String[] stringArray) {
        SetupManager.message("SetupManager selftest...");
        SetupManager setupManager = SetupManager.getSetupManager();
        SetupManager.loadAllProperties("jfig.cnf");
        SetupManager.list(System.out);
        SetupManager.message("Saving user Properties...");
        SetupManager.saveUserProperties("jfig setup variables", "hugo.conf");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    /*
     * Unable to fully structure code
     */
    private SetupManager() {
        block9: {
            super();
            try {
                var1_1 = System.getSecurityManager();
                if (var1_1 != null) {
                    var1_1.checkPropertiesAccess();
                }
                SetupManager.properties = System.getProperties();
                if (SetupManager.debug) {
                    SetupManager.message("-I- loaded system properties.");
                }
            }
            catch (SecurityException var1_2) {
                SetupManager.properties = new Properties();
                var2_4 = new String[]{"java.version", "java.vendor", "java.vendor.url", "java.class.version", "os.name", "os.arch", "or.version", "file.separator", "path.separator", "line.separator"};
                var3_5 = 0;
                ** while (var3_5 < var2_4.length)
            }
lbl-1000:
            // 1 sources

            {
                try {
                    SetupManager.properties.put(var2_4[var3_5], System.getProperty(var2_4[var3_5]));
                }
                catch (SecurityException var4_6) {
                    // empty catch block
                }
                ++var3_5;
                continue;
            }
lbl23:
            // 1 sources

            if (SetupManager.debug) {
                SetupManager.message("-I- created empty system properties.");
            }
            break block9;
            catch (Throwable var1_3) {
                SetupManager.properties = new Properties();
                if (!SetupManager.debug) break block9;
                SetupManager.message("-I- created empty system properties.");
            }
        }
    }

    static {
        debug = false;
        SetupManager.getSetupManager();
    }
}

