/*
 * Decompiled with CFR 0.152.
 */
package jfig.utils;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.util.Vector;

public class PresentationParser {
    public static final boolean debug = false;
    public static final int N_SLIDES = 5000;
    public static final int N_CHAPTERS = 200;
    public static String DUMMY_TITLE = "no title";
    public static String DUMMY_URL = "/jfig/examples/presentation-empty.fig";
    private String basename;
    private String[] slideTitles = new String[5000];
    private String[] slideURLs = new String[5000];
    private String[] chapterTitles = new String[200];
    private int[] chapterIndexArray = new int[200];
    private int[] bookIndexArray;
    private int currentSlide;
    private int currentChapter;
    private int maxSlide;
    private int maxChapter;

    void initData() {
        int n = 0;
        while (n < 200) {
            this.chapterIndexArray[0] = 0;
            this.chapterTitles[0] = "no chapter";
            ++n;
        }
        n = 0;
        while (n < 5000) {
            this.slideURLs[0] = DUMMY_URL;
            this.slideTitles[0] = DUMMY_TITLE;
            ++n;
        }
        this.currentSlide = 0;
        this.maxSlide = 0;
        this.currentChapter = 0;
        this.maxChapter = 0;
    }

    public void setBasename(String string) {
        this.basename = string;
    }

    public String getFirstSlide() {
        this.currentSlide = 0;
        this.currentChapter = 0;
        return this.getSlide(this.currentSlide);
    }

    public String getLastSlide() {
        this.currentSlide = this.maxSlide - 1;
        this.updateChapterIndex();
        return this.getSlide(this.currentSlide);
    }

    public String getSlide(int n) {
        this.currentSlide = n < 0 ? 0 : (n >= this.maxSlide ? this.maxSlide - 1 : n);
        this.updateChapterIndex();
        String string = this.slideURLs[this.currentSlide];
        if (this.basename == null) {
            return string;
        }
        return this.basename + string;
    }

    public String getSlide(int n, int n2) {
        if (n < 0 || n > this.maxChapter) {
            n = 0;
            n2 = 0;
        }
        return this.getSlide(this.chapterIndexArray[n] + n2);
    }

    public boolean hasNextSlide() {
        return this.currentSlide < this.maxSlide - 1;
    }

    public boolean hasPreviousSlide() {
        return this.currentSlide > 0;
    }

    public String getNextSlide() {
        if (this.hasNextSlide()) {
            ++this.currentSlide;
            this.updateChapterIndex();
        }
        return this.getSlide(this.currentSlide);
    }

    public String getPreviousSlide() {
        if (this.hasPreviousSlide()) {
            --this.currentSlide;
            this.updateChapterIndex();
        }
        return this.getSlide(this.currentSlide);
    }

    private void updateChapterIndex() {
        if (this.maxChapter == 0) {
            this.currentChapter = 0;
            return;
        }
        this.currentChapter = this.maxChapter - 1;
        while (this.currentSlide < this.chapterIndexArray[this.currentChapter]) {
            --this.currentChapter;
        }
        if (this.currentChapter < 0) {
            this.currentChapter = 0;
        }
    }

    public boolean hasNextChapter() {
        return this.currentChapter < this.maxChapter - 1;
    }

    public boolean hasPreviousChapter() {
        return this.currentChapter > 0;
    }

    public String getNextChapter() {
        if (this.hasNextChapter()) {
            ++this.currentChapter;
        }
        this.currentSlide = this.chapterIndexArray[this.currentChapter];
        return this.getSlide(this.currentSlide);
    }

    public String getPreviousChapter() {
        if (this.hasPreviousChapter()) {
            --this.currentChapter;
        }
        this.currentSlide = this.chapterIndexArray[this.currentChapter];
        return this.getSlide(this.currentSlide);
    }

    public int getCurrentChapterIndex() {
        return this.currentChapter;
    }

    public String getCurrentChapterTitle() {
        return this.chapterTitles[this.currentChapter];
    }

    public String[] getChapterTitles() {
        return this.chapterTitles;
    }

    public String getCurrentSlideTitle() {
        return this.slideTitles[this.currentSlide];
    }

    public int getCurrentSlideIndex() {
        return this.currentSlide;
    }

    public int getNumberOfSlides() {
        return this.maxSlide;
    }

    public String[] getCurrentChapterSlideTitles() {
        int n = this.chapterIndexArray[this.currentChapter];
        int n2 = 0;
        n2 = this.hasNextChapter() ? this.chapterIndexArray[this.currentChapter + 1] : this.maxSlide;
        String[] stringArray = new String[n2 - n];
        int n3 = n;
        int n4 = 0;
        while (n3 < n2) {
            stringArray[n4] = this.slideTitles[n3];
            ++n3;
            ++n4;
        }
        return stringArray;
    }

    public void parse(InputStream inputStream) throws Exception {
        if (inputStream == null) {
            return;
        }
        Vector<String> vector = new Vector<String>();
        StreamTokenizer streamTokenizer = null;
        try {
            int n;
            streamTokenizer = new StreamTokenizer(new BufferedReader(new InputStreamReader(inputStream)));
            streamTokenizer.commentChar(35);
            streamTokenizer.quoteChar(34);
            streamTokenizer.eolIsSignificant(true);
            streamTokenizer.whitespaceChars(32, 32);
            streamTokenizer.whitespaceChars(9, 9);
            streamTokenizer.slashSlashComments(false);
            streamTokenizer.slashStarComments(false);
            while ((n = streamTokenizer.nextToken()) != -1) {
                if (n == -2) {
                    PresentationParser.dbg("[N: " + streamTokenizer.nval + "] ");
                    vector.addElement(streamTokenizer.sval);
                    continue;
                }
                if (n == -3) {
                    PresentationParser.dbg("[W: " + streamTokenizer.sval + "] ");
                    vector.addElement(streamTokenizer.sval);
                    continue;
                }
                if (n == 10) {
                    PresentationParser.dbg("");
                    this.decodeTokens(vector, streamTokenizer.lineno());
                    vector.removeAllElements();
                    continue;
                }
                if (n != 34) continue;
                PresentationParser.dbg("[Q: " + streamTokenizer.sval + "] ");
                vector.addElement(streamTokenizer.sval);
            }
            inputStream.close();
        }
        catch (Exception exception) {
            PresentationParser.msg("-E- PresentationParser: " + exception);
            if (streamTokenizer != null) {
                PresentationParser.msg("-E- error on line " + streamTokenizer.lineno());
            }
            throw exception;
        }
        if (this.maxSlide == 0) {
            this.maxSlide = 1;
            this.maxChapter = 1;
        }
    }

    public void decodeTokens(Vector vector, int n) {
        if (vector.size() < 1) {
            return;
        }
        String[] stringArray = new String[vector.size()];
        int n2 = 0;
        while (n2 < stringArray.length) {
            stringArray[n2] = (String)vector.elementAt(n2);
            ++n2;
        }
        if (stringArray[0].equals("chapter")) {
            this.chapterTitles[this.maxChapter] = DUMMY_TITLE;
            try {
                n2 = 1;
                while (n2 < stringArray.length) {
                    if (stringArray[n2].equals("title")) {
                        this.chapterTitles[this.maxChapter] = stringArray[n2 + 1];
                    }
                    ++n2;
                }
            }
            catch (Exception exception) {
                PresentationParser.msg("-E- " + exception);
                PresentationParser.msg("illegal or missing token on line " + n);
            }
            this.chapterIndexArray[this.maxChapter] = this.maxSlide;
            ++this.maxChapter;
        } else if (stringArray[0].equals("slide")) {
            this.slideTitles[this.maxSlide] = DUMMY_TITLE;
            this.slideURLs[this.maxSlide] = DUMMY_URL;
            try {
                n2 = 1;
                while (n2 < stringArray.length) {
                    if (stringArray[n2].equals("title")) {
                        this.slideTitles[this.maxSlide] = stringArray[n2 + 1];
                    }
                    if (stringArray[n2].equals("href")) {
                        this.slideURLs[this.maxSlide] = stringArray[n2 + 1];
                    }
                    ++n2;
                }
            }
            catch (Exception exception) {
                PresentationParser.msg("-E- " + exception);
                PresentationParser.msg("illegal or missing token on line " + n);
            }
            ++this.maxSlide;
        } else {
            PresentationParser.msg("-W- unknown token: " + stringArray[0] + " on line " + n);
        }
    }

    public void dumpData() {
        PresentationParser.msg("Presentation data: " + this.maxSlide + " slides in " + this.maxChapter + " chapters.");
        int n = 0;
        while (n < this.maxSlide) {
            PresentationParser.msg("slide[" + n + "] " + this.slideTitles[n] + " " + this.slideURLs[n]);
            ++n;
        }
        PresentationParser.msg("indexing: ");
        n = 0;
        while (n < this.maxChapter) {
            PresentationParser.msg("chapter[" + n + "] starts at page " + this.chapterIndexArray[n]);
            ++n;
        }
    }

    public static void dbg(String string) {
    }

    public static void msg(String string) {
        System.out.println(string);
    }

    public static void main(String[] stringArray) throws Exception {
        PresentationParser.msg("PresentationParser selftest...");
        if (stringArray.length < 2) {
            PresentationParser.msg("Usage: java jfig.utils.PresentationParser <filename> <basename>");
            return;
        }
        PresentationParser presentationParser = new PresentationParser();
        presentationParser.setBasename(stringArray[1]);
        presentationParser.parse(new FileInputStream(stringArray[0]));
        presentationParser.dumpData();
        int n = 0;
        while (n < presentationParser.chapterTitles.length) {
            PresentationParser.msg(presentationParser.getCurrentChapterTitle());
            String[] stringArray2 = presentationParser.getCurrentChapterSlideTitles();
            int n2 = 0;
            while (n2 < stringArray2.length) {
                PresentationParser.msg(">>" + stringArray2[n2]);
                ++n2;
            }
            if (!presentationParser.hasNextChapter()) break;
            presentationParser.getNextChapter();
            ++n;
        }
    }

    public PresentationParser() {
        this.initData();
        this.basename = null;
    }
}

