/*
 * Decompiled with CFR 0.152.
 */
package jfig.utils;

import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import jfig.utils.SetupManager;

public class MouseMapper {
    static boolean remap = SetupManager.getBoolean("jfig.utils.MouseMapper.Remap", false);
    static boolean doubleClickIsMiddleClick = SetupManager.getBoolean("jfig.utils.MouseMapper.DoubleClickIsMiddleClick", false);
    static boolean shiftClickIsMiddleClick = SetupManager.getBoolean("jfig.utils.MouseMapper.ShiftClickIsMiddleClick", false);
    static boolean controlClickIsRightClick = SetupManager.getBoolean("jfig.utils.MouseMapper.ControlClickIsRightClick", false);

    public static boolean isRemap() {
        return remap;
    }

    public static void setRemap(boolean bl) {
        remap = bl;
    }

    public static boolean isAltDown(InputEvent inputEvent) {
        if (remap) {
            return inputEvent.isMetaDown();
        }
        return inputEvent.isAltDown();
    }

    public static boolean isMetaDown(InputEvent inputEvent) {
        if (remap) {
            return inputEvent.isAltDown();
        }
        return inputEvent.isMetaDown();
    }

    public static boolean isControlDown(InputEvent inputEvent) {
        return inputEvent.isControlDown();
    }

    public static boolean isShiftDown(InputEvent inputEvent) {
        return inputEvent.isShiftDown();
    }

    public static boolean checkShiftClickIsMiddleClick(MouseEvent mouseEvent) {
        return shiftClickIsMiddleClick && mouseEvent.isShiftDown();
    }

    public static boolean checkDoubleClickIsMiddleClick(MouseEvent mouseEvent) {
        return doubleClickIsMiddleClick && (mouseEvent.getModifiers() & 0x10) != 0 && mouseEvent.getClickCount() > 1;
    }

    public static boolean isMiddleClick(MouseEvent mouseEvent) {
        return MouseMapper.isAltDown(mouseEvent) || MouseMapper.checkShiftClickIsMiddleClick(mouseEvent) || MouseMapper.checkDoubleClickIsMiddleClick(mouseEvent);
    }

    public static boolean isRightClick(InputEvent inputEvent) {
        if (controlClickIsRightClick && MouseMapper.isControlDown(inputEvent)) {
            return true;
        }
        return MouseMapper.isMetaDown(inputEvent);
    }

    public static boolean isLeftClick(InputEvent inputEvent) {
        return !(MouseMapper.isAltDown(inputEvent) || MouseMapper.isMetaDown(inputEvent));
    }
}

