/*
 * Decompiled with CFR 0.152.
 */
package jfig.utils;

import java.awt.Color;
import java.awt.Point;
import jfig.gui.ColorCache;
import jfig.gui.ModularEditor;
import jfig.objects.FigCompound;
import jfig.objects.FigObject;
import jfig.objects.FigPolyline;
import jfig.utils.ExceptionTracer;

public class MakePieChart {
    static final double _2PI = Math.PI * 2;
    ModularEditor editor = null;

    public FigObject makePieSlice(Point point, double d, double d2, double d3, Color color) {
        int n = 2 + (int)(200.0 * d2);
        double d4 = d2 * (Math.PI * 2) / (double)(n - 2);
        Point[] pointArray = new Point[n];
        pointArray[0] = new Point(point.x, point.y);
        double d5 = d3;
        int n2 = 1;
        while (n2 < n) {
            pointArray[n2] = new Point(point.x + (int)(d * Math.cos(d5) + 0.5), point.y + (int)(d * Math.sin(d5) + 0.5));
            d5 += d4;
            ++n2;
        }
        FigPolyline figPolyline = new FigPolyline();
        figPolyline.setIsClosed(true);
        figPolyline.setLineColor(Color.white);
        figPolyline.setLineWidth(1);
        figPolyline.setFillStyle(2);
        figPolyline.setFillColor(color);
        figPolyline.setTrafo(this.editor.getObjectCanvas().getTrafo());
        figPolyline.setPoints(pointArray);
        return figPolyline;
    }

    public FigCompound makePieChart(double[] dArray) {
        int[] nArray = new int[]{4, 2, 1, 31, 11, 15, 21, 20, 14, 10};
        FigCompound figCompound = new FigCompound();
        figCompound.setTrafo(this.editor.getObjectCanvas().getTrafo());
        Point point = new Point(4800, 4800);
        double d = 2400.0;
        double d2 = 0.0;
        int n = 0;
        while (n < dArray.length) {
            Color color = ColorCache.getColorCache().get(nArray[n % nArray.length]);
            FigObject figObject = this.makePieSlice(point, d, dArray[n], d2, color);
            figCompound.addMember(figObject);
            d2 += dArray[n] * (Math.PI * 2);
            ++n;
        }
        return figCompound;
    }

    public static double[] normalize(double[] dArray) {
        double d = 0.0;
        int n = 0;
        while (n < dArray.length) {
            d += dArray[n];
            ++n;
        }
        if (d != 0.0) {
            n = 0;
            while (n < dArray.length) {
                int n2 = n++;
                dArray[n2] = dArray[n2] / d;
            }
        }
        return dArray;
    }

    public static void main(String[] stringArray) {
        MakePieChart makePieChart = new MakePieChart();
        ExceptionTracer.setEnabled(false);
        makePieChart.editor = new ModularEditor();
        double[] dArray = new double[]{0.1, 0.2, 0.3, 0.1, 0.15, 0.15};
        double[] dArray2 = new double[]{0.0, 0.55, 0.23, 0.22};
        double[] dArray3 = new double[]{0.0, 22.0, 34.0, 7.0, 4.0, 5.0, 1.0, 12.0, 2.0, 5.0};
        double[] dArray4 = new double[]{0.0, 20.0, 54.0, 16.0, 8.0, 5.0, 4.0, 26.0, 4.0, 21.0};
        double[] dArray5 = new double[]{9.0, 28.0, 88.0, 5.0, 0.0, 0.0, 0.0, 6.0, 26.0, 122.0};
        FigCompound figCompound = makePieChart.makePieChart(MakePieChart.normalize(dArray3));
        FigCompound figCompound2 = makePieChart.makePieChart(MakePieChart.normalize(dArray4));
        FigCompound figCompound3 = makePieChart.makePieChart(MakePieChart.normalize(dArray5));
        figCompound.move(0, 2400);
        figCompound2.move(7200, 2400);
        figCompound3.move(14400, 2400);
        makePieChart.editor.insertIntoObjectList((FigObject)figCompound);
        makePieChart.editor.insertIntoObjectList((FigObject)figCompound2);
        makePieChart.editor.insertIntoObjectList((FigObject)figCompound3);
        makePieChart.editor.doRedraw();
    }
}

