/*
 * Decompiled with CFR 0.152.
 */
package jfig.utils;

import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.image.BufferedImage;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Stack;
import java.util.Vector;
import jfig.canvas.FigTrafo2D;
import jfig.gui.ColorCache;
import jfig.gui.FontCache;
import jfig.objects.FigAttribs;
import jfig.objects.FigCompound;
import jfig.objects.FigObjectList;
import jfig.objects.FigPolyline;
import jfig.objects.FigRectangle;
import jfig.objects.FigText;
import jfig.objects.FigWriter;

public class LP2 {
    static boolean debug = false;
    static final int THINSPACE = 5;
    static final int USE_LUCIDA_FONTS = 1;
    static final int USE_CM_FONTS = 2;
    static final int USE_SYMBOL_FONT = 3;
    static final int CMERR = -13;
    static final int CMANY = -12;
    static final int CMR = 35;
    static final int CMMI = 42;
    static final int CMSS = 38;
    static final int CMSL = 39;
    static final int CMSY = 44;
    static final int CMTT = 40;
    static final int CMEX = 46;
    static final int MSAM = 47;
    static final int MSBM = 48;
    static Graphics2D imageGraphics2D = null;
    static final int INVALID = 0;
    static final int TEXT = 1;
    static final int COMMAND = 2;
    static final int MATH = 3;
    static final int BEGINGROUP = 4;
    static final int ENDGROUP = 5;
    static final int CONTROL = 6;
    static final int BEGINMATH = 7;
    static final int ENDMATH = 8;
    static final int SUPERSCRIPT = 9;
    static final int SUBSCRIPT = 10;
    static final int MATHSYMBOL = 11;
    static final int MATHDIGIT = 12;
    static final String[] _mode_names;
    static int count;
    boolean dump_tokens = false;
    boolean display_boxes = false;
    boolean use_word_boxes = true;
    int fontMode = 2;
    int mathFontIndex = 1;
    int mathGreekFontIndex = 1;
    int mathSymbolFontIndex = 0;
    int mathBackupFontIndex = 16;
    ColorCache colorCache = ColorCache.getColorCache();
    FontCache fontCache = FontCache.getFontCache();
    StringBuffer token;
    Vector tokens;
    Vector types;
    String line;
    int pos;
    int mode;
    Stack stack = new Stack();
    Stack delayedCommandStack = new Stack();
    Box master;
    Box current;
    int fontIndex;
    int ptBaseSize;
    int ptSize;
    int colorIndex;
    int italic_correction = 0;
    Object pdfMapper = null;
    public final int[][] subscriptPtSizes = new int[][]{{9, 6}, {10, 6}, {11, 7}, {12, 9}, {15, 10}, {17, 12}, {20, 12}, {24, 15}, {30, 20}, {40, 27}};
    private static /* synthetic */ Class class$Ljava$lang$String;

    public void setFontMode(int n) {
        if (n == 1) {
            this.fontMode = 1;
            this.mathFontIndex = 1;
            this.mathGreekFontIndex = 1;
            this.mathSymbolFontIndex = 0;
            this.mathBackupFontIndex = 16;
        } else if (n == 2) {
            this.fontMode = 2;
            this.mathFontIndex = 42;
            this.mathGreekFontIndex = 1;
            this.mathSymbolFontIndex = 44;
            this.mathBackupFontIndex = 16;
        } else {
            if (n == 3) {
                this.fontMode = 3;
                throw new IllegalArgumentException("Use Symbol font mode not yet!");
            }
            throw new IllegalArgumentException("Wrong font mode: " + n);
        }
    }

    public void setPDFMapper(Object object) {
        this.pdfMapper = object;
    }

    public int getStringWidthPoints(int n, int n2, String string) {
        if (this.pdfMapper == null) {
            FontMetrics fontMetrics = this.fontCache.getFontMetrics(n, n2);
            return fontMetrics.stringWidth(string);
        }
        try {
            String string2 = "getStringWidthPoints";
            Class[] classArray = new Class[]{Integer.TYPE, Integer.TYPE, class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = LP2.class$("java.lang.String"))};
            Method method = this.pdfMapper.getClass().getMethod(string2, classArray);
            Object[] objectArray = new Object[]{new Integer(n), new Integer(n2), string};
            Object object = method.invoke(this.pdfMapper, objectArray);
            return (Integer)object;
        }
        catch (Throwable throwable) {
            LP2.msg("-E- internal error in getStringWidthPoints: " + throwable);
            LP2.msg("-I- falling back to AWT font metrics...");
            FontMetrics fontMetrics = this.fontCache.getFontMetrics(n, n2);
            return fontMetrics.stringWidth(string);
        }
    }

    String tokenize_command() {
        StringBuffer stringBuffer = new StringBuffer();
        char c = this.line.charAt(this.pos);
        if (c != '\\') {
            throw new RuntimeException("-E- not a double quote: " + c + " " + this.pos);
        }
        char c2 = this.line.charAt(this.pos + 1);
        if (this.mode == 3) {
            switch (c2) {
                case ',': {
                    this.checkAddToken("\\mskip_thin", 2);
                    ++this.pos;
                    return "\\mskip_thin";
                }
                case '>': {
                    this.checkAddToken("\\mskip_med", 2);
                    ++this.pos;
                    return "\\mskip_med";
                }
                case ';': {
                    this.checkAddToken("\\mskip_thick", 2);
                    ++this.pos;
                    return "\\mskip_thick";
                }
                case '!': {
                    this.checkAddToken("\\mskip_back", 2);
                    ++this.pos;
                    return "\\mskip_back";
                }
            }
        }
        switch (c2) {
            case ' ': {
                if (this.mode == 3) {
                    this.addMathSpaceToken();
                } else {
                    this.addShortCommandToken(" ");
                }
                return null;
            }
            case '\"': {
                this.addShortCommandToken("\"");
                return null;
            }
            case '$': {
                this.addShortCommandToken("$");
                return null;
            }
            case '&': {
                this.addShortCommandToken("&");
                return null;
            }
            case '%': {
                this.addShortCommandToken("%");
                return null;
            }
            case '#': {
                this.addShortCommandToken("#");
                return null;
            }
            case '_': {
                this.addShortCommandToken("_");
                return null;
            }
            case '\\': {
                this.addShortCommandToken("\\");
                return null;
            }
            case '{': {
                this.addShortCommandToken("{");
                return null;
            }
            case '}': {
                this.addShortCommandToken("}");
                return null;
            }
            case '|': {
                this.addShortCommandToken("|");
                return null;
            }
            case '@': {
                this.addShortCommandToken("");
                return null;
            }
            case '(': {
                this.add_begin_math_token();
                return null;
            }
            case '[': {
                this.add_begin_math_token();
                return null;
            }
            case ')': {
                this.add_end_math_token();
                return null;
            }
            case ']': {
                this.add_end_math_token();
                return null;
            }
        }
        if (!this.isAscii(c2)) {
            throw new RuntimeException("-E- Invalid command: '" + c + c2 + "'");
        }
        stringBuffer.append(c);
        int n = this.line.length();
        while (this.pos < n - 1) {
            if (this.isAscii(c2 = this.line.charAt(++this.pos))) {
                stringBuffer.append(c2);
                continue;
            }
            if (c2 == ' ') break;
            --this.pos;
            break;
        }
        String string = stringBuffer.toString();
        LP2.msg("-#- tokenize_command: " + string);
        this.checkAddToken(string, 2);
        return string;
    }

    String handle_double_quote() {
        char c = this.line.charAt(this.pos);
        if (c != '\"') {
            throw new RuntimeException("-E- not a double quote: " + c + " " + this.pos);
        }
        ++this.pos;
        switch (this.line.charAt(this.pos + 1)) {
            case 'a': {
                this.addShortCommandToken("\u00e4");
                return null;
            }
            case 'A': {
                this.addShortCommandToken("\u00c4");
                return null;
            }
            case 'o': {
                this.addShortCommandToken("\u00f6");
                return null;
            }
            case 'O': {
                this.addShortCommandToken("\u00d6");
                return null;
            }
            case 'u': {
                this.addShortCommandToken("\u00fc");
                return null;
            }
            case 'U': {
                this.addShortCommandToken("\u00dc");
                return null;
            }
            case 's': {
                this.addShortCommandToken("\u00df");
                return null;
            }
        }
        ++this.pos;
        throw new RuntimeException("illegal double quote");
    }

    void addShortCommandToken(String string) {
        this.tokens.add(string);
        this.types.add(new Integer(this.mode));
        ++this.pos;
    }

    void addMathSpaceToken() {
        this.tokens.add(" ");
        this.types.add(new Integer(11));
        ++this.pos;
    }

    private void begin_group() {
        this.checkAddToken("{", 4);
    }

    private void end_group() {
        this.checkAddToken("}", 5);
    }

    private void toggle_math_mode() {
        if (this.mode == 1) {
            this.checkAddToken("$", 7);
            this.mode = 3;
        } else if (this.mode == 3) {
            this.checkAddToken("$", 8);
            this.mode = 1;
        } else {
            LP2.msg("-E- toggle_math_mode: neither text nor math mode?? ignored.");
        }
    }

    private void add_begin_math_token() {
        if (this.mode == 1) {
            this.checkAddToken("$", 7);
            this.mode = 3;
        } else {
            LP2.msg("-E- add_begin_math_token: already in math mode, ignored.");
        }
        ++this.pos;
    }

    private void add_end_math_token() {
        if (this.mode == 3) {
            this.checkAddToken("$", 8);
            this.mode = 1;
        } else {
            LP2.msg("-E- add_end_math_token: already in text mode, ignored.");
        }
        ++this.pos;
    }

    private void eat_trailing_spaces(int n) {
        try {
            this.pos = n;
            int n2 = this.line.length();
            while (this.pos < n2 && this.line.charAt(this.pos) == ' ') {
                ++this.pos;
            }
            --this.pos;
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            this.pos = n;
        }
    }

    void tokenize(String string) {
        this.line = string;
        this.tokens = new Vector();
        this.types = new Vector();
        this.token = new StringBuffer("");
        this.pos = 0;
        char c = '\u0000';
        boolean bl = false;
        int n = 0;
        String string2 = null;
        this.mode = 1;
        this.pos = 0;
        n = this.line.length();
        while (this.pos < n) {
            c = this.line.charAt(this.pos);
            if (this.mode == 1) {
                switch (c) {
                    case '\"': {
                        string2 = this.handle_double_quote();
                        break;
                    }
                    case '\\': {
                        string2 = this.tokenize_command();
                        break;
                    }
                    case '{': {
                        this.begin_group();
                        break;
                    }
                    case '}': {
                        this.end_group();
                        break;
                    }
                    case '$': {
                        this.toggle_math_mode();
                        break;
                    }
                    case '@': {
                        this.checkAddToken("@", 1);
                        break;
                    }
                    case '\'': {
                        this.checkAddToken("'", 1);
                        break;
                    }
                    case '`': {
                        this.checkAddToken("`", 1);
                        break;
                    }
                    case '%': {
                        return;
                    }
                    default: {
                        if (this.isTextToken(c)) {
                            this.checkAddToken("" + c, 1);
                            break;
                        }
                        this.error_in_tokenizer(this.pos, this.mode, this.line);
                        break;
                    }
                }
            } else if (this.mode == 3) {
                switch (c) {
                    case '%': {
                        return;
                    }
                    case '\"': {
                        string2 = this.handle_double_quote();
                        break;
                    }
                    case '\\': {
                        string2 = this.tokenize_command();
                        break;
                    }
                    case '{': {
                        this.begin_group();
                        break;
                    }
                    case '}': {
                        this.end_group();
                        break;
                    }
                    case '$': {
                        this.toggle_math_mode();
                        break;
                    }
                    case '^': {
                        this.checkAddToken("^", 9);
                        break;
                    }
                    case '_': {
                        this.checkAddToken("_", 10);
                        break;
                    }
                    default: {
                        if (this.isDigit(c)) {
                            this.checkAddToken("" + c, 12);
                            break;
                        }
                        if (this.isMathSymbol(c)) {
                            this.checkAddToken("" + c, 11);
                            break;
                        }
                        if (this.isWhitespace(c)) {
                            this.checkAddToken("" + c, 11);
                            break;
                        }
                        if (this.isPunctuation(c)) {
                            this.checkAddToken("" + c, 3);
                            break;
                        }
                        if (this.isTextToken(c)) {
                            this.checkAddToken("" + c, 3);
                            break;
                        }
                        this.error_in_tokenizer(this.pos, this.mode, this.line);
                        break;
                    }
                }
            } else {
                this.error_in_tokenizer(this.pos, this.mode, this.line);
            }
            ++this.pos;
        }
        if (this.token != null && this.token.length() > 0) {
            this.checkAddToken(this.token, this.mode);
        }
    }

    private void checkAddToken(Object object, int n) {
        if (object == null) {
            return;
        }
        String string = object.toString();
        if (string.length() > 0) {
            this.tokens.add(object);
            this.types.add(new Integer(n));
        }
    }

    private void handleMathDigit(char c) {
        if (this.fontMode == 2) {
            this.tokens.add("" + c);
            this.types.add(new Integer(3));
        } else {
            this.tokens.add("" + c);
            this.types.add(new Integer(3));
        }
    }

    private void error_in_tokenizer(int n, int n2, String string) {
        System.err.println("Error in tokenize, mode= " + _mode_names[n2]);
        System.err.println(string);
        int n3 = 0;
        while (n3 < n) {
            System.err.print(" ");
            ++n3;
        }
        System.err.println("^");
        Thread.dumpStack();
        System.err.println("\n\n\n");
    }

    public boolean isTextToken(char c) {
        return this.isAscii(c) || this.isUmlaut(c) || this.isDigit(c) || this.isWhitespace(c) || this.isPunctuation(c);
    }

    public boolean isAscii(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    public boolean isUmlaut(char c) {
        return c == '\u00e4' || c == '\u00c4' || c == '\u00f6' || c == '\u00d6' || c == '\u00fc' || c == '\u00dc' || c == '\u00df';
    }

    public boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public boolean isWhitespace(char c) {
        return c == ' ' || c == '\t';
    }

    public boolean isPunctuation(char c) {
        return c == '.' || c == ',' || c == ';' || c == ':' || c == '!' || c == '?' || c == '\'' || c == '-' || c == '+' || c == '*' || c == '/' || c == '=' || c == '(' || c == ')' || c == '[' || c == ']';
    }

    public boolean isMathSymbol(char c) {
        return c == '=' || c == '>' || c == '<' || c == '+' || c == '-' || c == '|' || c == '*' || c == '(' || c == ')' || c == '[' || c == ']' || c == ':' || c == ',' || c == '.' || c == '\'' || c == '/';
    }

    public void dumpTokens() {
        int n = 0;
        int n2 = 0;
        int n3 = this.tokens.size();
        while (n2 < n3) {
            int n4 = 0;
            while (n4 < n) {
                System.out.print(" ");
                ++n4;
            }
            String string = this.tokens.elementAt(n2).toString();
            int n5 = (Integer)this.types.elementAt(n2);
            System.out.println(string + "   " + _mode_names[n5]);
            n += string.length();
            ++n2;
        }
    }

    public Object getState() {
        return new Object[]{new Integer(this.fontIndex), new Integer(this.ptSize), new Integer(this.colorIndex)};
    }

    public void setState(Object object) {
        try {
            int n = 0;
            Object[] objectArray = (Object[])object;
            this.fontIndex = (Integer)objectArray[n++];
            this.ptSize = (Integer)objectArray[n++];
            this.colorIndex = (Integer)objectArray[n++];
        }
        catch (Throwable throwable) {
            LP2.msg("-E- internal in setState: tmp= " + object);
            throwable.printStackTrace();
        }
    }

    public void append(Box box) {
        if (this.current instanceof GroupBox) {
            ((GroupBox)this.current).appendMember(box);
            box.setParent(this.current);
        } else {
            LP2.msg("-E- internal: current not a GroupBox in append..." + this.current);
            Thread.dumpStack();
            this.current.append(box);
            this.current = box;
        }
    }

    public Box buildBox() {
        LP2 lP2 = this;
        if (lP2 == null) {
            throw null;
        }
        this.current = this.master = lP2.new GroupBox();
        int n = 0;
        int n2 = this.tokens.size();
        while (n < n2) {
            String string = this.tokens.elementAt(n).toString();
            int n3 = (Integer)this.types.elementAt(n);
            if (!this.delayedCommandStack.isEmpty()) {
                LP2.msg("**** dCS: " + this.delayedCommandStack.pop() + " " + string);
            }
            switch (n3) {
                case 0: {
                    LP2.msg("-E-internal: mode=INVALID, token=" + string);
                    break;
                }
                case 1: {
                    int n4 = 0;
                    while (n4 < string.length()) {
                        String string2 = "" + string.charAt(n4);
                        LP2 lP22 = this;
                        if (lP22 == null) {
                            throw null;
                        }
                        this.append(lP22.new CharBox(string2, this.fontIndex, this.ptSize, this.colorIndex));
                        ++n4;
                    }
                    break;
                }
                case 2: {
                    String string3 = string.substring(1);
                    int n5 = this.handleCommand(string3);
                    if (n5 <= 0) break;
                    this.buildBoxHandleBeginCommand(string3, n5);
                    break;
                }
                case 3: {
                    Object object;
                    int n6 = 0;
                    while (n6 < string.length()) {
                        object = "" + string.charAt(n6);
                        if (this.fontMode == 2) {
                            if (((String)object).startsWith("{")) {
                                this.unicode("{", 44, 102);
                            } else if (((String)object).startsWith("}")) {
                                this.unicode("}", 44, 103);
                            } else if (((String)object).startsWith(",")) {
                                this.unicode(",", 35, 44);
                            } else if (((String)object).startsWith(";")) {
                                this.unicode(";", 35, 59);
                            } else {
                                LP2 lP23 = this;
                                if (lP23 == null) {
                                    throw null;
                                }
                                this.append(lP23.new CharBox((String)object, this.fontIndex, this.ptSize, this.colorIndex));
                            }
                        } else {
                            LP2 lP24 = this;
                            if (lP24 == null) {
                                throw null;
                            }
                            this.append(lP24.new CharBox((String)object, this.fontIndex, this.ptSize, this.colorIndex));
                        }
                        ++n6;
                    }
                    break;
                }
                case 4: {
                    this.buildBoxHandleBeginGroup();
                    break;
                }
                case 5: {
                    Object object;
                    GroupBox groupBox = (GroupBox)this.current;
                    this.buildBoxHandleEndGroup();
                    if (this.current instanceof CommandBox) {
                        object = (CommandBox)this.current;
                        ((CommandBox)object).addArgument(groupBox);
                        if (debug) {
                            LP2.msg("\nCMD: " + ((CommandBox)object).getCommand());
                        }
                        if (!((CommandBox)object).hasAllArguments()) break;
                        ((CommandBox)object).executeCommand();
                        this.buildBoxHandleEndGroup();
                        break;
                    }
                    if (!(this.current instanceof SubSuperScriptBox)) break;
                    object = (SubSuperScriptBox)this.current;
                    ((SubSuperScriptBox)object).setMode("none");
                    ((SubSuperScriptBox)object).measure();
                    if (debug) {
                        LP2.msg("\u00a7\u00a7\u00a7 ENDGROUP:end of SubSuperScript:" + object);
                    }
                    this.buildBoxHandleEndGroup();
                    break;
                }
                case 6: {
                    LP2.msg("-W- control character, should not happen: " + string);
                    break;
                }
                case 7: {
                    this.buildBoxHandleBeginGroup();
                    if (this.fontMode == 2) {
                        this.fontIndex = 42;
                        break;
                    }
                    this.fontIndex = this.mathFontIndex;
                    break;
                }
                case 8: {
                    this.buildBoxHandleEndGroup();
                    break;
                }
                case 9: {
                    GroupBox groupBox;
                    if (debug) {
                        LP2.msg("\n\n\n>>>SUPERSCRIPT>>>");
                    }
                    if ((groupBox = (GroupBox)this.current) == null) {
                        LP2.msg("-E- Internal: SUPERSCRIPT master not a group: " + this.current);
                        if (!debug) break;
                        Thread.dumpStack();
                        break;
                    }
                    Object object = null;
                    Box box = groupBox.getLastMember();
                    if (box instanceof SubSuperScriptBox) {
                        if (((SubSuperScriptBox)box).getSuperscriptBox() == null) {
                            object = (SubSuperScriptBox)box;
                            ((SubSuperScriptBox)object).setMode("superscript");
                        } else {
                            LP2 lP25 = this;
                            if (lP25 == null) {
                                throw null;
                            }
                            object = lP25.new SubSuperScriptBox(this.fontIndex, this.ptSize);
                            ((SubSuperScriptBox)object).setMode("superscript");
                            ((Box)object).setParent(groupBox);
                            groupBox.appendMember((Box)object);
                        }
                    } else {
                        LP2 lP26 = this;
                        if (lP26 == null) {
                            throw null;
                        }
                        object = lP26.new SubSuperScriptBox(this.fontIndex, this.ptSize);
                        ((SubSuperScriptBox)object).setMode("superscript");
                        ((Box)object).setParent(groupBox);
                        groupBox.appendMember((Box)object);
                    }
                    this.current = object;
                    this.stack.push(this.getState());
                    this.ptSize = ((SubSuperScriptBox)object).getSubscriptPtSize();
                    Point point = ((SubSuperScriptBox)object).getSuperscriptBasePoint();
                    break;
                }
                case 10: {
                    GroupBox groupBox;
                    if (debug) {
                        LP2.msg("\n\n\n>>>SUBSCRIPT>>>");
                    }
                    if ((groupBox = (GroupBox)this.current) == null) {
                        LP2.msg("-E- Internal: SUBSCRIPT master not a group: " + this.current);
                        if (!debug) break;
                        Thread.dumpStack();
                        break;
                    }
                    Object object = null;
                    Box box = groupBox.getLastMember();
                    if (box instanceof SubSuperScriptBox) {
                        if (((SubSuperScriptBox)box).getSubscriptBox() == null) {
                            object = (SubSuperScriptBox)box;
                            ((SubSuperScriptBox)object).setMode("subscript");
                        } else {
                            LP2 lP27 = this;
                            if (lP27 == null) {
                                throw null;
                            }
                            object = lP27.new SubSuperScriptBox(this.fontIndex, this.ptSize);
                            ((SubSuperScriptBox)object).setMode("subscript");
                            ((Box)object).setParent(groupBox);
                            groupBox.appendMember((Box)object);
                        }
                    } else {
                        LP2 lP28 = this;
                        if (lP28 == null) {
                            throw null;
                        }
                        object = lP28.new SubSuperScriptBox(this.fontIndex, this.ptSize);
                        ((SubSuperScriptBox)object).setMode("subscript");
                        ((Box)object).setParent(groupBox);
                        groupBox.appendMember((Box)object);
                    }
                    this.current = object;
                    this.stack.push(this.getState());
                    this.ptSize = ((SubSuperScriptBox)object).getSubscriptPtSize();
                    Point point = ((SubSuperScriptBox)object).getSubscriptBasePoint();
                    break;
                }
                case 11: {
                    this.handleMathSymbol(string);
                    break;
                }
                case 12: {
                    this.handleMathDigit(string);
                    break;
                }
                default: {
                    System.out.println("UNKNOWN MODE: " + n3 + " " + string);
                }
            }
            ++n;
        }
        return this.master;
    }

    public void buildBoxHandleBeginGroup() {
        LP2 lP2 = this;
        if (lP2 == null) {
            throw null;
        }
        GroupBox groupBox = lP2.new GroupBox();
        this.append(groupBox);
        this.current = groupBox;
        this.stack.push(this.getState());
    }

    public void buildBoxHandleBeginCommand(String string, int n) {
        LP2 lP2 = this;
        if (lP2 == null) {
            throw null;
        }
        CommandBox commandBox = lP2.new CommandBox(string, n);
        this.append(commandBox);
        this.current = commandBox;
        this.stack.push(this.getState());
        try {
            Method method = this.getClass().getMethod("_" + string + "_BEGIN", new Class[0]);
            Object object = method.invoke((Object)this, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void buildBoxHandleEndGroup() {
        if (this.current instanceof GroupBox) {
            Box box;
            this.current.measure();
            this.current.getBounds();
            if (debug) {
                LP2.msg(">>> buildBoxHandleEndGroup: " + this.current.getBounds());
            }
            if ((box = this.current.getParent()) != null) {
                this.current = box;
            } else {
                LP2.msg("-E- internal: ENDGROUP: enclosing group is null");
                LP2.msg("token is: " + this.token);
                Thread.dumpStack();
            }
        } else {
            LP2.msg("-E- internal in ENDGROUP: current not a GroupBox!");
            Thread.dumpStack();
        }
        if (!this.stack.isEmpty()) {
            this.setState(this.stack.pop());
        } else {
            LP2.msg("-E- Internal error in buildBoxHandleEndGroup: empty stack");
        }
    }

    public void handleMathSymbol(String string) {
        if (this.fontMode == 2) {
            if (string.length() != 1) {
                LP2.msg("-E- handleMathSymbol: invalid token: '" + string + "'");
                return;
            }
            char c = string.charAt(0);
            switch (c) {
                case ' ': {
                    this.cm_math(35, 32);
                    break;
                }
                case '\t': {
                    this.cm_math(35, 32);
                    break;
                }
                case '(': {
                    this.cm_math(35, 40);
                    break;
                }
                case ')': {
                    this.cm_math(35, 41);
                    break;
                }
                case '[': {
                    this.cm_math(35, 91);
                    break;
                }
                case ']': {
                    this.cm_math(35, 93);
                    break;
                }
                case ':': {
                    this.cm_math(35, 58);
                    break;
                }
                case '+': {
                    this.cm_math(35, 43);
                    break;
                }
                case '=': {
                    this.cm_math(35, 61);
                    break;
                }
                case '-': {
                    this.cm_math(35, 123);
                    break;
                }
                case '*': {
                    this.cm_math(44, 164);
                    break;
                }
                case '|': {
                    this.cm_math(44, 106);
                    break;
                }
                case '\'': {
                    this.cm_math(38, 39);
                    break;
                }
                case '.': {
                    this.cm_math(42, 58);
                    break;
                }
                case ',': {
                    this.cm_math(42, 59);
                    break;
                }
                case '/': {
                    this.cm_math(42, 61);
                    break;
                }
                case '<': {
                    this._thinspace();
                    this.cm_math(42, 60);
                    this._thinspace();
                    break;
                }
                case '>': {
                    this._thinspace();
                    this.cm_math(42, 62);
                    this._thinspace();
                    break;
                }
                default: {
                    LP2.msg("-E- handleMathSymbol: unhandled token: '" + string + "'");
                    break;
                }
            }
        } else {
            LP2 lP2 = this;
            if (lP2 == null) {
                throw null;
            }
            this.append(lP2.new CharBox(string, this.mathSymbolFontIndex, this.ptSize, this.colorIndex));
        }
    }

    public void handleMathDigit(String string) {
        if (this.fontMode == 2) {
            this.cm_math(35, string.charAt(0));
        } else {
            LP2 lP2 = this;
            if (lP2 == null) {
                throw null;
            }
            this.append(lP2.new CharBox(string, this.mathSymbolFontIndex, this.ptSize, this.colorIndex));
        }
    }

    private void cm_math(int n, int n2) {
        String string = "" + (char)n2;
        LP2 lP2 = this;
        if (lP2 == null) {
            throw null;
        }
        this.append(lP2.new CharBox(string, n, this.ptSize, this.colorIndex));
    }

    public int handleCommand(String string) {
        String string2 = "_" + string;
        try {
            Class[] classArray = new Class[]{};
            Object[] objectArray = new Object[]{};
            Method method = null;
            Object object = null;
            try {
                method = this.getClass().getMethod(string2, classArray);
                object = method.invoke((Object)this, objectArray);
                if (object != null) {
                    return (Integer)object;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                classArray = new Class[]{objectArray.getClass()};
                method = this.getClass().getMethod(string2, classArray);
                objectArray = new Object[]{null};
                object = method.invoke((Object)this, objectArray);
                if (object != null) {
                    return (Integer)object;
                }
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            LP2.msg("-E- handleCommand: " + throwable);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            LP2.msg("-W- Command undefined: " + string + " " + noSuchMethodException);
            noSuchMethodException.printStackTrace();
            LP2 lP2 = this;
            if (lP2 == null) {
                throw null;
            }
            this.append(lP2.new CharBox(string, this.fontIndex, this.ptSize, this.colorIndex));
        }
        catch (Exception exception) {
            LP2.msg("-E- exception: " + exception + " for command: " + string);
            exception.printStackTrace();
        }
        return 0;
    }

    public int handleCommand(String string, Object[] objectArray) {
        String string2 = "_" + string;
        try {
            Class[] classArray = new Class[]{objectArray.getClass()};
            Method method = this.getClass().getMethod(string2, classArray);
            Object[] objectArray2 = new Object[]{objectArray};
            Object object = method.invoke((Object)this, objectArray2);
            if (object != null) {
                return (Integer)object;
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            LP2.msg("-E- handleCommand: " + throwable);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            LP2.msg("-W- Command undefined: " + string + " " + noSuchMethodException);
            noSuchMethodException.printStackTrace();
            LP2 lP2 = this;
            if (lP2 == null) {
                throw null;
            }
            this.append(lP2.new CharBox(string, this.fontIndex, this.ptSize, this.colorIndex));
        }
        catch (Exception exception) {
            LP2.msg("-E- exception: " + exception + " for command: " + string);
            exception.printStackTrace();
        }
        return 0;
    }

    public void FIXME(String string) {
        System.out.println("-W- function not (yet) supported: " + string);
    }

    public void _today() {
        String string = new Date().toString();
        LP2 lP2 = this;
        if (lP2 == null) {
            throw null;
        }
        this.append(lP2.new CharBox(string, this.fontIndex, this.ptSize, this.colorIndex));
    }

    public void _bf() {
        this.fontIndex |= 2;
    }

    public void _it() {
        this.fontIndex = this.fontMode == 2 ? (this.fontIndex |= 1) : (this.fontIndex |= 1);
    }

    public void _em() {
        this.fontIndex ^= 1;
    }

    public void _rm() {
        this.fontIndex = this.fontMode == 2 ? 35 : (this.fontIndex &= 0xFC);
    }

    public void _sf() {
        this.fontIndex = this.fontMode == 2 ? 38 : 16;
    }

    public void _sl() {
        this.fontIndex = this.fontMode == 2 ? 39 : 17;
    }

    public void _sc() {
        this.FIXME("_sc: caps/small caps font not available yet.");
    }

    public void _mathrm() {
        this.fontIndex = this.fontMode == 2 ? 35 : (this.fontIndex &= 0xFC);
    }

    public void _tt() {
        this.fontIndex = this.fontMode == 2 ? 40 : 12;
    }

    public void _btt() {
        if (this.fontMode == 2) {
            LP2.msg("-W- \\btt: no bold typewriter font in CM fonts.");
            this.fontIndex = 40;
        } else {
            this.fontIndex = 14;
        }
    }

    public void _itt() {
        this.fontIndex = 13;
    }

    public void _black() {
        this.colorIndex = ColorCache.BLACK;
    }

    public void _red() {
        this.colorIndex = ColorCache.RED;
    }

    public void _green() {
        this.colorIndex = ColorCache.GREEN;
    }

    public void _blue() {
        this.colorIndex = ColorCache.BLUE;
    }

    public void _cyan() {
        this.colorIndex = ColorCache.CYAN;
    }

    public void _magenta() {
        this.colorIndex = ColorCache.MAGENTA;
    }

    public void _yellow() {
        this.colorIndex = ColorCache.YELLOW;
    }

    public void _white() {
        this.colorIndex = ColorCache.WHITE;
    }

    public void _darkblue() {
        this.colorIndex = ColorCache.BLUE4;
    }

    public void _lightblue() {
        this.colorIndex = ColorCache.LTBLUE;
    }

    public void _darkgreen() {
        this.colorIndex = ColorCache.GREEN4;
    }

    public void _darkred() {
        this.colorIndex = ColorCache.RED4;
    }

    public void _darkpink() {
        this.colorIndex = ColorCache.PINK4;
    }

    public void _gold() {
        this.colorIndex = ColorCache.GOLD;
    }

    public void _fivept() {
        this.ptSize = 5;
    }

    public void _sixpt() {
        this.ptSize = 6;
    }

    public void _sevenpt() {
        this.ptSize = 7;
    }

    public void _eightpt() {
        this.ptSize = 8;
    }

    public void _ninept() {
        this.ptSize = 9;
    }

    public void _tenpt() {
        this.ptSize = 10;
    }

    public void _elevenpt() {
        this.ptSize = 11;
    }

    public void _twelvept() {
        this.ptSize = 12;
    }

    public void _thirteenpt() {
        this.ptSize = 13;
    }

    public void _fourteenpt() {
        this.ptSize = 14;
    }

    public void _fifteenpt() {
        this.ptSize = 15;
    }

    public void _sixteenpt() {
        this.ptSize = 16;
    }

    public void _seventeenpt() {
        this.ptSize = 17;
    }

    public void _eightteenpt() {
        this.ptSize = 18;
    }

    public void _nineteenpt() {
        this.ptSize = 19;
    }

    public void _twentypt() {
        this.ptSize = 20;
    }

    public void _twentyonept() {
        this.ptSize = 21;
    }

    public void _twentytwopt() {
        this.ptSize = 22;
    }

    public void _twentythreept() {
        this.ptSize = 23;
    }

    public void _twentyfourpt() {
        this.ptSize = 24;
    }

    public void _twentyfivept() {
        this.ptSize = 25;
    }

    public void _twentysixpt() {
        this.ptSize = 26;
    }

    public void _twentysevenpt() {
        this.ptSize = 27;
    }

    public void _twentyeightpt() {
        this.ptSize = 28;
    }

    public void _twentyninept() {
        this.ptSize = 29;
    }

    public void _thirtypt() {
        this.ptSize = 30;
    }

    public void _thirtyfivept() {
        this.ptSize = 35;
    }

    public void _fourtypt() {
        this.ptSize = 40;
    }

    public void _fourtyfivept() {
        this.ptSize = 45;
    }

    public void _fiftypt() {
        this.ptSize = 50;
    }

    public void _fiftyfivept() {
        this.ptSize = 55;
    }

    public void _sixtypt() {
        this.ptSize = 60;
    }

    public void _seventypt() {
        this.ptSize = 70;
    }

    public void _eightypt() {
        this.ptSize = 80;
    }

    public void _ninetypt() {
        this.ptSize = 90;
    }

    public void _hundredpt() {
        this.ptSize = 100;
    }

    public void _xpt() {
        this.ptSize = 10;
    }

    public void _xipt() {
        this.ptSize = 11;
    }

    public void _xiipt() {
        this.ptSize = 12;
    }

    public void _xiiipt() {
        this.ptSize = 13;
    }

    public void _xivpt() {
        this.ptSize = 14;
    }

    public void _xvpt() {
        this.ptSize = 15;
    }

    public void _xvipt() {
        this.ptSize = 16;
    }

    public void _xviipt() {
        this.ptSize = 17;
    }

    public void _xviiipt() {
        this.ptSize = 18;
    }

    public void _xixpt() {
        this.ptSize = 19;
    }

    public void _xxpt() {
        this.ptSize = 20;
    }

    public void _xxipt() {
        this.ptSize = 21;
    }

    public void _xxiipt() {
        this.ptSize = 22;
    }

    public void _xxiiipt() {
        this.ptSize = 23;
    }

    public void _xxivpt() {
        this.ptSize = 24;
    }

    public void _xxvpt() {
        this.ptSize = 25;
    }

    public void _xxvipt() {
        this.ptSize = 26;
    }

    public void _xxviipt() {
        this.ptSize = 27;
    }

    public void _xxxpt() {
        this.ptSize = 30;
    }

    public void _xxxvpt() {
        this.ptSize = 35;
    }

    public void _xlpt() {
        this.ptSize = 40;
    }

    private int __round(double d) {
        return (int)Math.round(d);
    }

    public void _tiny() {
        this.ptSize = this.__round(0.5 * (double)this.ptBaseSize);
    }

    public void _scriptsize() {
        this.ptSize = this.__round(0.6666666666666666 * (double)this.ptBaseSize);
    }

    public void _footnotesize() {
        this.ptSize = this.__round(0.8333333333333334 * (double)this.ptBaseSize);
    }

    public void _small() {
        this.ptSize = this.__round(0.9166666666666666 * (double)this.ptBaseSize);
    }

    public void _normalsize() {
        this.ptSize = this.ptBaseSize;
    }

    public void _large() {
        this.ptSize = this.__round(1.1666666666666667 * (double)this.ptBaseSize);
    }

    public void _Large() {
        this.ptSize = this.__round(1.4166666666666667 * (double)this.ptBaseSize);
    }

    public void _LARGE() {
        this.ptSize = this.__round(1.6666666666666667 * (double)this.ptBaseSize);
    }

    public void _huge() {
        this.ptSize = this.__round(2.0833333333333335 * (double)this.ptBaseSize);
    }

    public void _Huge() {
        this.ptSize = this.__round(2.0833333333333335 * (double)this.ptBaseSize);
    }

    public void _hashsign() {
        this.unicode("#", -12, 35);
    }

    public void _atsign() {
        this.unicode("@", -12, 64);
    }

    public void _lbracket() {
        this.unicode("[", -12, 91);
    }

    public void _backslash() {
        this.unicode("\\", 40, 92);
    }

    public void _rbracket() {
        this.unicode("]", -12, 93);
    }

    public void _lbrace() {
        this.unicode("{", 44, 102);
    }

    public void _verticalbar() {
        this.unicode("|", 44, 106);
    }

    public void _rbrace() {
        this.unicode("}", 44, 103);
    }

    public void _tildechar() {
        this.unicode("~", -12, 126);
    }

    public void _lesschar() {
        this.unicode("<", 42, 60);
    }

    public void _equalchar() {
        this.unicode("=", -12, 61);
    }

    public void _greaterchar() {
        this.unicode(">", 42, 62);
    }

    public void _arccos() {
        this.mathfunction("arccos");
    }

    public void _arcsin() {
        this.mathfunction("arcsin");
    }

    public void _arctan() {
        this.mathfunction("arctan");
    }

    public void _arg() {
        this.mathfunction("arg");
    }

    public void _atan() {
        this.mathfunction("atan");
    }

    public void _cos() {
        this.mathfunction("cos");
    }

    public void _cosh() {
        this.mathfunction("cosh");
    }

    public void _cot() {
        this.mathfunction("cot");
    }

    public void _coth() {
        this.mathfunction("coth");
    }

    public void _csc() {
        this.mathfunction("csc");
    }

    public void _deg() {
        this.mathfunction("deg");
    }

    public void _det() {
        this.mathfunction("det");
    }

    public void _dim() {
        this.mathfunction("dim");
    }

    public void _exp() {
        this.mathfunction("exp");
    }

    public void _gcd() {
        this.mathfunction("gcd");
    }

    public void _hom() {
        this.mathfunction("hom");
    }

    public void _inf() {
        this.mathfunction("inf");
    }

    public void _ker() {
        this.mathfunction("ker");
    }

    public void _lg() {
        this.mathfunction("lg");
    }

    public void _lim() {
        this.mathfunction("lim");
    }

    public void _liminf() {
        this.mathfunction("liminf");
    }

    public void _limsup() {
        this.mathfunction("limsup");
    }

    public void _ln() {
        this.mathfunction("ln");
    }

    public void _log() {
        this.mathfunction("log");
    }

    public void _max() {
        this.mathfunction("max");
    }

    public void _min() {
        this.mathfunction("min");
    }

    public void _Pr() {
        this.mathfunction("Pr");
    }

    public void _sec() {
        this.mathfunction("sec");
    }

    public void _sin() {
        this.mathfunction("sin");
    }

    public void _sinh() {
        this.mathfunction("sinh");
    }

    public void _sgn() {
        this.mathfunction("sgn");
    }

    public void _sup() {
        this.mathfunction("sup");
    }

    public void _tan() {
        this.mathfunction("tan");
    }

    public void _tanh() {
        this.mathfunction("tanh");
    }

    public void _alpha() {
        this.greek("\u03b1", 42, 174);
    }

    public void _beta() {
        this.greek("\u03b2", 42, 175);
    }

    public void _gamma() {
        this.greek("\u03b3", 42, 176);
    }

    public void _delta() {
        this.greek("\u03b4", 42, 177);
    }

    public void _epsilon() {
        this.greek("\u03b5", 42, 178);
    }

    public void _zeta() {
        this.greek("\u03b6", 42, 179);
    }

    public void _eta() {
        this.greek("\u03b7", 42, 180);
    }

    public void _theta() {
        this.greek("\u03b8", 42, 181);
    }

    public void _iota() {
        this.greek("\u03b9", 42, 182);
    }

    public void _kappa() {
        this.greek("\u03ba", 42, 183);
    }

    public void _lambda() {
        this.greek("\u03bb", 42, 184);
    }

    public void _mu() {
        this.greek("\u03bc", 42, 185);
    }

    public void _nu() {
        this.greek("\u03bd", 42, 186);
    }

    public void _xi() {
        this.greek("\u03be", 42, 187);
    }

    public void _greeko() {
        this.greek("\u03bf", 42, 111);
    }

    public void _pi() {
        this.greek("\u03c0", 42, 188);
    }

    public void _rho() {
        this.greek("\u03c1", 42, 189);
    }

    public void _sigma() {
        this.greek("\u03c3", 42, 190);
    }

    public void _tau() {
        this.greek("\u03c4", 42, 191);
    }

    public void _upsilon() {
        this.greek("\u03c5", 42, 192);
    }

    public void _phi() {
        this.greek("\u03d5", 42, 193);
    }

    public void _chi() {
        this.greek("\u03c7", 42, 194);
    }

    public void _psi() {
        this.greek("\u03c8", 42, 195);
    }

    public void _omega() {
        this.greek("\u03c9", 42, 33);
    }

    public void _varepsilon() {
        this.greek("\u02b5", 42, 34);
    }

    public void _vartheta() {
        this.greek("\u03d1", 42, 35);
    }

    public void _varpi() {
        this.greek("\u03d6", 42, 36);
    }

    public void _varrho() {
        this.greek("\u03f1", 42, 37);
    }

    public void _varsigma() {
        this.greek("\u03da", 42, 38);
    }

    public void _varphi() {
        this.greek("\u03c6", 42, 39);
    }

    public void _Alpha() {
        this.greek("\u0391", 35, 65);
    }

    public void _Beta() {
        this.greek("\u0392", 35, 66);
    }

    public void _Gamma() {
        this.greek("\u0393", 35, 161);
    }

    public void _Delta() {
        this.greek("\u0394", 35, 162);
    }

    public void _Epsilon() {
        this.greek("\u0395", 35, 69);
    }

    public void _Zeta() {
        this.greek("\u0396", 35, 90);
    }

    public void _Eta() {
        this.greek("\u0397", 35, 78);
    }

    public void _Theta() {
        this.greek("\u0398", 35, 163);
    }

    public void _Iota() {
        this.greek("\u0399", 35, 73);
    }

    public void _Kappa() {
        this.greek("\u039a", 35, 75);
    }

    public void _Lambda() {
        this.greek("\u039b", 35, 164);
    }

    public void _Mu() {
        this.greek("\u039c", 35, 77);
    }

    public void _Nu() {
        this.greek("\u039d", 35, 78);
    }

    public void _Xi() {
        this.greek("\u039e", 35, 165);
    }

    public void _Greeko() {
        this.greek("\u039f", 35, 79);
    }

    public void _Pi() {
        this.greek("\u03a0", 35, 166);
    }

    public void _Rho() {
        this.greek("\u03a1", 35, 82);
    }

    public void _Sigma() {
        this.greek("\u03a3", 35, 167);
    }

    public void _Tau() {
        this.greek("\u03a4", 35, 84);
    }

    public void _Upsilon() {
        this.greek("\u03a5", 35, 168);
    }

    public void _Phi() {
        this.greek("\u03a6", 35, 169);
    }

    public void _Chi() {
        this.greek("\u03a7", 35, 88);
    }

    public void _Psi() {
        this.greek("\u03a8", 35, 170);
    }

    public void _Omega() {
        this.greek("\u03a9", 35, 173);
    }

    public void _calA() {
        this.calli("A", 44, 65);
    }

    public void _calB() {
        this.calli("B", 44, 66);
    }

    public void _calC() {
        this.calli("C", 44, 67);
    }

    public void _calD() {
        this.calli("D", 44, 68);
    }

    public void _calE() {
        this.calli("E", 44, 69);
    }

    public void _calF() {
        this.calli("F", 44, 70);
    }

    public void _calG() {
        this.calli("G", 44, 71);
    }

    public void _calH() {
        this.calli("H", 44, 72);
    }

    public void _calI() {
        this.calli("I", 44, 73);
    }

    public void _calJ() {
        this.calli("J", 44, 74);
    }

    public void _calK() {
        this.calli("K", 44, 75);
    }

    public void _calL() {
        this.calli("L", 44, 76);
    }

    public void _calM() {
        this.calli("M", 44, 77);
    }

    public void _calN() {
        this.calli("N", 44, 78);
    }

    public void _calO() {
        this.calli("O", 44, 79);
    }

    public void _calP() {
        this.calli("P", 44, 80);
    }

    public void _calQ() {
        this.calli("Q", 44, 81);
    }

    public void _calR() {
        this.calli("R", 44, 82);
    }

    public void _calS() {
        this.calli("S", 44, 83);
    }

    public void _calT() {
        this.calli("T", 44, 84);
    }

    public void _calU() {
        this.calli("U", 44, 85);
    }

    public void _calV() {
        this.calli("V", 44, 86);
    }

    public void _calW() {
        this.calli("W", 44, 87);
    }

    public void _calX() {
        this.calli("X", 44, 88);
    }

    public void _calY() {
        this.calli("Y", 44, 89);
    }

    public void _calZ() {
        this.calli("Z", 44, 90);
    }

    public void _aleph() {
        this.unicode("\u2135", 44, 64);
    }

    public void _hbar() {
        this.unicode("\u210f", 48, 126);
    }

    public void _imath() {
        this.unicode("FIXME", 42, 123);
    }

    public void _jmath() {
        this.unicode("FIXME", 42, 124);
    }

    public void _ell() {
        this.unicode("\u2113", 42, 96);
    }

    public void _wp() {
        this.unicode("\u2118", 42, 125);
    }

    public void _Re() {
        this.unicode("\u211c", 44, 60);
    }

    public void _Im() {
        this.unicode("\u2111", 44, 61);
    }

    public void _partial() {
        this.unicode("\u2202", 42, 64);
    }

    public void _infty() {
        this.unicode("\u221e", 44, 49);
    }

    public void _prime() {
        this.unicode("\u2032", 44, 48);
    }

    public void _emptyset() {
        this.unicode("\u2205", 44, 59);
    }

    public void _nabla() {
        this.unicode("\u2207", 44, 114);
    }

    public void _surd() {
        this.unicode("\u221a", 44, 112);
    }

    public void _top() {
        this.unicode("\u22a4", 44, 62);
    }

    public void _bot() {
        this.unicode("\u22a5", 44, 63);
    }

    public void _doublebar() {
        this.unicode("FIXME", 44, 107);
    }

    public void _angle() {
        this.unicode("\u2220", 47, 92);
    }

    public void _triangle() {
        this.unicode("\u2206", 44, 52);
    }

    public void _mbackslash() {
        this.unicode("\\", 44, 110);
    }

    public void _forall() {
        this.unicode("\u2200", 44, 56);
    }

    public void _exists() {
        this.unicode("\u2203", 44, 57);
    }

    public void _neg() {
        this.unicode("\u00ac", 44, 58);
    }

    public void _flat() {
        this.unicode("FIXME", 42, 91);
    }

    public void _natural() {
        this.unicode("FIXME", 42, 92);
    }

    public void _sharp() {
        this.unicode("FIXME", 42, 93);
    }

    public void _clubsuit() {
        this.unicode("\u2663", 44, 124);
    }

    public void _diamondsuit() {
        this.unicode("\u2666", 44, 125);
    }

    public void _heartsuit() {
        this.unicode("\u2665", 44, 126);
    }

    public void _spadesuit() {
        this.unicode("\u2660", 44, 196);
    }

    public void _oldstyle() {
        this.FIXME("oldstyle");
    }

    public void _sum() {
        this.unicode("\u2211", -12, 167);
    }

    public void _prod() {
        this.unicode("\u220f", -12, 166);
    }

    public void _coprod() {
        this.unicode("\u2210", 44, 113);
    }

    public void _int() {
        this.unicode("\u222b", 44, 115);
    }

    public void _oint() {
        this.unicode("\u222e", 46, 72);
    }

    public void _bigcap() {
        this.big_opr("\u2229", 44, 92);
    }

    public void _bigcup() {
        this.big_opr("\u222a", 44, 91);
    }

    public void _bigsqcup() {
        this.big_opr("\u2294", 44, 116);
    }

    public void _bigvee() {
        this.big_opr("\u2228", 44, 95);
    }

    public void _bigwedge() {
        this.big_opr("\u2227", 44, 94);
    }

    public void _bigodot() {
        this.big_opr("\u2299", 44, 175);
    }

    public void _bigotimes() {
        this.big_opr("\u2297", 44, 173);
    }

    public void _bigoplus() {
        this.big_opr("\u2295", 44, 169);
    }

    public void _biguplus() {
        this.big_opr("\u228e", 44, 93);
    }

    public int _Sum(Object[] objectArray) {
        if (objectArray == null) {
            return 2;
        }
        this.setState(this.stack.pop());
        LP2 lP2 = this;
        if (lP2 == null) {
            throw null;
        }
        CharBox charBox = lP2.new CharBox("\u00a7", 35, 2 * this.ptSize, this.colorIndex);
        charBox.setYOffset((int)(-0.3 * (double)this.ptSize));
        return this.__big_operator(objectArray, charBox);
    }

    public void _Sum_BEGIN() {
        this.__big_operator_begin();
    }

    public int _Prod(Object[] objectArray) {
        if (objectArray == null) {
            return 2;
        }
        this.setState(this.stack.pop());
        LP2 lP2 = this;
        if (lP2 == null) {
            throw null;
        }
        CharBox charBox = lP2.new CharBox("\u00a6", 35, 2 * this.ptSize, this.colorIndex);
        charBox.setYOffset((int)(-0.3 * (double)this.ptSize));
        return this.__big_operator(objectArray, charBox);
    }

    public void _Prod_BEGIN() {
        this.__big_operator_begin();
    }

    public int _Int(Object[] objectArray) {
        if (objectArray == null) {
            return 2;
        }
        this.setState(this.stack.pop());
        LP2 lP2 = this;
        if (lP2 == null) {
            throw null;
        }
        CharBox charBox = lP2.new CharBox("s", 44, 2 * this.ptSize, this.colorIndex);
        return this.__big_operator(objectArray, charBox);
    }

    public void _Int_BEGIN() {
        this.__big_operator_begin();
    }

    private void __big_operator_begin() {
        int n;
        this.stack.push(this.getState());
        LP2 lP2 = this;
        if (lP2 == null) {
            throw null;
        }
        SubSuperScriptBox subSuperScriptBox = lP2.new SubSuperScriptBox(this.fontIndex, this.ptSize);
        this.ptSize = n = subSuperScriptBox.getSubscriptPtSize();
    }

    private int __big_operator(Object[] objectArray, Box box) {
        GroupBox groupBox = (GroupBox)objectArray[0];
        GroupBox groupBox2 = (GroupBox)objectArray[1];
        GroupBox groupBox3 = (GroupBox)groupBox.getParent();
        groupBox3.deleteAllMembers();
        box.moveTo(groupBox3.getX(), groupBox3.getY());
        LP2 lP2 = this;
        if (lP2 == null) {
            throw null;
        }
        StackBox stackBox = lP2.new StackBox();
        stackBox.setParent(groupBox3.getParent());
        stackBox.moveTo(groupBox3.getX(), groupBox3.getY());
        stackBox.setCenterBox(box);
        stackBox.setTopBox(groupBox2);
        stackBox.setBottomBox(groupBox);
        stackBox.measure();
        groupBox3.appendMember(stackBox);
        groupBox3.measure();
        return 0;
    }

    public int _lstack(Object[] objectArray) {
        return this.__stack(objectArray, 1);
    }

    public int _cstack(Object[] objectArray) {
        return this.__stack(objectArray, 2);
    }

    public int _rstack(Object[] objectArray) {
        return this.__stack(objectArray, 3);
    }

    private int __stack(Object[] objectArray, int n) {
        if (objectArray == null) {
            return 3;
        }
        GroupBox groupBox = (GroupBox)objectArray[0];
        GroupBox groupBox2 = (GroupBox)objectArray[1];
        GroupBox groupBox3 = (GroupBox)objectArray[2];
        GroupBox groupBox4 = (GroupBox)groupBox2.getParent();
        groupBox4.deleteAllMembers();
        groupBox2.moveTo(groupBox4.getX(), groupBox4.getY());
        groupBox.measure();
        groupBox2.measure();
        groupBox3.measure();
        int n2 = groupBox.getW();
        int n3 = groupBox2.getW();
        int n4 = groupBox3.getW();
        LP2 lP2 = this;
        if (lP2 == null) {
            throw null;
        }
        StackBox stackBox = lP2.new StackBox();
        stackBox.moveTo(groupBox4.getX(), groupBox4.getY());
        stackBox.setParent(groupBox4.getParent());
        stackBox.setTopBox(groupBox);
        stackBox.setBottomBox(groupBox3);
        stackBox.setCenterBox(groupBox2);
        stackBox.setAlignment(n);
        stackBox.measure();
        groupBox4.appendMember(stackBox);
        groupBox4.measure();
        return 0;
    }

    public int _frac(Object[] objectArray) {
        if (objectArray == null) {
            return 2;
        }
        GroupBox groupBox = (GroupBox)objectArray[0];
        GroupBox groupBox2 = (GroupBox)objectArray[1];
        GroupBox groupBox3 = (GroupBox)groupBox2.getParent();
        groupBox3.deleteAllMembers();
        groupBox2.measure();
        groupBox.measure();
        int n = groupBox2.getW();
        int n2 = groupBox.getW();
        int n3 = Math.max(n, n2);
        Box box = this.__make_line(groupBox3.getX(), groupBox3.getY(), n3);
        LP2 lP2 = this;
        if (lP2 == null) {
            throw null;
        }
        StackBox stackBox = lP2.new StackBox();
        stackBox.moveTo(groupBox3.getX(), groupBox3.getY());
        stackBox.setParent(groupBox3.getParent());
        stackBox.setTopBox(groupBox);
        stackBox.setBottomBox(groupBox2);
        stackBox.setCenterBox(box);
        stackBox.measure();
        groupBox3.appendMember(stackBox);
        groupBox3.measure();
        return 0;
    }

    public void _minus() {
        this.binaryop("\u2212", 44, 161);
    }

    public void _slash() {
        this.binaryop("/", 44, 61);
    }

    public void _pm() {
        this.binaryop("\u00b2", 44, 167);
    }

    public void _mp() {
        this.binaryop("\u2213", 44, 168);
    }

    public void _setminus() {
        this.binaryop("\u2216", 44, 110);
    }

    public void _cdot() {
        this.binaryop("\u22c5", 44, 162);
    }

    public void _cdotvar() {
        this.binaryop("\u00b7", 44, 162);
    }

    public void _times() {
        this.binaryop("\u00d7", 44, 163);
    }

    public void _ast() {
        this.binaryop("\u2217", 44, 164);
    }

    public void _star() {
        this.binaryop("\u22c6", 42, 63);
    }

    public void _diamond() {
        this.binaryop("\u22c4", 44, 166);
    }

    public void _circ() {
        this.binaryop("\u2218", 44, 177);
    }

    public void _bullet() {
        this.binaryop("\u2219", 44, 178);
    }

    public void _div() {
        this.binaryop("\u00f7", 44, 165);
    }

    public void _cap() {
        this.binaryop("\u2229", 44, 92);
    }

    public void _cup() {
        this.binaryop("\u222a", 44, 91);
    }

    public void _uplus() {
        this.binaryop("\u228e", 44, 93);
    }

    public void _sqcap() {
        this.binaryop("\u2293", 44, 117);
    }

    public void _sqcup() {
        this.binaryop("\u2294", 44, 116);
    }

    public void _triangleleft() {
        this.binaryop("\u22b2", 42, 47);
    }

    public void _triangleright() {
        this.binaryop("\u22b3", 42, 46);
    }

    public void _wr() {
        this.binaryop("\u2240", 44, 111);
    }

    public void _bigcirc() {
        this.binaryop("\u25cb", 44, 176);
    }

    public void _bigtriangleup() {
        this.binaryop("\u2206", 44, 52);
    }

    public void _bigtriangledown() {
        this.binaryop("\u2207", 44, 53);
    }

    public void _vee() {
        this.binaryop("\u2228", 44, 95);
    }

    public void _wedge() {
        this.binaryop("\u2227", 44, 94);
    }

    public void _oplus() {
        this.binaryop("\u2295", 44, 169);
    }

    public void _ominus() {
        this.binaryop("\u2296", 44, 170);
    }

    public void _otimes() {
        this.binaryop("\u2297", 44, 173);
    }

    public void _oslash() {
        this.binaryop("\u2298", 44, 174);
    }

    public void _odot() {
        this.binaryop("\u2299", 44, 175);
    }

    public void _dagger() {
        this.binaryop("\u2020", 44, 121);
    }

    public void _ddagger() {
        this.binaryop("\u2021", 44, 122);
    }

    public void _amalg() {
        this.binaryop("\u2210", 44, 113);
    }

    public void _lessthan() {
        this.relation("<", 42, 60);
    }

    public void _greaterthan() {
        this.relation(">", 42, 62);
    }

    public void _equals() {
        this.relation("=", 35, 61);
    }

    public void _leq() {
        this.relation("\u2264", 44, 183);
    }

    public void _prec() {
        this.relation("\u227a", 44, 193);
    }

    public void _preceq() {
        this.relation("\u227c", 44, 185);
    }

    public void _ll() {
        this.relation("\u226a", 44, 191);
    }

    public void _subset() {
        this.relation("\u2282", 44, 189);
    }

    public void _subseteq() {
        this.relation("\u2286", 44, 181);
    }

    public void _sqsubseteq() {
        this.relation("\u2291", 44, 118);
    }

    public void _in() {
        this.relation("\u2208", 44, 50);
    }

    public void _vdash() {
        this.relation("\u22a2", 44, 96);
    }

    public void _smile() {
        this.relation("\u203f", 42, 94);
    }

    public void _frown() {
        this.relation("\u2040", 42, 95);
    }

    public void _geq() {
        this.relation("\u2265", 44, 184);
    }

    public void _succ() {
        this.relation("\u227b", 44, 194);
    }

    public void _succeq() {
        this.relation("\u227d", 44, 186);
    }

    public void _gg() {
        this.relation("\u226b", 44, 192);
    }

    public void _supset() {
        this.relation("\u2283", 44, 190);
    }

    public void _supseteq() {
        this.relation("\u2287", 44, 182);
    }

    public void _sqsupseteq() {
        this.relation("\u2292", 44, 119);
    }

    public void _ni() {
        this.relation("\u220b", 44, 51);
    }

    public void _dashv() {
        this.relation("\u22a3", 44, 97);
    }

    public void _mid() {
        this.relation("\u2223", 44, 106);
    }

    public void _parallel() {
        this.relation("\u2225", 44, 107);
    }

    public void _equiv() {
        this.relation("\u2261", 44, 180);
    }

    public void _sim() {
        this.relation("\u223c", 44, 187);
    }

    public void _simeq() {
        this.relation("\u22d6", 44, 39);
    }

    public void _asymp() {
        this.relation("\u224d", 44, 179);
    }

    public void _approx() {
        this.relation("\u2248", 44, 188);
    }

    public void _cong() {
        this.relation("\u2245", -13, 0);
    }

    public void _bowtie() {
        this.relation("\u22c8", -13, 0);
    }

    public void _propto() {
        this.relation("\u221d", 44, 47);
    }

    public void _models() {
        this.relation("\u22a8", 47, 178);
    }

    public void _doteq() {
        this.relation("\u2250", 47, 36);
    }

    public void _perp() {
        this.relation("\u22a5", 44, 63);
    }

    public void _not() {
        this._not_internal();
    }

    public void _notin() {
        this._not();
        this._in();
    }

    public void _leftarrow() {
        this.relation("\u2190", 44, 195);
    }

    public void _Leftarrow() {
        this.relation("\u21d0", 44, 40);
    }

    public void _rightarrow() {
        this.relation("\u2192", 44, 33);
    }

    public void _Rightarrow() {
        this.relation("\u21d2", 44, 41);
    }

    public void _leftrightarrow() {
        this.relation("\u2194", 44, 36);
    }

    public void _Leftrightarrow() {
        this.relation("\u21d4", 44, 44);
    }

    public void _mapsto() {
        this.relation("\u21a6", 44, 55, 44, 33, 0);
    }

    public void _hookleftarrow() {
        this.relation("\u21a9", 44, 195, 42, 45, -4);
    }

    public void _leftharpoonup() {
        this.relation("\u21bc", 42, 40);
    }

    public void _leftharpoondown() {
        this.relation("\u21bd", 42, 41);
    }

    public void _rightleftharpoons() {
        this.FIXME("_rightleftharpoons");
    }

    public void _longleftarrow() {
        this.relation("\u2190", 44, 195, 44, 161, -4);
    }

    public void _Longleftarrow() {
        this.relation("\u21d0", 44, 40, 35, 61, -4);
    }

    public void _longrightarrow() {
        this.relation("\u2192", 44, 161, 44, 33, -4);
    }

    public void _Longrightarrow() {
        this.relation("\u21d2", 35, 61, 44, 41, -4);
    }

    public void _longleftrightarrow() {
        this.relation("\u2194", 44, 195, 44, 33, -4);
    }

    public void _Longleftrightarrow() {
        this.relation("\u21d4", 44, 40, 44, 41, -4);
    }

    public void _longmapsto() {
        this.relation("\u21a6", 44, 55, 44, 33, 0);
    }

    public void _hookrightarrow() {
        this.relation("\u21aa", 42, 44, 44, 33, -4);
    }

    public void _rightharpoonup() {
        this.relation("\u21c0", 42, 42);
    }

    public void _rightharpoondown() {
        this.relation("\u21c1", 42, 43);
    }

    public void _uparrow() {
        this.relation("\u2191", 44, 34);
    }

    public void _Uparrow() {
        this.relation("\u21d1", 44, 42);
    }

    public void _downarrow() {
        this.relation("\u2193", 44, 35);
    }

    public void _Downarrow() {
        this.relation("\u21d3", 44, 43);
    }

    public void _updownarrow() {
        this.relation("\u2195", 44, 108);
    }

    public void _Updownarrow() {
        this.relation("\u21d5", 44, 109);
    }

    public void _nearrow() {
        this.relation("\u2197", 44, 45);
    }

    public void _searrow() {
        this.relation("\u2198", 44, 46);
    }

    public void _swarrow() {
        this.relation("\u2199", 44, 38);
    }

    public void _nwarrow() {
        this.relation("\u2196", 44, 37);
    }

    public void _buildrel() {
        this.FIXME("buildrel not supported.");
    }

    public void _looparrowleft() {
        this.unicode("\u21ab", 47, 34);
    }

    public void _looparrowright() {
        this.unicode("\u21ac", 47, 35);
    }

    public void _leftrightsquigarrow() {
        this.unicode("\u21ad", 47, 33);
    }

    public void _circlearrowleft() {
        this.unicode("\u21ba", 47, 169);
    }

    public void _circlearrowright() {
        this.unicode("\u21bb", 47, 168);
    }

    public void _nleftarrow() {
        this.unicode("\u219a", 48, 56);
    }

    public void _nrightarrow() {
        this.unicode("\u219b", 48, 57);
    }

    public void _nleftrightarrow() {
        this.unicode("\u21ae", 48, 61);
    }

    public void _nLeftarrow() {
        this.unicode("\u21cd", 48, 58);
    }

    public void _nLeftrightarrow() {
        this.unicode("\u21ce", 48, 60);
    }

    public void _nRightarrow() {
        this.unicode("\u21cf", 48, 59);
    }

    public void _lbrack() {
        this.unicode("[", 35, 91);
    }

    public void _lfloor() {
        this.unicode("FIXME", 44, 98);
    }

    public void _lceil() {
        this.unicode("\u02e5", 44, 100);
    }

    public void _langle() {
        this.unicode("FIXME", 44, 104);
    }

    public void _lmoustache() {
        this.FIXME("lmoustache");
    }

    public void _lgroup() {
        this.FIXME("lgroup");
    }

    public void _rbrack() {
        this.unicode("]", 35, 93);
    }

    public void _rfloor() {
        this.unicode("FIXME", 44, 99);
    }

    public void _rceil() {
        this.unicode("\u02e9", 44, 101);
    }

    public void _rangle() {
        this.unicode("FIXME", 44, 105);
    }

    public void _rmoustache() {
        this.FIXME("rmoustache");
    }

    public void _rgroup() {
        this.FIXME("rgroup");
    }

    public void _arrowvert() {
        this.FIXME("arrowvert");
    }

    public void _Arrowvert() {
        this.FIXME("Arrowvert");
    }

    public void _bracevert() {
        this.FIXME("bracevert");
    }

    public void _colon() {
        this.unicode(":", 35, 58);
    }

    public void _ldots() {
        this._ldots_internal();
    }

    public void _cdots() {
        this._cdots_internal();
    }

    public void _ne() {
        this._neq();
    }

    public void _neq() {
        this.relation("\u2260", 35, 61, 42, 61, -10);
    }

    public void _le() {
        this._leq();
    }

    public void _ge() {
        this._geq();
    }

    public void _to() {
        this._rightarrow();
    }

    public void _gets() {
        this._leftarrow();
    }

    public void _owns() {
        this._ni();
    }

    public void _land() {
        this._wedge();
    }

    public void _lor() {
        this._vee();
    }

    public void _lnot() {
        this._neg();
    }

    public void _vert() {
        this._verticalbar();
    }

    public void _Vert() {
        this._parallel();
    }

    public void _iff() {
        this._thinspace();
        this._Longleftrightarrow();
        this._thinspace();
    }

    public void _S() {
        this.unicode("\u00a7", 44, 120);
    }

    public void _P() {
        this.unicode("\u00b6", 44, 123);
    }

    public void _dag() {
        this.unicode("\u2020", 44, 121);
    }

    public void _ddag() {
        this.unicode("\u2021", 44, 122);
    }

    public void _sqsubset() {
        this.unicode("\u228f");
    }

    public void _define() {
        this.unicode("\u225d", -13, 0);
    }

    public void _Join() {
        this.unicode("\u22c8");
    }

    public void _sqsupset() {
        this.unicode("\u2290");
    }

    public void _vdots() {
        this.unicode("\u22ee");
    }

    public void _ddots() {
        this.unicode("\u22f1");
    }

    public void _Box() {
        this.unicode("\u25a1");
    }

    public void _Diamond() {
        this.unicode("\u25ca");
    }

    public void _mho() {
        this.unicode("\u2127");
    }

    public void _euro() {
        this.unicode("\u20ac");
    }

    public void _pound() {
        this.unicode("\u20a4");
    }

    public void _pts() {
        this.unicode("\u20a7");
    }

    public void _setZ() {
        this.unicode("\u2124", 48, 90);
    }

    public void _setN() {
        this.unicode("\u2115", 48, 78);
    }

    public void _setR() {
        this.unicode("\u211d", 48, 82);
    }

    public void _celsius() {
        this.unicode("\u2103", 35, 186, 35, 67, 3);
    }

    public void _fahrenheit() {
        this.unicode("\u2109", 35, 186, 35, 70, 3);
    }

    public void _complement() {
        this.unicode("\u2201", 47, 123);
    }

    public void _nexists() {
        this.unicode("\u2204", 48, 64);
    }

    public void _varnothing() {
        this.unicode("\u2205", 44, 59);
    }

    public void _mathslash() {
        this.unicode("\u2215", 42, 60);
    }

    public void _root() {
        this.unicode("\u221a", 44, 112);
    }

    public void _cubicroot() {
        this.unicode("\u221b", -13, 0);
    }

    public void _fourthroot() {
        this.unicode("\u221c", -13, 0);
    }

    public void _varpropto() {
        this.unicode("\u221d", 44, 47);
    }

    public void _lhd() {
        this.unicode("\u22b2");
    }

    public void _rhd() {
        this.unicode("\u22b3");
    }

    public void _unlhd() {
        this.unicode("\u22b4");
    }

    public void _unrhd() {
        this.unicode("\u22b5");
    }

    public void _iint() {
        this.unicode("\u222c", -13, 0);
    }

    public void _iiint() {
        this.unicode("\u222d", -13, 0);
    }

    public void _telephone() {
        this.unicode("\u260e", -13, 0);
    }

    public void _smiley() {
        this.unicode("\u263a", -13, 0);
    }

    public void _smileyblack() {
        this.unicode("\u263b", -13, 0);
    }

    public void _male() {
        this.unicode("\u2642", -13, 0);
    }

    public void _female() {
        this.unicode("\u2640", -13, 0);
    }

    public void _proportional() {
        this.unicode("\u2243");
    }

    public void _approxeq() {
        this.unicode("\u2245");
    }

    public int _pmb() {
        this.FIXME("\\pmb#1");
        return 1;
    }

    public int _hat(Object[] objectArray) {
        return this.accent("\\hat", objectArray);
    }

    public int _check(Object[] objectArray) {
        return this.accent("\\check", objectArray);
    }

    public int _acute(Object[] objectArray) {
        return this.accent("\\acute", objectArray);
    }

    public int _grave(Object[] objectArray) {
        return this.accent("\\grave", objectArray);
    }

    public int _bar(Object[] objectArray) {
        return this.accent("\\bar", objectArray);
    }

    public int _vec(Object[] objectArray) {
        return this.accent("\\vec", objectArray);
    }

    public int _dot(Object[] objectArray) {
        return this.accent("\\dot", objectArray);
    }

    public int _ddot(Object[] objectArray) {
        return this.accent("\\ddot", objectArray);
    }

    public int _tilde(Object[] objectArray) {
        return this.accent("\\tilde", objectArray);
    }

    public int _dq(Object[] objectArray) {
        return this.accent("\\dq", objectArray);
    }

    public int accent(String string, Object[] objectArray) {
        if (objectArray == null) {
            return 1;
        }
        CharBox charBox = null;
        if (this.fontMode == 2) {
            if ("\\hat".equals(string)) {
                LP2 lP2 = this;
                if (lP2 == null) {
                    throw null;
                }
                charBox = lP2.new CharBox("^", 35, this.ptSize, this.colorIndex);
            } else if ("\\dot".equals(string)) {
                LP2 lP2 = this;
                if (lP2 == null) {
                    throw null;
                }
                charBox = lP2.new CharBox("_", 35, this.ptSize, this.colorIndex);
            } else if ("\\tilde".equals(string)) {
                LP2 lP2 = this;
                if (lP2 == null) {
                    throw null;
                }
                charBox = lP2.new CharBox("~", 35, this.ptSize, this.colorIndex);
            } else if ("\\acute".equals(string)) {
                LP2 lP2 = this;
                if (lP2 == null) {
                    throw null;
                }
                charBox = lP2.new CharBox("\u00b5", 35, this.ptSize, this.colorIndex);
            } else if ("\\check".equals(string)) {
                LP2 lP2 = this;
                if (lP2 == null) {
                    throw null;
                }
                charBox = lP2.new CharBox("\u00b6", 35, this.ptSize, this.colorIndex);
            } else if ("\\grave".equals(string)) {
                LP2 lP2 = this;
                if (lP2 == null) {
                    throw null;
                }
                charBox = lP2.new CharBox("\u00b8", 35, this.ptSize, this.colorIndex);
            } else if ("\\bar".equals(string)) {
                LP2 lP2 = this;
                if (lP2 == null) {
                    throw null;
                }
                charBox = lP2.new CharBox("\u00b9", 35, this.ptSize, this.colorIndex);
            } else if ("\\ddot".equals(string)) {
                LP2 lP2 = this;
                if (lP2 == null) {
                    throw null;
                }
                charBox = lP2.new CharBox("\u00c4", 35, this.ptSize, this.colorIndex);
            } else if ("\\dq".equals(string)) {
                LP2 lP2 = this;
                if (lP2 == null) {
                    throw null;
                }
                charBox = lP2.new CharBox("\"", 35, this.ptSize, this.colorIndex);
            } else if ("\\vec".equals(string)) {
                LP2 lP2 = this;
                if (lP2 == null) {
                    throw null;
                }
                charBox = lP2.new CharBox("~", 42, this.ptSize, this.colorIndex);
            } else if ("\\tinyinversegrave".equals(string)) {
                LP2 lP2 = this;
                if (lP2 == null) {
                    throw null;
                }
                charBox = lP2.new CharBox("\u00c4", 42, this.ptSize, this.colorIndex);
            } else {
                LP2.msg("-E- accent: unknown command: " + string);
                LP2 lP2 = this;
                if (lP2 == null) {
                    throw null;
                }
                charBox = lP2.new CharBox("#", 35, this.ptSize, this.colorIndex);
            }
        } else {
            LP2.msg("-E- Internal: accent command '" + string + "' only supported " + "when using the Computer Modern fonts, sorry.");
            LP2 lP2 = this;
            if (lP2 == null) {
                throw null;
            }
            charBox = lP2.new CharBox(string, this.fontIndex, this.ptSize, this.colorIndex);
        }
        GroupBox groupBox = (GroupBox)objectArray[0];
        GroupBox groupBox2 = (GroupBox)groupBox.getParent();
        LP2 lP2 = this;
        if (lP2 == null) {
            throw null;
        }
        StackBox stackBox = lP2.new StackBox();
        stackBox.setAlignment(2);
        stackBox.setParent(groupBox.getParent());
        stackBox.moveTo(groupBox2.getX(), groupBox2.getY());
        stackBox.setCenterBox(groupBox);
        stackBox.setTopBox(charBox);
        stackBox.measure();
        groupBox2.deleteMember(groupBox);
        groupBox2.appendMember(stackBox);
        groupBox2.measure();
        return 0;
    }

    public void _widetilde() {
        this.FIXME("widetilde#1");
    }

    public void _widehat() {
        this.FIXME("widehat#1");
    }

    public void _overleftarrow() {
        this.FIXME("overleftarrow#1");
    }

    public void _overrightarrow() {
        this.FIXME("overrightarrow#1");
    }

    public int _overbrace() {
        this.FIXME("overbrace#1");
        return 1;
    }

    public int _underbrace() {
        this.FIXME("underbrace#1");
        return 1;
    }

    public void _over() {
        this.FIXME("#1\\over#2: Please use \\frac{#1}{#2} instead");
    }

    public int _sqrtn() {
        this.FIXME("sqrt#1#2");
        return 2;
    }

    public int _underline(Object[] objectArray) {
        if (objectArray == null) {
            return 1;
        }
        GroupBox groupBox = (GroupBox)objectArray[0];
        groupBox.measure();
        double d = groupBox.getW();
        GroupBox groupBox2 = (GroupBox)this.__make_line(0.0, 0.0, d);
        LP2 lP2 = this;
        if (lP2 == null) {
            throw null;
        }
        GroupBox groupBox3 = lP2.new GroupBox();
        Object[] objectArray2 = new Object[]{groupBox3, objectArray[0], groupBox2};
        return this.__stack(objectArray2, 2);
    }

    public int _overline(Object[] objectArray) {
        if (objectArray == null) {
            return 1;
        }
        GroupBox groupBox = (GroupBox)objectArray[0];
        groupBox.measure();
        double d = groupBox.getW();
        GroupBox groupBox2 = (GroupBox)this.__make_line(0.0, 0.0, d);
        LP2 lP2 = this;
        if (lP2 == null) {
            throw null;
        }
        GroupBox groupBox3 = lP2.new GroupBox();
        Object[] objectArray2 = new Object[]{groupBox2, objectArray[0], groupBox3};
        return this.__stack(objectArray2, 2);
    }

    public int _sqrt(Object[] objectArray) {
        if (objectArray == null) {
            return 1;
        }
        GroupBox groupBox = (GroupBox)objectArray[0];
        GroupBox groupBox2 = (GroupBox)groupBox.getParent();
        LP2 lP2 = this;
        if (lP2 == null) {
            throw null;
        }
        SqrtBox sqrtBox = lP2.new SqrtBox(groupBox);
        sqrtBox.setParent(groupBox2);
        sqrtBox.moveTo(groupBox.getX(), groupBox.getY());
        groupBox2.deleteMember(groupBox);
        groupBox2.appendMember(sqrtBox);
        return 0;
    }

    public void _digamma() {
        this.unicode("F");
    }

    public void _beth() {
        this.unicode("\u2136");
    }

    public void _daleth() {
        this.unicode("\u2138");
    }

    public void _gimel() {
        this.unicode("\u2137");
    }

    public void _lll() {
        this.unicode("\u22d8");
    }

    public void _ggg() {
        this.unicode("\u22d9");
    }

    public void _percent() {
        this.unicode("%");
    }

    public void _promille() {
        this.unicode("\u2030");
    }

    public void _copyright() {
        this.unicode("\u00a9");
    }

    public void _paragraph() {
        this.unicode("\u00b6", 44, 123);
    }

    public void _degrees() {
        this.unicode("\u00b0", 35, 186);
    }

    public void _square() {
        this.unicode("\u22a1");
    }

    public void _not_internal() {
        CharBox charBox = null;
        this._thinspace();
        this._thinspace();
        if (this.fontMode == 2) {
            LP2 lP2 = this;
            if (lP2 == null) {
                throw null;
            }
            charBox = lP2.new CharBox("=", 42, this.ptSize, this.colorIndex);
        } else {
            LP2 lP2 = this;
            if (lP2 == null) {
                throw null;
            }
            charBox = lP2.new CharBox("/", this.fontIndex, this.ptSize, this.colorIndex);
        }
        ((Box)charBox).measure();
        this.append(charBox);
        this.__space(-10 - charBox.getW());
    }

    public void _ldots_internal() {
        if (this.fontMode == 2) {
            this.cm_math(35, 46);
            this.cm_math(35, 46);
            this.cm_math(35, 46);
        } else {
            this.unicode("\u2026");
        }
    }

    public void _cdots_internal() {
        if (this.fontMode == 2) {
            this.cm_math(44, 162);
            this.cm_math(44, 162);
            this.cm_math(44, 162);
        } else {
            this.unicode("\u22ef");
        }
    }

    public void _strut() {
        FontMetrics fontMetrics = this.fontCache.getFontMetrics(this.fontIndex, this.ptSize);
        LP2 lP2 = this;
        if (lP2 == null) {
            throw null;
        }
        Box box = lP2.new Box();
        box.setA(fontMetrics.getMaxAscent());
        box.setD(fontMetrics.getMaxDescent());
        box.setW(0);
        this.append(box);
    }

    public void __space(int n) {
        LP2 lP2 = this;
        if (lP2 == null) {
            throw null;
        }
        Box box = lP2.new Box();
        box.setW(n);
        this.append(box);
    }

    public void _thinspace() {
        this.__space(5);
    }

    public void _mskip_thin() {
        this.__space(5);
    }

    public void _mskip_med() {
        this.__space(10);
    }

    public void _mskip_thick() {
        this.__space(20);
    }

    public void _mskip_back() {
        this.__space(-5);
    }

    public void _qquad() {
        this.__space(40);
    }

    public void _emspace() {
        LP2 lP2 = this;
        if (lP2 == null) {
            throw null;
        }
        CharBox charBox = lP2.new CharBox("M", this.fontIndex, this.ptSize, this.colorIndex);
        charBox.measure();
        LP2 lP22 = this;
        if (lP22 == null) {
            throw null;
        }
        Box box = lP22.new Box();
        box.setW(charBox.getW());
        this.append(box);
    }

    public Box __make_line(double d, double d2, double d3) {
        LP2 lP2 = this;
        if (lP2 == null) {
            throw null;
        }
        GroupBox groupBox = lP2.new GroupBox();
        groupBox.moveTo((int)d, (int)d2);
        if (this.fontMode == 2) {
            String string = "|";
            LP2 lP22 = this;
            if (lP22 == null) {
                throw null;
            }
            CharBox charBox = lP22.new CharBox(string, 35, this.ptSize, this.colorIndex);
            charBox.measure();
            double d4 = charBox.getW();
            int n = (int)(-Math.max(1.0, d4 / 10.0));
            groupBox.appendMember(charBox);
            double d5 = d4;
            while (d5 < d3) {
                LP2 lP23 = this;
                if (lP23 == null) {
                    throw null;
                }
                Box box = lP23.new Box();
                LP2 lP24 = this;
                if (lP24 == null) {
                    throw null;
                }
                CharBox charBox2 = lP24.new CharBox(string, 35, this.ptSize, this.colorIndex);
                if (d5 + d4 >= d3) {
                    box.setW((int)(d3 - d5 - d4));
                } else {
                    box.setW(n);
                }
                groupBox.appendMember(box);
                groupBox.appendMember(charBox2);
                d5 += (double)(box.getW() + charBox2.getW());
            }
            groupBox.measure();
            return groupBox;
        }
        System.err.println("__make_line Times not yet");
        Thread.dumpStack();
        return groupBox;
    }

    void greek(String string) {
        LP2 lP2 = this;
        if (lP2 == null) {
            throw null;
        }
        this.append(lP2.new CharBox(string, this.mathGreekFontIndex, this.ptSize, this.colorIndex));
    }

    void greek(String string, int n, int n2) {
        if (this.fontMode == 2) {
            String string2 = "" + (char)n2;
            LP2 lP2 = this;
            if (lP2 == null) {
                throw null;
            }
            this.append(lP2.new CharBox(string2, n, this.ptSize, this.colorIndex));
        } else {
            this.greek(string);
        }
    }

    void calli(String string, int n, int n2) {
        if (this.fontMode == 2) {
            String string2 = "" + (char)n2;
            LP2 lP2 = this;
            if (lP2 == null) {
                throw null;
            }
            this.append(lP2.new CharBox(string2, n, this.ptSize, this.colorIndex));
        } else {
            LP2 lP2 = this;
            if (lP2 == null) {
                throw null;
            }
            this.append(lP2.new CharBox(string, 33, this.ptSize, this.colorIndex));
        }
    }

    void unicode(String string, int n, int n2, int n3, int n4, int n5) {
        if (this.fontMode == 2) {
            LP2 lP2 = this;
            if (lP2 == null) {
                throw null;
            }
            this.append(lP2.new CharBox("" + (char)n2, n, this.ptSize, this.colorIndex));
            this.__space(n5);
            LP2 lP22 = this;
            if (lP22 == null) {
                throw null;
            }
            this.append(lP22.new CharBox("" + (char)n4, n3, this.ptSize, this.colorIndex));
        } else {
            this.unicode(string);
        }
    }

    void unicode(String string, int n, int n2) {
        if (this.fontMode == 2) {
            if (n == -13) {
                LP2.msg("-W- Symbol not supported in CM_FONTS mode: '" + string + "'" + " " + Integer.toHexString(string.charAt(0)));
                this.unicode(string);
            } else {
                if (n == -12) {
                    n = 35;
                }
                String string2 = "" + (char)n2;
                LP2 lP2 = this;
                if (lP2 == null) {
                    throw null;
                }
                this.append(lP2.new CharBox(string2, n, this.ptSize, this.colorIndex));
            }
        } else {
            this.unicode(string);
        }
    }

    void unicode(String string) {
        LP2 lP2 = this;
        if (lP2 == null) {
            throw null;
        }
        this.append(lP2.new CharBox(string, this.mathSymbolFontIndex, this.ptSize, this.colorIndex));
    }

    void big_opr(String string, int n, int n2) {
        int n3 = this.ptSize;
        this.ptSize = (int)((double)this.ptSize * 1.4);
        this.unicode(string, n, n2);
        this.ptSize = n3;
    }

    void binaryop(String string, int n, int n2) {
        this._thinspace();
        if (this.fontMode == 2 && n != -13) {
            if (n == -12) {
                n = 35;
            }
            String string2 = "" + (char)n2;
            LP2 lP2 = this;
            if (lP2 == null) {
                throw null;
            }
            this.append(lP2.new CharBox(string2, n, this.ptSize, this.colorIndex));
        } else {
            this.unicode(string);
        }
        this._thinspace();
    }

    void relation(String string, int n, int n2) {
        this.binaryop(string, n, n2);
    }

    void relation(String string, int n, int n2, int n3, int n4, int n5) {
        if (this.fontMode == 2) {
            this._thinspace();
            LP2 lP2 = this;
            if (lP2 == null) {
                throw null;
            }
            this.append(lP2.new CharBox("" + (char)n2, n, this.ptSize, this.colorIndex));
            if (n5 != 0) {
                this.__space(n5);
            }
            LP2 lP22 = this;
            if (lP22 == null) {
                throw null;
            }
            this.append(lP22.new CharBox("" + (char)n4, n3, this.ptSize, this.colorIndex));
            this._thinspace();
        } else {
            this.binaryop(string, -13, 0);
        }
    }

    void mathfunction(String string) {
        if (this.fontMode == 2) {
            LP2 lP2 = this;
            if (lP2 == null) {
                throw null;
            }
            this.append(lP2.new CharBox(string, 35, this.ptSize, this.colorIndex));
        } else {
            int n = 0;
            LP2 lP2 = this;
            if (lP2 == null) {
                throw null;
            }
            this.append(lP2.new CharBox(string, n, this.ptSize, this.colorIndex));
        }
    }

    void space(int n) {
        LP2 lP2 = this;
        if (lP2 == null) {
            throw null;
        }
        Box box = lP2.new Box();
        box.setW(n);
        this.append(box);
    }

    void writeFigHeader(PrintStream printStream) {
        printStream.println("#FIG 3.2");
        printStream.println("Portrait");
        printStream.println("Center");
        printStream.println("Metric");
        printStream.println("A4");
        printStream.println("100.0");
        printStream.println("Single");
        printStream.println("-2");
        printStream.println("1200 2");
    }

    public void setFontIndex(int n) {
        this.fontIndex = n;
    }

    public void setFontPtSize(int n) {
        this.ptSize = n;
        this.ptBaseSize = n;
    }

    public void setColorIndex(int n) {
        this.colorIndex = n;
    }

    public void parse(String string) {
        this.tokenize(string);
        if (this.dump_tokens) {
            System.out.println("tokens for input:\n" + string);
            this.dumpTokens();
            System.out.println();
            System.out.println();
        }
    }

    public void convertToFig(FigCompound figCompound) {
        Box box = this.buildBox();
        box.convertToFig(figCompound);
    }

    public void selftest(String string) {
        this.fontIndex = 35;
        this.ptSize = 24;
        this.parse(string);
        Box box = this.buildBox();
        if (debug) {
            box.dump(System.out);
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream("hugo" + ++count + ".fig");
            FigCompound figCompound = new FigCompound();
            figCompound.setTrafo(new FigTrafo2D());
            box.convertToFig(figCompound);
            figCompound.update_bbox();
            FigText figText = new FigText();
            figText.setTrafo(new FigTrafo2D());
            figText.setText(string);
            figText.move(0, 2400);
            FigWriter figWriter = new FigWriter();
            FigObjectList figObjectList = new FigObjectList();
            figObjectList.insert(figCompound);
            figObjectList.insert(figText);
            figWriter.write_fig31_file(new DataOutputStream(fileOutputStream), true, figObjectList);
            fileOutputStream.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setEnableDisplayBoxes(boolean bl) {
        this.display_boxes = bl;
    }

    public void setEnableDumpTokens(boolean bl) {
        this.dump_tokens = bl;
    }

    public void setUseWords(boolean bl) {
        this.use_word_boxes = bl;
    }

    public static void msg(String string) {
        if (debug) {
            System.out.println(string);
        } else if (!string.startsWith("-#-")) {
            System.out.println(string);
        }
    }

    public static void usage() {
        LP2.msg("java jfig.utils.LP2 [options]");
        LP2.msg("where options include: ");
        LP2.msg("-help               - this message ");
        LP2.msg("-debug              - lots of diagnostic output");
        LP2.msg("-tokens             - dump tokens to stdout");
        LP2.msg("-boxes              - display the box outlines");
        LP2.msg("-italic <value>     - add <value> pts after italic chars");
        LP2.msg("-cmfonts            - use Computer Modern fonts");
        LP2.msg("-symbolfont         - use Symbol font for math");
        System.exit(0);
    }

    public static void main(String[] stringArray) {
        LP2 lP2 = new LP2();
        int n = 0;
        while (n < stringArray.length) {
            if ("-tokens".equals(stringArray[n])) {
                lP2.dump_tokens = true;
            }
            if ("-boxes".equals(stringArray[n])) {
                lP2.display_boxes = true;
            }
            if ("-debug".equals(stringArray[n])) {
                debug = true;
            }
            if ("-italic".equals(stringArray[n])) {
                lP2.italic_correction = Integer.parseInt(stringArray[n + 1]);
            }
            if ("-cmfonts".equals(stringArray[n])) {
                lP2.setFontMode(2);
            }
            if ("-symbol".equals(stringArray[n])) {
                lP2.setFontMode(3);
            }
            if ("-help".equals(stringArray[n])) {
                LP2.usage();
            }
            ++n;
        }
        lP2.setFontIndex(35);
        lP2.setFontPtSize(27);
        lP2.selftest("TimesRoman $Times \\cos^{2}(x) {\\mathrm{Times}} Times \\sin^{2}(times)$, Times");
        lP2.selftest("$\\frac{n^{2} (n+1)}{n-\\beta} \\cdot\\sum_{j} \\xi_{j}$");
        lP2.selftest("$x^{2y}_{3z}  x^{4^{5^{6}}_{7}}_{3z} $");
        lP2.selftest("$x^{2y} x_{2y} x^{y^{2}} x^{y_{1}} x^{y}_{1} x_{1}^{y}$");
        lP2.selftest("$ a^{2^{5}} + b^{3} = c^{4}$");
        lP2.selftest("Hopfield-Lernen: $J_{ij} = (1/N) \\sum_{\\mu} \\xi_{i}^{\\mu} \\xi_{j}^{\\mu}$ ");
        lP2.selftest("Hopfield-Dynamik: $S_{i} (t+1) = (1/N) \\ {\\fourtypt\\sum}_{j}\\  J_{ij}\\cdot S_{j} (t)$");
        lP2.selftest("X$ \\sqrt{a+b-c\\cdot d} + \\sqrt{\\strut a+b-c\\cdot d} + \\frac{1}{3}\\cdot \\alpha$.");
        lP2.selftest("X$ \\frac{\\sqrt{a+b+c}}{1 + \\sqrt{\\cos(\\alpha)}} = \\omega$");
        lP2.selftest("Square root $\\sqrt{x+y}$ and an $n$th root \\sqrt[n]{2}$.");
        lP2.selftest("Underline: $\\underline{\\alpha} + \\underline{x+y\\cdot\\pi}$");
        lP2.selftest("Aber \\lstack{Franziskus}{Gabi}{Ottokar} das \\cstack{a}{bcde}{f} ist \\rstack{\\red red}{\\green green}{\\magenta magenta} nicht \\lstack{\\strut\\red red}{\\strut\\green green}{\\strut\\magenta magenta} alles.");
        lP2.selftest("X \\rstack{jolanda}{irina}{olga} X  \\cstack{jolanda}{olga}{irina} X");
        lP2.selftest("{\\darkgreen Pythagoras:} $a^{2} + b^{2} = c^{2}$");
        lP2.selftest("\\[ x = \\frac{y+z/2}{y^{2}+1} \\]");
        lP2.selftest("\\[\\frac{x+y}{1 + \\frac{y}{z+1}}\\]");
        lP2.selftest("in-text formula to produce a fraction like $\\frac{1}{2}$.");
        lP2.selftest("A low ellipsis: $x_{1}, \\ldots\\ , x_{n}$.");
        lP2.selftest("IEEE 754: $value = (-1)^{s} \\cdot\\  2^{exp-127} \\cdot\\ (1 + mantisse\\,\\cdot\\,2^{-23})$ ");
        lP2.selftest("Akzente: $\\hat{\\alpha} \\hat{\\Sigma} \\check{\\beta} \\acute{\\gamma} \\grave{\\delta} \\bar{\\epsilon} \\vec{x} \\vec{vmax} \\vec{v}_{max} \\dot{y} \\ddot{y} \\tilde{W} ");
        lP2.selftest("Summe: $\\qquad \\Sum{\\xvpt i=0}{\\xivpt N} i = N (N+1)/2$");
        lP2.selftest("$\\Sum{\\xvpt i}{} \\Sum{\\xvpt j}{\\xviiipt N} x^{i,j} = \\gamma\\cdot\\int f(x)dx$");
        lP2.selftest("$\\Sum{\\xvpt i,j,k}{\\xvpt N} \\Sum{\\xvpt l}{\\xviiipt M} x^{i,j} = \\gamma\\cdot\\int f(x)dx$");
        lP2.selftest("$\\Sum{\\xvpt i,j,k}{\\xvpt N} \\Prod{\\xvpt l,m}{\\xvpt M} x_{ijk}^{lm} = \\Int{\\xvpt x=0}{\\xvpt 2\\pi} f(x)dx$");
        lP2.selftest("Black, {\\red red}, {\\gold gold}, {\\green green}, {\\blue blue {\\black black inside} blue}!");
        lP2.selftest("{\\twentypt 20pt {\\fifteenpt 15pt }{\\twelvept 12pt }{\\tenpt 10pt }{\\eightpt 8pt }{\\fivept 5pt } and back to 20pt}");
        lP2.selftest("Und es begab sich zu der Zeit, da Cyrhenius Landpfleger...");
        lP2.selftest("Text und {\\tt Code mit {\\itt kursivem} Argument.}");
        lP2.selftest("Das {\\bf Theorem} von {\\em Archimedes}.");
        lP2.selftest("{\\em\\red hendrich\\thinspace}{\\black \\atsign informatik.uni-hamburg.de}");
        lP2.selftest("Normaler Text, {\\blue $w = \\sin ( \\alpha \\cdot \\pi /4 )$}");
        lP2.selftest("Text mit Formel, {\\blue$w = \\sin( \\alpha\\cdot\\pi/4 )$}");
        lP2.setFontPtSize(20);
        lP2.selftest("Boole'sche Algebra: $a = b \\oplus  c$ ");
        lP2.selftest("\\lessthan X\\greaterthan \\equals\\backslash \\$ \\lbrace\\lbracket X\\rbracket\\rbrace X");
        lP2.selftest("\\lessthan X\\greaterthan \\equals\\backslash\\$\\lbrace\\lbracket X\\rbracket\\rbrace X");
        lP2.selftest("M\\emspace M $\\black\\clubsuit\\spadesuit {\\red\\heartsuit{}\\diamondsuit}$ \\telephone\\male\\ \\ \\female 42.59\\ \\euro, 15\\thinspace\\pound, 22.000\\thinspace\\pts");
        lP2.setFontIndex(0);
        lP2.setFontPtSize(30);
        lP2.selftest("{\\darkgreen Pythagoras:} $a^{2} + b^{2} = c^{2}$");
        lP2.selftest("$\\cos^{2}(x) + \\sin^{2}(x) = 1$");
        lP2.selftest("{\\darkblue Euler formula:  $\\exp (i \\pi ) + 1 = 0$}");
        lP2.selftest("{\\darkblue Euler formula:  $e^{\\thinspace i \\pi} + 1 = 0$}");
        lP2.selftest("AbCdE: \\int $X_{j=3}^{2} \\cdot dx = 42.0$");
        lP2.selftest("Formel1: $X_{i} = \\sum_{i=1}^{N_{0}} \\phi  \\xi  \\cdot 3$");
        lP2.selftest("$\\prod_{i} \\sum_{j} \\Gamma_{\\Xi_{\\mu}} \\Rightarrow \\setZ \\bullet (TeX \\mp Word)$");
        lP2.selftest("Hopfield-Dynamik: $S_{i} (t+1) = (1/N) \\ {\\fourtypt\\sum}_{j}\\  J_{ij}\\cdot S_{j} (t)$");
        lP2.selftest("Hopfield-Lernen: $J_{ij} = (1/N) \\sum_{\\mu} \\xi_{i}^{\\mu} \\xi_{j}^{\\mu}$ ");
        lP2.selftest("${\\fourtypt\\int^{5}_{0}}\\ (x^{2}) {\\rm d}x = 1/3 x^{3}{\\fourtypt |_{0}^{5}} = (125/3) $");
        lP2.selftest("$\\int^{3}_{x=0} a$");
        lP2.selftest("IEEE 754: $value = (-1)^{s} \\cdot\\  2^{exp-127} \\cdot\\ (1 + mantisse\\,\\cdot\\,2^{-23})$ ");
        lP2.selftest("Text (in) [Klammern] \\{und\\} mit\\_unterstrich");
        lP2.selftest("For all $x: f(x) = g(x+1)$");
        lP2.selftest("Preparing an input file: ");
        lP2.selftest("abcde fghij klmno pqrst uvwxy z");
        lP2.selftest("ABCDE FGHIJ KLMNO PQRST UVWXY Z");
        lP2.selftest("01234 56789 .:;,?! '`()[] -/*+=@");
        lP2.selftest("The Romans wrote I + I = II. Really!");
        lP2.selftest("Beans (lima, etc.)\\ have vitamin B\\@.");
        lP2.selftest("\\$ \\& \\% \\# \\_ \\{ \\} are easy to produce.");
        lP2.selftest("This page was produced on \\today. (\\backslash today)");
        lP2.selftest("The formula \\( x-3y = 7 \\) is easy to type.");
        lP2.selftest("Does \\( x + y \\) always equal \\(x+y\\)?");
        lP2.selftest("\\( a_{1} > x^{2n} / y^{2n} \\)");
        lP2.selftest("This proves that \\( x' < x'' - y'_{3} < 10 x''' z \\).");
        lP2.selftest("The formula \\( a<7 \\) is a noun in this sentence.");
        lP2.selftest("Let $x$ be a prime such that $y>2x$.");
        lP2.selftest("displayed equation: \\[ x' + y^{2} = z_{i}^{2} \\]");
        lP2.selftest("{\\bf This is a bold type style.}");
        lP2.selftest("{\\sf This is a sans serif type style.}");
        lP2.selftest("{\\sl This is a slanted type style.}");
        lP2.selftest("{\\sc This is a Small Caps type style.}");
        lP2.selftest("{\\tt This is a typewriter type style.}");
        lP2.selftest("\\dag \\ddag \\S \\P \\copyright.");
        lP2.selftest("$x^{2y} x_{2y} x^{y^{2}} x^{y_{1}} x^{y}_{1} x_{1}^{y}$");
        lP2.selftest("Multiplying by $n/2$ gives \\( (m+n)/n \\).");
        lP2.selftest("\\[ x = \\frac{y+z/2}{y^{2}+1} \\]");
        lP2.selftest("\\[\\frac{x+y}{1 + \\frac{y}{z+1}}\\]");
        lP2.selftest("in-text formula to produce a fraction like $\\frac{1}{2}$.");
        lP2.selftest("Square root $\\sqrt{x+y}$ and an $n$th root \\sqrt[n]{2}$.");
        lP2.selftest("A low ellipsis: $x_{1}, \\ldots\\ , x_{n}$.");
        lP2.selftest("A centered ellipsis: $a + \\cdots\\ + z$.");
        lP2.selftest("Making Greek letters is as easy as $\\pi$ (or $\\Pi$).");
        lP2.selftest("A\\ B\\ \\ \\ C$\\pi\\ $D");
        lP2.selftest("Boole'sche Algebra: $a = b \\oplus  c$ ");
        lP2.selftest("$\\bigcup_{n=1}^{m}(x_{n}\\cup y_{n})$");
        lP2.selftest("F.1: $\\alpha,\\beta,\\gamma,\\delta,\\epsilon,\\varepsilon,\\zeta,\\eta,\\theta,\\vartheta,\\iota,\\kappa,\\lambda,\\mu,\\nu,\\xi,o,\\pi,\\varpi,\\rho,\\varrho,\\sigma,\\varsigma,\\tau,\\upsilon,\\phi,\\varphi,\\chi,\\psi,\\omega");
        lP2.selftest("F.2: $\\Gamma,\\Delta,\\Theta,\\Lambda,\\Xi,\\Pi,\\Sigma,\\Upsilon,\\Phi,\\Psi,\\Omega$.");
        lP2.selftest("F.3: calligraphic: $\\calA\\calB\\calC\\calD\\ldots\\calZ$");
        lP2.selftest("F.4: dotless i and j: $\\hat\\imath, \\vec\\jmath$");
        lP2.selftest("F.4: $\\aleph,\\hbar,\\imath,\\jmath,\\ell,\\wp,\\Re,\\Im,\\partial,\\infty$ ");
        lP2.selftest("F.4: $\\prime,\\emptyset,\\nabla,\\surd,\\top,\\bot,\\doublebar,\\angle,\\triangle,\\mbackslash$");
        lP2.selftest("F.4: $\\forall,\\exists,\\neg,\\flat,\\natural,\\sharp\\clubsuit,\\diamondsuit,\\heartsuit,\\spadesuit$");
        lP2.selftest("F.5: 01234 56789 {\\bf 01234 56789} {\\it 01234 56789}");
        lP2.selftest("F.6: $\\sum,\\prod,\\coprod,\\int,\\oint,\\bigcap,\\bigcup,\\bigsqcup,\\bigvee,\\bigwedge,\\bigodot,\\bigotimes,\\bigoplus,\\biguplus");
        lP2.selftest("F.7: $\\pm,\\mp,\\setminus,\\cdot,\\times,\\ast,\\star,\\diamond,\\circ,\\bullet,\\div$");
        lP2.selftest("F.7: $\\cap,\\cup,\\uplus,\\sqcap,\\sqcup,\\triangleleft,\\triangleright,\\wr,\\bigcirc,\\bigtriangleup,\\bigtriangledown$");
        lP2.selftest("F.7: $\\vee,\\wedge,\\oplus,\\ominus,\\otimes,\\oslash,\\odot,\\dagger,\\ddagger,\\amalg.$");
        lP2.selftest("F.8: $\\leq,\\prec,\\preceq,\\ll,\\subset,\\subseteq,\\sqsubseteq,\\in,\\vdash,\\smile,\\frown$");
        lP2.selftest("F.8: $\\geq,\\succ,\\succeq,\\gg,\\supset,\\supseteq,\\sqsupseteq,\\ni,\\dashv,\\mid,\\parallel$");
        lP2.selftest("F.8: $\\equiv,\\sim,\\simeq,\\asymp,\\approx,\\cong,\\bowtie,\\propto,\\models,\\doteq,\\perp$");
        lP2.selftest("F.9: $\\not=,\\not\\lessthan,\\not\\geq,\\not\\prec,\\not\\subset,\\not\\asymp$");
        lP2.selftest("$\\vec{a} \\vec{X} \\vec{d} \\hat{b} \\tilde{\\alpha}$");
        System.out.println("OK.");
        System.exit(0);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        BufferedImage bufferedImage = new BufferedImage(20, 20, 2);
        imageGraphics2D = (Graphics2D)bufferedImage.getGraphics();
        LP2.msg("-#- imageGraphics2D=" + imageGraphics2D);
        _mode_names = new String[]{"invalid", "text", "command", "math", "begingroup", "endgroup", "control", "beginmath", "endmath", "superscript", "subscript", "mathsymbol", "mathdigit"};
        count = 100;
    }

    public class Box {
        protected int x;
        protected int y;
        protected int w;
        protected int a;
        protected int d;
        protected Box next;
        protected Box prev;
        protected Box parent;
        protected String comment;

        public void setComment(String string) {
            this.comment = string;
        }

        public String getComment() {
            return this.comment;
        }

        public void move(int n, int n2) {
            this.x += n;
            this.y += n2;
        }

        public void moveTo(int n, int n2) {
            int n3 = n - this.getX();
            int n4 = n2 - this.getY();
            this.move(n3, n4);
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getW() {
            return this.w;
        }

        public int getA() {
            return this.a;
        }

        public int getD() {
            return this.d;
        }

        public Point getOrigin() {
            return new Point(this.getX(), this.getY());
        }

        public void setX(int n) {
            this.x = n;
        }

        public void setY(int n) {
            this.y = n;
        }

        public void setW(int n) {
            this.w = n;
        }

        public void setA(int n) {
            this.a = n;
        }

        public void setD(int n) {
            this.d = n;
        }

        public Box getNextBox() {
            return this.next;
        }

        public Box getPrevBox() {
            return this.prev;
        }

        public void setNextBox(Box box) {
            this.next = box;
        }

        public void setPrevBox(Box box) {
            this.prev = box;
        }

        public void append(Box box) {
            this.measure();
            this.next = box;
            box.prev = this;
            box.setParent(this.getParent());
            box.setOrigin(this.getAbutmentPoint());
        }

        public void measure() {
        }

        public Rectangle getBounds() {
            int n = Math.min(this.x, this.x + this.w);
            int n2 = Math.max(this.x, this.x + this.w) - n;
            return new Rectangle(n, this.y - this.a, n2, this.d + this.a);
        }

        public Point getAbutmentPoint() {
            return new Point(this.x + this.w, this.y);
        }

        public void setOrigin(Point point) {
            this.x = point.x;
            this.y = point.y;
            this.measure();
        }

        public Box getParent() {
            return this.parent;
        }

        public void setParent(Box box) {
            this.parent = box;
        }

        public String toString() {
            return this.getClass().getName() + "[(" + this.x + "," + this.y + ") " + this.w + " (" + this.a + "," + this.d + ")]";
        }

        public void dump(PrintStream printStream) {
            printStream.println(this.toString());
            if (this.getNextBox() != null) {
                this.getNextBox().dump(printStream);
            }
        }

        public void convertToFig(FigCompound figCompound) {
            if (LP2.this.display_boxes) {
                figCompound.fastAddMember(this.getFigRectangle(figCompound, ColorCache.RED, 190));
            }
            if (this.next != null) {
                this.next.convertToFig(figCompound);
            }
        }

        public FigRectangle getFigRectangle(FigCompound figCompound, int n, int n2) {
            Rectangle rectangle = this.getBounds();
            Point point = new Point(32 * rectangle.x, 32 * rectangle.y);
            Point point2 = new Point(32 * (rectangle.x + rectangle.width), 32 * (rectangle.y + rectangle.height));
            FigRectangle figRectangle = new FigRectangle();
            figRectangle.setPoints(new Point[]{point, point2});
            figRectangle.setTrafo(figCompound.getTrafo());
            figRectangle.setAttributes(new FigAttribs());
            figRectangle.setLineColor(LP2.this.colorCache.get(n));
            figRectangle.setFillColor(LP2.this.colorCache.get(n));
            figRectangle.getAttributes().currentLayer = n2;
            return figRectangle;
        }
    }

    public class CharBox
    extends Box {
        protected int y_offset = 0;
        protected int fontIndex;
        protected int ptSize;
        protected int colorIndex;
        protected String s;

        public int getColorIndex() {
            return this.colorIndex;
        }

        public int getFontIndex() {
            return this.fontIndex;
        }

        public int getPtSize() {
            return this.ptSize;
        }

        public String getText() {
            return this.s;
        }

        public void setText(String string) {
            this.s = string;
            this.measure();
        }

        public void setYOffset(int n) {
            this.y_offset = n;
        }

        public void measure() {
            FontRenderContext fontRenderContext = imageGraphics2D.getFontRenderContext();
            GlyphVector glyphVector = LP2.this.fontCache.getFont(this.fontIndex, this.ptSize).createGlyphVector(fontRenderContext, this.s);
            Rectangle rectangle = glyphVector.getPixelBounds(fontRenderContext, 0.0f, 0.0f);
            this.a = -rectangle.y + this.y_offset;
            this.d = rectangle.height - this.a;
            this.w = LP2.this.getStringWidthPoints(this.fontIndex, this.ptSize, this.s);
        }

        public void append(Box box) {
            Object object;
            boolean bl = false;
            if (LP2.this.use_word_boxes && box instanceof CharBox) {
                object = (CharBox)box;
                if (((CharBox)object).fontIndex == this.fontIndex && ((CharBox)object).ptSize == this.ptSize && ((CharBox)object).colorIndex == this.colorIndex) {
                    bl = true;
                    System.out.println("CharBox.append: makeWordBox: " + this.s + " " + ((CharBox)object).s);
                }
            }
            if (bl) {
                this.s = this.s + ((CharBox)box).s;
                this.measure();
                object = this.getAbutmentPoint();
            } else {
                boolean bl2;
                this.measure();
                this.next = box;
                object = this.getAbutmentPoint();
                boolean bl3 = (this.fontIndex & 1) != 0;
                boolean bl4 = bl2 = box instanceof CharBox && (((CharBox)box).fontIndex & 1) != 0;
                if (bl3 && !bl2) {
                    ((Point)object).x += LP2.this.italic_correction;
                }
                box.setOrigin((Point)object);
                box.setParent(this.getParent());
            }
        }

        public String toString() {
            return this.getClass().getName() + "[(" + this.x + "," + this.y + ") " + this.w + " (" + this.a + "," + this.d + ")]" + "'" + this.s + "'";
        }

        public void convertToFig(FigCompound figCompound) {
            FigTrafo2D figTrafo2D = figCompound.getTrafo();
            FigAttribs figAttribs = new FigAttribs();
            Point point = new Point(32 * this.x, 32 * (this.y - this.y_offset));
            FigText figText = new FigText(point, this.s, figAttribs, figTrafo2D);
            figText.setFont(this.fontIndex);
            figText.setFontSize(this.ptSize);
            figText.setColor(LP2.this.colorCache.get(this.colorIndex));
            figCompound.fastAddMember(figText);
            if (LP2.this.display_boxes) {
                figCompound.fastAddMember(this.getFigRectangle(figCompound, ColorCache.BLUE, 200));
            }
            if (this.next != null) {
                this.next.convertToFig(figCompound);
            }
        }

        public CharBox(String string, int n, int n2, int n3) {
            this.y = 0;
            this.x = 0;
            this.s = string;
            this.fontIndex = n;
            this.colorIndex = n3;
            this.ptSize = n2;
            this.measure();
        }
    }

    public class GroupBox
    extends Box {
        protected Vector members = new Vector();

        public void deleteAllMembers() {
            this.members = new Vector();
            this.measure();
        }

        public void deleteMember(Box box) {
            this.members.remove(box);
        }

        public Vector getMembers() {
            return this.members;
        }

        public void appendMemberOrig(Box box) {
            int n = this.members.size();
            this.members.addElement(box);
            box.setParent(this);
            if (n == 0) {
                box.setOrigin(this.getOrigin());
            } else {
                Box box2 = (Box)this.members.elementAt(n - 1);
                box.setOrigin(box2.getAbutmentPoint());
            }
        }

        public void appendMember(Box box) {
            int n = this.members.size();
            box.setParent(this);
            if (n == 0) {
                this.members.addElement(box);
                box.setOrigin(this.getOrigin());
            } else {
                Box box2 = (Box)this.members.elementAt(n - 1);
                boolean bl = false;
                if (LP2.this.use_word_boxes && box2 instanceof CharBox && box instanceof CharBox) {
                    CharBox charBox = (CharBox)box2;
                    CharBox charBox2 = (CharBox)box;
                    if (charBox.getFontIndex() == charBox2.getFontIndex() && charBox.getPtSize() == charBox2.getPtSize() && charBox.getColorIndex() == charBox2.getColorIndex()) {
                        bl = true;
                        charBox.setText(charBox.getText() + charBox2.getText());
                    }
                }
                if (!bl) {
                    this.members.addElement(box);
                    box.setOrigin(box2.getAbutmentPoint());
                }
            }
        }

        public Box getLastMember() {
            int n = this.members.size();
            if (n == 0) {
                return null;
            }
            return (Box)this.members.elementAt(n - 1);
        }

        public void append(Box box) {
            super.append(box);
            box.setParent(this);
        }

        public Point getAbutmentPoint() {
            Rectangle rectangle = this.getBounds();
            int n = rectangle.width;
            return new Point(this.x + n, this.y);
        }

        public Rectangle getBounds() {
            Rectangle rectangle = super.getBounds();
            int n = this.members.size();
            int n2 = 0;
            while (n2 < n) {
                Box box = (Box)this.members.elementAt(n2);
                rectangle = rectangle.union(box.getBounds());
                ++n2;
            }
            LP2.msg("-#- getBounds: " + rectangle);
            return rectangle;
        }

        public void dumpGroupMembers() {
            LP2.msg("-I- GroupBox.dumpGroupMembers...");
            int n = this.members.size();
            int n2 = 0;
            while (n2 < n) {
                Box box = (Box)this.members.elementAt(n2);
                System.out.println("      " + box);
                ++n2;
            }
            LP2.msg("<<< GroupBox.END");
            LP2.msg("");
        }

        public void move(int n, int n2) {
            int n3 = this.members.size();
            int n4 = 0;
            while (n4 < n3) {
                Box box = (Box)this.members.elementAt(n4);
                box.move(n, n2);
                ++n4;
            }
            super.move(n, n2);
        }

        public void measure() {
            super.measure();
            Rectangle rectangle = new Rectangle(this.getX(), this.getY(), 0, 0);
            int n = this.members.size();
            int n2 = 0;
            while (n2 < n) {
                Box box = (Box)this.members.elementAt(n2);
                box.measure();
                rectangle = rectangle.union(box.getBounds());
                ++n2;
            }
            this.setW(rectangle.width);
            this.setA(this.getY() - rectangle.y);
            this.setD(-this.getY() + rectangle.y + rectangle.height);
        }

        public void convertToFig(FigCompound figCompound) {
            if (LP2.this.display_boxes) {
                figCompound.fastAddMember(this.getFigRectangle(figCompound, ColorCache.BROWN2, 193));
            }
            int n = this.members.size();
            int n2 = 0;
            while (n2 < n) {
                Box box = (Box)this.members.elementAt(n2);
                box.convertToFig(figCompound);
                ++n2;
            }
            if (this.next != null) {
                this.next.convertToFig(figCompound);
            }
        }
    }

    public class SubSuperScriptBox
    extends GroupBox {
        protected Box superscriptBox;
        protected Box subscriptBox;
        protected String mode = "none";
        protected int aa;
        protected int dd;
        protected int sa;
        protected int sd;
        protected int ptSize;
        protected int fontIndex;
        protected int italicCorrection = 0;

        public void setMode(String string) {
            this.mode = string;
        }

        public String getMode() {
            return this.mode;
        }

        public void appendMember(Box box) {
            if (this.mode == "superscript") {
                this.superscriptBox = box;
                Point point = this.getSuperscriptBasePoint();
                box.moveTo(point.x, point.y);
            } else if (this.mode == "subscript") {
                this.subscriptBox = box;
                Point point = this.getSubscriptBasePoint();
                box.moveTo(point.x, point.y);
            } else {
                LP2.msg("-E- SubSuperScriptBox.appendMember: unknown mode " + this.mode);
                Thread.dumpStack();
            }
        }

        public void deleteMember(Box box) {
            if (box == this.superscriptBox) {
                this.superscriptBox = null;
            }
            if (box == this.subscriptBox) {
                this.subscriptBox = null;
            }
            this.measure();
        }

        public void deleteAllMembers() {
            this.superscriptBox = null;
            this.subscriptBox = null;
            this.measure();
        }

        public void move(int n, int n2) {
            if (this.superscriptBox != null) {
                this.superscriptBox.move(n, n2);
            }
            if (this.subscriptBox != null) {
                this.subscriptBox.move(n, n2);
            }
            super.move(n, n2);
        }

        public void measure() {
            int n = 0;
            int n2 = 0;
            int n3 = this.getY();
            int n4 = this.getY();
            if (this.superscriptBox != null) {
                this.superscriptBox.measure();
                n = this.superscriptBox.getW();
                n3 = this.superscriptBox.getY() - this.superscriptBox.getA();
            }
            if (this.subscriptBox != null) {
                this.subscriptBox.measure();
                n2 = this.subscriptBox.getW();
                n4 = this.subscriptBox.getY() + this.subscriptBox.getD();
            }
            this.setA(this.getY() - n3);
            this.setD(n4 - this.getY());
            this.setW(Math.max(n, n2));
        }

        public Point getAbutmentPoint() {
            Box box = null;
            box = this.subscriptBox;
            Point point = new Point(0, 0);
            while (box != null) {
                point = box.getAbutmentPoint();
                box = box.getNextBox();
            }
            box = this.superscriptBox;
            Point point2 = new Point(0, 0);
            while (box != null) {
                point2 = box.getAbutmentPoint();
                box = box.getNextBox();
            }
            return new Point(Math.max(point.x, point2.x), this.y);
        }

        public int getSubscriptPtSize() {
            int n = 0;
            while (n < LP2.this.subscriptPtSizes.length) {
                if (LP2.this.subscriptPtSizes[n][0] >= this.ptSize) {
                    return LP2.this.subscriptPtSizes[n][1];
                }
                ++n;
            }
            return LP2.this.subscriptPtSizes[LP2.this.subscriptPtSizes.length - 1][1];
        }

        public Point getSuperscriptBasePoint() {
            int n = this.y - this.aa + (this.aa + this.dd) / 2;
            int n2 = n - (2 * this.sa + 2 * this.sd + this.sd) / 2;
            return new Point(this.x, n2 + this.sa);
        }

        public Point getSubscriptBasePoint() {
            int n = this.y - this.aa + (this.aa + this.dd) / 2;
            int n2 = n + (2 * this.sa + 2 * this.sd + this.sd) / 2;
            return new Point(this.x, n2 - this.sd);
        }

        public Box getSubscriptBox() {
            return this.subscriptBox;
        }

        public Box getSuperscriptBox() {
            return this.superscriptBox;
        }

        public void setSubscriptBox(Box box) {
            this.subscriptBox = box;
        }

        public void setSuperscriptBox(Box box) {
            this.superscriptBox = box;
        }

        public String toString() {
            String string = this.getClass().getName() + "[(" + this.x + "," + this.y + ") " + this.w + " (" + this.aa + "," + this.dd + ")]";
            String string2 = this.superscriptBox != null ? this.superscriptBox.toString() : "";
            String string3 = this.subscriptBox != null ? this.subscriptBox.toString() : "";
            return string + "\nsuperscript box:\n" + string2 + "\nsubscript box:" + string3 + "\n";
        }

        public void convertToFig(FigCompound figCompound) {
            if (LP2.this.display_boxes) {
                figCompound.fastAddMember(this.getFigRectangle(figCompound, ColorCache.GREEN, 195));
            }
            if (this.next != null) {
                this.next.convertToFig(figCompound);
            }
            if (this.superscriptBox != null) {
                this.superscriptBox.convertToFig(figCompound);
            }
            if (this.subscriptBox != null) {
                this.subscriptBox.convertToFig(figCompound);
            }
        }

        public SubSuperScriptBox(int n, int n2) {
            this.y = 0;
            this.x = 0;
            this.fontIndex = n;
            this.ptSize = n2;
            FontMetrics fontMetrics = LP2.this.fontCache.getFontMetrics(n, n2);
            this.aa = fontMetrics.getAscent();
            this.dd = fontMetrics.getDescent();
            int n3 = this.getSubscriptPtSize();
            FontMetrics fontMetrics2 = LP2.this.fontCache.getFontMetrics(n, n3);
            this.sa = fontMetrics2.getAscent();
            this.sd = fontMetrics2.getDescent();
            int n4 = 2 * this.sa + 2 * this.sd + this.sd;
            this.measure();
        }
    }

    public class CommandBox
    extends GroupBox {
        protected String command;
        protected int n_args = 1;
        protected Vector args = null;

        public String getCommand() {
            return this.command;
        }

        public void addArgument(Box box) {
            this.args.add(box);
        }

        public boolean hasAllArguments() {
            return this.args.size() == this.n_args;
        }

        public void executeCommand() {
            LP2.this.handleCommand(this.command, this.args.toArray());
        }

        public CommandBox(String string, int n) {
            this.command = string;
            this.n_args = n;
            this.args = new Vector();
        }
    }

    public class StackBox
    extends Box {
        protected Box topBox;
        protected Box centerBox;
        protected Box bottomBox;
        protected int align = 2;
        protected int Y_SPACING = 2;

        public Box getTopBox() {
            return this.topBox;
        }

        public Box getCenterbox() {
            return this.centerBox;
        }

        public Box getBottomBox() {
            return this.bottomBox;
        }

        public void setTopBox(Box box) {
            this.topBox = box;
        }

        public void setCenterBox(Box box) {
            this.centerBox = box;
        }

        public void setBottomBox(Box box) {
            this.bottomBox = box;
        }

        public void setAlignment(int n) {
            this.align = n;
        }

        public int getAlignment() {
            return this.align;
        }

        public void move(int n, int n2) {
            if (this.topBox != null) {
                this.topBox.move(n, n2);
            }
            if (this.centerBox != null) {
                this.centerBox.move(n, n2);
            }
            if (this.bottomBox != null) {
                this.bottomBox.move(n, n2);
            }
            super.move(n, n2);
        }

        public void measure() {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            if (this.centerBox != null) {
                this.centerBox.measure();
                n = this.centerBox.getA();
                n2 = this.centerBox.getD();
                n4 = this.centerBox.getW();
                this.Y_SPACING = Math.max(2, LP2.this.ptSize / 5);
                n6 += this.centerBox.getA();
                n7 += this.centerBox.getD();
            }
            if (this.topBox != null) {
                this.topBox.measure();
                n3 = this.topBox.getW();
                n6 = n6 + this.topBox.getBounds().height + this.Y_SPACING;
            }
            if (this.bottomBox != null) {
                this.bottomBox.measure();
                n5 = this.bottomBox.getW();
                n7 = n7 + this.bottomBox.getBounds().height + this.Y_SPACING;
            }
            int n8 = Math.max(n4, Math.max(n3, n5));
            if (this.align == 1) {
                if (this.centerBox != null) {
                    int n9 = this.getX();
                    int n10 = this.getY();
                    this.centerBox.moveTo(n9, n10);
                }
                if (this.topBox != null) {
                    int n11 = this.getX();
                    int n12 = this.getY() - n - this.topBox.getD() - this.Y_SPACING;
                    this.topBox.moveTo(n11, n12);
                }
                if (this.bottomBox != null) {
                    int n13 = this.getX();
                    int n14 = this.getY() + n2 + this.bottomBox.getA() + this.Y_SPACING;
                    this.bottomBox.moveTo(n13, n14);
                }
            } else if (this.align == 2) {
                if (this.centerBox != null) {
                    int n15 = this.getX() + (n8 - n4) / 2;
                    int n16 = this.getY();
                    this.centerBox.moveTo(n15, n16);
                }
                if (this.topBox != null) {
                    int n17 = this.getX() + (n8 - n3) / 2;
                    int n18 = this.getY() - n - this.topBox.getD() - this.Y_SPACING;
                    this.topBox.moveTo(n17, n18);
                }
                if (this.bottomBox != null) {
                    int n19 = this.getX() + (n8 - n5) / 2;
                    int n20 = this.getY() + n2 + this.bottomBox.getA() + this.Y_SPACING;
                    this.bottomBox.moveTo(n19, n20);
                }
            } else if (this.align == 3) {
                if (this.centerBox != null) {
                    int n21 = this.getX() + (n8 - n4);
                    int n22 = this.getY();
                    this.centerBox.moveTo(n21, n22);
                }
                if (this.topBox != null) {
                    int n23 = this.getX() + (n8 - n3);
                    int n24 = this.getY() - n - this.topBox.getD() - this.Y_SPACING;
                    this.topBox.moveTo(n23, n24);
                }
                if (this.bottomBox != null) {
                    int n25 = this.getX() + (n8 - n5);
                    int n26 = this.getY() + n2 + this.bottomBox.getA() + this.Y_SPACING;
                    this.bottomBox.moveTo(n25, n26);
                }
            } else {
                throw new IllegalArgumentException("Unknown align" + this.align);
            }
            this.setW(n8);
            this.setA(n6);
            this.setD(n7);
        }

        public void convertToFig(FigCompound figCompound) {
            if (LP2.this.display_boxes) {
                figCompound.fastAddMember(this.getFigRectangle(figCompound, ColorCache.MAGENTA, 191));
            }
            if (this.topBox != null) {
                this.topBox.convertToFig(figCompound);
            }
            if (this.centerBox != null) {
                this.centerBox.convertToFig(figCompound);
            }
            if (this.bottomBox != null) {
                this.bottomBox.convertToFig(figCompound);
            }
            if (this.next != null) {
                this.next.convertToFig(figCompound);
            }
        }

        public StackBox() {
            this.setAlignment(2);
        }
    }

    public class SqrtBox
    extends Box {
        protected GroupBox group;
        protected int Y_SPACING = 3;
        protected int X_OFFSET = 0;

        public void move(int n, int n2) {
            if (this.group != null) {
                this.group.move(n, n2);
            }
            super.move(n, n2);
        }

        public void measure() {
            if (this.group != null) {
                this.group.measure();
                this.setA(this.group.getA() + this.Y_SPACING);
                this.setD(this.group.getD());
                this.X_OFFSET = (this.getA() + this.getD()) / 2;
                this.setW(this.group.getW() + this.X_OFFSET);
                this.group.moveTo(this.getX() + this.X_OFFSET, this.getY());
            }
        }

        private Point gp(int n, int n2) {
            return new Point(32 * n, 32 * n2);
        }

        public void convertToFig(FigCompound figCompound) {
            if (LP2.this.display_boxes) {
                figCompound.fastAddMember(this.getFigRectangle(figCompound, ColorCache.BLUE3, 192));
            }
            if (this.group != null) {
                this.group.convertToFig(figCompound);
            }
            int n = this.group.getX();
            int n2 = this.group.getW();
            int n3 = this.group.getY();
            int n4 = this.group.getA();
            int n5 = this.group.getD();
            Point point = this.gp(n + n2, n3 - n4 - 2);
            Point point2 = this.gp(n, n3 - n4 - 2);
            Point point3 = this.gp(n - (n4 + n5) / 3, n3 + n5);
            Point point4 = this.gp(n - (n4 + n5) / 2, n3 - n4 / 3);
            FigPolyline figPolyline = new FigPolyline();
            figPolyline.setPoints(new Point[]{point4, point3, point2, point});
            figPolyline.setTrafo(figCompound.getTrafo());
            figPolyline.setAttributes(new FigAttribs());
            figPolyline.setLineColor(LP2.this.colorCache.get(LP2.this.colorIndex));
            figPolyline.setFillColor(LP2.this.colorCache.get(LP2.this.colorIndex));
            figPolyline.getAttributes().currentLayer = 192;
            figPolyline.getAttributes().parse("linewidth=2");
            figCompound.fastAddMember(figPolyline);
        }

        public SqrtBox(GroupBox groupBox) {
            this.group = groupBox;
        }
    }
}

