/*
 * Decompiled with CFR 0.152.
 */
package jfig.utils;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import jfig.canvas.FigSwingCanvas;
import jfig.gui.JImageButton;
import jfig.gui.JModularEditor;
import jfig.gui.JStateButton;
import jfig.objects.FigAttribs;
import jfig.utils.AntiDeadlock;
import jfig.utils.ExceptionTracer;

public class Gremlins {
    public static final int BUTTON1 = 16;
    public static final int BUTTON2 = 8;
    public static final int BUTTON3 = 4;
    public static final int MOUSE_MOVE = 0;
    public static final int MOUSE_DRAG = 1;
    public static final int MOUSE_LEFT_CLICK = 2;
    public static final int MOUSE_MIDDLE_CLICK = 3;
    public static final int MOUSE_RIGHT_CLICK = 4;
    public static final int KEY_ASCII = 5;
    public static final int KEY_NUMBER = 6;
    public static final int KEY_CURSOR = 7;
    public static final String[] names = new String[]{"MOVE", "DRAG", "LEFT", "MIDDLE", "RIGHT", "ASCII", "NUMBER", "CURSOR"};
    public static final double[] pFigSwingCanvas = new double[]{0.3, 0.0, 0.3, 0.3, 0.05, 0.03, 0.03, 0.04};
    public static final double[] pJImageButton = new double[]{0.05, 0.0, 0.8, 0.1, 0.0, 0.05, 0.04, 0.01};
    public static final double[] pJStateButton = new double[]{0.1, 0.0, 0.1, 0.3, 0.3, 0.1, 0.09, 0.01};
    public static final double[] pJTextField = new double[]{0.1, 0.0, 0.1, 0.05, 0.05, 0.4, 0.2, 0.1};
    public static final double[] pJButton = new double[]{0.0, 0.0, 0.9, 0.1, 0.0, 0.0, 0.0, 0.0};
    public static final double[] pJComboBox = new double[]{0.1, 0.0, 0.1, 0.1, 0.1, 0.1, 0.1, 0.4};
    public static final double[] pJComponent = new double[]{0.3, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1};
    public static final int[] keycodesNUMERIC = new int[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57};
    public static final int[] keycodesASCII = new int[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90};
    public static final int[] keycodesCURSOR = new int[]{38, 37, 40, 39};
    long seed;
    int n_seconds;
    int n_events;
    int max_seconds = 30;
    int max_events = 50000;
    int mouse_x;
    int mouse_y;
    long t_start;
    int[] keycodes;
    Random generator = new Random();
    Dimension screenSize;
    Robot robot;
    JModularEditor editor;
    Component lastActiveComponent;
    Vector editorComponents;

    public void setSeed(long l) {
        this.seed = l;
        this.generator.setSeed(this.seed);
    }

    public void setMaxSeconds(int n) {
        this.max_seconds = n;
    }

    public void setMaxEventCount(int n) {
        this.max_events = n;
    }

    public int getRunTimeSeconds(long l) {
        return (int)((System.currentTimeMillis() - l) / 1000L);
    }

    public void createKeyCodeTable() {
        this.keycodes = new int[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 521, 151, 45, 10};
    }

    public void runRandomTest() {
        this.t_start = System.currentTimeMillis();
        this.n_events = 0;
        int n = this.getRunTimeSeconds(this.t_start);
        while (n < this.max_seconds && this.n_events < this.max_events) {
            this.createOneRandomEvent();
            ++this.n_events;
            if (this.n_events % 100 == 99) {
                this.robot.delay(1000);
            }
            n = this.getRunTimeSeconds(this.t_start);
        }
        System.out.println("Gremlins: executed " + this.n_events + " events " + "in " + this.getRunTimeSeconds(this.t_start) + " seconds. Exiting now.");
    }

    public void runCreateObjectsTest() {
        Gremlins.msg("-I- runCreateObjectsTest...");
        this.editorComponents = new Vector();
        this.enumerateLeafComponents(this.editor.getFrame(), this.editorComponents);
        this.runCreateRectangleTest(200);
        this.runCreateRoundRectangleTest(200);
        this.clearObjects();
        this.resetAttributes();
        this.runCreateCircleTest(100);
        this.runCreateEllipseTest(100);
        this.clearObjects();
        this.resetAttributes();
        this.runCreatePolylineTest(200);
        this.runCreatePolygonTest(200);
        this.clearObjects();
        this.resetAttributes();
        this.runCreateSplineTest(200);
        this.runCreateClosedSplineTest(200);
        this.clearObjects();
        this.resetAttributes();
        this.runCreateBezierTest(200);
        this.runCreateClosedBezierTest(200);
        this.clearObjects();
        this.resetAttributes();
        this.runCreateTextTest(600);
        this.runCreateArcTest(200);
        this.clearObjects();
        this.resetAttributes();
        this.runCreatePolylineTest(200);
        this.runCreateSplineTest(200);
        this.runCreateImageObjectTest();
        this.runCreateLibraryObjectTest();
    }

    public void clearObjects() {
        this.editor.doCancel(null);
        this.editor.doStartNewDrawing("IGNORE_UNSAVED_CHANGES");
    }

    public void runModifyObjectsTest() {
    }

    public void runCreateRectangleTest(int n) {
        Gremlins.msg("-I- runCreateRectangleTest (" + n + " iterations)");
        JImageButton jImageButton = this.findImageButton("Rectangle");
        this.createMouseClick(jImageButton, 16);
        double[] dArray = new double[]{0.4, 0.0, 0.3, 0.2, 0.1, 0.0, 0.0, 0.0};
        Component component = this.editor.getObjectCanvas().getComponent();
        int n2 = 0;
        while (n2 < n) {
            if (this.generator.nextDouble() > 0.9) {
                this.setRandomAttributes();
            }
            this.createRandomWeightedEvent(component, dArray);
            ++n2;
        }
    }

    public void runCreateRoundRectangleTest(int n) {
        Gremlins.msg("-I- runCreateRoundRectangleTest (" + n + " iterations)");
        JImageButton jImageButton = this.findImageButton("roundRect");
        this.createMouseClick(jImageButton, 16);
        double[] dArray = new double[]{0.4, 0.0, 0.3, 0.2, 0.1, 0.0, 0.0, 0.0};
        Component component = this.editor.getObjectCanvas().getComponent();
        int n2 = 0;
        while (n2 < n) {
            if (this.generator.nextDouble() > 0.9) {
                this.setRandomAttributes();
            }
            this.createRandomWeightedEvent(component, dArray);
            ++n2;
        }
    }

    public void runCreateCircleTest(int n) {
        Gremlins.msg("-I- runCreateCircleTest (" + n + " iterations)");
        JImageButton jImageButton = this.findImageButton("Circle");
        this.createMouseClick(jImageButton, 16);
        double[] dArray = new double[]{0.4, 0.0, 0.3, 0.2, 0.1, 0.0, 0.0, 0.0};
        Component component = this.editor.getObjectCanvas().getComponent();
        int n2 = 0;
        while (n2 < n) {
            if (this.generator.nextDouble() > 0.9) {
                this.setRandomAttributes();
            }
            this.createRandomWeightedEvent(component, dArray);
            ++n2;
        }
    }

    public void runCreateEllipseTest(int n) {
        Gremlins.msg("-I- runCreateEllipseTest (" + n + " iterations)");
        JImageButton jImageButton = this.findImageButton("Ellipse");
        this.createMouseClick(jImageButton, 16);
        double[] dArray = new double[]{0.4, 0.0, 0.3, 0.2, 0.1, 0.0, 0.0, 0.0};
        Component component = this.editor.getObjectCanvas().getComponent();
        int n2 = 0;
        while (n2 < n) {
            if (this.generator.nextDouble() > 0.9) {
                this.setRandomAttributes();
            }
            this.createRandomWeightedEvent(component, dArray);
            ++n2;
        }
    }

    public void runCreatePolylineTest(int n) {
        Gremlins.msg("-I- runCreatePolylineTest (" + n + " iterations)");
        JImageButton jImageButton = this.findImageButton("Polyline");
        this.createMouseClick(jImageButton, 16);
        double[] dArray = new double[]{0.5, 0.0, 0.4, 0.05, 0.05, 0.0, 0.0, 0.0};
        Component component = this.editor.getObjectCanvas().getComponent();
        int n2 = 0;
        while (n2 < n) {
            if (this.generator.nextDouble() > 0.8) {
                this.setRandomAttributes();
            }
            this.createRandomWeightedEvent(component, dArray);
            ++n2;
        }
    }

    public void runCreatePolygonTest(int n) {
        Gremlins.msg("-I- runCreatePolygonTest (" + n + " iterations)");
        JImageButton jImageButton = this.findImageButton("Polygon");
        this.createMouseClick(jImageButton, 16);
        double[] dArray = new double[]{0.5, 0.0, 0.4, 0.05, 0.05, 0.0, 0.0, 0.0};
        Component component = this.editor.getObjectCanvas().getComponent();
        int n2 = 0;
        while (n2 < n) {
            if (this.generator.nextDouble() > 0.8) {
                this.setRandomAttributes();
            }
            this.createRandomWeightedEvent(component, dArray);
            ++n2;
        }
    }

    public void runCreateSplineTest(int n) {
        Gremlins.msg("-I- runCreateSplineTest (" + n + " iterations)");
        JImageButton jImageButton = this.findImageButton("Spline");
        this.createMouseClick(jImageButton, 16);
        double[] dArray = new double[]{0.5, 0.0, 0.4, 0.05, 0.05, 0.0, 0.0, 0.0};
        Component component = this.editor.getObjectCanvas().getComponent();
        int n2 = 0;
        while (n2 < n) {
            if (this.generator.nextDouble() > 0.8) {
                this.setRandomAttributes();
            }
            this.createRandomWeightedEvent(component, dArray);
            ++n2;
        }
    }

    public void runCreateClosedSplineTest(int n) {
        Gremlins.msg("-I- runCreateClosedSplineTest (" + n + " iterations)");
        JImageButton jImageButton = this.findImageButton("c.Spline");
        this.createMouseClick(jImageButton, 16);
        double[] dArray = new double[]{0.5, 0.0, 0.4, 0.05, 0.05, 0.0, 0.0, 0.0};
        Component component = this.editor.getObjectCanvas().getComponent();
        int n2 = 0;
        while (n2 < n) {
            if (this.generator.nextDouble() > 0.8) {
                this.setRandomAttributes();
            }
            this.createRandomWeightedEvent(component, dArray);
            ++n2;
        }
    }

    public void runCreateBezierTest(int n) {
        Gremlins.msg("-I- runCreateBezierTest (" + n + " iterations)");
        JImageButton jImageButton = this.findImageButton("Bezier");
        this.createMouseClick(jImageButton, 16);
        double[] dArray = new double[]{0.5, 0.0, 0.4, 0.05, 0.05, 0.0, 0.0, 0.0};
        Component component = this.editor.getObjectCanvas().getComponent();
        int n2 = 0;
        while (n2 < n) {
            if (this.generator.nextDouble() > 0.8) {
                this.setRandomAttributes();
            }
            this.createRandomWeightedEvent(component, dArray);
            ++n2;
        }
    }

    public void runCreateClosedBezierTest(int n) {
        Gremlins.msg("-I- runCreateClosedBezierTest (" + n + " iterations)");
        JImageButton jImageButton = this.findImageButton("c.Bezier");
        this.createMouseClick(jImageButton, 16);
        double[] dArray = new double[]{0.5, 0.0, 0.4, 0.05, 0.05, 0.0, 0.0, 0.0};
        Component component = this.editor.getObjectCanvas().getComponent();
        int n2 = 0;
        while (n2 < n) {
            if (this.generator.nextDouble() > 0.8) {
                this.setRandomAttributes();
            }
            this.createRandomWeightedEvent(component, dArray);
            ++n2;
        }
    }

    public void runCreateArcTest(int n) {
        Gremlins.msg("-I- runCreateArcTest (" + n + " iterations)");
        JImageButton jImageButton = this.findImageButton("Arc");
        this.createMouseClick(jImageButton, 16);
        double[] dArray = new double[]{0.5, 0.0, 0.4, 0.05, 0.05, 0.0, 0.0, 0.0};
        Component component = this.editor.getObjectCanvas().getComponent();
        int n2 = 0;
        while (n2 < n) {
            if (this.generator.nextDouble() > 0.8) {
                this.setRandomAttributes();
            }
            this.createRandomWeightedEvent(component, dArray);
            ++n2;
        }
    }

    public void runCreateTextTest(int n) {
        Gremlins.msg("-I- runCreateTextTest (" + n + " iterations)");
        JImageButton jImageButton = this.findImageButton("Text");
        this.createMouseClick(jImageButton, 16);
        double[] dArray = new double[]{0.2, 0.0, 0.1, 0.05, 0.05, 0.3, 0.2, 0.1};
        Component component = this.editor.getObjectCanvas().getComponent();
        int n2 = 0;
        while (n2 < n) {
            if (this.generator.nextDouble() > 0.8) {
                this.setRandomAttributes();
            }
            this.createRandomWeightedEvent(component, dArray);
            ++n2;
        }
    }

    public void runCreateImageObjectTest() {
        Gremlins.msg("-E- runCreateImageObjectTest: not yet implemented!");
    }

    public void runCreateLibraryObjectTest() {
        Gremlins.msg("-E- runCreateLibraryObjectTest: not yet implemented!");
    }

    public JImageButton findImageButton(String string) {
        int n = 0;
        int n2 = this.editorComponents.size();
        while (n < n2) {
            String string2;
            Object e = this.editorComponents.elementAt(n);
            if (e instanceof JImageButton && string.equals(string2 = ((JImageButton)e).getLabel())) {
                return (JImageButton)e;
            }
            ++n;
        }
        return null;
    }

    public void setRandomAttributes() {
        int n = 0;
        int n2 = this.editorComponents.size();
        while (n < n2) {
            Object e = this.editorComponents.elementAt(n);
            if (e instanceof JStateButton) {
                this.modifyJStateButton(e);
            }
            ++n;
        }
    }

    public void resetAttributes() {
        this.editor.setCurrentAttribs(new FigAttribs());
    }

    public void modifyJStateButton(Object object) {
        if (!(object instanceof JStateButton)) {
            return;
        }
        JStateButton jStateButton = (JStateButton)object;
        if (!jStateButton.isVisible()) {
            return;
        }
        double d = this.generator.nextDouble();
        if (d > 0.7) {
            int n = 0;
            while (n < this.generator.nextInt(4)) {
                this.createMouseClick(jStateButton, 4);
                ++n;
            }
        } else {
            int n = 0;
            while (n < this.generator.nextInt(4)) {
                this.createMouseClick(jStateButton, 8);
                ++n;
            }
        }
    }

    public void testJStateButtonSelectDialog(JStateButton jStateButton) {
        this.createMouseClick(jStateButton, 16);
        Dialog dialog = jStateButton.getDialog();
        int n = 0;
        while (!(n >= 4000 || dialog != null && dialog.isShowing())) {
            AntiDeadlock.sleep(100L);
            dialog = jStateButton.getDialog();
            Gremlins.msg("-W- waiting for Dialog creation...: " + jStateButton.getClass().getName() + " t_wait= " + (n += 100) + " msec.");
        }
        if (dialog == null || !dialog.isShowing()) {
            Gremlins.msg("-E- internal: select dialog null or not showing...");
            return;
        }
        Vector vector = new Vector();
        this.enumerateLeafComponents(dialog, vector);
        Component component = this.selectRandomLeafComponent(dialog);
        if (component.isShowing() && component.isVisible()) {
            if (component instanceof JImageButton) {
                this.createMouseClick(component, 16);
                AntiDeadlock.sleep(100L);
            }
        } else {
            Gremlins.msg("    component not visible: " + component.getClass().getName());
        }
        if (dialog.isShowing()) {
            dialog.setVisible(false);
        }
        n = 0;
        while (n < 4000 && dialog.isShowing()) {
            AntiDeadlock.sleep(100L);
            Gremlins.msg("-W- waiting for Dialog to close..." + jStateButton.getClass().getName() + " t_wait= " + (n += 100) + " msec.");
        }
        AntiDeadlock.sleep(100L);
        this.robot.waitForIdle();
        this.createMouseMove(this.editor.getObjectCanvas().getComponent());
    }

    public void createOneRandomEvent() {
        Gremlins.msg("\n\ncreateOneRandomEvent...");
        Frame frame = this.selectActiveFrame();
        Window window = this.findActiveWindow(frame);
        Gremlins.msg("... active window is " + window.getClass().getName());
        window.toFront();
        this.robot.waitForIdle();
        if (window instanceof Dialog) {
            double d = this.generator.nextDouble();
            if (d > 0.8) {
                window.setVisible(false);
            }
            return;
        }
        Component component = this.selectRandomLeafComponent(window);
        Gremlins.msg("    random target is " + component.getClass().getName());
        if (component.isShowing() && component.isVisible()) {
            this.createRandomComponentEvent(component);
        } else {
            Gremlins.msg("-E- target not showing: " + component);
        }
        try {
            Thread.sleep(10L);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public Frame selectActiveFrame() {
        Enumeration enumeration = this.editor.getActiveFrames();
        Vector<Frame> vector = new Vector<Frame>();
        int n = 0;
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            ++n;
            Frame frame = (Frame)enumeration.nextElement();
            if (!frame.isShowing()) continue;
            vector.add(frame);
            ++n2;
        }
        int n3 = this.generator.nextInt(vector.size());
        Frame frame = (Frame)vector.elementAt(n3);
        Gremlins.msg("    selectActiveFrame: found " + n + " Frames (" + vector.size() + " showing)");
        Gremlins.msg("    selecting: " + n3 + " " + frame.getClass().getName());
        return frame;
    }

    public Window findActiveWindow(Window window) {
        Window[] windowArray = window.getOwnedWindows();
        if (windowArray == null) {
            return window;
        }
        Gremlins.msg("    findActiveWindow: found " + windowArray.length + " child windows.");
        Window window2 = null;
        int n = 0;
        while (n < windowArray.length) {
            Window window3 = windowArray[n];
            Gremlins.msg("   " + window3.isShowing() + " " + window3.getClass().getName());
            if (window3.isShowing() && (window2 = this.findActiveWindow(window3)) instanceof Dialog && ((Dialog)window2).isModal()) {
                return window2;
            }
            ++n;
        }
        if (window2 != null) {
            return window2;
        }
        return window;
    }

    public Component selectRandomLeafComponent(Window window) {
        Vector vector = new Vector();
        this.enumerateLeafComponents(window, vector);
        Vector vector2 = new Vector();
        int n = 0;
        int n2 = vector.size();
        while (n < n2) {
            Object e = vector.elementAt(n);
            if (e instanceof FigSwingCanvas) {
                this._add(vector2, e, 150);
            } else if (e instanceof JTextArea) {
                this._add(vector2, e, 10);
            } else if (e instanceof JTextField) {
                this._add(vector2, e, 3);
            } else {
                this._add(vector2, e, 1);
            }
            ++n;
        }
        n = this.generator.nextInt(vector2.size());
        return (Component)vector2.elementAt(n);
    }

    private void _add(Vector vector, Object object, int n) {
        int n2 = 0;
        while (n2 < n) {
            vector.add(object);
            ++n2;
        }
    }

    public void enumerateLeafComponents(Container container, Vector vector) {
        Component[] componentArray = container.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] instanceof Container) {
                this.enumerateLeafComponents((Container)componentArray[n], vector);
            }
            vector.add(componentArray[n]);
            ++n;
        }
    }

    public void createRandomComponentEvent(Component component) {
        Gremlins.msg("-#- createRandomComponentEvent: " + component.getClass().getName());
        Gremlins.msg("");
        double[] dArray = null;
        dArray = component instanceof FigSwingCanvas ? pFigSwingCanvas : (component instanceof JStateButton ? pJStateButton : (component instanceof JImageButton ? pJImageButton : (component instanceof JTextArea ? pJTextField : (component instanceof JTextField ? pJTextField : (component instanceof JButton ? pJButton : pJComponent)))));
        this.createRandomWeightedEvent(component, dArray);
    }

    public void createRandomWeightedEvent(Component component, double[] dArray) {
        double d = this.generator.nextDouble();
        double d2 = 0.0;
        int n = 0;
        int n2 = 0;
        while (n2 < dArray.length) {
            if (d < (d2 += dArray[n2])) {
                n = n2;
                break;
            }
            ++n2;
        }
        switch (n) {
            case 0: {
                this.createMouseMove(component);
                break;
            }
            case 1: {
                this.createMouseDrag(component);
                break;
            }
            case 2: {
                this.createMouseClick(component, 16);
                break;
            }
            case 3: {
                this.createMouseClick(component, 8);
                break;
            }
            case 4: {
                this.createMouseClick(component, 4);
                break;
            }
            case 5: {
                this.createKeyTypeAscii(component);
                break;
            }
            case 6: {
                this.createKeyTypeNumber(component);
                break;
            }
            case 7: {
                this.createKeyTypeCursor(component);
                break;
            }
            default: {
                Gremlins.msg("-E- internal error: type= " + n + " random= " + d);
            }
        }
    }

    public void createMouseMove(Component component) {
        this.lastActiveComponent = component;
        Rectangle rectangle = this.getLocation(component);
        int n = 0;
        int n2 = 0;
        if (rectangle.width > 0) {
            n = this.generator.nextInt(rectangle.width);
        }
        if (rectangle.width > 0) {
            n2 = this.generator.nextInt(rectangle.height);
        }
        this.robot.mouseMove(rectangle.x + n, rectangle.y + n2);
        this.robot.waitForIdle();
    }

    public void createMouseDrag(Component component) {
        Gremlins.msg("    createMouseDrag: " + component.getClass().getName());
        Gremlins.msg("    NOT YET IMPLEMENTED!");
    }

    public void createMouseClick(Component component, int n) {
        Rectangle rectangle = this.getLocation(component);
        if (component != this.lastActiveComponent) {
            this.createMouseMove(component);
            this.lastActiveComponent = component;
        }
        this.robot.mousePress(n);
        this.robot.waitForIdle();
        this.robot.mouseRelease(n);
        this.robot.waitForIdle();
    }

    public void createKeyTypeAscii(Component component) {
        boolean bl;
        if (!(component instanceof FigSwingCanvas)) {
            Gremlins.msg("    createKeyTypeAscii: " + component.getClass().getName());
        }
        Rectangle rectangle = this.getLocation(component);
        if (component != this.lastActiveComponent) {
            this.createMouseMove(component);
            this.lastActiveComponent = component;
        }
        int n = this.generator.nextInt(keycodesASCII.length);
        int n2 = keycodesASCII[n];
        boolean bl2 = bl = this.generator.nextDouble() > 0.9;
        if (bl) {
            this.robot.keyPress(16);
        }
        this.robot.keyPress(n2);
        this.robot.waitForIdle();
        this.robot.keyRelease(n2);
        if (bl) {
            this.robot.keyRelease(16);
        }
        this.robot.waitForIdle();
    }

    public void createKeyTypeNumber(Component component) {
        if (!(component instanceof FigSwingCanvas)) {
            Gremlins.msg("    createKeyTypeNumber: " + component.getClass().getName());
        }
        Rectangle rectangle = this.getLocation(component);
        if (component != this.lastActiveComponent) {
            this.createMouseMove(component);
            this.lastActiveComponent = component;
        }
        int n = this.generator.nextInt(keycodesNUMERIC.length);
        int n2 = keycodesNUMERIC[n];
        this.robot.keyPress(n2);
        this.robot.waitForIdle();
        this.robot.keyRelease(n2);
        this.robot.waitForIdle();
    }

    public void createKeyTypeCursor(Component component) {
        if (!(component instanceof FigSwingCanvas)) {
            Gremlins.msg("    createKeyTypeCursor: " + component.getClass().getName());
        }
        Rectangle rectangle = this.getLocation(component);
        if (component != this.lastActiveComponent) {
            this.createMouseMove(component);
            this.lastActiveComponent = component;
        }
        int n = this.generator.nextInt(keycodesCURSOR.length);
        int n2 = keycodesCURSOR[n];
        this.robot.keyPress(n2);
        this.robot.waitForIdle();
        this.robot.keyRelease(n2);
        this.robot.waitForIdle();
    }

    public Rectangle getLocation(Component component) {
        Point point = component.getLocationOnScreen();
        Dimension dimension = component.getSize();
        return new Rectangle(point.x, point.y, dimension.width, dimension.height);
    }

    public void createMouseMove() {
        Point point = this.editor.getFrame().getLocationOnScreen();
        Insets insets = this.editor.getFrame().getInsets();
        Rectangle rectangle = this.editor.getFrame().getBounds();
        Point point2 = new Point(point.x + insets.left, point.y + insets.top);
        Dimension dimension = new Dimension(rectangle.width - insets.left - insets.right, rectangle.height - insets.top - insets.bottom);
        double d = Math.random();
        if (d > 0.1) {
            this.mouse_x += (int)this.getRandom(-10.0, 10.0);
            this.mouse_y += (int)this.getRandom(-10.0, 10.0);
        } else if (d > 0.066) {
            this.mouse_x = (int)this.getRandom(point2.x, point2.x + 50);
            this.mouse_y = (int)this.getRandom(point2.y + 40, point2.y + 700);
        } else if (d > 0.033) {
            this.mouse_x = (int)this.getRandom(point2.x, point2.x + dimension.width);
            this.mouse_y = (int)this.getRandom(point2.y, point2.y + 30);
        } else {
            this.mouse_x = point2.x + dimension.width / 2;
            this.mouse_y = point2.y + dimension.height / 2;
        }
        this.mouse_x = this.clip(this.mouse_x, point2.x, 800);
        this.mouse_y = this.clip(this.mouse_y, point2.y, point2.y + dimension.height);
        this.robot.mouseMove(this.mouse_x, this.mouse_y);
        this.robot.waitForIdle();
    }

    public int clip(int n, int n2, int n3) {
        return Math.min(n3, Math.max(n2, n));
    }

    public double getRandom(double d, double d2) {
        return (d2 - d) * Math.random() + d;
    }

    public static void msg(String string) {
        System.out.println(string);
    }

    public static void usage() {
        System.out.println("Usage: java jfig.utils.Gremlins [options]\nwhere options include\n-regression               (run deterministic regression test)\n-timeout <secs>           (time interval to run the test)\n-events <count>           (number of events to generate)\n-seed   <value>           (random generator seed value)\n");
        System.exit(0);
    }

    public static void main(String[] stringArray) {
        Gremlins gremlins = new Gremlins();
        int n = 3;
        int n2 = 4;
        int n3 = 3;
        try {
            if (stringArray.length == 0) {
                Gremlins.usage();
            }
            int n4 = 0;
            while (n4 < stringArray.length) {
                if ("-seed".equals(stringArray[n4])) {
                    gremlins.setSeed(Long.parseLong(stringArray[++n4]));
                }
                if ("-timeout".equals(stringArray[n4])) {
                    gremlins.setMaxSeconds(Integer.parseInt(stringArray[++n4]));
                }
                if ("-events".equals(stringArray[n4])) {
                    gremlins.setMaxEventCount(Integer.parseInt(stringArray[++n4]));
                }
                if ("-regression".equals(stringArray[n4])) {
                    n3 = 4;
                }
                ++n4;
            }
            if (n3 == 4) {
                gremlins.runCreateObjectsTest();
            } else {
                gremlins.runRandomTest();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Gremlins() {
        try {
            this.screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            this.robot = new Robot();
            this.robot.setAutoWaitForIdle(true);
        }
        catch (Exception exception) {
            System.err.println("-E- Could not create java.awt.Robot, exiting.\nPerhaps you need to enable some X11/window manager extensions?\nPerhaps you need to run the test as a privileged user?\n");
            System.exit(0);
        }
        this.createKeyCodeTable();
        ExceptionTracer.setEnabled(true);
        this.editor = new JModularEditor();
        this.editor.setSaveFileEnable(false);
        this.robot.waitForIdle();
        this.editor.getFrame().setBounds(0, 0, 800, 800);
        this.editor.getFrame().invalidate();
        this.editor.getFrame().setBounds(0, 0, 800, 800);
        this.editor.getFrame().validate();
        Gremlins.msg("*** Gremlins<init>: resize the window manually, if necessary...");
        AntiDeadlock.sleep(1000L);
        this.robot.waitForIdle();
    }
}

