/*
 * Decompiled with CFR 0.152.
 */
package jfig.objects;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.io.PrintWriter;
import jfig.canvas.FigTrafo2D;
import jfig.canvas.ObjectPainter;
import jfig.gui.ColorCache;
import jfig.objects.FigAttribs;
import jfig.objects.FigBbox;
import jfig.objects.FigObject;
import jfig.objects.FigObjectFactory;
import jfig.objects.FigRenderer;
import jfig.objects.FigWriter;

public class FigPolyline
implements FigObject {
    protected Point[] wcp = new Point[1];
    protected int min_i;
    protected int min_num_points = 2;
    protected boolean is_closed = false;
    protected FigRenderer renderer = null;
    protected FigAttribs attribs = null;
    protected FigTrafo2D trafo = null;
    protected FigBbox bbox = null;
    protected ObjectPainter painter = null;
    protected String comment = null;
    protected boolean debug = false;
    protected boolean syncRedrawFlag = false;
    protected boolean selected = false;
    protected boolean showPoints = false;
    protected boolean visible = true;

    public void createRenderer() {
        this.renderer = FigObjectFactory.getDefaultObjectFactory().createPolylineRenderer(this);
    }

    public void rebuild() {
        this.renderer.rebuild();
        this.update_bbox();
    }

    public boolean isClosed() {
        return this.is_closed;
    }

    public void setIsClosed(boolean bl) {
        boolean bl2 = bl != this.is_closed;
        this.is_closed = bl;
        if (bl2) {
            this.renderer.rebuild();
        }
    }

    public void appendPoint(Point point) {
        if (this.debug) {
            this.message("FigPolyline.appendPoint: " + point);
        }
        if (point.x == this.wcp[this.wcp.length - 1].x && point.y == this.wcp[this.wcp.length - 1].y) {
            return;
        }
        Point[] pointArray = new Point[this.wcp.length + 1];
        int n = 0;
        while (n < this.wcp.length) {
            pointArray[n] = this.wcp[n];
            ++n;
        }
        pointArray[this.wcp.length] = new Point(point.x, point.y);
        this.wcp = pointArray;
        this.rebuild();
    }

    public void update_bbox() {
        if (this.bbox == null) {
            this.bbox = new FigBbox(0, 0, 0, 0);
        }
        int n = Integer.MAX_VALUE;
        int n2 = -2147483647;
        int n3 = Integer.MAX_VALUE;
        int n4 = -2147483647;
        int n5 = 0;
        while (n5 < this.wcp.length) {
            if (this.wcp[n5].x > n2) {
                n2 = this.wcp[n5].x;
            }
            if (this.wcp[n5].x < n) {
                n = this.wcp[n5].x;
            }
            if (this.wcp[n5].y > n4) {
                n4 = this.wcp[n5].y;
            }
            if (this.wcp[n5].y < n3) {
                n3 = this.wcp[n5].y;
            }
            ++n5;
        }
        this.bbox.set(n, n3, n2, n4);
    }

    public void setTrafo(FigTrafo2D figTrafo2D) {
        if (figTrafo2D == null) {
            this.message("-E- FigPolyline.setTrafo: trafo is null! ignoring...");
            return;
        }
        if (figTrafo2D != this.trafo) {
            this.trafo = figTrafo2D;
            this.rebuild();
        }
    }

    public void setLayer(int n) {
        this.attribs.currentLayer = n;
    }

    public void setArrowMode(int n) {
        this.attribs.arrowMode = n;
        this.rebuild();
    }

    public void setForwardArrow(int n, double d, double d2, double d3) {
        this.attribs.arrow_f_Width = 96.0 * d;
        this.attribs.arrow_f_Length = 96.0 * d2;
        this.attribs.arrow_f_Thickness = 30.0 * d3;
        this.rebuild();
    }

    public void setBackwardArrow(int n, double d, double d2, double d3) {
        this.attribs.arrow_b_Width = 96.0 * d;
        this.attribs.arrow_b_Length = 96.0 * d2;
        this.attribs.arrow_b_Thickness = 30.0 * d3;
        this.rebuild();
    }

    public void setLineColor(Color color) {
        int n;
        this.attribs.fig_line_color = n = ColorCache.getColorCache().registerUserColor(color);
        this.attribs.lineColor = color;
    }

    public void setLineWidth(int n) {
        this.attribs.setFigLineWidth(n);
        this.rebuild();
    }

    public void setLineStyle(int n) {
        this.attribs.lineStyle = n;
        this.rebuild();
    }

    public void setFillColor(Color color) {
        int n;
        this.attribs.fig_fill_color = n = ColorCache.getColorCache().registerUserColor(color);
        this.attribs.fillColor = color;
    }

    public void setFillStyle(int n) {
        if (n < 0) {
            this.attribs.fillStyle = 1;
        } else if (n < 41) {
            this.attribs.fillStyle = 2;
            this.attribs.fig_area_fill = n;
        } else if (n <= 56) {
            this.attribs.fillStyle = 3;
            this.attribs.fig_area_fill = n;
        } else {
            this.message("setFillStyle: value out of range: " + n);
        }
        this.rebuild();
    }

    public double minDistance(Point point) {
        int n = Integer.MAX_VALUE;
        int n2 = 0;
        while (n2 < this.wcp.length) {
            int n3;
            int n4 = Math.abs(this.wcp[n2].x - point.x);
            if (n4 + (n3 = Math.abs(this.wcp[n2].y - point.y)) < n) {
                n = n4 + n3;
            }
            ++n2;
        }
        return n;
    }

    public double minDistanceEuclid(Point point) {
        double d = 5.0;
        double d2 = this.getMinPerpendicularDistance(point);
        return d2 + d;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("FigPolyline with " + this.wcp.length + "points: ");
        int n = 0;
        while (n < this.wcp.length) {
            stringBuffer.append("( " + this.wcp[n].x + ", " + this.wcp[n].y + "), ");
            ++n;
        }
        return stringBuffer.toString();
    }

    public void move(int n, int n2) {
        if (this.debug) {
            this.message("Polyline.move( " + n + ", " + n2 + ") ");
        }
        int n3 = 0;
        while (n3 < this.wcp.length) {
            this.wcp[n3].x += n;
            this.wcp[n3].y += n2;
            ++n3;
        }
        this.rebuild();
    }

    public FigObject copy() {
        if (this.debug) {
            this.message("FigPolyline.copy()...");
        }
        FigPolyline figPolyline = new FigPolyline();
        figPolyline.setPoints(this.getPoints());
        figPolyline.is_closed = this.is_closed;
        figPolyline.setAttributes(this.attribs.getClone());
        figPolyline.setTrafo(this.trafo);
        return figPolyline;
    }

    public boolean canRotate(double d) {
        return true;
    }

    public void update(FigAttribs figAttribs) {
        if (this.debug) {
            this.message("FigPolyline.update()...");
        }
        this.attribs.update(figAttribs);
        this.rebuild();
    }

    public void mirrorX(int n, int n2) {
        int n3 = 0;
        while (n3 < this.wcp.length) {
            this.wcp[n3].x = 2 * n - this.wcp[n3].x;
            ++n3;
        }
        this.rebuild();
    }

    public void mirrorY(int n, int n2) {
        int n3 = 0;
        while (n3 < this.wcp.length) {
            this.wcp[n3].y = 2 * n2 - this.wcp[n3].y;
            ++n3;
        }
        this.rebuild();
    }

    public boolean supportsPointOps() {
        return true;
    }

    public Point[] getPoints() {
        return this.wcp;
    }

    public void setPoints(Point[] pointArray) {
        Point[] pointArray2 = new Point[pointArray.length];
        int n = 0;
        while (n < pointArray.length) {
            pointArray2[n] = new Point(pointArray[n].x, pointArray[n].y);
            ++n;
        }
        this.wcp = pointArray2;
        this.rebuild();
    }

    public void insertPoint(Point point, Point point2) {
        if (this.debug) {
            this.message("FigPolyline.insertPoint()...");
        }
        boolean bl = false;
        int n = -1;
        int n2 = 0;
        while (n2 < this.wcp.length) {
            if (point2.x == this.wcp[n2].x && point2.y == this.wcp[n2].y) {
                n = n2;
            }
            if (point.x == this.wcp[n2].x && point.y == this.wcp[n2].y) {
                bl = true;
            }
            ++n2;
        }
        if (n == -1) {
            this.message("FigPolyline.insertPoint(): Point wprev " + point2.toString() + "is not a Point on this polyline!");
            return;
        }
        if (bl) {
            this.message("FigPolyline.insertPoint(): Point wp " + point.toString() + "is already a Point on this polyline!");
            return;
        }
        Point[] pointArray = new Point[this.wcp.length + 1];
        int n3 = 0;
        while (n3 <= n) {
            pointArray[n3] = this.wcp[n3];
            ++n3;
        }
        pointArray[n + 1] = new Point(point.x, point.y);
        n3 = n + 2;
        while (n3 < pointArray.length) {
            pointArray[n3] = this.wcp[n3 - 1];
            ++n3;
        }
        this.wcp = pointArray;
        this.rebuild();
    }

    public Point deletePoint(Point point) {
        if (this.debug) {
            this.message("FigPolyline.deletePoint()...");
        }
        if (this.wcp.length <= this.min_num_points) {
            return null;
        }
        int n = this.indexOfNearestNeighbor(point);
        if (n == -1) {
            this.message("FigPolyline.delete(): Point wp " + point.toString() + "is not a Point on this polyline!");
            return null;
        }
        Point point2 = n > 0 ? this.wcp[n - 1] : this.wcp[0];
        Point[] pointArray = new Point[this.wcp.length - 1];
        int n2 = 0;
        while (n2 < n) {
            pointArray[n2] = this.wcp[n2];
            ++n2;
        }
        n2 = n;
        while (n2 < pointArray.length) {
            pointArray[n2] = this.wcp[n2 + 1];
            ++n2;
        }
        this.wcp = pointArray;
        this.rebuild();
        return point2;
    }

    public int indexOfNearestNeighbor(Point point) {
        int n = -1;
        int n2 = Integer.MAX_VALUE;
        int n3 = 0;
        while (n3 < this.wcp.length) {
            int n4 = Math.abs(point.x - this.wcp[n3].x) + Math.abs(point.y - this.wcp[n3].y);
            if (n4 < n2) {
                n2 = n4;
                n = n3;
            }
            ++n3;
        }
        if (n2 > this.trafo.getSnapRelative()) {
            return -1;
        }
        return n;
    }

    public void movePoint(Point point, Point point2) {
        int n;
        if (this.debug) {
            this.message("FigPolyline.movePoint()...");
        }
        if ((n = this.indexOfNearestNeighbor(point)) == -1) {
            if (this.debug) {
                this.message("FigPolyline.movePoint(): Point wp " + point.toString() + "is not a Point on this polyline!");
            }
            if (this.debug) {
                String string = "the points are: ";
                int n2 = 0;
                while (n2 < this.wcp.length) {
                    string = string + "(" + this.wcp[n2].x + "," + this.wcp[n2].y + ") ";
                    ++n2;
                }
                this.message(string);
            }
            return;
        }
        this.wcp[n].x = point2.x;
        this.wcp[n].y = point2.y;
        this.rebuild();
    }

    public Point[] getMovePointNeighbors(Point point) {
        int n = Integer.MAX_VALUE;
        int n2 = 0;
        while (n2 < this.wcp.length) {
            int n3 = Math.abs(point.x - this.wcp[n2].x) + Math.abs(point.y - this.wcp[n2].y);
            if (n3 < n) {
                n = n3;
                this.min_i = n2;
            }
            ++n2;
        }
        Point[] pointArray = new Point[]{this.min_i > 0 ? this.wcp[this.min_i - 1] : (this.is_closed ? this.wcp[this.wcp.length - 1] : null), this.min_i < this.wcp.length - 1 ? this.wcp[this.min_i + 1] : (this.is_closed ? this.wcp[0] : null)};
        return pointArray;
    }

    public Point[] getNeighborPoints(Point point) {
        double d;
        double d2 = Double.MAX_VALUE;
        Point point2 = this.wcp[0];
        int n = 0;
        while (n < this.wcp.length - 1) {
            d = this.getSegmentDistance(this.wcp[n], this.wcp[n + 1], point);
            if (this.debug) {
                this.printCost(n, d, d2);
            }
            if (d <= d2) {
                d2 = d;
                this.min_i = n;
                point2 = this.nearerPoint(this.wcp[n], this.wcp[n + 1], point);
            }
            ++n;
        }
        if (this.is_closed) {
            d = this.getSegmentDistance(this.wcp[this.wcp.length - 1], this.wcp[0], point);
            if (this.debug) {
                this.printCost(this.wcp.length, d, d2);
            }
            if (d <= d2) {
                d2 = d;
                this.min_i = this.wcp.length - 1;
                point2 = this.nearerPoint(this.wcp[this.wcp.length - 1], this.wcp[0], point);
            }
        }
        Point[] pointArray = new Point[]{this.wcp[this.min_i], this.min_i < this.wcp.length - 1 ? this.wcp[this.min_i + 1] : this.wcp[0], point2};
        return pointArray;
    }

    protected double getSegmentDistance(Point point, Point point2, Point point3) {
        int n = point3.x - point.x;
        int n2 = point3.y - point.y;
        int n3 = point3.x - point2.x;
        int n4 = point3.y - point2.y;
        int n5 = point2.x - point.x;
        int n6 = point2.y - point.y;
        double d = n * n + n2 * n2 + n3 * n3 + n4 * n4;
        return d /= (double)(n5 * n5 + n6 * n6);
    }

    protected Point nearerPoint(Point point, Point point2, Point point3) {
        int n;
        int n2 = Math.abs(point.x - point3.x) + Math.abs(point.y - point3.y);
        if (n2 < (n = Math.abs(point2.x - point3.x) + Math.abs(point2.y - point3.y))) {
            return point;
        }
        return point2;
    }

    protected void printCost(int n, double d, double d2) {
        if (this.debug) {
            this.message("FigPolyline.getNeighborPoints(): segment " + n + " cost: " + d + " min_cost: " + d2);
        }
    }

    public double calc_dist(Point point) {
        double d = Double.MAX_VALUE;
        int n = 0;
        while (n < this.wcp.length - 1) {
            int n2 = point.x - this.wcp[n].x;
            int n3 = point.y - this.wcp[n].y;
            int n4 = point.x - this.wcp[n + 1].x;
            int n5 = point.y - this.wcp[n + 1].y;
            double d2 = n2 * n2 + n3 * n3 + n4 * n4 + n5 * n5;
            if (this.debug) {
                this.message("FigPolyline.dist(): segment " + n + " cost: " + d2 + " min_cost: " + d);
            }
            if (d2 <= d) {
                d = d2;
                this.min_i = n;
            }
            ++n;
        }
        return d;
    }

    public double getMinPerpendicularDistance(Point point) {
        double d = Double.MAX_VALUE;
        int n = 0;
        while (n < this.wcp.length - 1) {
            double d2 = this.getMinPerpendicularDistance(point, this.wcp[n], this.wcp[n + 1]);
            if (d2 < d) {
                d = d2;
                this.min_i = n;
            }
            ++n;
        }
        return d;
    }

    public double getMinPerpendicularDistance(Point point, Point point2, Point point3) {
        double d = Double.MAX_VALUE;
        double d2 = point3.x - point2.x;
        double d3 = point3.y - point2.y;
        double d4 = point.x - point2.x;
        double d5 = point.y - point2.y;
        double d6 = d2 * d2 + d3 * d3;
        if (d6 <= 0.0) {
            d = Math.sqrt(d4 * d4 + d5 * d5);
        } else {
            double d7 = (d4 * d2 + d5 * d3) / d6;
            double d8 = (d4 * d3 - d5 * d2) / d6;
            if (d7 >= 0.0 && d7 <= 1.0) {
                d = Math.abs(d8) * Math.sqrt(d6);
            } else if (d7 < 0.0) {
                d = Math.sqrt(d4 * d4 + d5 * d5);
            } else {
                d4 = point.x - point3.x;
                d5 = point.y - point3.y;
                d = Math.sqrt(d4 * d4 + d5 * d5);
            }
        }
        return d;
    }

    public int get_min_dist_index(Point point) {
        this.calc_dist(point);
        return this.min_i;
    }

    public Point getMinDistPoint1() {
        return this.wcp[this.min_i];
    }

    public Point getMinDistPoint2() {
        return this.wcp[this.min_i + 1];
    }

    public boolean isVisible(FigBbox figBbox) {
        return this.getBbox().isVisible(figBbox);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public boolean initialize(String string) {
        this.message("-E- FigPolyline.initialize: not supported, ignored!");
        return true;
    }

    public void setObjectPainter(ObjectPainter objectPainter) {
        this.painter = objectPainter;
    }

    public ObjectPainter getObjectPainter() {
        return this.painter;
    }

    public FigTrafo2D getTrafo() {
        return this.trafo;
    }

    public int getLayer() {
        return this.getAttributes().currentLayer;
    }

    public FigBbox getBbox() {
        if (this.bbox == null) {
            this.update_bbox();
        }
        return this.bbox;
    }

    public FigBbox get_sc_bbox() {
        if (this.bbox == null) {
            this.update_bbox();
        }
        int n = this.trafo.wc_to_screen_x(this.bbox.getXl());
        int n2 = this.trafo.wc_to_screen_x(this.bbox.getXr());
        int n3 = this.trafo.wc_to_screen_y(this.bbox.getYt());
        int n4 = this.trafo.wc_to_screen_y(this.bbox.getYb());
        return new FigBbox(n, n3, n2, n4);
    }

    public Point getPosition() {
        if (this.wcp != null && this.wcp.length > 0) {
            return this.wcp[0];
        }
        return new Point(0, 0);
    }

    public FigAttribs getAttributes() {
        return this.attribs;
    }

    public void setAttributes(FigAttribs figAttribs) {
        this.attribs = figAttribs;
        this.rebuild();
    }

    public void updateAttributes(String string) {
        this.getAttributes().parse(string);
        this.rebuild();
    }

    public void set_debug() {
        this.debug = true;
    }

    public void reset_debug() {
        this.debug = false;
    }

    public void scale(Point point, double d, double d2) {
        Point[] pointArray = this.getPoints();
        if (pointArray != null) {
            Point[] pointArray2 = new Point[pointArray.length];
            int n = 0;
            while (n < pointArray2.length) {
                int n2 = point.x + (int)((double)(pointArray[n].x - point.x) * d);
                int n3 = point.y + (int)((double)(pointArray[n].y - point.y) * d2);
                pointArray2[n] = new Point(n2, n3);
                ++n;
            }
            this.setPoints(pointArray2);
        }
        d = Math.abs(d);
        this.attribs.lineWidth *= d;
        this.attribs.dashLength *= d;
        this.attribs.arrow_f_Width *= d;
        this.attribs.arrow_f_Length *= d;
        this.attribs.arrow_f_Thickness *= d;
        this.attribs.arrow_b_Width *= d;
        this.attribs.arrow_b_Length *= d;
        this.attribs.arrow_b_Thickness *= d;
    }

    public void rotate(Point point, double d) throws Exception {
        Point[] pointArray;
        if (this.canRotate(d)) {
            Point[] pointArray2 = this.getPoints();
            pointArray = new Point[pointArray2.length];
            double d2 = Math.cos(d);
            double d3 = Math.sin(d);
            int n = 0;
            while (n < pointArray2.length) {
                double d4 = pointArray2[n].x - point.x;
                double d5 = pointArray2[n].y - point.y;
                double d6 = d4 * d2 - d5 * d3;
                double d7 = d4 * d3 + d5 * d2;
                pointArray[n] = new Point((int)(d6 += (double)point.x), (int)(d7 += (double)point.y));
                ++n;
            }
        } else {
            throw new Exception("Rotation not supported on FigBaseObject!");
        }
        this.setPoints(pointArray);
    }

    public void showPoints() {
        this.showPoints = true;
        this.selected = false;
    }

    public void select() {
        this.selected = true;
        this.showPoints = false;
    }

    public void deselect() {
        this.selected = false;
        this.showPoints = false;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public boolean isShowPoints() {
        return this.showPoints;
    }

    public int numPoints() {
        return this.wcp.length;
    }

    public String getText() {
        this.message("-E- FigPolyline.getText: should not be called! ");
        return null;
    }

    public void setText(String string) {
        this.message("-E- FigPolyline.setText: should not be called! ");
    }

    public Point getNearestPoint(Point point) {
        Point point2 = null;
        double d = Double.MAX_VALUE;
        int n = 0;
        while (n < this.wcp.length) {
            double d2 = this.manhattan(this.wcp[n], point);
            if (d2 < d) {
                d = d2;
                point2 = this.wcp[n];
            }
            ++n;
        }
        return point2;
    }

    public int manhattan(Point point, Point point2) {
        return Math.abs(point.x - point2.x) + Math.abs(point.y - point2.y);
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.message("-E- FigPolyline.keyPressed: ignored");
    }

    public void writeAsResource(PrintWriter printWriter) {
        new FigWriter().writeAsResource(printWriter, this);
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public boolean getSyncRedrawFlag() {
        return this.syncRedrawFlag;
    }

    public void setSyncRedrawFlag(boolean bl) {
        this.syncRedrawFlag = bl;
    }

    public void message(String string) {
        System.err.println(string);
    }

    public void paint(Graphics graphics) {
        this.renderer.paint(graphics);
    }

    public void paint(Graphics graphics, FigTrafo2D figTrafo2D) {
        this.renderer.paint(graphics, figTrafo2D);
    }

    public void paintSave(Graphics graphics, FigTrafo2D figTrafo2D) {
        Graphics graphics2 = graphics.create();
        this.paint(graphics2, figTrafo2D);
        graphics2.dispose();
    }

    public FigPolyline() {
        this.wcp[0] = new Point(0, 0);
        this.trafo = new FigTrafo2D();
        this.attribs = new FigAttribs();
        this.visible = true;
        this.selected = false;
        this.showPoints = false;
        this.syncRedrawFlag = false;
        this.createRenderer();
    }

    public FigPolyline(int n, int n2, boolean bl, FigAttribs figAttribs, FigTrafo2D figTrafo2D) {
        this();
        this.wcp = new Point[]{new Point(n, n2)};
        this.attribs = figAttribs.getClone();
        this.trafo = figTrafo2D;
        this.is_closed = bl;
        this.rebuild();
    }
}

