/*
 * Decompiled with CFR 0.152.
 */
package jfig.objects;

import jfig.java2d.FigArcRenderer;
import jfig.java2d.FigBezierSplineRenderer;
import jfig.java2d.FigEllipseRenderer;
import jfig.java2d.FigImageRenderer;
import jfig.java2d.FigPolylineRenderer;
import jfig.java2d.FigRectangleRenderer;
import jfig.java2d.FigSplineRenderer;
import jfig.java2d.FigTextRenderer;
import jfig.java2d.FigXSplineRenderer;
import jfig.objects.AWTArcRenderer;
import jfig.objects.AWTBezierSplineRenderer;
import jfig.objects.AWTEllipseRenderer;
import jfig.objects.AWTImageRenderer;
import jfig.objects.AWTPolylineRenderer;
import jfig.objects.AWTRectangleRenderer;
import jfig.objects.AWTSplineRenderer;
import jfig.objects.AWTTextRenderer;
import jfig.objects.AWTXSplineRenderer;
import jfig.objects.FigArc;
import jfig.objects.FigAttribs;
import jfig.objects.FigBezier;
import jfig.objects.FigEllipse;
import jfig.objects.FigImage;
import jfig.objects.FigPolyline;
import jfig.objects.FigRectangle;
import jfig.objects.FigRenderer;
import jfig.objects.FigSpline;
import jfig.objects.FigText;
import jfig.objects.FigXSpline;

public class FigObjectFactory {
    private static FigObjectFactory defaultFactory;
    private FigObjectFactory factory;

    public static FigObjectFactory getDefaultObjectFactory() {
        if (defaultFactory == null) {
            FigObjectFactory figObjectFactory = new FigObjectFactory();
            if (FigAttribs.enableJava2D) {
                FigObjectFactory figObjectFactory2 = figObjectFactory;
                if (figObjectFactory2 == null) {
                    throw null;
                }
                defaultFactory = figObjectFactory2.new Java2DFactory();
            } else {
                FigObjectFactory figObjectFactory3 = figObjectFactory;
                if (figObjectFactory3 == null) {
                    throw null;
                }
                defaultFactory = figObjectFactory3.new AWTFactory();
            }
        }
        return defaultFactory;
    }

    public FigRenderer createPolylineRenderer(FigPolyline figPolyline) {
        return this.factory.createPolylineRenderer(figPolyline);
    }

    public FigRenderer createXSplineRenderer(FigXSpline figXSpline) {
        return this.factory.createXSplineRenderer(figXSpline);
    }

    public FigRenderer createSplineRenderer(FigSpline figSpline) {
        return this.factory.createSplineRenderer(figSpline);
    }

    public FigRenderer createBezierSplineRenderer(FigBezier figBezier) {
        return this.factory.createBezierSplineRenderer(figBezier);
    }

    public FigRenderer createArcRenderer(FigArc figArc) {
        return this.factory.createArcRenderer(figArc);
    }

    public FigRenderer createRectangleRenderer(FigRectangle figRectangle) {
        return this.factory.createRectangleRenderer(figRectangle);
    }

    public FigRenderer createImageRenderer(FigImage figImage) {
        return this.factory.createImageRenderer(figImage);
    }

    public FigRenderer createTextRenderer(FigText figText) {
        return this.factory.createTextRenderer(figText);
    }

    public FigRenderer createEllipseRenderer(FigEllipse figEllipse) {
        return this.factory.createEllipseRenderer(figEllipse);
    }

    class Java2DFactory
    extends FigObjectFactory {
        public FigRenderer createPolylineRenderer(FigPolyline figPolyline) {
            return new FigPolylineRenderer(figPolyline);
        }

        public FigRenderer createXSplineRenderer(FigXSpline figXSpline) {
            return new FigXSplineRenderer(figXSpline);
        }

        public FigRenderer createBezierSplineRenderer(FigBezier figBezier) {
            return new FigBezierSplineRenderer(figBezier);
        }

        public FigRenderer createSplineRenderer(FigSpline figSpline) {
            return new FigSplineRenderer(figSpline);
        }

        public FigRenderer createArcRenderer(FigArc figArc) {
            return new FigArcRenderer(figArc);
        }

        public FigRenderer createRectangleRenderer(FigRectangle figRectangle) {
            return new FigRectangleRenderer(figRectangle);
        }

        public FigRenderer createImageRenderer(FigImage figImage) {
            return new FigImageRenderer(figImage);
        }

        public FigRenderer createTextRenderer(FigText figText) {
            return new FigTextRenderer(figText);
        }

        public FigRenderer createEllipseRenderer(FigEllipse figEllipse) {
            return new FigEllipseRenderer(figEllipse);
        }
    }

    class AWTFactory
    extends FigObjectFactory {
        public FigRenderer createPolylineRenderer(FigPolyline figPolyline) {
            return new AWTPolylineRenderer(figPolyline);
        }

        public FigRenderer createXSplineRenderer(FigXSpline figXSpline) {
            return new AWTXSplineRenderer(figXSpline);
        }

        public FigRenderer createBezierSplineRenderer(FigBezier figBezier) {
            return new AWTBezierSplineRenderer(figBezier);
        }

        public FigRenderer createSplineRenderer(FigSpline figSpline) {
            return new AWTSplineRenderer(figSpline);
        }

        public FigRenderer createArcRenderer(FigArc figArc) {
            return new AWTArcRenderer(figArc);
        }

        public FigRenderer createRectangleRenderer(FigRectangle figRectangle) {
            return new AWTRectangleRenderer(figRectangle);
        }

        public FigRenderer createImageRenderer(FigImage figImage) {
            return new AWTImageRenderer(figImage);
        }

        public FigRenderer createTextRenderer(FigText figText) {
            return new AWTTextRenderer(figText);
        }

        public FigRenderer createEllipseRenderer(FigEllipse figEllipse) {
            return new AWTEllipseRenderer(figEllipse);
        }
    }
}

