/*
 * Decompiled with CFR 0.152.
 */
package jfig.objects;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.net.URL;
import jfig.canvas.FigTrafo2D;
import jfig.canvas.FullRedraw;
import jfig.canvas.ObjectPainter;
import jfig.gui.ImageHelper;
import jfig.objects.FigAttribs;
import jfig.objects.FigObject;
import jfig.objects.FigObjectFactory;
import jfig.objects.FigRectangle;
import jfig.utils.SetupManager;

public class FigImage
extends FigRectangle
implements ImageObserver {
    public static final int FIT_TO_WIDTH = 13;
    public static final int FIT_TO_HEIGHT = 14;
    public static final int KEEP_SELECTED_SIZE = 15;
    protected String name;
    protected Image theImage;
    protected int aspectRatio;
    protected FullRedraw theCanvas;
    protected ImageObserver theObserver;
    int sx1;
    int sy1;
    int sx2;
    int sy2;
    boolean has_error = false;
    boolean imageUpdateDebug = false;
    protected String pathname;
    protected String filetype;

    public void rebuild() {
        this.renderer.rebuild();
    }

    public void createRenderer() {
        this.renderer = FigObjectFactory.getDefaultObjectFactory().createImageRenderer(this);
    }

    public String getImageName() {
        return new String(this.name);
    }

    public void setFilenameAndType(String string, String string2) {
        this.pathname = string;
        this.filetype = string2;
    }

    public void getImageFromResource(String string) {
        try {
            this.name = string;
            URL uRL = this.getClass().getResource(string);
            this.theImage = Toolkit.getDefaultToolkit().getImage(uRL);
            this.timestamp = 0L;
        }
        catch (Exception exception) {
            this.message("-E- FigImage.getImageFromResource(): " + exception);
            this.message("-E- offending name is '" + string + "' ");
            exception.printStackTrace();
        }
    }

    public void setImage(String string, boolean bl) {
        this.getImageFromResource(string);
    }

    public void setImageName(String string) {
        this.name = string;
    }

    public void setImageAndFilename(String string, String string2, String string3, boolean bl) {
        if (this.debug) {
            this.message("FigImage.sIAF: name=" + string + " fname=" + string2 + " ftype=" + string3);
        }
        this.setFilenameAndType(string2, string3);
        this.name = string;
        if (string2 != null) {
            this.theImage = ImageHelper.findImage(string3, string2, string);
            this.timestamp = 0L;
        } else {
            this.getImageFromResource(string);
        }
    }

    public void setImage(Image image) {
        this.theImage = image;
        this.rebuild();
    }

    public Image getImage() {
        return this.theImage;
    }

    public void setObjectPainter(ObjectPainter objectPainter) {
        if (this.painter == objectPainter) {
            return;
        }
        super.setObjectPainter(objectPainter);
        try {
            this.theCanvas = (FullRedraw)((Object)objectPainter);
            this.theObserver = this;
            this.theCanvas.doFullRedraw();
        }
        catch (Exception exception) {
            this.message("-W- FigImage.setObjectPainter(): not a FullRedraw?");
            this.message("-W- message is: '" + exception + "'");
            this.message("-W- painter is: '" + objectPainter + "'");
        }
    }

    public void updateAspectRatio(int n) {
        if (this.debug) {
            this.message("-#- updateAspectRatio: " + n);
        }
        this.aspectRatio = n;
        if (this.theImage == null) {
            return;
        }
        int n2 = this.theImage.getWidth(this.theObserver);
        int n3 = this.theImage.getHeight(this.theObserver);
        if (n2 <= 0 || n3 <= 0) {
            return;
        }
        double d = 1.0;
        Point point = this.getPoints()[0];
        Point point2 = this.getPoints()[1];
        Point point3 = new Point(point2.x, point2.y);
        if (n == 13) {
            d = 1.0 * (double)(point2.x - point.x) / (double)n2;
            double d2 = d * (double)n3;
            point3.y = point.y + (int)d2;
        } else if (n == 14) {
            d = 1.0 * (double)(point2.y - point.y) / (double)n3;
            double d3 = d * (double)n2;
            point3.x = point.x + (int)d3;
        } else {
            return;
        }
        Point[] pointArray = new Point[]{point, point3};
        this.setPoints(pointArray);
    }

    public FigObject copy() {
        FigImage figImage = new FigImage();
        figImage.setPoints(this.getPoints());
        figImage.setAttributes(this.getAttributes().getClone());
        figImage.setTrafo(this.getTrafo());
        figImage.name = this.name;
        figImage.theCanvas = this.theCanvas;
        figImage.setImageAndFilename(this.name, this.pathname, this.filetype, false);
        return figImage;
    }

    public void paint(Graphics graphics) {
        this.renderer.paint(graphics);
    }

    public void paint(Graphics graphics, FigTrafo2D figTrafo2D) {
        this.renderer.paint(graphics, figTrafo2D);
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if (this.imageUpdateDebug) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("-#- FigImage.imageUpdate: ");
            if (image != null) {
                stringBuffer.append(image.hashCode());
            } else {
                stringBuffer.append("image is NULL");
            }
            stringBuffer.append(" [" + n4 + "," + n5 + "] " + n);
            if ((n & 0x20) > 0) {
                stringBuffer.append(" ALLBITS.");
            }
            if ((n & 0x40) > 0) {
                stringBuffer.append(" ERROR!");
            }
            System.out.println(stringBuffer);
        }
        if ((n & 0x38) != 0) {
            // empty if block
        }
        if ((n & 0x20) > 0) {
            this.renderer.rebuild();
            if (this.theCanvas != null) {
                if (this.imageUpdateDebug) {
                    System.out.println("-#- FigImage.imageUpdate: calling doFullRedraw...");
                }
                this.theCanvas.doFullRedraw(200L);
            } else {
                System.err.println("-E- Internal: FigImage.imageUpdate: null canvas");
            }
            return false;
        }
        if ((n & 0x40) > 0 && !this.has_error) {
            this.has_error = true;
            this.message("-E- error while loading image '" + this.name + "', sorry!");
            this.message("-E- pathname '" + this.pathname + "' type '" + this.filetype + "'");
            return false;
        }
        return true;
    }

    public void setRedraw(FullRedraw fullRedraw) {
        this.theCanvas = fullRedraw;
    }

    public String toString() {
        String string = "FigImage from (" + this.bbox.getXl() + ", " + this.bbox.getYb() + ") to (" + this.bbox.getXr() + ", " + this.bbox.getYt() + ") on layer (" + this.attribs.currentLayer + ") with colors " + this.attribs.lineColor.toString() + ", " + this.attribs.fillColor.toString() + "\n with Image: " + this.name;
        return string;
    }

    public FigImage(int n, int n2, int n3, int n4, FigAttribs figAttribs, FigTrafo2D figTrafo2D, String string) {
        super(n, n2, n3, n4, 1);
        this.name = string;
        this.trafo = figTrafo2D;
        this.attribs = figAttribs.getClone();
        this.theCanvas = null;
        this.aspectRatio = 15;
        this.theObserver = this;
        if (this.name != null) {
            ImageHelper.findImage(null, null, this.name);
        }
        this.imageUpdateDebug = SetupManager.getBoolean("jfig.objects.FigImage.verboseImageUpdate", false);
        this.rebuild();
    }

    public FigImage() {
        this(0, 0, 500, 500, new FigAttribs(), new FigTrafo2D(), null);
    }
}

