/*
 * Decompiled with CFR 0.152.
 */
package jfig.objects;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import jfig.canvas.FigTrafo2D;
import jfig.gui.ColorCache;
import jfig.objects.FigAttribs;
import jfig.objects.FigBaseobject;
import jfig.objects.FigBbox;
import jfig.objects.FigObject;
import jfig.objects.FigObjectFactory;
import jfig.objects.FigRenderer;

public class FigEllipse
extends FigBaseobject {
    FigRenderer renderer;
    Point center;
    Point size;

    public void createRenderer() {
        this.renderer = FigObjectFactory.getDefaultObjectFactory().createEllipseRenderer(this);
    }

    public void setAttributes(FigAttribs figAttribs) {
        this.attribs = figAttribs;
        figAttribs.fig_ellipse_angle = figAttribs.fig_angle;
        this.rebuild();
    }

    public Point getCenterPoint() {
        return this.center;
    }

    public Point getRadiusPoint() {
        return this.size;
    }

    public void setTrafo(FigTrafo2D figTrafo2D) {
        if (figTrafo2D != this.trafo) {
            this.trafo = figTrafo2D;
            this.rebuild();
        }
    }

    public void setCenterAndRadius(Point point, Point point2) {
        this.center = new Point(point.x, point.y);
        this.size = new Point(point2.x, point2.y);
        this.rebuild();
    }

    public void rebuild() {
        if (this.renderer == null) {
            this.createRenderer();
        }
        this.renderer.rebuild();
        this.bbox = new FigBbox(this.center.x - this.size.x, this.center.y - this.size.y, this.center.x + this.size.x, this.center.y + this.size.y);
        this.timestamp = System.currentTimeMillis();
    }

    public Point[] getPoints() {
        Point[] pointArray = new Point[]{new Point(this.center.x - this.size.x, this.center.y - this.size.y), new Point(this.center.x + this.size.x, this.center.y + this.size.y)};
        return pointArray;
    }

    public void setPoints(Point[] pointArray) {
        if (pointArray == null || pointArray.length != 2) {
            this.message("-E- FigEllipse.setPoints: invalid argument:" + pointArray);
            return;
        }
        int n = Math.abs(pointArray[0].x - pointArray[1].x) / 2;
        int n2 = Math.abs(pointArray[0].y - pointArray[1].y) / 2;
        int n3 = (pointArray[0].x + pointArray[1].x) / 2;
        int n4 = (pointArray[0].y + pointArray[1].y) / 2;
        this.center = new Point(n3, n4);
        this.size = new Point(n, n2);
        this.rebuild();
    }

    public boolean supportsPointOps() {
        return true;
    }

    public boolean isClosed() {
        return true;
    }

    public void appendPoint(Point point) {
    }

    public Point deletePoint(Point point) {
        return null;
    }

    public void insertPoint(Point point, Point point2) {
    }

    public Point[] getMovePointNeighbors(Point point) {
        int n = Math.abs(point.x - this.bbox.getXl()) < Math.abs(point.x - this.bbox.getXr()) ? this.bbox.getXr() : this.bbox.getXl();
        int n2 = Math.abs(point.y - this.bbox.getYt()) < Math.abs(point.y - this.bbox.getYb()) ? this.bbox.getYb() : this.bbox.getYt();
        Point point2 = new Point(n, n2);
        Point[] pointArray = new Point[]{point2};
        return pointArray;
    }

    public void movePoint(Point point, Point point2) {
        int n = Math.abs(point.x - this.bbox.getXl());
        int n2 = Math.abs(point.x - this.bbox.getXr());
        int n3 = Math.abs(point.y - this.bbox.getYt());
        int n4 = Math.abs(point.y - this.bbox.getYb());
        int n5 = n < n2 ? this.bbox.getXr() : this.bbox.getXl();
        int n6 = n3 < n4 ? this.bbox.getYb() : this.bbox.getYt();
        Point point3 = new Point(n5, n6);
        this.bbox.set(point2.x, point2.y, point3.x, point3.y);
        this.x = this.bbox.getXl();
        this.y = this.bbox.getYt();
        Point[] pointArray = new Point[]{point2, point3};
        this.setPoints(pointArray);
    }

    public Point getNearestPoint(Point point) {
        int n = Math.abs(point.x - this.bbox.getXl());
        int n2 = Math.abs(point.x - this.bbox.getXr());
        int n3 = Math.abs(point.y - this.bbox.getYt());
        int n4 = Math.abs(point.y - this.bbox.getYb());
        int n5 = n > n2 ? this.bbox.getXr() : this.bbox.getXl();
        int n6 = n3 > n4 ? this.bbox.getYb() : this.bbox.getYt();
        return new Point(n5, n6);
    }

    public Point[] getNeighborPoints(Point point) {
        Point[] pointArray = new Point[]{point, point, point};
        return pointArray;
    }

    void update_bbox() {
    }

    public void paint(Graphics graphics) {
        this.renderer.paint(graphics);
    }

    public void move(int n, int n2) {
        this.x += n;
        this.y += n2;
        this.center.x += n;
        this.center.y += n2;
        this.rebuild();
    }

    public FigObject copy() {
        FigEllipse figEllipse = new FigEllipse(new Point(this.center.x, this.center.y), new Point(this.center.x + this.size.x, this.center.y + this.size.y), this.attribs.getClone(), this.trafo);
        return figEllipse;
    }

    public void mirrorX(int n, int n2) {
        Point point = this.getCenterPoint();
        Point point2 = this.getRadiusPoint();
        point.x = 2 * n - point.x;
        this.setCenterAndRadius(point, point2);
    }

    public void mirrorY(int n, int n2) {
        Point point = this.getCenterPoint();
        Point point2 = this.getRadiusPoint();
        point.y = 2 * n2 - point.y;
        this.setCenterAndRadius(point, point2);
    }

    public void update(FigAttribs figAttribs) {
        this.attribs.update(figAttribs);
        this.attribs.fig_ellipse_angle = this.attribs.fig_angle;
        this.rebuild();
    }

    public boolean canRotate(double d) {
        return true;
    }

    public void rotate(Point point, double d) {
        try {
            Point point2 = this.getCenterPoint();
            Point point3 = this.getRadiusPoint();
            double d2 = Math.cos(d);
            double d3 = Math.sin(d);
            double d4 = point2.x - point.x;
            double d5 = point2.y - point.y;
            double d6 = d4 * d2 - d5 * d3 + (double)point.x + 0.5;
            double d7 = d4 * d3 + d5 * d2 + (double)point.y + 0.5;
            this.attribs.fig_ellipse_angle -= d;
            this.setCenterAndRadius(new Point((int)d6, (int)d7), point3);
            this.rebuild();
        }
        catch (Throwable throwable) {
            System.err.println(throwable);
            throwable.printStackTrace();
        }
    }

    public void setLayer(int n) {
        this.attribs.currentLayer = n;
    }

    public void setLineColor(Color color) {
        int n;
        this.attribs.fig_line_color = n = ColorCache.getColorCache().registerUserColor(color);
        this.attribs.lineColor = color;
    }

    public void setLineWidth(int n) {
        this.attribs.setFigLineWidth(n);
        this.rebuild();
    }

    public void setLineStyle(int n) {
        this.attribs.lineStyle = n;
        this.rebuild();
    }

    public void setFillColor(Color color) {
        int n;
        this.attribs.fig_fill_color = n = ColorCache.getColorCache().registerUserColor(color);
        this.attribs.fillColor = color;
    }

    public void setFillStyle(int n) {
        if (n < 0) {
            this.attribs.fillStyle = 1;
        } else if (n < 41) {
            this.attribs.fillStyle = 2;
            this.attribs.fig_area_fill = n;
        } else if (n <= 56) {
            this.attribs.fillStyle = 3;
            this.attribs.fig_area_fill = n;
        } else {
            this.message("setFillStyle: value out of range: " + n);
        }
        this.rebuild();
    }

    public double minDistance(Point point) {
        return this.bbox.minDistanceInside(point);
    }

    public String toString() {
        String string = "FigEllipse  center " + this.x + "," + this.y + " radii " + this.size.x + "," + this.size.y + " layer " + this.attribs.currentLayer + " colors " + this.attribs.lineColor + " " + this.attribs.fillColor;
        return string;
    }

    public FigEllipse(Point point, Point point2, FigAttribs figAttribs, FigTrafo2D figTrafo2D) {
        this.center = new Point(point.x, point.y);
        this.size = new Point(Math.abs(point2.x - point.x), Math.abs(point2.y - point.y));
        this.x = this.center.x;
        this.y = this.center.y;
        this.attribs = figAttribs.getClone();
        this.attribs.fig_ellipse_angle = figAttribs.fig_angle;
        this.trafo = figTrafo2D;
        this.timestamp = 0L;
        this.createRenderer();
        this.rebuild();
    }
}

