/*
 * Decompiled with CFR 0.152.
 */
package jfig.objects;

import java.awt.Point;
import java.awt.Rectangle;

public final class FigBbox {
    private int xl;
    private int yt;
    private int xr;
    private int yb;

    public final void set(int n, int n2, int n3, int n4) {
        this.xl = Math.min(n, n3);
        this.xr = Math.max(n, n3);
        this.yt = Math.min(n2, n4);
        this.yb = Math.max(n2, n4);
    }

    public final void set(FigBbox figBbox) {
        this.xl = figBbox.xl;
        this.yt = figBbox.yt;
        this.xr = figBbox.xr;
        this.yb = figBbox.yb;
    }

    public final FigBbox get() {
        return this;
    }

    public int getXl() {
        return this.xl;
    }

    public int getYt() {
        return this.yt;
    }

    public int getXr() {
        return this.xr;
    }

    public int getYb() {
        return this.yb;
    }

    public final boolean isInside(Point point) {
        return point.x >= this.xl && point.x <= this.xr && point.y >= this.yt && point.y <= this.yb;
    }

    public final boolean inside(int n, int n2) {
        return this.xl <= n && n <= this.xr && this.yt <= n2 && n2 <= this.yb;
    }

    public final boolean inside(FigBbox figBbox) {
        return this.xl >= figBbox.xl && this.xr <= figBbox.xr && this.yt >= figBbox.yt && this.yb <= figBbox.yb;
    }

    public final boolean isVisible(FigBbox figBbox) {
        return this.xl < figBbox.xr && this.xr > figBbox.xl && this.yt < figBbox.yb && this.yb > figBbox.yt;
    }

    public final boolean isOnBorder(Point point, int n) {
        if (Math.abs(point.y - this.yt) < n || Math.abs(point.y - this.yb) < n) {
            return point.x > this.xl && point.x < this.xr;
        }
        if (Math.abs(point.x - this.xl) < n || Math.abs(point.x - this.xr) < n) {
            return point.y > this.yt && point.y < this.yb;
        }
        return false;
    }

    public final FigBbox union(FigBbox figBbox) {
        FigBbox figBbox2 = new FigBbox(this.xl, this.yt, this.xr, this.yb);
        figBbox2.xl = Math.min(this.xl, figBbox.xl);
        figBbox2.xr = Math.max(this.xr, figBbox.xr);
        figBbox2.yt = Math.min(this.yt, figBbox.yt);
        figBbox2.yb = Math.max(this.yb, figBbox.yb);
        return figBbox2;
    }

    public static final FigBbox union(FigBbox figBbox, FigBbox figBbox2) {
        FigBbox figBbox3 = new FigBbox(0, 0, 0, 0);
        figBbox3.xl = Math.min(figBbox.xl, figBbox2.xl);
        figBbox3.xr = Math.max(figBbox.xr, figBbox2.xr);
        figBbox3.yt = Math.min(figBbox.yt, figBbox2.yt);
        figBbox3.yb = Math.max(figBbox.yb, figBbox2.yb);
        return figBbox3;
    }

    public final double minDistance(Point point) {
        int n = Math.min(Math.abs(this.xl - point.x), Math.abs(this.xr - point.x));
        int n2 = Math.min(Math.abs(this.yt - point.y), Math.abs(this.yb - point.y));
        return n + n2;
    }

    public final double minDistanceInsideZero(Point point) {
        if (this.isInside(point)) {
            return 0.0;
        }
        return this.minDistance(point);
    }

    public final double minDistanceInside(Point point) {
        double d = this.minDistance(point);
        if (this.isInside(point)) {
            return 0.9 * d;
        }
        return d;
    }

    public final Point getNearestCorner(Point point) {
        int n = Math.abs(point.x - this.xl);
        int n2 = Math.abs(point.x - this.xr);
        int n3 = Math.abs(point.y - this.yt);
        int n4 = Math.abs(point.y - this.yb);
        int n5 = n > n2 ? this.xr : this.xl;
        int n6 = n3 > n4 ? this.yb : this.yt;
        return new Point(n5, n6);
    }

    public final Point getOppositeCorner(Point point) {
        int n = Math.abs(point.x - this.xl);
        int n2 = Math.abs(point.x - this.xr);
        int n3 = Math.abs(point.y - this.yt);
        int n4 = Math.abs(point.y - this.yb);
        int n5 = n < n2 ? this.xr : this.xl;
        int n6 = n3 < n4 ? this.yb : this.yt;
        return new Point(n5, n6);
    }

    public final Point getCenterPoint() {
        return new Point((int)(0.5 * (double)(this.xl + this.xr)), (int)(0.5 * (double)(this.yt + this.yb)));
    }

    public Rectangle getRectangle() {
        return new Rectangle(this.xl, this.yt, this.xr - this.xl, this.yb - this.yt);
    }

    public String toString() {
        String string = "bbox: (" + this.xl + ", " + this.yt + ") (" + this.xr + ", " + this.yb + ") ";
        return string;
    }

    public FigBbox(int n, int n2, int n3, int n4) {
        this.xl = Math.min(n, n3);
        this.xr = Math.max(n, n3);
        this.yt = Math.min(n2, n4);
        this.yb = Math.max(n2, n4);
    }

    public FigBbox(Point point, Point point2) {
        this.xl = Math.min(point.x, point2.x);
        this.xr = Math.max(point.x, point2.x);
        this.yt = Math.min(point.y, point2.y);
        this.yb = Math.max(point.y, point2.y);
    }

    public FigBbox(FigBbox figBbox) {
        this.xl = figBbox.xl;
        this.xr = figBbox.xr;
        this.yt = figBbox.yt;
        this.yb = figBbox.yb;
    }
}

