/*
 * Decompiled with CFR 0.152.
 */
package jfig.objects;

import java.awt.Color;
import java.awt.Font;
import java.util.Properties;
import java.util.StringTokenizer;
import jfig.gui.ColorCache;
import jfig.gui.FontCache;
import jfig.utils.SetupManager;

public class FigAttribs
implements Cloneable {
    public static final int FIG_20 = 20;
    public static final int FIG_21 = 21;
    public static final int FIG_30 = 30;
    public static final int FIG_31 = 31;
    public static final int FIG_32 = 32;
    public static final int SIMPLE_ARROW = 2;
    public static final int TRIANGLE_ARROW = 4;
    public static final int TRIANGLE_FILL_ARROW = 5;
    public static final int BACK_ARROW = 6;
    public static final int BACK_FILL_ARROW = 7;
    public static final int ARC_ARROW = 8;
    public static final int ARC_FILL_ARROW = 9;
    public static final int SOLDERDOT_ARROW = 11;
    public static final int NO_ARROW = 0;
    public static final int FORWARD_ARROW = 1;
    public static final int BACKWARD_ARROW = 2;
    public static final int DOUBLE_ARROW = 3;
    public static final int SOLID_LINE = 0;
    public static final int DASHED_LINE = 1;
    public static final int DOTTED_LINE = 2;
    public static final int DASH_DOT_LINE = 3;
    public static final int DASH_DOT2_LINE = 4;
    public static final int DASH_DOT3_LINE = 5;
    public static final int LINE_WIDTH_0 = 0;
    public static final int LINE_WIDTH_1 = 1;
    public static final int LINE_WIDTH_2 = 2;
    public static final int LINE_WIDTH_3 = 3;
    public static final int LINE_WIDTH_4 = 4;
    public static final int LINE_WIDTH_5 = 5;
    public static final int LINE_WIDTH_6 = 6;
    public static final int LINE_WIDTH_7 = 7;
    public static final int LINE_WIDTH_8 = 8;
    public static final int LINE_WIDTH_9 = 9;
    public static final double defaultDashLength = 192.0;
    public static final int NO_FILL = 1;
    public static final int SOLID_FILL = 2;
    public static final int PATTERN_FILL = 3;
    public static final int PATTERN_BLACK = 0;
    public static final int PATTERN_PURE = 20;
    public static final int PATTERN_WHITE = 40;
    public static final int PATTERN_30_DEGREE_LEFT = 41;
    public static final int PATTERN_30_DEGREE_RIGHT = 42;
    public static final int PATTERN_30_DEGREE_CROSSHATCH = 43;
    public static final int PATTERN_45_DEGREE_LEFT = 44;
    public static final int PATTERN_45_DEGREE_RIGHT = 45;
    public static final int PATTERN_45_DEGREE_CROSSHATCH = 46;
    public static final int PATTERN_BRICKS = 47;
    public static final int PATTERN_CIRCLES = 48;
    public static final int PATTERN_HORIZONTAL_LINES = 49;
    public static final int PATTERN_VERTICAL_LINES = 50;
    public static final int PATTERN_CROSSHATCH = 51;
    public static final int PATTERN_FISH_SCALES = 52;
    public static final int PATTERN_SMALL_FISH_SCALES = 53;
    public static final int PATTERN_OCTOGONS = 54;
    public static final int PATTERN_HORIZONTAL_TIRE_TREADS = 55;
    public static final int PATTERN_VERTICAL_TIRE_TREADDS = 56;
    public static final int JOIN_MITER = 0;
    public static final int JOIN_BEVEL = 1;
    public static final int JOIN_ROUND = 2;
    public static final int CAP_BUTT = 0;
    public static final int CAP_ROUND = 1;
    public static final int CAP_PROJECTING = 2;
    public static final int NO_ALIGN = 0;
    public static final int LEFT_ALIGN = 1;
    public static final int CENTER_X_ALIGN = 2;
    public static final int RIGHT_ALIGN = 3;
    public static final int BOTTOM_ALIGN = 1;
    public static final int CENTER_Y_ALIGN = 2;
    public static final int TOP_ALIGN = 3;
    public static final int defaultFontSize = 12;
    public static final Font defaultFont = new Font("Courier", 0, 10);
    public static final int FONT_TIMES_ROMAN = 0;
    public static final int FONT_TIMES_ROMAN_ITALIC = 1;
    public static final int FONT_TIMES_ROMAN_BOLD = 2;
    public static final int FONT_TIMES_ROMAN_BOLD_ITALIC = 3;
    public static final int FONT_AVANTGARDE_BOOK = 4;
    public static final int FONT_AVANTGARDE_BOOK_OBLIQUE = 5;
    public static final int FONT_AVANTGARDE_BOOK_DEMI = 6;
    public static final int FONT_AVANTGARDE_BOOK_DEMI_OBLIQUE = 7;
    public static final int FONT_BOOKMAN_LIGHT = 8;
    public static final int FONT_BOOKMAN_LIGHT_ITALIC = 9;
    public static final int FONT_BOOKMAN_LIGHT_DEMI = 10;
    public static final int FONT_BOOKMAN_LIGHT_DEMI_ITALIC = 11;
    public static final int FONT_COURIER = 12;
    public static final int FONT_COURIER_OBLIQUE = 13;
    public static final int FONT_COURIER_BOLD = 14;
    public static final int FONT_COURIER_BOLD_OBLIQUE = 15;
    public static final int FONT_HELVETICA = 16;
    public static final int FONT_HELVETICA_OBLIQUE = 17;
    public static final int FONT_HELVETICA_BOLD = 18;
    public static final int FONT_HELVETICA_BOLD_OBLIQUE = 19;
    public static final int FONT_HELVETICA_NARROW = 20;
    public static final int FONT_HELVETICA_NARROW_OBLIQUE = 21;
    public static final int FONT_HELVETICA_NARROW_BOLD = 22;
    public static final int FONT_HELVETICA_NARROW_BOLD_OBLIQUE = 23;
    public static final int FONT_NEW_CENTURY_SCHLBK_ROMAN = 24;
    public static final int FONT_NEW_CENTURY_SCHLBK_ITALIC = 25;
    public static final int FONT_NEW_CENTURY_SCHLBK_BOLD = 26;
    public static final int FONT_NEW_CENTURY_SCHLBK_BOLD_ITALIC = 27;
    public static final int FONT_PALATINO_ROMAN = 28;
    public static final int FONT_PALATINO_ITALIC = 29;
    public static final int FONT_PALATINO_BOLD = 30;
    public static final int FONT_PALATINO_BOLD_ITALIC = 31;
    public static final int FONT_SYMBOL = 32;
    public static final int FONT_ZAPF_CHANCERY_MEDIUM_ITALIC = 33;
    public static final int FONT_ZAPF_DINGBATS = 34;
    public static final int FONT_CMR = 35;
    public static final int FONT_CMTI = 36;
    public static final int FONT_CMBX = 37;
    public static final int FONT_CMSS = 38;
    public static final int FONT_CMSL = 39;
    public static final int FONT_CMTT = 40;
    public static final int FONT_CMITT = 41;
    public static final int FONT_CMMI = 42;
    public static final int FONT_CMMIB = 43;
    public static final int FONT_CMSY = 44;
    public static final int FONT_CMBSY = 45;
    public static final int FONT_CMEX = 46;
    public static final int FONT_MSAM = 47;
    public static final int FONT_MSBM = 48;
    public static final String HEADER_UNITS_METRIC = "Metric";
    public static final String HEADER_UNITS_INCHES = "Inches";
    public static final String[] HEADER_PAPER_SIZE = new String[]{"A4", "A3", "Letter", "Legal"};
    public static int defaultFigVersion = 32;
    public static String pageUnits = "Metric";
    public static String pageJustification = "Center";
    public static String pageOrientation = "Portrait";
    public static String paperSize = "A4";
    public static String singleOrMultipleSheets = "Single";
    public static double exportMagnification = 100.0;
    public static int transparentColorIndex = -2;
    private static String[] objects = new String[]{"polyline", "line", "polygon", "patch", "spline", "bspline", "ispline", "xspline", "arc", "rect", "rectangle", "roundrect", "circle", "ellipse", "image", "text"};
    private static String[] colorNames = new String[]{"black", "blue", "green", "cyan", "red", "magenta", "yellow", "white", "blue4", "blue3", "blue2", "ltblue", "green4", "green3", "green2", "cyan4", "cyan3", "cyan2", "red4", "red3", "red", "magenta4", "magenta3", "magenta2", "brown4", "brown3", "brown2", "pink4", "pink3", "pink2", "pink", "gold"};
    private static String[] lineStyles = new String[]{"solid", "dashed", "dotted", "dashdot", "dashdot2", "dashdot3", "-", "--", ".", "-.", "-..", "-..."};
    private static String[] arrowModes = new String[]{"none", "forward", "backward", "both", "-", "->", "<-", "<->"};
    private static String[] patterns = new String[]{"none", "pure", "0%", "5%", "10%", "15%", "20%", "25%", "30%", "35%", "40%", "45%", "50%", "55%", "60%", "65%", "70%", "75%", "80%", "85%", "90%", "95%", "100%", "105%", "110%", "115%", "120%", "125%", "130%", "135%", "140%", "145%", "150%", "155%", "160%", "165%", "170%", "175%", "180%", "185%", "190%", "195%", "bricks", "crosshatch", "fishscales"};
    public static final int Landscape = 0;
    public static final int Portrait = 1;
    public static final int CenterJustification = 0;
    public static final int FlushLeftJustification = 1;
    public static final int MetricUnits = 0;
    public static final int InchesUnits = 1;
    public static final int XMMUnits = 2;
    public static int fig_orientation = 0;
    public static int fig_justification = 0;
    public static int fig_units = 0;
    public static int fig_resolution = 1200;
    public static int fig_origin = 2;
    public static boolean enableJava2D = false;
    public static boolean updateLineColorMask = true;
    public static boolean updateLineStyleMask = true;
    public static boolean updateLineWidthMask = true;
    public static boolean updateArrowModeMask = true;
    public static boolean updateArrowStyleMask = true;
    public static boolean updateFillColorMask = true;
    public static boolean updateFillStyleMask = true;
    public static boolean updateFontMask = true;
    public static boolean updateFontSizeMask = true;
    public static boolean updateFontFlagMask = true;
    public static boolean updateTextAlignMask = true;
    public static boolean updateTextMask = true;
    public static boolean updateAngleMask = true;
    public static boolean updateLayerMask = true;
    public static boolean updateCornerRadiusMask = true;
    public int fig_line_color;
    public int fig_fill_color;
    public int fig_area_fill;
    public int fig_pen_style;
    public int fig_join_style;
    public int fig_cap_style;
    public double fig_style_val = 4.0;
    public double fig_angle;
    public double fig_ellipse_angle;
    public int fig_ellipse_direction;
    public int fig_font;
    public int fig_font_flags;
    public double fig_text_height;
    public double fig_text_width;
    public int figVersion = defaultFigVersion;
    public Color lineColor = Color.black;
    public int lineStyle = 0;
    public int arrowMode = 0;
    public double lineWidth = 30.0;
    public double dashLength = 192.0;
    public int currentLayer = 100;
    public int arrow_f_Style = 2;
    public int arrow_b_Style = 2;
    public double arrow_f_Width = 288.0;
    public double arrow_f_Length = 480.0;
    public double arrow_f_Thickness = 30.0;
    public double arrow_b_Width = 288.0;
    public double arrow_b_Length = 480.0;
    public double arrow_b_Thickness = 30.0;
    public int cornerRadius = 0;
    public int objectAlign = 2;
    public int textAlign = 1;
    public Color fillColor = Color.black;
    public int fillStyle = 1;
    public int fontSize = 12;

    public FigAttribs getClone() {
        try {
            FigAttribs figAttribs = (FigAttribs)FigAttribs.super.clone();
            return figAttribs;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void update(FigAttribs figAttribs) {
        if (figAttribs.getUpdateLineStyleMask()) {
            this.lineStyle = figAttribs.lineStyle;
            this.fig_style_val = figAttribs.fig_style_val;
            this.dashLength = figAttribs.dashLength;
        }
        if (figAttribs.getUpdateLineWidthMask()) {
            this.lineWidth = figAttribs.lineWidth;
        }
        if (figAttribs.getUpdateLineColorMask()) {
            this.lineColor = figAttribs.lineColor;
            this.fig_line_color = figAttribs.fig_line_color;
        }
        if (figAttribs.getUpdateArrowModeMask()) {
            this.arrowMode = figAttribs.arrowMode;
        }
        if (figAttribs.getUpdateArrowStyleMask()) {
            this.arrow_f_Style = figAttribs.arrow_f_Style;
            this.arrow_b_Style = figAttribs.arrow_b_Style;
            this.arrow_f_Width = figAttribs.arrow_f_Width;
            this.arrow_f_Length = figAttribs.arrow_f_Length;
            this.arrow_f_Thickness = figAttribs.arrow_f_Thickness;
            this.arrow_b_Width = figAttribs.arrow_b_Width;
            this.arrow_b_Length = figAttribs.arrow_b_Length;
            this.arrow_b_Thickness = figAttribs.arrow_b_Thickness;
        }
        if (figAttribs.getUpdateFillStyleMask()) {
            this.fillStyle = figAttribs.fillStyle;
            this.fig_area_fill = figAttribs.fig_area_fill;
        }
        if (figAttribs.getUpdateFillColorMask()) {
            this.fillColor = figAttribs.fillColor;
            this.fig_fill_color = figAttribs.fig_fill_color;
        }
        if (figAttribs.getUpdateFontMask()) {
            this.fig_font = figAttribs.fig_font;
        }
        if (figAttribs.getUpdateFontSizeMask()) {
            this.fontSize = figAttribs.fontSize;
        }
        if (figAttribs.getUpdateFontFlagMask()) {
            this.fig_font_flags = figAttribs.fig_font_flags;
        }
        if (figAttribs.getUpdateTextAlignMask()) {
            this.textAlign = figAttribs.textAlign;
        }
        if (figAttribs.getUpdateLayerMask()) {
            this.currentLayer = figAttribs.currentLayer;
        }
        if (figAttribs.getUpdateCornerRadiusMask()) {
            this.cornerRadius = figAttribs.cornerRadius;
        }
        if (figAttribs.getUpdateAngleMask()) {
            this.fig_angle = figAttribs.fig_angle;
        }
    }

    public static void initializeFromProperties(Properties properties) {
        pageUnits = properties.getProperty("jfig.units", HEADER_UNITS_METRIC);
        paperSize = properties.getProperty("jfig.paperSize", "A4");
        pageJustification = properties.getProperty("jfig.pageJustification", "Center");
        pageOrientation = properties.getProperty("jfig.pageOrientation", "Landscape");
    }

    public void setFigLineWidth(int n) {
        this.lineWidth = n <= 0 ? 0.0 : (double)(n * 30);
    }

    public String getPageOrientation() {
        return pageOrientation;
    }

    public String getPageJustification() {
        return pageJustification;
    }

    public String getPageUnits() {
        return pageUnits;
    }

    public String getPaperSize() {
        return paperSize;
    }

    public double getExportMagnification() {
        return exportMagnification;
    }

    public String getSingleOrMultipleSheets() {
        return singleOrMultipleSheets;
    }

    public int getTransparentColorIndex() {
        return transparentColorIndex;
    }

    public int getFigOrientation() {
        return fig_orientation;
    }

    public int getFigJustification() {
        return fig_justification;
    }

    public int getFigUnits() {
        return fig_units;
    }

    public int getFigOrigin() {
        return fig_origin;
    }

    public int getFigResolution() {
        return fig_resolution;
    }

    public int getDefaultFigVersion() {
        return defaultFigVersion;
    }

    public boolean getEnableJava2D() {
        return enableJava2D;
    }

    public void setPageOrientation(String string) {
        pageOrientation = string;
    }

    public void setPageJustification(String string) {
        pageJustification = string;
    }

    public void setPageUnits(String string) {
        pageUnits = string;
    }

    public void setPaperSize(String string) {
        paperSize = string;
    }

    public void setExportMagnification(double d) {
        exportMagnification = d;
    }

    public void setSingleOrMultipleSheets(String string) {
        singleOrMultipleSheets = string;
    }

    public void setDefaultFigVersion(int n) {
        defaultFigVersion = n;
    }

    public void setFigVersion(int n) {
        this.figVersion = n;
    }

    public void setFigOrientation(int n) {
        fig_orientation = n;
    }

    public void setFigJustification(int n) {
        fig_justification = n;
    }

    public void setFigUnits(int n) {
        fig_units = n;
    }

    public void setFigResolution(int n) {
        fig_resolution = n;
    }

    public void setFigOrigin(int n) {
        fig_origin = n;
    }

    public void setTransparentColorIndex(int n) {
        transparentColorIndex = n;
    }

    public boolean getUpdateLineStyleMask() {
        return updateLineStyleMask;
    }

    public boolean getUpdateLineWidthMask() {
        return updateLineWidthMask;
    }

    public boolean getUpdateLineColorMask() {
        return updateLineColorMask;
    }

    public boolean getUpdateArrowModeMask() {
        return updateArrowModeMask;
    }

    public boolean getUpdateArrowStyleMask() {
        return updateArrowStyleMask;
    }

    public boolean getUpdateFillStyleMask() {
        return updateFillStyleMask;
    }

    public boolean getUpdateFillColorMask() {
        return updateFillColorMask;
    }

    public boolean getUpdateFontMask() {
        return updateFontMask;
    }

    public boolean getUpdateFontSizeMask() {
        return updateFontSizeMask;
    }

    public boolean getUpdateFontFlagMask() {
        return updateFontFlagMask;
    }

    public boolean getUpdateTextAlignMask() {
        return updateTextAlignMask;
    }

    public boolean getUpdateLayerMask() {
        return updateLayerMask;
    }

    public boolean getUpdateCornerRadiusMask() {
        return updateCornerRadiusMask;
    }

    public boolean getUpdateAngleMask() {
        return updateAngleMask;
    }

    public void setUpdateLineStyleMask(boolean bl) {
        updateLineStyleMask = bl;
    }

    public void setUpdateLineWidthMask(boolean bl) {
        updateLineWidthMask = bl;
    }

    public void setUpdateLineColorMask(boolean bl) {
        updateLineColorMask = bl;
    }

    public void setUpdateArrowModeMask(boolean bl) {
        updateArrowModeMask = bl;
    }

    public void setUpdateArrowStyleMask(boolean bl) {
        updateArrowStyleMask = bl;
    }

    public void setUpdateFillStyleMask(boolean bl) {
        updateFillStyleMask = bl;
    }

    public void setUpdateFillColorMask(boolean bl) {
        updateFillColorMask = bl;
    }

    public void setUpdateFontMask(boolean bl) {
        updateFontMask = bl;
    }

    public void setUpdateFontSizeMask(boolean bl) {
        updateFontSizeMask = bl;
    }

    public void setUpdateFontFlagMask(boolean bl) {
        updateFontFlagMask = bl;
    }

    public void setUpdateTextAlignMask(boolean bl) {
        updateTextAlignMask = bl;
    }

    public void setUpdateLayerMask(boolean bl) {
        updateLayerMask = bl;
    }

    public void setUpdateCornerRadiusMask(boolean bl) {
        updateCornerRadiusMask = bl;
    }

    public void setUpdateAngleMask(boolean bl) {
        updateAngleMask = bl;
    }

    public void setLineColor(Color color) {
        int n = ColorCache.getColorCache().registerUserColor(color);
        this.lineColor = color;
        this.fig_line_color = n;
    }

    public void setFillColor(Color color) {
        int n = ColorCache.getColorCache().registerUserColor(color);
        this.fillColor = color;
        this.fig_fill_color = n;
    }

    public String toString() {
        String string = "FigAttribs.toString():\n layer " + this.currentLayer + " align " + this.textAlign + "\n" + " line color " + this.lineColor.toString() + "\n" + " fill color " + this.fillColor.toString() + " fill style " + this.fillStyle + "\n" + " line style " + this.lineStyle + " width " + this.lineWidth + " dash " + this.dashLength + "\n" + " arrow mode " + this.arrowMode + "f: " + this.arrow_f_Style + ", " + this.arrow_f_Length + ", " + this.arrow_f_Width + ", b: " + this.arrow_b_Style + ", " + this.arrow_b_Length + ", " + this.arrow_b_Width + "\n" + " font " + this.fig_font + " size " + this.fontSize + "\n";
        return string;
    }

    public void restoreDefaults() {
        this.lineColor = Color.black;
        this.fig_line_color = 0;
        this.fillColor = Color.black;
        this.fillStyle = 1;
        this.fig_fill_color = -1;
        this.fig_area_fill = -1;
        this.dashLength = 192.0;
        this.fig_style_val = 4.0;
    }

    public void parse(String string) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n");
            while (stringTokenizer.hasMoreTokens()) {
                this.parseSingleToken(stringTokenizer.nextToken());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void parseSingleToken(String string) {
        int n = string.indexOf(61);
        if (n > 0) {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1, string.length());
            if ("color".equals(string2)) {
                this.setLineColor(string3);
            } else if ("linecolor".equals(string2)) {
                this.setLineColor(string3);
            } else if ("linestyle".equals(string2)) {
                this.setLineStyle(string3);
            } else if ("style".equals(string2)) {
                this.setLineStyle(string3);
            } else if ("linewidth".equals(string2)) {
                this.setLineWidth(string3);
            } else if ("width".equals(string2)) {
                this.setLineWidth(string3);
            } else if ("arrowmode".equals(string2)) {
                this.setArrowMode(string3);
            } else if ("arrowstyle".equals(string2)) {
                this.setArrowStyle(string3);
            } else if ("arrowsize".equals(string2)) {
                this.setArrowSize(string3);
            } else if ("fillcolor".equals(string2)) {
                this.setFillColor(string3);
            } else if ("fillstyle".equals(string2)) {
                this.setFillStyle(string3);
            } else if ("pattern".equals(string2)) {
                this.setFillStyle(string3);
            } else if ("depth".equals(string2)) {
                this.setLayer(string3);
            } else if ("layer".equals(string2)) {
                this.setLayer(string3);
            } else if ("font".equals(string2)) {
                this.setFont(string3);
            } else if ("fontname".equals(string2)) {
                this.setFont(string3);
            } else if ("fontsize".equals(string2)) {
                this.setFontSize(string3);
            } else if ("pt".equals(string2)) {
                this.setFontSize(string3);
            } else if ("align".equals(string2)) {
                this.setTextAlign(string3);
            } else if ("textalign".equals(string2)) {
                this.setTextAlign(string3);
            } else if ("angle".equals(string2)) {
                this.setRotationAngle(string3);
            } else if ("rotation".equals(string2)) {
                this.setRotationAngle(string3);
            } else {
                this.err("parseSingleToken: Unknown key: '" + string + "'");
            }
        } else {
            int n2 = 0;
            while (n2 < colorNames.length) {
                if (colorNames[n2].equals(string)) {
                    this.setLineColor(string);
                    return;
                }
                ++n2;
            }
            n2 = 0;
            while (n2 < lineStyles.length) {
                if (lineStyles[n2].equals(string)) {
                    this.setLineStyle(string);
                    return;
                }
                ++n2;
            }
            n2 = 0;
            while (n2 < arrowModes.length) {
                if (arrowModes[n2].equals(string)) {
                    this.setArrowMode(string);
                    return;
                }
                ++n2;
            }
            n2 = 0;
            while (n2 < patterns.length) {
                if (patterns[n2].equals(string)) {
                    this.setFillStyle(string);
                    return;
                }
                ++n2;
            }
            this.err("-E- Unsupported attribute token: '" + string + "'");
        }
    }

    public void setLineColor(String string) {
        this.fig_line_color = this.decodeColor(string);
        this.lineColor = ColorCache.getColorCache().get(this.fig_line_color);
    }

    public void setLineStyle(String string) {
        String string2 = string.trim().toLowerCase();
        if ("solid".equals(string2)) {
            this.lineStyle = 0;
        } else if ("dashed".equals(string2)) {
            this.lineStyle = 1;
        } else if ("dotted".equals(string2)) {
            this.lineStyle = 2;
        } else if ("dashdot".equals(string2)) {
            this.lineStyle = 3;
        } else if ("dashdot2".equals(string2)) {
            this.lineStyle = 4;
        } else if ("dashdot3".equals(string2)) {
            this.lineStyle = 5;
        } else if ("-".equals(string2)) {
            this.lineStyle = 0;
        } else if ("--".equals(string2)) {
            this.lineStyle = 1;
        } else if (".".equals(string2)) {
            this.lineStyle = 2;
        } else if ("-.".equals(string2)) {
            this.lineStyle = 3;
        } else if ("-..".equals(string2)) {
            this.lineStyle = 4;
        } else if ("-...".equals(string2)) {
            this.lineStyle = 5;
        } else {
            this.err("setLineStyle: Unknown line style '" + string + "'");
        }
    }

    public void setLineWidth(String string) {
        try {
            int n = Integer.parseInt(string);
            this.lineWidth = n <= 0 ? 0.0 : (double)(n * 30);
        }
        catch (NumberFormatException numberFormatException) {
            this.err("setLineWidth: Illegal number format '" + string + "'");
        }
    }

    public void setArrowMode(String string) {
        String string2 = string.trim().toLowerCase();
        if ("none".equals(string2)) {
            this.arrowMode = 0;
        } else if ("forward".equals(string2)) {
            this.arrowMode = 1;
        } else if ("backward".equals(string2)) {
            this.arrowMode = 2;
        } else if ("both".equals(string2)) {
            this.arrowMode = 3;
        } else if ("-".equals(string2)) {
            this.arrowMode = 0;
        } else if ("->".equals(string2)) {
            this.arrowMode = 1;
        } else if ("<-".equals(string2)) {
            this.arrowMode = 2;
        } else if ("<->".equals(string2)) {
            this.arrowMode = 3;
        } else {
            this.err("setArrowMode: Unknown mode '" + string + "'");
        }
    }

    public void setArrowStyle(String string) {
        String string2 = string.trim().toLowerCase();
        int n = 0;
        if ("0".equals(string2)) {
            n = 2;
        } else if ("1".equals(string2)) {
            n = 4;
        } else if ("2".equals(string2)) {
            n = 5;
        } else if ("3".equals(string2)) {
            n = 6;
        } else if ("4".equals(string2)) {
            n = 7;
        } else if ("5".equals(string2)) {
            n = 8;
        } else if ("6".equals(string2)) {
            n = 9;
        } else if ("7".equals(string2)) {
            n = 11;
        } else {
            this.err("setArrowStyle: unknown value '" + string + "'");
        }
        this.arrow_f_Style = n;
        this.arrow_b_Style = n;
    }

    public void setArrowSize(String string) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            double d = Double.valueOf(stringTokenizer.nextToken());
            double d2 = Double.valueOf(stringTokenizer.nextToken());
            double d3 = Double.valueOf(stringTokenizer.nextToken());
            this.arrow_f_Width = 96.0 * d;
            this.arrow_f_Length = 96.0 * d2;
            this.arrow_f_Thickness = 30.0 * d3;
            this.arrow_b_Width = 96.0 * d;
            this.arrow_b_Length = 96.0 * d2;
            this.arrow_b_Thickness = 30.0 * d3;
        }
        catch (Exception exception) {
            this.err("setArrowSize: invalid input '" + string + "'");
        }
    }

    public void setFillColor(String string) {
        this.fig_fill_color = this.decodeColor(string);
        this.fillColor = ColorCache.getColorCache().get(this.fig_fill_color);
    }

    public void setFillStyle(String string) {
        try {
            String string2 = string.trim().toLowerCase();
            if ("none".equals(string2)) {
                this.fillStyle = 1;
                this.fig_area_fill = 0;
            } else if ("pure".equals(string2)) {
                this.fillStyle = 2;
                this.fig_area_fill = 20;
            } else if (string2.indexOf(37) > 0) {
                int n = Integer.parseInt(string2 = string2.substring(0, string2.indexOf(37)));
                int n2 = n / 5;
                if (n2 < 0) {
                    n2 = 0;
                }
                if (n2 > 40) {
                    n2 = 40;
                }
                this.fillStyle = 2;
                this.fig_area_fill = n2;
            } else {
                int n = Integer.parseInt(string2);
                if (n < 0) {
                    this.fillStyle = 2;
                    this.fig_area_fill = 0;
                } else if (n <= 40) {
                    this.fillStyle = 2;
                    this.fig_area_fill = n;
                } else if (n <= 56) {
                    this.fillStyle = 3;
                    this.fig_area_fill = n;
                } else {
                    this.err("setFillStyle: value out of range '" + string + "'");
                }
            }
        }
        catch (Exception exception) {
            this.err("setFillStyle: internal error, input is '" + string + "'");
            this.fillStyle = 1;
            this.fig_area_fill = 0;
        }
    }

    public void setFont(String string) {
        String string2 = string.trim().toLowerCase();
        try {
            this.fig_font = string2.length() <= 2 ? Integer.parseInt(string2) : FontCache.getFontCache().getFontIndex(string2);
        }
        catch (Exception exception) {
            this.err("setFont: parsing error '" + string + "'");
        }
    }

    public void setFontSize(String string) {
        try {
            this.fontSize = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.err("setFontSize: Invalid number format: '" + string + "'");
        }
    }

    public void setTextAlign(String string) {
        String string2 = string.trim().toLowerCase();
        if ("left".equals(string2)) {
            this.textAlign = 1;
        } else if ("center".equals(string2)) {
            this.textAlign = 2;
        } else if ("right".equals(string2)) {
            this.textAlign = 3;
        } else {
            this.err("setTextAlign: unknown value: '" + string + "'");
        }
    }

    public void setLayer(String string) {
        try {
            this.currentLayer = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.err("setLayer: Invalid number format: '" + string + "'");
        }
    }

    public void setDepth(String string) {
        this.setLayer(string);
    }

    public void setRotationAngle(String string) {
        try {
            double d = Double.valueOf(string.trim());
            this.fig_ellipse_angle = this.fig_angle = (d = d * Math.PI / 180.0);
        }
        catch (Exception exception) {
            this.err("setRotationAngle: Invalid input: '" + string + "'");
        }
    }

    private int decodeColor(String string) {
        String string2 = string.trim().toLowerCase();
        if (string2.startsWith("0x")) {
            int n = Integer.parseInt(string2.substring(2), 16);
            Color color = new Color(n);
            return ColorCache.getColorCache().registerUserColor(color);
        }
        if (string2.startsWith("(")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "() ,");
            int n = Integer.parseInt(stringTokenizer.nextToken());
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            int n3 = Integer.parseInt(stringTokenizer.nextToken());
            Color color = new Color(n, n2, n3);
            return ColorCache.getColorCache().registerUserColor(color);
        }
        int n = 0;
        int n4 = colorNames.length;
        while (n < n4) {
            if (colorNames[n].equals(string2)) {
                return n;
            }
            ++n;
        }
        this.err("decodeColor: unknown color '" + string + "'");
        return 0;
    }

    private void err(String string) {
        System.err.println("-E- FigAttribs:" + string);
    }

    public void NOT_YET() {
        Thread.dumpStack();
    }

    public FigAttribs() {
        this.figVersion = defaultFigVersion;
        this.lineColor = Color.black;
        this.fillColor = Color.black;
        fig_justification = 0;
        fig_units = 1;
        fig_resolution = 1200;
        fig_origin = 2;
        this.fig_line_color = -1;
        this.fig_fill_color = -1;
        this.fig_area_fill = 20;
        this.fig_pen_style = 1;
        this.fig_join_style = 0;
        this.fig_cap_style = 0;
        this.fig_style_val = 4.0;
        this.fig_angle = 0.0;
        this.fig_ellipse_angle = 0.0;
        this.fig_ellipse_direction = 1;
        this.fig_font = 0;
        this.fig_font_flags = 4;
        this.fig_text_height = 0.0;
    }

    static {
        try {
            Class.forName("java.awt.geom.AffineTransform");
            Class.forName("java.awt.Graphics2D");
            String string = System.getProperty("java.vendor").toLowerCase();
            if (string.indexOf("kaffe") >= 0) {
                enableJava2D = false;
                System.out.println("-I- Java2D disabled due to Kaffe VM bugs.");
            } else if (SetupManager.getBoolean("jfig.allowJava2D", true)) {
                enableJava2D = true;
                System.out.println("-I- Java2D found, using it...");
            } else {
                enableJava2D = false;
                System.out.println("-I- Java2D available but disabled, using AWT...");
            }
        }
        catch (Throwable throwable) {
            enableJava2D = false;
            System.out.println("-I- Java2D not found, using AWT...");
        }
    }
}

