/*
 * Decompiled with CFR 0.152.
 */
package jfig.objects;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import jfig.canvas.FigTrafo2D;
import jfig.objects.FigAttribs;
import jfig.objects.FigObject;
import jfig.objects.FillWrapper;
import jfig.objects.LineWrapper;

public class FigArrow {
    Point a1;
    Point a2;
    Point a3;
    Point a4;
    Point sp;
    int radius;
    boolean front;
    double length;
    double width;
    int type;
    FigObject parent;
    LineWrapper wline;
    FillWrapper wfill;

    public static FigArrow create(FigObject figObject, Point point, Point point2, boolean bl) {
        return new FigArrow(figObject, point, point2, bl);
    }

    public void paint(Graphics graphics) {
        FigAttribs figAttribs = this.parent.getAttributes();
        if (this.type == 11) {
            this.sp = this.parent.getTrafo().wc_to_screen(this.a1, this.sp);
            this.radius = this.parent.getTrafo().wc_to_screen((int)this.width);
            graphics.setColor(figAttribs.lineColor);
            graphics.fillOval(this.sp.x - this.radius, this.sp.y - this.radius, 2 * this.radius, 2 * this.radius);
            return;
        }
        graphics.setColor(figAttribs.lineColor);
        if (this.wfill != null) {
            this.wfill.paint(graphics);
        }
        if (this.wline != null) {
            this.wline.paint(graphics);
        }
    }

    public String toString() {
        String string = "arrow (mode " + this.parent.getAttributes().arrowMode + ", style " + this.type + ") " + "Points at " + this.a1.toString() + ", " + this.a2.toString() + ", " + this.a3.toString() + ", " + this.a4.toString();
        return string;
    }

    public void print() {
        System.out.println(this.toString());
    }

    public FigArrow() {
    }

    public FigArrow(FigObject figObject, Point point, Point point2, boolean bl) {
        this.sp = new Point(0, 0);
        this.parent = figObject;
        this.front = bl;
        FigAttribs figAttribs = figObject.getAttributes();
        this.type = bl ? figAttribs.arrow_f_Style : figAttribs.arrow_b_Style;
        double d = point2.x - point.x;
        double d2 = point2.y - point.y;
        double d3 = Math.sqrt(d * d + d2 * d2);
        if (d3 == 0.0) {
            d3 = 1.0;
        }
        double d4 = d / d3;
        double d5 = d2 / d3;
        double d6 = -d2 / d3;
        double d7 = d / d3;
        if (bl) {
            this.length = figAttribs.arrow_f_Length;
            this.width = figAttribs.arrow_f_Width;
        } else {
            this.length = figAttribs.arrow_b_Length;
            this.width = figAttribs.arrow_b_Width;
        }
        this.a1 = new Point(point2.x, point2.y);
        this.a3 = new Point((int)((double)point2.x - this.length * d4 + 0.5), (int)((double)point2.y - this.length * d5 + 0.5));
        this.a2 = new Point((int)((double)point2.x - this.length * d4 + 0.5 * this.width * d6 + 0.5), (int)((double)point2.y - this.length * d5 + 0.5 * this.width * d7 + 0.5));
        this.a4 = new Point((int)((double)point2.x - this.length * d4 - 0.5 * this.width * d6 + 0.5), (int)((double)point2.y - this.length * d5 - 0.5 * this.width * d7 + 0.5));
        if (this.type == 8 || this.type == 9) {
            this.a3 = new Point((int)((double)point2.x - 1.2 * this.length * d4 + 0.5), (int)((double)point2.y - 1.2 * this.length * d5 + 0.5));
        }
        if (this.type == 6 || this.type == 7) {
            this.a3 = new Point((int)((double)point2.x - 0.8 * this.length * d4 + 0.5), (int)((double)point2.y - 0.8 * this.length * d5 + 0.5));
        }
        FigTrafo2D figTrafo2D = figObject.getTrafo();
        switch (this.type) {
            case 2: {
                Point[] pointArray = new Point[]{this.a2, this.a1, this.a4};
                this.wline = new LineWrapper(figObject, figTrafo2D, pointArray, false);
                this.wfill = null;
                break;
            }
            case 4: {
                Point[] pointArray = new Point[]{this.a1, this.a2, this.a4, this.a1};
                this.wline = new LineWrapper(figObject, figTrafo2D, pointArray, false);
                this.wfill = new FillWrapper(figObject, figTrafo2D, pointArray, Color.white);
                break;
            }
            case 5: {
                Point[] pointArray = new Point[]{this.a1, this.a2, this.a4, this.a1};
                this.wline = new LineWrapper(figObject, figTrafo2D, pointArray, false);
                this.wfill = new FillWrapper(figObject, figTrafo2D, pointArray, figObject.getAttributes().lineColor);
                break;
            }
            case 6: {
                Point[] pointArray = new Point[]{this.a1, this.a2, this.a3, this.a4, this.a1};
                this.wline = new LineWrapper(figObject, figTrafo2D, pointArray, false);
                this.wfill = new FillWrapper(figObject, figTrafo2D, pointArray, Color.white);
                break;
            }
            case 7: {
                Point[] pointArray = new Point[]{this.a1, this.a2, this.a3, this.a4, this.a1};
                this.wline = new LineWrapper(figObject, figTrafo2D, pointArray, false);
                this.wfill = new FillWrapper(figObject, figTrafo2D, pointArray, figObject.getAttributes().lineColor);
                break;
            }
            case 8: {
                Point[] pointArray = new Point[]{this.a1, this.a2, this.a3, this.a4, this.a1};
                this.wline = new LineWrapper(figObject, figTrafo2D, pointArray, false);
                this.wfill = new FillWrapper(figObject, figTrafo2D, pointArray, Color.white);
                break;
            }
            case 9: {
                Point[] pointArray = new Point[]{this.a1, this.a2, this.a3, this.a4, this.a1};
                this.wline = new LineWrapper(figObject, figTrafo2D, pointArray, false);
                this.wfill = new FillWrapper(figObject, figTrafo2D, pointArray, figObject.getAttributes().lineColor);
                break;
            }
            case 11: {
                break;
            }
            default: {
                System.out.println("unknown Arrow type" + this.type);
                break;
            }
        }
    }
}

