/*
 * Decompiled with CFR 0.152.
 */
package jfig.objects;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import jfig.canvas.FigTrafo2D;
import jfig.objects.FigAttribs;
import jfig.objects.FigEllipse;
import jfig.objects.FigRenderer;
import jfig.objects.FillWrapper;
import jfig.objects.LineWrapper;

public class AWTEllipseRenderer
implements FigRenderer {
    FigEllipse ellipse;
    Point[] wcp_ellipse;
    Point[] wcp;
    LineWrapper wellipse;
    FillWrapper wfill;
    long timestamp;

    public void rebuild() {
        FigAttribs figAttribs = this.ellipse.getAttributes();
        FigTrafo2D figTrafo2D = this.ellipse.getTrafo();
        Point point = this.ellipse.getCenterPoint();
        Point point2 = this.ellipse.getRadiusPoint();
        double d = figAttribs.fig_ellipse_angle;
        this.wcp_ellipse = new Point[100];
        double d2 = Math.PI * 2 / (double)this.wcp_ellipse.length;
        double d3 = Math.cos(-d);
        double d4 = Math.sin(-d);
        int n = 0;
        int n2 = this.wcp_ellipse.length;
        while (n < n2) {
            double d5 = (double)n * d2;
            double d6 = (double)point2.x * Math.cos(d5);
            double d7 = (double)point2.y * Math.sin(d5);
            if (d != 0.0) {
                double d8 = d6 * d3 - d7 * d4;
                double d9 = d6 * d4 + d7 * d3;
                d6 = d8;
                d7 = d9;
            }
            int n3 = (int)(d6 + 0.5) + point.x;
            int n4 = (int)(d7 + 0.5) + point.y;
            this.wcp_ellipse[n] = new Point(n3, n4);
            ++n;
        }
        this.wellipse = new LineWrapper(this.ellipse, figTrafo2D, this.wcp_ellipse, true);
        this.wfill = figAttribs.fillStyle != 1 ? new FillWrapper(this.ellipse, figTrafo2D, this.wcp_ellipse) : null;
        this.timestamp = System.currentTimeMillis();
    }

    public void paint(Graphics graphics) {
        this.paint(graphics, this.ellipse.getTrafo());
    }

    public void paint(Graphics graphics, FigTrafo2D figTrafo2D) {
        int n;
        int n2;
        int n3;
        if (!this.ellipse.isVisible()) {
            return;
        }
        if (this.timestamp < figTrafo2D.getTimestamp()) {
            this.rebuild();
        }
        if (this.wfill != null) {
            this.wfill.paint(graphics);
        }
        if (this.wellipse != null) {
            this.wellipse.paint(graphics);
        }
        Point[] pointArray = this.ellipse.getPoints();
        if (this.ellipse.isShowPoints()) {
            n3 = 0;
            while (n3 < pointArray.length) {
                n2 = figTrafo2D.wc_to_screen_x(pointArray[n3].x);
                n = figTrafo2D.wc_to_screen_y(pointArray[n3].y);
                graphics.setColor(Color.black);
                graphics.drawRect(n2 - 2, n - 2, 4, 4);
                graphics.setColor(Color.white);
                graphics.fillRect(n2 - 1, n - 1, 3, 3);
                ++n3;
            }
        }
        if (this.ellipse.isSelected()) {
            n3 = 0;
            while (n3 < pointArray.length) {
                n2 = figTrafo2D.wc_to_screen_x(pointArray[n3].x);
                n = figTrafo2D.wc_to_screen_y(pointArray[n3].y);
                graphics.setColor(Color.black);
                graphics.fillRect(n2 - 2, n - 2, 5, 5);
                graphics.setColor(Color.white);
                graphics.drawRect(n2 - 3, n - 3, 6, 6);
                ++n3;
            }
        }
    }

    public AWTEllipseRenderer(FigEllipse figEllipse) {
        this.ellipse = figEllipse;
    }
}

