/*
 * Decompiled with CFR 0.152.
 */
package jfig.java2d;

import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import jfig.canvas.FigTrafo2D;
import jfig.java2d.FigTools2D;
import jfig.objects.FigAttribs;
import jfig.objects.FigEllipse;
import jfig.objects.FigRenderer;
import jfig.objects.FillPatterns;

public class FigEllipseRenderer
implements FigRenderer {
    FigEllipse ellipse;
    Shape ellipse2D;
    BasicStroke stroke;
    AffineTransform cachedAffineTransform;

    public void rebuild() {
        this.stroke = FigTools2D.createStroke(this.ellipse.getAttributes());
        Point point = this.ellipse.getCenterPoint();
        Point point2 = this.ellipse.getRadiusPoint();
        this.ellipse2D = new Ellipse2D.Double(point.x - point2.x, point.y - point2.y, 2.0 * (double)point2.x, 2.0 * (double)point2.y);
    }

    public AffineTransform createCompoundTransform(AffineTransform affineTransform, FigTrafo2D figTrafo2D) {
        double d = -this.ellipse.getAttributes().fig_ellipse_angle;
        double d2 = figTrafo2D.getZoomFactor() / 32.0;
        double d3 = this.ellipse.getCenterPoint().x;
        double d4 = this.ellipse.getCenterPoint().y;
        AffineTransform affineTransform2 = new AffineTransform();
        affineTransform2.scale(d2, d2);
        affineTransform2.translate(-figTrafo2D.getAnchor().x, -figTrafo2D.getAnchor().y);
        affineTransform2.rotate(d, d3, d4);
        affineTransform2.preConcatenate(affineTransform);
        return affineTransform2;
    }

    public void paint(Graphics graphics) {
        this.paint(graphics, this.ellipse.getTrafo());
    }

    public void paint(Graphics graphics, FigTrafo2D figTrafo2D) {
        if (!this.ellipse.isVisible()) {
            return;
        }
        try {
            Point[] pointArray;
            Point[] pointArray2;
            boolean bl = false;
            Graphics2D graphics2D = (Graphics2D)graphics;
            FigAttribs figAttribs = this.ellipse.getAttributes();
            AffineTransform affineTransform = graphics2D.getTransform();
            Stroke stroke = graphics2D.getStroke();
            if (this.cachedAffineTransform != affineTransform) {
                this.cachedAffineTransform = this.createCompoundTransform(affineTransform, figTrafo2D);
                graphics2D.setTransform(this.cachedAffineTransform);
                bl = true;
            }
            graphics2D.setTransform(this.cachedAffineTransform);
            if (figAttribs.fig_area_fill >= 40) {
                graphics2D.setPaint(FillPatterns.getTexturePaint(figAttribs.fig_area_fill - 40 + 20, 32, figAttribs.lineColor, figAttribs.fillColor));
                graphics2D.fill(this.ellipse2D);
            } else if (figAttribs.fillStyle == 2) {
                graphics2D.setColor(figAttribs.fillColor);
                graphics2D.fill(this.ellipse2D);
            }
            graphics2D.setColor(figAttribs.lineColor);
            graphics2D.setStroke(this.stroke);
            if ((double)this.stroke.getLineWidth() > 0.0) {
                graphics2D.draw(this.ellipse2D);
            }
            graphics2D.setTransform(affineTransform);
            graphics2D.setStroke(stroke);
            if (this.ellipse.isSelected()) {
                pointArray = pointArray2 = this.ellipse.getPoints();
                FigTools2D.showSelected(graphics, figTrafo2D, pointArray);
            }
            if (this.ellipse.isShowPoints()) {
                pointArray = pointArray2 = this.ellipse.getPoints();
                FigTools2D.showPoints(graphics, figTrafo2D, pointArray);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public Point[] getRotatedPoints(Point[] pointArray, double d) {
        Point point = this.ellipse.getCenterPoint();
        Point[] pointArray2 = new Point[pointArray.length];
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        int n = 0;
        while (n < pointArray.length) {
            double d4 = pointArray[n].x - point.x;
            double d5 = pointArray[n].y - point.y;
            double d6 = d4 * d2 - d5 * d3;
            double d7 = d4 * d3 + d5 * d2;
            pointArray2[n] = new Point((int)(d6 += (double)point.x), (int)(d7 += (double)point.y));
            ++n;
        }
        return pointArray2;
    }

    public FigEllipseRenderer(FigEllipse figEllipse) {
        this.ellipse = figEllipse;
    }
}

