/*
 * Decompiled with CFR 0.152.
 */
package jfig.gui;

import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.PrintJob;
import java.awt.Toolkit;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.Properties;
import jfig.canvas.FigCanvas;
import jfig.canvas.FigDrawable;
import jfig.canvas.FigDrawableEnumerator;
import jfig.canvas.FigTrafo2D;
import jfig.objects.FigAttribs;
import jfig.objects.FigBbox;
import jfig.utils.BoundingBoxCalculator;
import jfig.utils.SetupManager;

public class PrintManager {
    Frame frame = null;
    FigCanvas objectCanvas = null;
    String bannerString = null;
    Object exportOptionsDialog = null;
    boolean debug = false;

    public void setBannerString(String string) {
        this.bannerString = string;
    }

    public void doPrint() {
        block4: {
            Properties properties;
            block3: {
                if (this.bannerString == null) {
                    this.bannerString = "jfig printjob";
                }
                if (!FigAttribs.enableJava2D) break block3;
                this.dbg("-#- PrintManager: experimental: using Java2D...");
                PrintManager printManager = this;
                if (printManager == null) {
                    throw null;
                }
                Manager2D manager2D = printManager.new Manager2D();
                manager2D.doPrint();
                break block4;
            }
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            PrintJob printJob = toolkit.getPrintJob(this.frame, this.bannerString, properties = SetupManager.getProperties());
            if (printJob == null) break block4;
            Graphics graphics = printJob.getGraphics();
            if (graphics != null) {
                this.objectCanvas.drawAllObjects(graphics);
                graphics.dispose();
            }
            printJob.end();
        }
    }

    public void message(String string) {
        System.out.println(string);
    }

    public void dbg(String string) {
        this.debug = SetupManager.getBoolean("jfig.gui.PrintManager.debug", false);
        if (this.debug) {
            System.out.println(string);
        }
    }

    public PrintManager(Frame frame, FigCanvas figCanvas) {
        this.frame = frame;
        this.objectCanvas = figCanvas;
    }

    class Manager2D
    implements Printable {
        public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
            Object object;
            PrintManager.this.dbg("");
            PrintManager.this.dbg("-#- PM.M2D.print: page #" + n + " ");
            Graphics2D graphics2D = (Graphics2D)graphics;
            if (n >= 1) {
                return 1;
            }
            PrintManager.this.dbg("-1- selected pageformat: " + this.dumpPageFormat(pageFormat));
            double d = pageFormat.getImageableX();
            double d2 = pageFormat.getImageableY();
            double d3 = pageFormat.getImageableWidth();
            double d4 = pageFormat.getImageableHeight();
            FigBbox figBbox = BoundingBoxCalculator.getBoundingBox(PrintManager.this.objectCanvas.getObjectEnumerator().getDrawableObjects());
            FigBbox figBbox2 = BoundingBoxCalculator.getBoundingBox(PrintManager.this.objectCanvas.getObjectEnumerator().getDrawableObjects());
            double d5 = figBbox.getXr() - figBbox.getXl();
            double d6 = figBbox.getYb() - figBbox.getYt();
            PrintManager.this.dbg("-2- bbox: " + figBbox + " " + d5 + " " + d6);
            double d7 = 32.0 * d3 / d5;
            double d8 = 32.0 * d4 / d6;
            double d9 = Math.min(1.0, Math.min(d7, d8));
            try {
                String string = SetupManager.getProperty("jfig.gui.PrintManager.magnification");
                if (string != null) {
                    d9 = Double.valueOf(string.trim()) / 100.0;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            PrintManager.this.dbg("-3- zoom: zx,zy,zmin: " + d7 + " " + d8 + " " + d9);
            double d10 = 0.5 * (double)(figBbox.getXl() + figBbox.getXr());
            double d11 = 0.5 * (double)(figBbox.getYt() + figBbox.getYb());
            double d12 = d + 0.5 * d3;
            double d13 = d2 + 0.5 * d4;
            PrintManager.this.dbg("-3b wcenter (" + d10 + "," + d11 + ")");
            PrintManager.this.dbg("-3c pcenter (" + d12 + "," + d13 + ")");
            FigTrafo2D figTrafo2D = PrintManager.this.objectCanvas.getTrafo();
            FigTrafo2D figTrafo2D2 = new FigTrafo2D();
            if (PrintManager.this.exportOptionsDialog == null) {
                if (FigAttribs.fig_justification == 1) {
                    PrintManager.this.dbg("-I- PM.M2D: using FigAttribs, flush left, zoom= " + d9);
                    figTrafo2D2.setAnchor(new Point(0, 0));
                    figTrafo2D2.set_zoom(d9);
                } else {
                    PrintManager.this.dbg("-I- PM.M2D: using FigAttribs, centered, zoom= " + d9);
                    object = new Point(0, 0);
                    ((Point)object).x = (int)(d10 - 32.0 / d9 * d12);
                    ((Point)object).y = (int)(d11 - 32.0 / d9 * d13);
                    PrintManager.this.dbg("-I- PM.M2D: anchor: " + object);
                    figTrafo2D2.setAnchor((Point)object);
                    figTrafo2D2.set_zoom(d9);
                }
            }
            PrintManager.this.objectCanvas.setTrafo(figTrafo2D2);
            FigDrawableEnumerator figDrawableEnumerator = PrintManager.this.objectCanvas.getObjectEnumerator();
            object = figDrawableEnumerator.getDrawableObjects();
            while (object.hasMoreElements()) {
                FigDrawable figDrawable = (FigDrawable)object.nextElement();
                figDrawable.setTrafo(figTrafo2D2);
                figDrawable.paint(graphics2D);
                figDrawable.setTrafo(figTrafo2D);
            }
            FigBbox figBbox3 = BoundingBoxCalculator.getBoundingBox(PrintManager.this.objectCanvas.getObjectEnumerator().getDrawableObjects());
            PrintManager.this.dbg("-5- " + PrintManager.this.objectCanvas.getTrafo().getAnchor() + " " + PrintManager.this.objectCanvas.getTrafo().getZoomFactor());
            PrintManager.this.dbg("-6- bboxes: " + figBbox + " " + figBbox2 + " " + figBbox3);
            PrintManager.this.objectCanvas.setTrafo(figTrafo2D);
            PrintManager.this.objectCanvas.doFullRedraw();
            return 0;
        }

        public void doPrint() {
            PrintManager.this.dbg("-1- doPrint: started...");
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            PageFormat pageFormat = printerJob.defaultPage();
            pageFormat.setOrientation(1);
            if (FigAttribs.fig_orientation == 0) {
                System.out.println("-I- PrintManager: landscape page orientation <<<<");
                pageFormat.setOrientation(0);
            } else {
                System.out.println("-I- PrintManager: portrait page orientation <<<<");
                pageFormat.setOrientation(1);
            }
            PrintManager.this.dbg("-2- doPrint: calling printDialog...");
            printerJob.setPrintable(this, pageFormat);
            if (printerJob.printDialog()) {
                PrintManager.this.dbg("-3- doPrint: page format is: " + pageFormat);
                try {
                    this.checkChangeBorderWidth(pageFormat);
                    PrintManager.this.dbg("XXX : pageformat is: " + pageFormat);
                    printerJob.setPrintable(this, pageFormat);
                    this.checkChangeBorderWidth(pageFormat);
                    PrintManager.this.dbg("XXX : pageformat is: " + pageFormat);
                    printerJob.print();
                }
                catch (Throwable throwable) {
                    PrintManager.this.message("-E- internal in PrintManager.Manager2D: " + throwable);
                    throwable.printStackTrace();
                }
            }
        }

        public void checkChangeBorderWidth(PageFormat pageFormat) {
            String string = SetupManager.getProperty("jfig.gui.PrintManager.border");
            if (string != null) {
                double d = Double.valueOf(string.trim());
                PrintManager.this.dbg("-#- PM.cCBW: user defined border width= " + d);
                double d2 = pageFormat.getWidth();
                double d3 = pageFormat.getHeight();
                double d4 = d;
                double d5 = d;
                double d6 = d2 - 2.0 * d;
                double d7 = d3 - 2.0 * d;
                Paper paper = new Paper();
                paper.setSize(d2, d3);
                paper.setImageableArea(d4, d5, d6, d7);
                pageFormat.setPaper(paper);
                PrintManager.this.dbg("-#- PM.cCBW: new page format " + this.dumpPageFormat(pageFormat));
            }
        }

        public String dumpPageFormat(PageFormat pageFormat) {
            String string = pageFormat.getOrientation() == 1 ? "Portrait" : "Landscape";
            double d = pageFormat.getImageableX();
            double d2 = pageFormat.getImageableY();
            double d3 = pageFormat.getImageableWidth();
            double d4 = pageFormat.getImageableHeight();
            return string + " " + d + " " + d2 + " " + d3 + " " + d4;
        }

        Manager2D() {
        }
    }
}

