/*
 * Decompiled with CFR 0.152.
 */
package jfig.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import jfig.commands.FigBasicEditor;
import jfig.gui.JModularEditor;
import jfig.gui.JNumericStateButton;
import jfig.objects.FigObject;
import jfig.utils.RegistrationKeyManager;
import jfig.utils.ShellSort;

public class JLayerManager
implements ActionListener {
    FigBasicEditor editor = null;
    JNumericStateButton editorLayerButton = null;
    Hashtable layerTable = new Hashtable();
    Hashtable boxTable = new Hashtable();
    Font defaultFont = new Font("Dialog", 0, 9);
    JPanel managerPanel = null;
    JComponent layersPanel = null;
    JScrollPane scroller = null;
    JButton reloadButton;
    JButton allButton;
    JButton noneButton;
    JButton invertButton;
    private boolean registered = RegistrationKeyManager.getRegistrationKeyManager().isValid();
    String s_unregistered = "Layer manager disabled. See help->registration...";

    public void setEditor(FigBasicEditor figBasicEditor) {
        this.editor = figBasicEditor;
        this.doReloadLayers();
    }

    public void setEditorLayerButton(JNumericStateButton jNumericStateButton) {
        this.editorLayerButton = jNumericStateButton;
    }

    public JComponent getPanel() {
        if (this.managerPanel == null) {
            this.createPanel();
        }
        return this.managerPanel;
    }

    private void createPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 1, 0, 0));
        JButton jButton = new JButton("layers:");
        jButton.setFont(this.defaultFont);
        jButton.setEnabled(false);
        jButton.setToolTipText(this.registered ? "manage layers (depths)" : this.s_unregistered);
        this.reloadButton = new JButton("reload");
        this.reloadButton.setFont(this.defaultFont);
        this.reloadButton.addActionListener(this);
        this.reloadButton.setToolTipText("reload layers from current drawing");
        this.allButton = new JButton("show all");
        this.allButton.setFont(this.defaultFont);
        this.allButton.addActionListener(this);
        this.allButton.setEnabled(this.registered);
        this.allButton.setToolTipText(this.registered ? "show all layers" : this.s_unregistered);
        this.noneButton = new JButton("hide all");
        this.noneButton.setFont(this.defaultFont);
        this.noneButton.addActionListener(this);
        this.noneButton.setEnabled(this.registered);
        this.noneButton.setToolTipText(this.registered ? "hide all layers" : this.s_unregistered);
        this.invertButton = new JButton("toggle");
        this.invertButton.setFont(this.defaultFont);
        this.invertButton.addActionListener(this);
        this.invertButton.setEnabled(this.registered);
        this.invertButton.setToolTipText(this.registered ? "toggle show/hide for all layers" : this.s_unregistered);
        jPanel.add(jButton);
        jPanel.add(this.reloadButton);
        jPanel.add(this.allButton);
        jPanel.add(this.noneButton);
        jPanel.add(this.invertButton);
        this.layersPanel = new JPanel();
        this.layersPanel.setLayout(new BoxLayout(this.layersPanel, 1));
        this.removeLayerBoxes();
        this.buildLayerBoxPanel();
        this.scroller = new JScrollPane(this.layersPanel);
        this.scroller.setVerticalScrollBarPolicy(20);
        this.scroller.setHorizontalScrollBarPolicy(31);
        this.managerPanel = new JPanel();
        this.managerPanel.setLayout(new BorderLayout());
        this.managerPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.managerPanel.add((Component)jPanel, "North");
        this.managerPanel.add((Component)this.scroller, "Center");
        if (!this.registered) {
            jButton.setToolTipText(this.s_unregistered);
            this.managerPanel.setToolTipText(this.s_unregistered);
        }
    }

    public void addLayer(int n) {
        this.layerTable.put(new Integer(n), "true");
        JLayerManager jLayerManager = this;
        if (jLayerManager == null) {
            throw null;
        }
        this.boxTable.put(new Integer(n), jLayerManager.new OneLayerPanel(n, true));
    }

    public void removeLayerBoxes() {
        if (this.layersPanel == null) {
            return;
        }
        Component[] componentArray = this.layersPanel.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            this.layersPanel.remove(componentArray[n]);
            ++n;
        }
        this.layersPanel.invalidate();
    }

    public void buildLayerBoxPanel() {
        Integer n;
        int n2 = this.layerTable.size();
        int[] nArray = new int[n2];
        Enumeration enumeration = this.layerTable.keys();
        int n3 = 0;
        while (n3 < n2) {
            n = (Integer)enumeration.nextElement();
            nArray[n3] = n;
            ++n3;
        }
        ShellSort.shellSort(nArray);
        n3 = 0;
        while (n3 < n2) {
            n = new Integer(nArray[n3]);
            OneLayerPanel oneLayerPanel = (OneLayerPanel)this.boxTable.get(n);
            this.layersPanel.add(oneLayerPanel);
            ++n3;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.allButton) {
            this.doShowAllLayers();
        } else if (object == this.noneButton) {
            this.doShowNoneLayers();
        } else if (object == this.invertButton) {
            this.doShowInvertLayers();
        } else if (object == this.reloadButton) {
            this.doReloadLayers();
        } else {
            JLayerManager.msg("-E- unknown event source: " + actionEvent);
        }
    }

    public void doShowAllLayers() {
        Enumeration enumeration = this.layerTable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            this.layerTable.put(k, "true");
            OneLayerPanel oneLayerPanel = (OneLayerPanel)this.boxTable.get(k);
            oneLayerPanel.setSelected(true);
        }
        this.updateObjectList();
    }

    public void doShowNoneLayers() {
        Enumeration enumeration = this.layerTable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            this.layerTable.put(k, "false");
            OneLayerPanel oneLayerPanel = (OneLayerPanel)this.boxTable.get(k);
            oneLayerPanel.setSelected(false);
        }
        this.updateObjectList();
    }

    public void doShowInvertLayers() {
        Enumeration enumeration = this.layerTable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object v = this.layerTable.get(k);
            boolean bl = !"true".equals(v);
            this.layerTable.put(k, bl ? "true" : "false");
            OneLayerPanel oneLayerPanel = (OneLayerPanel)this.boxTable.get(k);
            oneLayerPanel.setSelected(bl);
        }
        this.updateObjectList();
    }

    public void doReloadLayers() {
        if (this.editor == null) {
            return;
        }
        this.layerTable = new Hashtable();
        this.boxTable = new Hashtable();
        Enumeration enumeration = this.editor.getObjects();
        while (enumeration.hasMoreElements()) {
            FigObject figObject = (FigObject)enumeration.nextElement();
            Integer n = new Integer(figObject.getLayer());
            if (this.layerTable.get(n) != null) continue;
            this.addLayer(n);
        }
        if (this.managerPanel == null) {
            this.createPanel();
        }
        this.removeLayerBoxes();
        this.buildLayerBoxPanel();
        this.layersPanel.revalidate();
        this.scroller.revalidate();
        this.managerPanel.revalidate();
        this.managerPanel.repaint();
    }

    public void updateObjectList() {
        if (this.editor == null) {
            return;
        }
        Enumeration enumeration = this.editor.getObjects();
        while (enumeration.hasMoreElements()) {
            FigObject figObject = (FigObject)enumeration.nextElement();
            int n = figObject.getLayer();
            boolean bl = this.isSelectedLayer(n);
            figObject.setVisible(bl);
        }
        this.editor.doRedraw();
    }

    public boolean isSelectedLayer(int n) {
        return "true".equals(this.layerTable.get(new Integer(n)));
    }

    public void setSelectedLayer(int n, boolean bl) {
        String string;
        Integer n2 = new Integer(n);
        Object v = this.layerTable.get(n2);
        String string2 = string = bl ? "true" : "false";
        if (!string.equals(v)) {
            this.layerTable.put(n2, string);
            this.updateObjectList();
        }
    }

    public void selectCurrentLayer(int n) {
        if (this.editorLayerButton != null) {
            this.editorLayerButton.setState(n);
        }
    }

    public static void msg(String string) {
        System.out.println(string);
    }

    public static void main(String[] stringArray) {
        JModularEditor jModularEditor = new JModularEditor();
        jModularEditor.doParseFile("03-compound-depth-test.fig", false);
        JLayerManager jLayerManager = new JLayerManager();
        jLayerManager.setEditor(jModularEditor);
        jLayerManager.setEditorLayerButton(jModularEditor.attribsButtonPanel.depthButton);
        JFrame jFrame = (JFrame)jModularEditor.getFrame();
        jFrame.getContentPane().add("East", jLayerManager.getPanel());
        jFrame.invalidate();
    }

    class OneLayerPanel
    extends JPanel
    implements ActionListener,
    ItemListener {
        int layer;
        JCheckBox enableCB = new JCheckBox();
        JButton selectButton;

        public void setSelected(boolean bl) {
            this.enableCB.setSelected(bl);
        }

        public boolean isSelected() {
            return this.enableCB.isSelected();
        }

        public void setLayer(int n) {
            this.layer = n;
            this.selectButton.setText("" + n);
        }

        public int getLayer() {
            return this.layer;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.setSelected(true);
            JLayerManager.this.setSelectedLayer(this.layer, true);
            JLayerManager.this.selectCurrentLayer(this.layer);
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            JLayerManager.this.setSelectedLayer(this.layer, this.isSelected());
        }

        public OneLayerPanel(int n, boolean bl) {
            this.enableCB.addItemListener(this);
            String string = JLayerManager.this.registered ? "show or hide this layer" : JLayerManager.this.s_unregistered;
            this.enableCB.setToolTipText(string);
            this.enableCB.setEnabled(JLayerManager.this.registered);
            this.selectButton = new JButton("999");
            this.selectButton.setFont(JLayerManager.this.defaultFont);
            this.selectButton.setHorizontalAlignment(0);
            this.selectButton.setMargin(new Insets(1, 1, 1, 1));
            this.selectButton.addActionListener(this);
            string = JLayerManager.this.registered ? "select layer as current drawing layer" : JLayerManager.this.s_unregistered;
            this.selectButton.setToolTipText(string);
            this.selectButton.setEnabled(JLayerManager.this.registered);
            this.setLayout(new BorderLayout());
            this.add("West", this.enableCB);
            this.add("Center", this.selectButton);
            this.setMaximumSize(this.getPreferredSize());
            this.setLayer(n);
            this.setSelected(bl);
        }
    }
}

