/*
 * Decompiled with CFR 0.152.
 */
package jfig.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import jfig.gui.ImageHelper;
import jfig.gui.JImageButton;
import jfig.gui.JStateButton;
import jfig.gui.StatusMessage;
import jfig.utils.MouseMapper;

public class JFillPatternButton
extends JStateButton {
    private SelectDialog sd = null;

    public Dialog getDialog() {
        return this.sd;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (debug) {
            this.helper.setStatusMessage("StateButton:mousePressed()state[" + this.state + "]");
        }
        if (MouseMapper.isMiddleClick(mouseEvent)) {
            --this.state;
            if (this.state < 0) {
                this.state = this.images.length - 1;
            }
            this.createActionEvent();
            this.repaint();
        } else if (MouseMapper.isRightClick(mouseEvent)) {
            ++this.state;
            if (this.state >= this.images.length) {
                this.state = 0;
            }
            this.createActionEvent();
            this.repaint();
        } else if (this.updateMode && mouseEvent.getX() <= 7) {
            this.updateStatus = !this.updateStatus;
            this.repaint();
        } else {
            if (this.sd == null) {
                JFillPatternButton jFillPatternButton = this;
                if (jFillPatternButton == null) {
                    throw null;
                }
                this.sd = jFillPatternButton.new SelectDialog(this.findParentFrame());
                this.sd.pack();
                this.sd.setModal(true);
            }
            this.sd.setLocation(Math.max(0, this.getLocationOnScreen().x - 50), Math.max(0, this.getLocationOnScreen().y - this.sd.getBounds().height));
            this.disableToolTip();
            this.sd.setVisible(true);
        }
    }

    public int getFigAreaFill() {
        return this.getState() - 1;
    }

    public int getFillStyle() {
        int n = this.getState();
        if (n == 0) {
            return 1;
        }
        if (n <= 41) {
            return 2;
        }
        return 3;
    }

    public void setFigAreaFill(int n) {
        if (n <= -1) {
            this.setState(0);
        } else if (n == -1) {
            this.setState(0);
        } else if (n >= 63) {
            this.setState(63);
        } else {
            this.setState(n + 1);
        }
    }

    public static void main(String[] stringArray) {
        System.out.println("JFillPatternButton selftest...");
        JFrame jFrame = new JFrame("JFillPatternButton selftest");
        jFrame.setSize(100, 100);
        jFrame.show();
        JFillPatternButton jFillPatternButton = new JFillPatternButton(jFrame, "select pattern");
        jFrame.getContentPane().add("South", jFillPatternButton);
    }

    public JFillPatternButton(Component component, String string) {
        super(component, string, null, null);
        this.images = new Image[64];
        try {
            Image image = ImageHelper.loadResourceImage("/jfig/images/fillpatterns.gif");
            int n = 0;
            while (n < 8) {
                int n2 = 0;
                while (n2 < 8) {
                    this.images[8 * n + n2] = ImageHelper.createImage(40, 20);
                    this.images[8 * n + n2].getGraphics().drawImage(image, 0, 0, 40, 20, 45 * n2 + 5, 25 * n + 5, 45 * n2 + 40 + 5, 25 * n + 20 + 5, this.getBackground(), null);
                    ++n2;
                }
                ++n;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.calculateSize();
        this.setToolTipText("Select fill pattern");
    }

    public JFillPatternButton(Component component, String string, StatusMessage statusMessage, String string2) {
        this(component, string);
        this.helper = statusMessage;
        this.helpMessage = string2;
    }

    public JFillPatternButton(Component component, String string, Image[] imageArray) {
        this(component, string);
        this.images = imageArray;
        this.calculateSize();
    }

    class SelectDialog
    extends JDialog
    implements ActionListener {
        private JButton cancelButton = new JButton("Cancel");
        private JPanel ibuttonPanel;
        private JPanel cancelPanel;
        private JImageButton[] iButtons;

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if ("Cancel".equals(string)) {
                this.setVisible(false);
                JFillPatternButton.this.reEnableToolTip();
                JFillPatternButton.this.repaint();
            } else {
                try {
                    JFillPatternButton.this.state = Integer.parseInt(string);
                    this.setVisible(false);
                    JFillPatternButton.this.reEnableToolTip();
                    JFillPatternButton.this.repaint();
                }
                catch (Exception exception) {
                    this.msg("-E- SelectDialog: unknown button arg: " + string);
                }
            }
        }

        public void msg(String string) {
            System.out.println(string);
        }

        public SelectDialog(Frame frame) {
            super(frame, "Select fill pattern:");
            this.cancelButton.addActionListener(this);
            this.cancelPanel = new JPanel(new FlowLayout(1));
            this.cancelPanel.add(this.cancelButton);
            this.ibuttonPanel = new JPanel(new GridLayout(7, 11, 5, 5));
            this.iButtons = new JImageButton[JFillPatternButton.this.images.length];
            int n = 0;
            while (n < JFillPatternButton.this.images.length) {
                this.iButtons[n] = new JImageButton("" + n, null, "no help", JFillPatternButton.this.images[n]);
                this.iButtons[n].addActionListener(this);
                this.ibuttonPanel.add(this.iButtons[n]);
                ++n;
            }
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add("Center", this.ibuttonPanel);
            this.getContentPane().add("South", this.cancelPanel);
            this.pack();
        }
    }
}

