/*
 * Decompiled with CFR 0.152.
 */
package jfig.gui;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.awt.event.WindowListener;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import jfig.commands.FigBasicEditor;
import jfig.gui.ImageHelper;
import jfig.gui.JEditBaseobjectDialog;
import jfig.objects.FigAttribs;
import jfig.objects.FigXSpline;
import jfig.utils.AntiDeadlock;
import jfig.utils.ExceptionTracer;
import jfig.utils.SetupManager;

public class JEditXSplineDialog
extends JEditBaseobjectDialog
implements ActionListener,
KeyListener,
WindowListener {
    FigXSpline xspline;

    public void setXSpline(FigXSpline figXSpline) {
        if (figXSpline == null) {
            return;
        }
        this.xspline = figXSpline;
        this.savedAttribs = figXSpline.getAttributes().getClone();
        this.currentAttribs = figXSpline.getAttributes();
        this.showAttribs(this.currentAttribs);
        this.showCoords(figXSpline, this.coordsTextArea);
        this.savedCoords = this.coordsTextArea.getText();
    }

    public JPanel buildLabelsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 1, 0, 6));
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel.add(this.lineColorLabel);
        jPanel.add(this.lineWidthLabel);
        jPanel.add(this.arrowModeLabel);
        jPanel.add(this.arrowFLabel);
        jPanel.add(this.arrowBLabel);
        jPanel.add(new JLabel(""));
        jPanel.add(this.fillColorLabel);
        jPanel.add(this.depthLabel);
        return jPanel;
    }

    public JPanel buildAttribsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 1, 0, 6));
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel.add(this.buildLineColorPanel());
        jPanel.add(this.buildLineStylePanel());
        jPanel.add(this.buildArrowModePanel());
        jPanel.add(this.buildFArrowPanel());
        jPanel.add(this.buildBArrowPanel());
        jPanel.add(new JLabel(""));
        jPanel.add(this.buildFillStylePanel());
        jPanel.add(this.buildDepthPanel());
        this.dbg("-#- buildAttribsPanel ok.");
        return jPanel;
    }

    public void retrieveAttribs(FigAttribs figAttribs) {
        this.AC.setLineStyle(figAttribs, this.lineStyleButton);
        this.AC.setLineWidth(figAttribs, this.lineWidthButton);
        this.AC.setLineColor(figAttribs, this.lineColorButton);
        this.AC.setDashLength(figAttribs, this.dashLengthField);
        this.AC.setArrowMode(figAttribs, this.arrowModeButton);
        this.AC.setArrowStyle(figAttribs, this.arrowStyleButton);
        this.AC.setFArrowWidth(figAttribs, this.f_arrowWidthField);
        this.AC.setFArrowLength(figAttribs, this.f_arrowLengthField);
        this.AC.setFArrowThickness(figAttribs, this.f_arrowThicknessField);
        this.AC.setBArrowWidth(figAttribs, this.b_arrowWidthField);
        this.AC.setBArrowLength(figAttribs, this.b_arrowLengthField);
        this.AC.setBArrowThickness(figAttribs, this.b_arrowThicknessField);
        this.AC.setFillColor(figAttribs, this.fillColorButton);
        this.AC.setFillPattern(figAttribs, this.fillPatternButton);
        this.AC.setDepth(figAttribs, this.depthButton);
        this.dbg("new attribs= " + figAttribs);
    }

    public void showAttribs(FigAttribs figAttribs) {
        this.AC.showLineStyle(figAttribs, this.lineStyleButton);
        this.AC.showLineWidth(figAttribs, this.lineWidthButton);
        this.AC.showLineColor(figAttribs, this.lineColorButton);
        this.AC.showDashLength(figAttribs, this.dashLengthField);
        this.AC.showArrowMode(figAttribs, this.arrowModeButton);
        this.AC.showArrowStyle(figAttribs, this.arrowStyleButton);
        this.AC.showFArrowWidth(figAttribs, this.f_arrowWidthField);
        this.AC.showFArrowLength(figAttribs, this.f_arrowLengthField);
        this.AC.showFArrowThickness(figAttribs, this.f_arrowThicknessField);
        this.AC.showBArrowWidth(figAttribs, this.b_arrowWidthField);
        this.AC.showBArrowLength(figAttribs, this.b_arrowLengthField);
        this.AC.showBArrowThickness(figAttribs, this.b_arrowThicknessField);
        this.AC.showFillColor(figAttribs, this.fillColorButton);
        this.AC.showFillPattern(figAttribs, this.fillPatternButton);
        this.AC.showDepth(figAttribs, this.depthButton);
        this.dbg("existing attribs= " + figAttribs);
    }

    public void retrievePoints(FigXSpline figXSpline, JTextArea jTextArea) {
        String string = jTextArea.getText();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        Vector<Point> vector = new Vector<Point>();
        Vector<Point[]> vector2 = new Vector<Point[]>();
        String string2 = "";
        try {
            Object object;
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "(),\t ");
                Point point = new Point(0, 0);
                point.x = Integer.parseInt(stringTokenizer2.nextToken());
                point.y = Integer.parseInt(stringTokenizer2.nextToken());
                vector.addElement(point);
                object = Double.valueOf(stringTokenizer2.nextToken());
                vector2.addElement((Point[])object);
                this.dbg("---(" + point.x + ", " + point.y + ") + " + object);
            }
            object = new Point[vector.size()];
            int n = 0;
            while (n < ((Point[])object).length) {
                object[n] = (Point)vector.elementAt(n);
                ++n;
            }
            double[] dArray = new double[vector.size()];
            int n2 = 0;
            while (n2 < dArray.length) {
                dArray[n2] = (Double)vector2.elementAt(n2);
                ++n2;
            }
            figXSpline.setPoints((Point[])object);
            figXSpline.setSFactors(dArray);
        }
        catch (NoSuchElementException noSuchElementException) {
            return;
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
    }

    public void showCoords(FigXSpline figXSpline, JTextArea jTextArea) {
        Point[] pointArray = figXSpline.getPoints();
        double[] dArray = figXSpline.getSFactors();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < pointArray.length) {
            stringBuffer.append("(" + pointArray[n].x + ", " + pointArray[n].y + ") " + "     " + dArray[n] + "\n");
            ++n;
        }
        jTextArea.setText(stringBuffer.toString());
    }

    public void restorePoints(FigXSpline figXSpline) {
        this.coordsTextArea.setText(this.savedCoords);
        this.retrievePoints(figXSpline, this.coordsTextArea);
    }

    public void doCancel() {
        this.dbg("-#- EditPolylineDialog.Cancel");
        this.xspline.setAttributes(this.savedAttribs);
        this.restorePoints(this.xspline);
        this.setVisible(false);
        AntiDeadlock.sleep(200L);
        this.doRedraw();
    }

    public void doApply() {
        this.dbg("-#- JEditXSplineDialog.Apply");
        this.retrieveAttribs(this.currentAttribs);
        this.xspline.update(this.currentAttribs);
        this.retrievePoints(this.xspline, this.coordsTextArea);
        this.editor.deleteFromObjectList(this.xspline);
        this.editor.insertIntoObjectList(this.xspline);
        this.doRedraw();
    }

    public void doOK() {
        this.dbg("-#- JEditXSplineDialog.OK...");
        this.retrieveAttribs(this.currentAttribs);
        this.xspline.update(this.currentAttribs);
        this.retrievePoints(this.xspline, this.coordsTextArea);
        this.editor.deleteFromObjectList(this.xspline);
        this.editor.insertIntoObjectList(this.xspline);
        this.setVisible(false);
        AntiDeadlock.sleep(200L);
        this.doRedraw();
    }

    public static void main(String[] stringArray) {
        ExceptionTracer.setEnabled(true);
        JFrame jFrame = new JFrame("dummy");
        jFrame.setSize(new Dimension(100, 100));
        ImageHelper.setVisibleParent(jFrame);
        SetupManager.loadAllProperties("jfig.cnf");
        JEditXSplineDialog jEditXSplineDialog = new JEditXSplineDialog((Frame)jFrame, null);
        FigXSpline figXSpline = new FigXSpline();
        figXSpline.setPoints(new Point[]{new Point(0, 0), new Point(100, 200), new Point(240, 480), new Point(13, 15), new Point(720, 2400)});
        figXSpline.setSFactors(new double[]{0.0, -1.0, 0.5, 0.3, 0.0});
        jEditXSplineDialog.setXSpline(figXSpline);
        jEditXSplineDialog.show();
    }

    public JEditXSplineDialog(Frame frame, FigBasicEditor figBasicEditor) {
        super(frame, figBasicEditor, "Edit xspline");
    }
}

