/*
 * Decompiled with CFR 0.152.
 */
package jfig.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import jfig.commands.FigBasicEditor;
import jfig.gui.ImageHelper;
import jfig.gui.JAttribsControlsFactory;
import jfig.gui.JColorButton;
import jfig.gui.JFillPatternButton;
import jfig.gui.JFontButton;
import jfig.gui.JNumericStateButton;
import jfig.gui.JStateButton;
import jfig.gui.StatusMessage;
import jfig.objects.FigAttribs;
import jfig.utils.AntiDeadlock;
import jfig.utils.ExceptionTracer;
import jfig.utils.SetupManager;

public class JEditGlobalAttributesDialog
extends JDialog
implements ActionListener,
KeyListener,
WindowListener {
    FigBasicEditor editor;
    FigAttribs savedAttribs;
    FigAttribs currentAttribs;
    String savedCoords;
    JButton okButton;
    JButton applyButton;
    JButton cancelButton;
    JAttribsControlsFactory AC;
    JStateButton lineStyleButton;
    JStateButton lineWidthButton;
    JTextField dashLengthField;
    JColorButton lineColorButton;
    JStateButton arrowModeButton;
    JStateButton arrowStyleButton;
    JTextField f_arrowWidthField;
    JTextField f_arrowLengthField;
    JTextField f_arrowThicknessField;
    JTextField b_arrowWidthField;
    JTextField b_arrowLengthField;
    JTextField b_arrowThicknessField;
    JColorButton fillColorButton;
    JFillPatternButton fillPatternButton;
    JNumericStateButton depthButton;
    JFontButton fontSelectButton;
    JNumericStateButton fontSizeButton;
    JStateButton textAlignButton;
    JComboBox landscapePortraitChoice;
    JComboBox centerFlushLeftChoice;
    JTextArea coordsTextArea;
    JLabel lineStyleLabel;
    JLabel lineWidthLabel;
    JLabel lineColorLabel;
    JLabel arrowModeLabel;
    JLabel arrowStyleLabel;
    JLabel fillStyleLabel;
    JLabel fillColorLabel;
    JLabel fillPatternLabel;
    JLabel fontStyleLabel;
    JLabel textAlignLabel;
    JLabel depthLabel;
    JLabel landscapeLabel;
    StatusMessage statusMessage;
    Font defaultFont;
    Color backgroundColor;
    boolean debug = false;

    public void setAttributes(FigAttribs figAttribs) {
        if (figAttribs == null) {
            System.out.println("-E- JEditGlobalAttributesDialog.setAttributes: null argument!");
            return;
        }
        this.savedAttribs = figAttribs.getClone();
        this.currentAttribs = figAttribs;
        this.showAttribs(this.currentAttribs);
    }

    private void getGUIDefaults() {
        String string = SetupManager.getProperty("jfig.gui.EditDialog.FontName", "SansSerif");
        int n = SetupManager.getInteger("jfig.gui.EditDialog.FontSize", 12);
        int n2 = 0;
        this.defaultFont = new Font(string, n2, n);
        this.backgroundColor = SetupManager.getColor("jfig.gui.EditDialog.BackgroundColor", Color.lightGray);
        if (this.defaultFont != null) {
            this.setFont(this.defaultFont);
        }
        if (this.backgroundColor != null) {
            this.setBackground(this.backgroundColor);
        }
    }

    private JPanel buildOKPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel.setLayout(new FlowLayout(1));
        this.okButton = new JButton("OK");
        this.applyButton = new JButton("Apply");
        this.cancelButton = new JButton("Cancel");
        jPanel.add(this.cancelButton);
        jPanel.add(new JLabel("   "));
        jPanel.add(this.applyButton);
        jPanel.add(this.okButton);
        this.dbg("-#- buildOKPanel ok.");
        return jPanel;
    }

    private void createControls() {
        this.lineWidthLabel = new JLabel("Line width, style: ", 4);
        this.lineColorLabel = new JLabel("Line pen color: ", 4);
        this.fillStyleLabel = new JLabel("Fill style, shade: ", 4);
        this.fillColorLabel = new JLabel("Fill base color: ", 4);
        this.arrowModeLabel = new JLabel("Arrow mode, style: ", 4);
        this.depthLabel = new JLabel("Depth/layer [0..999]: ", 4);
        this.fontStyleLabel = new JLabel("Text font: ", 4);
        this.textAlignLabel = new JLabel("Text size, alignment: ", 4);
        this.landscapeLabel = new JLabel("Paper orientation: ", 4);
        this.lineStyleButton = this.AC.createLineStyleButton(this);
        this.lineWidthButton = this.AC.createLineWidthButton(this);
        this.lineColorButton = this.AC.createLineColorButton(this);
        this.dashLengthField = this.AC.createDashLengthField(this);
        this.arrowModeButton = this.AC.createArrowModeButton(this);
        this.arrowStyleButton = this.AC.createArrowStyleButton(this);
        this.f_arrowWidthField = this.AC.createFrontArrowWidthField(this);
        this.f_arrowLengthField = this.AC.createFrontArrowLengthField(this);
        this.f_arrowThicknessField = this.AC.createFrontArrowThicknessField(this);
        this.b_arrowWidthField = this.AC.createBackArrowWidthField(this);
        this.b_arrowLengthField = this.AC.createBackArrowLengthField(this);
        this.b_arrowThicknessField = this.AC.createBackArrowThicknessField(this);
        this.fillColorButton = this.AC.createFillColorButton(this);
        this.fillPatternButton = this.AC.createFillPatternButton(this);
        this.fontSelectButton = this.AC.createFontSelectButton(this);
        this.fontSizeButton = this.AC.createFontSizeButton(this);
        this.textAlignButton = this.AC.createTextAlignButton(this);
        this.depthButton = this.AC.createDepthButton(this);
        this.landscapePortraitChoice = this.AC.createLandscapePortraitChoice(this);
        this.centerFlushLeftChoice = this.AC.createCenterFlushLeftChoice(this);
        this.dbg("-#- createControls ok.");
    }

    public JPanel buildLabelsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 1));
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel.add(this.lineColorLabel);
        jPanel.add(this.lineWidthLabel);
        jPanel.add(this.arrowModeLabel);
        jPanel.add(new JLabel("front arrow W/L [mm]: ", 4));
        jPanel.add(new JLabel("back arrow W/L [mm]: ", 4));
        jPanel.add(new JLabel(" "));
        jPanel.add(this.fillStyleLabel);
        jPanel.add(this.fillColorLabel);
        jPanel.add(this.fontStyleLabel);
        jPanel.add(this.textAlignLabel);
        jPanel.add(this.depthLabel);
        jPanel.add(new JLabel(" "));
        jPanel.add(this.landscapeLabel);
        return jPanel;
    }

    public JPanel buildAttribsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 1));
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel.add(this.lineColorButton);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0, 0, 0));
        jPanel2.add(this.lineWidthButton);
        jPanel2.add(new JLabel("  "));
        jPanel2.add(this.lineStyleButton);
        jPanel2.add(new JLabel("  "));
        jPanel2.add(this.dashLengthField);
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(0, 0, 0));
        jPanel3.add(this.arrowModeButton);
        jPanel3.add(new JLabel(" "));
        jPanel3.add(this.arrowStyleButton);
        jPanel.add(jPanel3);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(0, 0, 0));
        jPanel4.add(this.f_arrowWidthField);
        jPanel4.add(this.f_arrowLengthField);
        jPanel4.add(this.f_arrowThicknessField);
        jPanel.add(jPanel4);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new FlowLayout(0, 0, 0));
        jPanel5.add(this.b_arrowWidthField);
        jPanel5.add(this.b_arrowLengthField);
        jPanel5.add(this.b_arrowThicknessField);
        jPanel.add(jPanel5);
        jPanel.add(new JLabel(" "));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new FlowLayout(0, 0, 0));
        jPanel6.add(this.fillPatternButton);
        jPanel.add(jPanel6);
        jPanel.add(this.fillColorButton);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new FlowLayout(0, 0, 0));
        jPanel7.add(this.fontSelectButton);
        jPanel.add(jPanel7);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new FlowLayout(0, 0, 0));
        jPanel8.add(this.fontSizeButton);
        jPanel8.add(new JLabel("  "));
        jPanel8.add(this.textAlignButton);
        jPanel.add(jPanel8);
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new FlowLayout(0, 0, 0));
        jPanel9.add(this.depthButton);
        jPanel9.add(new JLabel(" "));
        jPanel.add(jPanel9);
        jPanel.add(new JLabel(" "));
        JPanel jPanel10 = new JPanel();
        jPanel10.add(this.landscapePortraitChoice);
        jPanel10.add(this.centerFlushLeftChoice);
        jPanel.add(jPanel10);
        this.dbg("-#- buildAttribsPanel ok.");
        return jPanel;
    }

    public JPanel buildCoordsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel.setLayout(new BorderLayout());
        this.coordsTextArea = new JTextArea(5, 20);
        jPanel.add("Center", this.coordsTextArea);
        return jPanel;
    }

    public void retrieveAttribs(FigAttribs figAttribs) {
        this.AC.setLineStyle(figAttribs, this.lineStyleButton);
        this.AC.setLineWidth(figAttribs, this.lineWidthButton);
        this.AC.setDashLength(figAttribs, this.dashLengthField);
        this.AC.setLineColor(figAttribs, this.lineColorButton);
        this.AC.setArrowMode(figAttribs, this.arrowModeButton);
        this.AC.setArrowStyle(figAttribs, this.arrowStyleButton);
        this.AC.setFArrowWidth(figAttribs, this.f_arrowWidthField);
        this.AC.setFArrowLength(figAttribs, this.f_arrowLengthField);
        this.AC.setFArrowThickness(figAttribs, this.f_arrowThicknessField);
        this.AC.setBArrowWidth(figAttribs, this.b_arrowWidthField);
        this.AC.setBArrowLength(figAttribs, this.b_arrowLengthField);
        this.AC.setBArrowThickness(figAttribs, this.b_arrowThicknessField);
        this.AC.setFillColor(figAttribs, this.fillColorButton);
        this.AC.setFillPattern(figAttribs, this.fillPatternButton);
        this.AC.selectFont(figAttribs, this.fontSelectButton);
        this.AC.setFontSize(figAttribs, this.fontSizeButton);
        this.AC.setTextAlignment(figAttribs, this.textAlignButton);
        this.AC.setDepth(figAttribs, this.depthButton);
        this.AC.setLandscapeMode(figAttribs, this.landscapePortraitChoice);
        this.AC.setJustificationMode(figAttribs, this.centerFlushLeftChoice);
        this.dbg("new attribs= " + figAttribs);
    }

    public void showAttribs(FigAttribs figAttribs) {
        this.AC.showLineStyle(figAttribs, this.lineStyleButton);
        this.AC.showLineWidth(figAttribs, this.lineWidthButton);
        this.AC.showDashLength(figAttribs, this.dashLengthField);
        this.AC.showLineColor(figAttribs, this.lineColorButton);
        this.AC.showArrowMode(figAttribs, this.arrowModeButton);
        this.AC.showArrowStyle(figAttribs, this.arrowStyleButton);
        this.AC.showFArrowWidth(figAttribs, this.f_arrowWidthField);
        this.AC.showFArrowLength(figAttribs, this.f_arrowLengthField);
        this.AC.showFArrowThickness(figAttribs, this.f_arrowThicknessField);
        this.AC.showBArrowWidth(figAttribs, this.b_arrowWidthField);
        this.AC.showBArrowLength(figAttribs, this.b_arrowLengthField);
        this.AC.showBArrowThickness(figAttribs, this.b_arrowThicknessField);
        this.AC.showFillColor(figAttribs, this.fillColorButton);
        this.AC.showFillPattern(figAttribs, this.fillPatternButton);
        this.AC.showFontName(figAttribs, this.fontSelectButton);
        this.AC.showFontSize(figAttribs, this.fontSizeButton);
        this.AC.showTextAlignment(figAttribs, this.textAlignButton);
        this.AC.showDepth(figAttribs, this.depthButton);
        this.AC.showLandscapeMode(figAttribs, this.landscapePortraitChoice);
        this.AC.showJustificationMode(figAttribs, this.centerFlushLeftChoice);
        this.dbg("existing attribs= " + figAttribs);
    }

    public void keyPressed(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (this.debug) {
            this.message("-#- textDialog.keyPressed() " + c);
        }
        if (c == '\n') {
            this.doOK();
        } else if (c == '\u001b') {
            this.doCancel();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    private void doRedraw() {
        if (this.editor != null) {
            this.editor.getObjectCanvas().doFullRedraw();
        }
    }

    public void doCancel() {
        this.dbg("-#- JEditGlobalAttributesDialog.Cancel");
        this.setVisible(false);
        AntiDeadlock.sleep(200L);
        this.editor.setCurrentAttribs(this.savedAttribs);
        this.doRedraw();
    }

    private void doApply() {
        this.dbg("-#- JEditGlobalAttributesDialog.Apply");
        this.retrieveAttribs(this.currentAttribs);
        this.editor.setCurrentAttribs(this.currentAttribs);
        this.doRedraw();
    }

    private void doOK() {
        this.dbg("-#- JEditGlobalAttributesDialog.OK...");
        this.retrieveAttribs(this.currentAttribs);
        this.editor.setCurrentAttribs(this.currentAttribs);
        this.setVisible(false);
        AntiDeadlock.sleep(200L);
        this.doRedraw();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JButton) {
            String string = actionEvent.getActionCommand();
            if (string.equals("OK")) {
                this.doOK();
            } else if (string.equals("Apply")) {
                this.doApply();
            } else if (string.equals("Cancel")) {
                this.doCancel();
            } else {
                this.message("-E- Unknown event source: " + actionEvent);
            }
        }
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        ((Component)this).setVisible(false);
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void message(String string) {
        System.out.println(string);
    }

    public void dbg(String string) {
        if (this.debug) {
            this.message(string);
        }
    }

    public static void main(String[] stringArray) {
        ExceptionTracer.setEnabled(true);
        JFrame jFrame = new JFrame("dummy");
        jFrame.setSize(new Dimension(100, 100));
        ImageHelper.setVisibleParent(jFrame);
        SetupManager.loadAllProperties("jfig.cnf");
        JEditGlobalAttributesDialog jEditGlobalAttributesDialog = new JEditGlobalAttributesDialog(new FigAttribs(), null, jFrame);
        jFrame.show();
        jEditGlobalAttributesDialog.show();
    }

    public JEditGlobalAttributesDialog(FigAttribs figAttribs, FigBasicEditor figBasicEditor, Frame frame) {
        super(frame, "jfig: Edit global attributes", true);
        if (figAttribs == null) {
            return;
        }
        this.editor = figBasicEditor;
        this.AC = JAttribsControlsFactory.getJAttribsControlsFactory(figBasicEditor);
        this.getGUIDefaults();
        this.createControls();
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add("North", this.buildOKPanel());
        this.getContentPane().add("West", this.buildLabelsPanel());
        this.getContentPane().add("Center", this.buildAttribsPanel());
        this.pack();
        this.setAttributes(figAttribs);
        this.okButton.addActionListener(this);
        this.applyButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.addKeyListener(this);
        this.addWindowListener(this);
    }
}

