/*
 * Decompiled with CFR 0.152.
 */
package jfig.gui;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import jfig.canvas.FigTrafo2D;
import jfig.commands.FigBasicEditor;
import jfig.gui.ImageHelper;
import jfig.gui.JEditBaseobjectDialog;
import jfig.objects.FigAttribs;
import jfig.objects.FigCompound;
import jfig.objects.FigText;
import jfig.utils.AntiDeadlock;
import jfig.utils.SetupManager;

public class JEditCompoundDialog
extends JEditBaseobjectDialog
implements ActionListener,
KeyListener {
    public static final int MAX_TEXT_FIELDS = 10;
    FigCompound compound;
    Vector _textObjectVector = null;
    Vector _textFieldVector = null;
    JPanel _textFieldPanel;

    public void setCompoundObject(FigCompound figCompound) {
        if (figCompound == null) {
            return;
        }
        try {
            this.compound = figCompound;
            this.savedAttribs = figCompound.getAttributes().getClone();
            this.currentAttribs = figCompound.getAttributes();
            this.updateTextFieldPanel();
            this.showAttribs(this.currentAttribs);
        }
        catch (Exception exception) {
            this.message("-E- JEditCompoundDialog: " + exception);
        }
    }

    public JPanel buildLabelsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 1, 0, 6));
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel.add(this.depthLabel);
        return jPanel;
    }

    public JPanel buildAttribsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 1, 0, 6));
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel.add(this.buildDepthPanel());
        this.dbg("-#- buildAttribsPanel ok.");
        return jPanel;
    }

    public JPanel buildCoordsPanel() {
        this._textFieldPanel = new JPanel(new GridLayout(0, 1, 2, 2));
        this._textFieldPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.updateTextFieldPanel();
        return this._textFieldPanel;
    }

    public void updateTextFieldPanel() {
        this.dbg("-#- updateTextFieldPanel...");
        if (this.compound == null) {
            return;
        }
        this._textObjectVector = new Vector();
        Enumeration enumeration = this.compound.getMembers().elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof FigText)) continue;
            this._textObjectVector.addElement(e);
        }
        int n = this._textObjectVector.size();
        this.dbg("-#- counted: " + n + " text objects, now building GUI...");
        if (n == 0) {
            this._textFieldPanel.removeAll();
            this._textFieldPanel.add(new JLabel("no text objects"));
            this.pack();
        } else if (n >= 10) {
            this._textFieldPanel.removeAll();
            this._textFieldPanel.add(new JLabel("too many text objects"));
            this.pack();
        } else {
            this._textFieldPanel.removeAll();
            this._textFieldVector = new Vector();
            int n2 = 0;
            while (n2 < n) {
                String string = ((FigText)this._textObjectVector.elementAt(n2)).getText();
                JTextField jTextField = new JTextField(string, 40);
                this._textFieldVector.addElement(jTextField);
                this._textFieldPanel.add(jTextField);
                ++n2;
            }
            this.pack();
        }
    }

    public void updateTextObjects() {
        int n = 0;
        while (n < this._textObjectVector.size()) {
            FigText figText = (FigText)this._textObjectVector.elementAt(n);
            JTextField jTextField = (JTextField)this._textFieldVector.elementAt(n);
            figText.setText(jTextField.getText());
            ++n;
        }
    }

    public void retrieveAttribs(FigAttribs figAttribs) {
        this.AC.setDepth(figAttribs, this.depthButton);
        this.dbg("-#- new attribs= " + figAttribs);
    }

    public void showAttribs(FigAttribs figAttribs) {
        this.AC.showDepth(figAttribs, this.depthButton);
        this.dbg("-#- existing attribs= " + figAttribs);
    }

    public void doCancel() {
        this.dbg("-#- JEditCompoundDialog.Cancel");
        this.compound.changeLayerRecursively(this.savedAttribs);
        this.setVisible(false);
        AntiDeadlock.sleep(200L);
        this.doRedraw();
    }

    public void doApply() {
        this.dbg("-#- JEditCompoundDialog.Apply");
        this.retrieveAttribs(this.currentAttribs);
        this.updateTextObjects();
        this.compound.changeLayerRecursively(this.currentAttribs);
        this.editor.deleteFromObjectList(this.compound);
        this.editor.insertIntoObjectList(this.compound);
        this.doRedraw();
    }

    public void doOK() {
        this.dbg("-#- JEditCompoundDialog.OK...");
        this.retrieveAttribs(this.currentAttribs);
        this.updateTextObjects();
        this.compound.changeLayerRecursively(this.currentAttribs);
        this.editor.deleteFromObjectList(this.compound);
        this.editor.insertIntoObjectList(this.compound);
        this.setVisible(false);
        AntiDeadlock.sleep(200L);
        this.doRedraw();
    }

    public static void main(String[] stringArray) {
        Frame frame = new Frame("dummy");
        frame.setSize(new Dimension(100, 100));
        ImageHelper.setVisibleParent(frame);
        FigAttribs figAttribs = new FigAttribs();
        FigTrafo2D figTrafo2D = new FigTrafo2D();
        FigCompound figCompound = new FigCompound();
        Point point = new Point(2400, 2400);
        figCompound.addMember(new FigText(point, "Ally", figAttribs, figTrafo2D));
        figCompound.addMember(new FigText(point, "Bridget", figAttribs, figTrafo2D));
        figCompound.addMember(new FigText(point, "Caroline", figAttribs, figTrafo2D));
        figCompound.addMember(new FigText(point, "Donna", figAttribs, figTrafo2D));
        figCompound.addMember(new FigText(point, "Erica", figAttribs, figTrafo2D));
        figCompound.addMember(new FigText(point, "Fran", figAttribs, figTrafo2D));
        figCompound.addMember(new FigText(point, "Gabriela", figAttribs, figTrafo2D));
        figCompound.addMember(new FigText(point, "Hanna", figAttribs, figTrafo2D));
        SetupManager.loadAllProperties("jfig.cnf");
        JEditCompoundDialog jEditCompoundDialog = new JEditCompoundDialog(frame, null);
        jEditCompoundDialog.setCompoundObject(figCompound);
        jEditCompoundDialog.show();
    }

    public JEditCompoundDialog(Frame frame, FigBasicEditor figBasicEditor) {
        super(frame, figBasicEditor, "Edit compound object");
    }
}

