/*
 * Decompiled with CFR 0.152.
 */
package jfig.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import jfig.gui.ConsoleMessage;
import jfig.utils.SetupManager;

public class JConsole
extends JFrame
implements ActionListener,
ConsoleMessage {
    private static JConsole _console = null;
    private JTextArea ta = new JTextArea(60, 10);
    private JButton okButton;
    private JButton clearButton;
    private Font consoleFont;
    private Font buttonFont;
    private int n_lines;
    private int max_lines;
    private boolean popupJConsoleOnWEF = true;

    public static JConsole getConsole() {
        if (_console == null) {
            _console = new JConsole();
        }
        return _console;
    }

    public void setPopupJConsoleOnWEF(boolean bl) {
        this.popupJConsoleOnWEF = bl;
    }

    public boolean isPopupJConsoleOnWEF() {
        return this.popupJConsoleOnWEF;
    }

    private void getDefaultFonts() {
        String string = SetupManager.getProperty("jfig.gui.JConsole.JConsoleFontName", "MonoSpaced");
        int n = SetupManager.getInteger("jfig.gui.JConsole.JConsoleFontSize", 12);
        int n2 = 0;
        this.consoleFont = new Font(string, n2, n);
        string = SetupManager.getProperty("jfig.gui.JConsole.ButtonFontName", "SansSerif");
        n = SetupManager.getInteger("jfig.gui.JConsole.ButtonFontSize", 12);
        n2 = 0;
        this.buttonFont = new Font(string, n2, n);
    }

    public void initialize(String string) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            int n = Integer.parseInt(stringTokenizer.nextToken());
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            int n3 = Integer.parseInt(stringTokenizer.nextToken());
            int n4 = Integer.parseInt(stringTokenizer.nextToken());
            this.show();
            ((Component)this).setLocation(n, n2);
            ((Component)this).setSize(n3, n4);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setMaxLines(int n) {
        this.max_lines = n;
    }

    public int getMaxLines() {
        return this.max_lines;
    }

    protected Font getDefaultJConsoleFont() {
        String string = SetupManager.getProperty("jfig.gui.JConsole.JConsoleFontName", "Courier");
        int n = SetupManager.getInteger("jfig.gui.JConsole.JConsoleFontSize", 14);
        int n2 = 0;
        return new Font(string, n2, n);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JButton) {
            String string = actionEvent.getActionCommand();
            if (string.equals("Clear")) {
                this.ta.setText("");
                this.n_lines = 0;
            } else if (string.equals("OK")) {
                this.setVisible(false);
            } else {
                System.err.println("-E- JConsole internal: unknown event source: " + actionEvent);
            }
        }
    }

    public void checkShouldSetVisible(String string) {
        if (string.startsWith("-W-") || string.startsWith("-E-") || string.startsWith("-F-")) {
            if (!this.isVisible() && this.popupJConsoleOnWEF) {
                this.show();
            }
            if (this.popupJConsoleOnWEF) {
                this.toFront();
            }
        }
    }

    public synchronized void println(String string) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.addLine(string);
            this.checkShouldSetVisible(string);
        } else {
            JConsole jConsole = this;
            if (jConsole == null) {
                throw null;
            }
            SwingUtilities.invokeLater(jConsole.new InvokeLaterBuffer(string));
        }
    }

    public void consoleMessage(String string) {
        this.println(string);
    }

    public void message(String string) {
        this.println(string);
    }

    public synchronized void setText(String string) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.internalSetText(string);
        } else {
            JConsole jConsole = this;
            if (jConsole == null) {
                throw null;
            }
            SwingUtilities.invokeLater(jConsole.new InvokeLaterSetTextBuffer(string));
        }
    }

    private void internalSetText(String string) {
        this.ta.setText(string);
        this.n_lines = this.countLines();
        if (!this.isVisible()) {
            this.show();
        }
    }

    private synchronized void addLine(String string) {
        ++this.n_lines;
        if (this.n_lines >= this.max_lines + this.max_lines) {
            this.cleanup();
        }
        this.ta.append(string + "\n");
    }

    public void cleanup() {
        String string = this.ta.getText();
        int n = 0;
        int n2 = string.length() - 1;
        while (n2 >= 0) {
            if (string.charAt(n2) == '\n') {
                ++n;
            }
            if (n >= this.max_lines) {
                this.ta.setText(string.substring(n2 + 1, string.length()));
                this.n_lines = n;
                return;
            }
            --n2;
        }
        this.n_lines = n;
    }

    public int countLines() {
        String string = this.ta.getText();
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            if (string.charAt(n2) == '\n') {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public static void main(String[] stringArray) {
        JConsole jConsole = new JConsole();
        jConsole.show();
        jConsole.println("Hades JConsole...");
        int n = 0;
        while (n < 500) {
            jConsole.println("i " + n + "  i*i " + n * n);
            ++n;
        }
        System.out.println("Number of lines is " + jConsole.countLines());
        System.out.println("Now limiting to 10 lines...");
        jConsole.setMaxLines(10);
        jConsole.println("Hades JConsole...");
        n = 0;
        while (n < 500) {
            jConsole.println("i " + n + "  i*i " + n * n);
            ++n;
        }
        System.out.println("Number of lines is " + jConsole.countLines());
    }

    public JConsole() {
        this("jfig messages");
    }

    public JConsole(String string) {
        super(string);
        JScrollPane jScrollPane = new JScrollPane(this.ta);
        jScrollPane.setViewportBorder(new EmptyBorder(2, 2, 2, 2));
        this.getDefaultFonts();
        if (this.buttonFont != null) {
            this.setFont(this.buttonFont);
        }
        if (this.consoleFont != null) {
            this.ta.setFont(this.consoleFont);
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1));
        this.okButton = new JButton("Clear");
        jPanel.add(this.okButton);
        this.clearButton = new JButton("OK");
        jPanel.add(this.clearButton);
        this.setBackground(Color.lightGray);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add("Center", jScrollPane);
        this.getContentPane().add("South", jPanel);
        this.okButton.addActionListener(this);
        this.clearButton.addActionListener(this);
        this.setDefaultCloseOperation(1);
        ((Component)this).setSize(new Dimension(400, 300));
        this.n_lines = 0;
        this.max_lines = SetupManager.getInteger("jfig.gui.JConsole.SaveLines", 500);
    }

    class InvokeLaterBuffer
    implements Runnable {
        String s = null;

        public void run() {
            JConsole.this.addLine(this.s);
            JConsole.this.checkShouldSetVisible(this.s);
        }

        public InvokeLaterBuffer(String string) {
            this.s = string;
        }
    }

    class InvokeLaterSetTextBuffer
    implements Runnable {
        String s = null;

        public void run() {
            JConsole.this.internalSetText(this.s);
        }

        public InvokeLaterSetTextBuffer(String string) {
            this.s = string;
        }
    }
}

