/*
 * Decompiled with CFR 0.152.
 */
package jfig.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import jfig.gui.ColorCache;
import jfig.gui.ImageHelper;
import jfig.gui.JImageButton;
import jfig.gui.JStateButton;
import jfig.gui.StatusMessage;
import jfig.utils.MouseMapper;

public class JColorButton
extends JStateButton
implements MouseListener {
    ColorCache colorCache = ColorCache.getColorCache();
    SelectColorDialog selectColorDialog;
    long timestamp = 0L;

    public void createColorImages() {
        try {
            this.images = new Image[this.colorCache.numberOfColors()];
            int n = 0;
            while (n < this.images.length) {
                this.images[n] = ImageHelper.createImage(20, 20);
                Graphics graphics = this.images[n].getGraphics();
                graphics.setColor(this.colorCache.getColorAt(n));
                graphics.fillRect(0, 0, 21, 21);
                ++n;
            }
            this.timestamp = System.currentTimeMillis();
        }
        catch (Exception exception) {
            System.err.println("-#- internal error: " + exception);
            exception.printStackTrace();
        }
    }

    public Color getColor() {
        return this.colorCache.getColorAt(this.state);
    }

    public int getColorIndex() {
        return this.colorCache.getFigColorIndex(this.state);
    }

    public void selectColor(int n) {
        this.setState(n);
        this.repaint();
    }

    public void selectColor(Color color) {
        int n = this.colorCache.getIndex(color);
        this.selectColor(n);
    }

    public Dialog getDialog() {
        return this.selectColorDialog;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (debug) {
            this.helper.setStatusMessage("StateButton:mousePressed()state[" + this.state + "]");
        }
        if (this.colorCache.numberOfColors() != this.images.length || this.colorCache.getTimestamp() > this.timestamp) {
            this.createColorImages();
        }
        if (MouseMapper.isMiddleClick(mouseEvent)) {
            --this.state;
            if (this.state < 0) {
                this.setState(this.images.length - 1);
            }
            this.createActionEvent();
            this.repaint();
        } else if (MouseMapper.isRightClick(mouseEvent)) {
            ++this.state;
            if (this.state >= this.images.length) {
                this.setState(0);
            }
            this.createActionEvent();
            this.repaint();
        } else if (this.updateMode && mouseEvent.getX() <= 7) {
            this.updateStatus = !this.updateStatus;
            this.repaint();
        } else {
            if (this.selectColorDialog == null || this.colorCache.numberOfColors() != this.selectColorDialog.numberOfColors() || this.colorCache.getTimestamp() > this.selectColorDialog.getTimestamp()) {
                JColorButton jColorButton = this;
                if (jColorButton == null) {
                    throw null;
                }
                this.selectColorDialog = jColorButton.new SelectColorDialog(this.findParentFrame());
            }
            this.selectColorDialog.setModal(true);
            this.selectColorDialog.setLocation(Math.max(0, this.getLocationOnScreen().x - 50), Math.max(0, this.getLocationOnScreen().y - this.selectColorDialog.getBounds().height));
            this.disableToolTip();
            this.selectColorDialog.setVisible(true);
        }
    }

    public String toString() {
        String string = "JColorButton" + this.helpMessage;
        return string;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("JColorButton selftest");
        jFrame.setSize(300, 100);
        jFrame.show();
        JColorButton jColorButton = new JColorButton((Component)jFrame, "Select color", null, null);
        jFrame.getContentPane().add("Center", jColorButton);
        JButton jButton = new JButton("new random color");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ColorCache.getColorCache().registerUserColor(new Color(32 * (int)(8.0 * Math.random()), 32 * (int)(8.0 * Math.random()), 32 * (int)(8.0 * Math.random())));
            }
            {
                this.constructor$0();
            }

            private final void constructor$0() {
            }
        });
        jFrame.getContentPane().add("South", jButton);
        jFrame.pack();
    }

    public JColorButton(Component component, String string, StatusMessage statusMessage, String string2) {
        super(component, string, null, null, statusMessage, string2);
        this.createColorImages();
        this.calculateSize();
        this.setState(0);
        this.setToolTipText(string2 + " [L: select M: prev R: next]");
    }

    class SelectColorDialog
    extends JDialog
    implements ActionListener {
        private JButton cancelButton = new JButton("Cancel");
        private JButton newColorButton;
        private JPanel ibuttonPanel;
        private JPanel cancelPanel;
        private JImageButton[] iButtons;
        private JColorChooser colorChooser;
        private long timestamp = 0L;

        public long getTimestamp() {
            return this.timestamp;
        }

        public int numberOfColors() {
            return this.iButtons.length;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if ("Cancel".equals(string)) {
                this.setVisible(false);
                JColorButton.this.reEnableToolTip();
                JColorButton.this.repaint();
            } else if ("Add new color".equals(string)) {
                Color color;
                if (this.colorChooser == null) {
                    this.colorChooser = new JColorChooser();
                }
                if ((color = JColorChooser.showDialog(this, "Select new color", Color.red)) != null) {
                    ColorCache.getColorCache().registerUserColor(color);
                }
                this.setVisible(false);
                JColorButton.this.reEnableToolTip();
                JColorButton.this.repaint();
            } else {
                try {
                    JColorButton.this.setState(Integer.parseInt(string));
                    this.setVisible(false);
                    JColorButton.this.reEnableToolTip();
                    JColorButton.this.repaint();
                }
                catch (Exception exception) {
                    System.err.println("-E- SelectDialog: unknown button arg: " + string);
                }
            }
        }

        public SelectColorDialog(Frame frame) {
            super(frame, "Select color:");
            this.cancelButton.addActionListener(this);
            this.newColorButton = new JButton("Add new color");
            this.newColorButton.addActionListener(this);
            this.cancelPanel = new JPanel(new FlowLayout(1));
            this.cancelPanel.add(this.newColorButton);
            this.cancelPanel.add(this.cancelButton);
            this.ibuttonPanel = new JPanel(new GridLayout(0, 8, 0, 0));
            this.iButtons = new JImageButton[JColorButton.this.images.length];
            int n = 0;
            while (n < JColorButton.this.images.length) {
                this.iButtons[n] = new JImageButton("" + n, null, "no help", JColorButton.this.images[n]);
                this.iButtons[n].addActionListener(this);
                this.ibuttonPanel.add(this.iButtons[n]);
                ++n;
            }
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add("Center", this.ibuttonPanel);
            this.getContentPane().add("South", this.cancelPanel);
            this.pack();
            this.timestamp = System.currentTimeMillis();
        }
    }
}

