/*
 * Decompiled with CFR 0.152.
 */
package jfig.commands;

import java.awt.Point;
import java.lang.reflect.Method;
import jfig.canvas.FigCanvas;
import jfig.canvas.FigCanvasEvent;
import jfig.commands.Command;
import jfig.commands.FigBasicEditor;

public class ZoomRegionCommand
extends Command {
    protected Point P1;
    protected Point P2;
    protected int n_points;

    public void execute() {
        try {
            Class[] classArray = new Class[4];
            int n = 0;
            while (n < classArray.length) {
                classArray[n] = Integer.TYPE;
                ++n;
            }
            Object[] objectArray = new Object[]{new Integer(this.P1.x), new Integer(this.P1.y), new Integer(this.P2.x), new Integer(this.P2.y)};
            Method method = this.editor.getClass().getMethod("doZoomRegion", classArray);
            method.invoke((Object)this.editor, objectArray);
        }
        catch (Exception exception) {
            this.message("-E- ZoomRegionCommand failed: " + exception);
            exception.printStackTrace();
        }
    }

    public void undo() {
        this.statusMessage("No use undoing a zoom command, ignored!");
    }

    public void mousePressed(FigCanvasEvent figCanvasEvent) {
        Point point = figCanvasEvent.getWorldCoordinatePoint();
        Point point2 = figCanvasEvent.getScreenCoordinatePoint();
        if (this.n_points == 0) {
            this.P1 = new Point(point);
            this.n_points = 1;
            this.objectCanvas.setRubberbandBasePoint(point2);
            this.objectCanvas.changeRubberbandMode(4);
            this.objectCanvas.doSimpleRedraw();
            this.statusMessage("Click on the opposite corner of the region to zoom into");
        } else {
            this.P2 = new Point(point);
            this.objectCanvas.changeRubberbandMode(0);
            this.statusMessage("Zoom ready... select a command");
            this.execute();
            this.ready = true;
        }
    }

    public String toString() {
        return "ZoomRegionCommand into: " + this.P1 + " , " + this.P2;
    }

    public String getDescription() {
        return "zoom region";
    }

    public ZoomRegionCommand(FigBasicEditor figBasicEditor, FigCanvas figCanvas) {
        super(figBasicEditor, figCanvas);
        this.ready = false;
        this.P1 = null;
        this.P2 = null;
        this.n_points = 0;
        this.statusMessage("Click on the first corner of the region to zoom into");
        figCanvas.changeRubberbandMode(1);
    }
}

