/*
 * Decompiled with CFR 0.152.
 */
package jfig.commands;

import java.awt.Point;
import jfig.canvas.FigCanvas;
import jfig.canvas.FigCanvasEvent;
import jfig.canvas.FigTrafo2D;
import jfig.commands.Command;
import jfig.commands.FigBasicEditor;
import jfig.objects.FigObject;

public class SnapToGridCommand
extends Command {
    protected Point[] oldPoints;
    protected Point[] newPoints;
    protected FigObject object;

    public FigObject[] getModifiedObjects() {
        FigObject[] figObjectArray = new FigObject[]{this.object};
        return figObjectArray;
    }

    public void execute() {
        if (this.object != null) {
            this.object.setPoints(this.newPoints);
            this.editor.getUndoStack().push(this);
            this.objectCanvas.doFullRedraw();
        }
    }

    public void undo() {
        if (this.object != null) {
            this.object.setPoints(this.oldPoints);
            this.objectCanvas.doFullRedraw();
        }
    }

    public void mousePressed(FigCanvasEvent figCanvasEvent) {
        Point point = figCanvasEvent.getWorldCoordinatePoint();
        Point point2 = figCanvasEvent.getScreenCoordinatePoint();
        this.object = this.editor.findObjectAt(point);
        if (this.object == null) {
            this.statusMessage("No object found at that position! Click directly on the object to snap to the grid!");
            return;
        }
        Point[] pointArray = this.object.getPoints();
        if (pointArray == null) {
            return;
        }
        this.oldPoints = new Point[pointArray.length];
        int n = 0;
        while (n < pointArray.length) {
            this.oldPoints[n] = new Point(pointArray[n]);
            ++n;
        }
        FigTrafo2D figTrafo2D = this.objectCanvas.getTrafo();
        this.newPoints = new Point[pointArray.length];
        int n2 = 0;
        while (n2 < pointArray.length) {
            Point point3 = figTrafo2D.getScreenCoords(pointArray[n2]);
            this.newPoints[n2] = figTrafo2D.getWorldCoordsSnapped(point3);
            ++n2;
        }
        this.execute();
        this.ready = true;
        this.notifyEditor();
    }

    public String getDescription() {
        return "snap object to grid";
    }

    public String toString() {
        return "jfig.commands.SnapToGridCommand[]";
    }

    public SnapToGridCommand(FigBasicEditor figBasicEditor, FigCanvas figCanvas) {
        super(figBasicEditor, figCanvas);
        this.statusMessage("Click on the object to snap to the grid!");
        figBasicEditor.showAllObjectCorners();
        figCanvas.changeRubberbandMode(1);
        this.object = null;
        this.ready = false;
    }
}

