/*
 * Decompiled with CFR 0.152.
 */
package jfig.commands;

import java.awt.Point;
import jfig.canvas.FigCanvas;
import jfig.canvas.FigCanvasEvent;
import jfig.commands.Command;
import jfig.commands.FigBasicEditor;
import jfig.objects.FigAttribs;
import jfig.objects.FigObject;
import jfig.objects.FigText;
import jfig.utils.MouseMapper;

public class ResizeTextCommand
extends Command {
    public static final int[] fontSizeTable = new int[]{5, 6, 8, 9, 10, 11, 12, 14, 15, 17, 18, 20, 22, 24, 27, 30, 35, 40, 60};
    protected int n_points;
    protected FigText object;
    protected int fontSize;
    protected int oldFontSize;
    protected int fontIndex;
    protected int oldFontIndex;
    protected int mode;
    public final int ENLARGE;
    public final int SHRINK;
    public final int TOGGLE;

    public FigObject[] getModifiedObjects() {
        FigObject[] figObjectArray = new FigObject[]{this.object};
        return figObjectArray;
    }

    public void execute() {
        if (this.object != null) {
            FigAttribs figAttribs = this.object.getAttributes();
            this.oldFontSize = figAttribs.fontSize;
            this.fontSize = figAttribs.fontSize;
            this.fontIndex = figAttribs.fig_font;
            this.oldFontIndex = figAttribs.fig_font;
            int n = 0;
            if (this.mode == 1) {
                n = 0;
                int n2 = 0;
                while (n2 < fontSizeTable.length) {
                    if (this.fontSize > fontSizeTable[n2]) {
                        ++n;
                    }
                    ++n2;
                }
                if (n + 1 < fontSizeTable.length) {
                    this.fontSize = fontSizeTable[n + 1];
                }
            } else if (this.mode == 2) {
                n = 0;
                int n3 = 0;
                while (n3 < fontSizeTable.length) {
                    if (this.fontSize > fontSizeTable[n3]) {
                        ++n;
                    }
                    ++n3;
                }
                if (n - 1 > 0) {
                    this.fontSize = fontSizeTable[n - 1];
                }
            } else if (this.mode == 3 && figAttribs.fig_font < 32) {
                ++this.fontIndex;
                if ((this.fontIndex & 3) == 0) {
                    this.fontIndex -= 4;
                }
            }
            figAttribs.fontSize = this.fontSize;
            figAttribs.fig_font = this.fontIndex;
            this.object.setAttributes(figAttribs.getClone());
            this.object.update_bbox();
            this.editor.getUndoStack().push(this);
            this.objectCanvas.doFullRedraw();
        }
    }

    public void undo() {
        if (this.object != null) {
            FigAttribs figAttribs = this.object.getAttributes();
            figAttribs.fontSize = this.oldFontSize;
            this.object.setAttributes(figAttribs.getClone());
            this.object.update_bbox();
            this.objectCanvas.doFullRedraw();
        }
    }

    public void mousePressed(FigCanvasEvent figCanvasEvent) {
        Point point = figCanvasEvent.getWorldCoordinatePoint();
        Point point2 = figCanvasEvent.getScreenCoordinatePoint();
        FigObject figObject = this.editor.findObjectAt(point);
        if (figObject == null || !(figObject instanceof FigText)) {
            this.statusMessage("Click on the text to resize!  L: enlarge  M,shift+L: shrink  R: toggle normal/bold/italic");
            this.ready = true;
            this.notifyEditor();
            return;
        }
        this.object = (FigText)figObject;
        this.mode = MouseMapper.isMiddleClick(figCanvasEvent) ? 2 : (MouseMapper.isRightClick(figCanvasEvent) ? 3 : 1);
        this.execute();
        this.ready = true;
        this.notifyEditor();
    }

    public String getDescription() {
        return "resize text";
    }

    public String toString() {
        return "jfig.commands.ResizeTextCommand[]";
    }

    public ResizeTextCommand(FigBasicEditor figBasicEditor, FigCanvas figCanvas) {
        super(figBasicEditor, figCanvas);
        this.ENLARGE = 1;
        this.SHRINK = 2;
        this.TOGGLE = 3;
        this.statusMessage("Click on the text to resize!  L: enlarge  M,shift+L: shrink  R: toggle normal/bold/italic");
        figBasicEditor.showAllObjectCorners();
        figCanvas.changeRubberbandMode(1);
        this.n_points = 0;
        this.ready = false;
    }
}

