/*
 * Decompiled with CFR 0.152.
 */
package jfig.commands;

import java.awt.Dialog;
import java.awt.Point;
import java.util.Enumeration;
import java.util.Stack;
import jfig.canvas.FigCanvas;
import jfig.canvas.FigCanvasEvent;
import jfig.commands.Command;
import jfig.commands.FigBasicEditor;
import jfig.gui.CloseCompoundDialog;
import jfig.gui.ModularEditor;
import jfig.gui.ModularEditorState;
import jfig.objects.FigCompound;
import jfig.objects.FigObject;

public class OpenCompoundCommand
extends Command {
    private static Stack _stack = new Stack();
    private static Dialog closeDialog = null;
    FigCompound compound = null;
    ModularEditor editor = null;
    ModularEditorState state = null;

    public FigObject[] getModifiedObjects() {
        FigObject[] figObjectArray = new FigObject[]{this.compound};
        return figObjectArray;
    }

    public void cancel() {
    }

    public void execute() {
        if (this.compound == null) {
            return;
        }
        this.editor.deleteFromObjectList((FigObject)this.compound);
        this.state = this.editor.getEditorState();
        this.editor.clearEditorState();
        Enumeration enumeration = this.compound.getMembers().elements();
        while (enumeration.hasMoreElements()) {
            this.editor.insertIntoObjectList((FigObject)enumeration.nextElement());
        }
        this.objectCanvas.doFullRedraw();
        _stack.push(this);
        if (closeDialog == null) {
            closeDialog = new CloseCompoundDialog(this.editor.getFrame());
        }
        closeDialog.setModal(false);
        closeDialog.setVisible(true);
        closeDialog.pack();
        closeDialog.setModal(true);
    }

    public void undo() {
    }

    public void mousePressed(FigCanvasEvent figCanvasEvent) {
        this.message("-I- OCC: mousePressed...");
        Point point = figCanvasEvent.getWorldCoordinatePoint();
        Point point2 = figCanvasEvent.getScreenCoordinatePoint();
        FigObject figObject = this.editor.findObjectAt(point);
        if (figObject == null || !(figObject instanceof FigCompound)) {
            this.statusMessage("No compound at that position!  L: open compound");
            return;
        }
        this.compound = (FigCompound)figObject;
        this.execute();
        this.ready = true;
        this.notifyEditor();
    }

    public boolean isReady() {
        return this.ready;
    }

    public void showAllCompounds() {
        Enumeration enumeration = this.editor.getObjects();
        while (enumeration.hasMoreElements()) {
            FigObject figObject = (FigObject)enumeration.nextElement();
            if (figObject instanceof FigCompound) {
                figObject.showPoints();
                continue;
            }
            figObject.deselect();
        }
        this.objectCanvas.doFullRedraw();
    }

    public static void closeOneCompound() {
        try {
            OpenCompoundCommand openCompoundCommand = (OpenCompoundCommand)_stack.pop();
            openCompoundCommand.editor.hideAllObjectCorners();
            openCompoundCommand.compound = new FigCompound();
            openCompoundCommand.compound.setTrafo(openCompoundCommand.objectCanvas.getTrafo());
            Enumeration enumeration = openCompoundCommand.editor.getObjects();
            while (enumeration.hasMoreElements()) {
                openCompoundCommand.compound.fastAddMember((FigObject)enumeration.nextElement());
            }
            openCompoundCommand.compound.update_bbox();
            openCompoundCommand.editor.setEditorState(openCompoundCommand.state);
            openCompoundCommand.editor.insertIntoObjectList((FigObject)openCompoundCommand.compound);
            openCompoundCommand.objectCanvas.doFullRedraw();
        }
        catch (Throwable throwable) {
            System.err.println("-E- internal in closeOneCompound: " + throwable);
            throwable.printStackTrace();
        }
        if (_stack.isEmpty()) {
            closeDialog.setVisible(false);
        }
    }

    public static void closeAllCompounds() {
        System.err.println("-E- closeAllCompounds not yet!");
    }

    public String getDescription() {
        return "jfig idle command";
    }

    public String toString() {
        return "jfig.commands.OpenCompoundCommand";
    }

    public OpenCompoundCommand(FigBasicEditor figBasicEditor, FigCanvas figCanvas) {
        super(figBasicEditor, figCanvas);
        this.editor = (ModularEditor)figBasicEditor;
        if (figBasicEditor == null) {
            this.message("-E- OpenCompoundCommand.<init>: I need a ModularEditor,  but I got: " + this.editor);
            this.ready = true;
            return;
        }
        this.showAllCompounds();
        figCanvas.changeRubberbandMode(1);
        this.statusMessage("L: open compound");
        this.ready = false;
    }
}

