/*
 * Decompiled with CFR 0.152.
 */
package jfig.commands;

import java.awt.Point;
import java.util.Enumeration;
import jfig.canvas.FigCanvas;
import jfig.canvas.FigCanvasEvent;
import jfig.canvas.FigTrafo2D;
import jfig.commands.Command;
import jfig.commands.FigBasicEditor;
import jfig.objects.FigAttribs;
import jfig.objects.FigObject;
import jfig.objects.FigPolyline;
import jfig.utils.MouseMapper;

public class JoinSplitLinesCommand
extends Command {
    public static final int NONE = 0;
    public static final int JOIN = 1;
    public static final int SPLIT = 2;
    protected int n_points;
    protected int mode;
    protected FigObject line1;
    protected FigObject line2;
    protected FigObject line3;
    protected Point P1;
    protected Point P2;

    public FigObject[] getModifiedObjects() {
        FigObject[] figObjectArray = new FigObject[]{this.line1, this.line2, this.line3};
        return figObjectArray;
    }

    public void execute() {
        if (this.mode == 1) {
            this.editor.deleteFromObjectList(this.line1);
            this.editor.deleteFromObjectList(this.line2);
            this.editor.insertIntoObjectList(this.line3);
            this.editor.getUndoStack().push(this);
            this.objectCanvas.doFullRedraw();
        } else if (this.mode == 2) {
            this.editor.deleteFromObjectList(this.line1);
            this.editor.insertIntoObjectList(this.line2);
            this.editor.insertIntoObjectList(this.line3);
            this.editor.getUndoStack().push(this);
            this.objectCanvas.doFullRedraw();
        } else if (this.mode != 0) {
            throw new RuntimeException("-E- Unknown mode in JoinSplitLineCommand.execute: " + this.mode);
        }
    }

    public void undo() {
        if (this.mode == 1) {
            this.editor.insertIntoObjectList(this.line1);
            this.editor.insertIntoObjectList(this.line2);
            this.editor.deleteFromObjectList(this.line3);
            this.objectCanvas.doFullRedraw();
        } else if (this.mode == 2) {
            this.editor.insertIntoObjectList(this.line1);
            this.editor.deleteFromObjectList(this.line2);
            this.editor.deleteFromObjectList(this.line3);
            this.objectCanvas.doFullRedraw();
        } else if (this.mode != 0) {
            throw new RuntimeException("-E- Unknown mode in JoinSplitLineCommand.undo: " + this.mode);
        }
    }

    public void mousePressed(FigCanvasEvent figCanvasEvent) {
        Point point = figCanvasEvent.getWorldCoordinatePoint();
        Point point2 = figCanvasEvent.getScreenCoordinatePoint();
        FigPolyline figPolyline = this.findPolyline(point);
        if (this.mode == 1) {
            if (MouseMapper.isRightClick(figCanvasEvent)) {
                this.ready = true;
                this.notifyEditor();
                return;
            }
            if (figPolyline == null) {
                this.statusMessage("No polyline at that position. L: select line to join, R: cancel");
                return;
            }
            if (figPolyline.isClosed()) {
                this.statusMessage("Cannot join polygons. L: select line to join, R: cancel");
                return;
            }
            if (figPolyline == this.line1) {
                this.statusMessage("Cannot join a line with itself. L: select line to join, R: cancel");
                return;
            }
            this.line2 = figPolyline;
            this.P2 = new Point(point);
            this.join();
            this.execute();
            this.ready = true;
            this.notifyEditor();
            return;
        }
        if (MouseMapper.isMiddleClick(figCanvasEvent)) {
            if (figPolyline == null) {
                this.statusMessage("No line to split at that position.L: select line to join, M: select line to split, R: cancel");
                return;
            }
            if (figPolyline.isClosed()) {
                this.statusMessage("Cannot split polygons. L: select line to join, R: cancel");
                return;
            }
            this.P1 = new Point(point);
            this.line1 = figPolyline;
            this.split();
            return;
        }
        if (!MouseMapper.isRightClick(figCanvasEvent)) {
            if (figPolyline == null) {
                this.statusMessage("Please click the endpoint of the first line to join!");
                return;
            }
            if (figPolyline.isClosed()) {
                this.statusMessage("Cannot join polygons. L: select line to join, R: cancel");
                return;
            }
            this.P1 = new Point(point);
            this.line1 = figPolyline;
            this.mode = 1;
            this.statusMessage("L: start point of the second line to join, R: cancel");
            return;
        }
        this.ready = true;
        this.notifyEditor();
    }

    public FigPolyline findPolyline(Point point) {
        FigObject figObject = this.editor.findObjectAt(point);
        if (figObject instanceof FigPolyline) {
            return (FigPolyline)figObject;
        }
        return null;
    }

    public void join() {
        Point[] pointArray = this.line1.getPoints();
        int n = pointArray.length;
        Point point = pointArray[0];
        Point point2 = pointArray[n - 1];
        double d = this.distance(this.P1, point);
        double d2 = this.distance(this.P1, point2);
        boolean bl = d2 < d;
        Point[] pointArray2 = this.line2.getPoints();
        int n2 = pointArray2.length;
        Point point3 = pointArray2[0];
        Point point4 = pointArray2[n2 - 1];
        double d3 = this.distance(this.P2, point3);
        double d4 = this.distance(this.P2, point4);
        boolean bl2 = d4 > d3;
        FigTrafo2D figTrafo2D = this.objectCanvas.getTrafo();
        FigAttribs figAttribs = this.line1.getAttributes().getClone();
        Point[] pointArray3 = new Point[n + n2];
        int n3 = 0;
        while (n3 < n) {
            pointArray3[n3] = bl ? new Point(pointArray[n3]) : new Point(pointArray[n - n3 - 1]);
            ++n3;
        }
        n3 = 0;
        while (n3 < n2) {
            pointArray3[n + n3] = bl2 ? new Point(pointArray2[n3]) : new Point(pointArray2[n2 - n3 - 1]);
            ++n3;
        }
        this.line3 = new FigPolyline(pointArray3[0].x, pointArray3[0].y, false, figAttribs, figTrafo2D);
        this.line3.setPoints(pointArray3);
    }

    public void split() {
        FigPolyline figPolyline = (FigPolyline)this.line1;
        Point[] pointArray = this.line1.getPoints();
        int n = pointArray.length;
        double d = Double.MAX_VALUE;
        double d2 = Double.MAX_VALUE;
        int n2 = -1;
        int n3 = 0;
        while (n3 < n - 1) {
            d = figPolyline.getMinPerpendicularDistance(this.P1, pointArray[n3], pointArray[n3 + 1]);
            if (d < d2) {
                d2 = d;
                n2 = n3;
            }
            ++n3;
        }
        if (n2 == 0 || n2 == n - 2) {
            this.statusMessage("No use to split first/last segment");
            return;
        }
        Point[] pointArray2 = new Point[n2 + 1];
        int n4 = 0;
        while (n4 <= n2) {
            pointArray2[n4] = new Point(pointArray[n4]);
            ++n4;
        }
        FigTrafo2D figTrafo2D = this.objectCanvas.getTrafo();
        FigAttribs figAttribs = this.line1.getAttributes().getClone();
        this.line2 = new FigPolyline(pointArray2[0].x, pointArray2[0].y, false, figAttribs, figTrafo2D);
        this.line2.setPoints(pointArray2);
        Point[] pointArray3 = new Point[n - n2 - 1];
        int n5 = 0;
        while (n5 < n - n2 - 1) {
            pointArray3[n5] = new Point(pointArray[n2 + 1 + n5]);
            ++n5;
        }
        this.line3 = new FigPolyline(pointArray3[0].x, pointArray3[0].y, false, figAttribs, figTrafo2D);
        this.line3.setPoints(pointArray3);
        this.mode = 2;
        this.execute();
        this.ready = true;
        this.notifyEditor();
    }

    public double distance(Point point, Point point2) {
        return Math.sqrt((point.x - point2.x) * (point.x - point2.x) + (point.y - point2.y) * (point.y - point2.y));
    }

    public void showAllPolylineMarkers() {
        Enumeration enumeration = this.editor.getObjects();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (e instanceof FigPolyline) {
                FigPolyline figPolyline = (FigPolyline)e;
                if (figPolyline.isClosed()) {
                    figPolyline.deselect();
                    continue;
                }
                figPolyline.showPoints();
                continue;
            }
            ((FigObject)e).deselect();
        }
        this.editor.doRedraw();
    }

    public String getDescription() {
        return "cut point";
    }

    public String toString() {
        return "jfig.commands.JoinSplitLinesCommand[]";
    }

    public JoinSplitLinesCommand(FigBasicEditor figBasicEditor, FigCanvas figCanvas) {
        super(figBasicEditor, figCanvas);
        this.statusMessage("L:  Mark first line, M: split polyline at selected point");
        this.showAllPolylineMarkers();
        figCanvas.changeRubberbandMode(1);
        this.n_points = 0;
        this.mode = 0;
        this.ready = false;
    }
}

