/*
 * Decompiled with CFR 0.152.
 */
package jfig.commands;

import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import jfig.canvas.FigCanvas;
import jfig.canvas.FigCanvasEvent;
import jfig.canvas.FigTrafo2D;
import jfig.commands.Command;
import jfig.commands.FigBasicEditor;
import jfig.gui.FontCache;
import jfig.objects.FigAttribs;
import jfig.objects.FigObject;
import jfig.objects.FigText;
import jfig.utils.MouseMapper;

public class CreateTextCommand
extends Command
implements KeyListener {
    public static final int IDLE = 0;
    public static final int EDIT = 1;
    protected FigText textObject;
    protected String str;
    protected String newString;
    protected String oldString;
    protected boolean editExistingText;
    protected int textCursorIndex;
    protected Point P1;
    protected boolean debug = true;

    public FigObject[] getModifiedObjects() {
        FigObject[] figObjectArray = new FigObject[]{this.textObject};
        return figObjectArray;
    }

    public void cancel() {
        if (this.textObject != null) {
            this.execute();
        }
    }

    public void execute() {
        if (this.textObject == null) {
            return;
        }
        if (this.editExistingText) {
            if (this.newString != null) {
                this.textObject.setText(this.newString);
            }
        } else if (this.textObject.getText().length() == 0) {
            return;
        }
        this.textObject.showCursor(false);
        this.editor.deleteTmpObject(this.textObject);
        if (!this.editor.isInObjectList(this.textObject)) {
            this.editor.insertIntoObjectList(this.textObject);
        }
        this.objectCanvas.doFullRedraw();
        this.editor.getUndoStack().push(this);
        this.ready = true;
    }

    public void undo() {
        if (this.textObject == null) {
            return;
        }
        if (this.editExistingText) {
            this.textObject.setText(this.oldString);
        } else {
            this.editor.deleteFromObjectList(this.textObject);
        }
        this.objectCanvas.doFullRedraw();
    }

    public void mousePressed(FigCanvasEvent figCanvasEvent) {
        Point point = figCanvasEvent.getWorldCoordinatePoint();
        Point point2 = figCanvasEvent.getScreenCoordinatePoint();
        this.P1 = new Point(point);
        if (this.textObject != null) {
            this.executeAndStartNewText(figCanvasEvent);
            return;
        }
        if (MouseMapper.isRightClick(figCanvasEvent)) {
            this.textObject = this.findTextAt(this.P1);
            if (this.textObject == null) {
                this.statusMessage("No text to edit at that position!");
                return;
            }
            this.statusMessage("Edit existing text: \"" + this.textObject.getText() + "\"");
            this.editExistingText = true;
            this.oldString = new String(this.textObject.getText());
            this.textCursorIndex = this.textObject.initializeCursor(point2.x, point2.y);
            this.textObject.showCursor(true);
            this.editor.addTmpObject(this.textObject);
            this.editor.deleteFromObjectList(this.textObject);
            this.objectCanvas.doFullRedraw();
        } else {
            this.textObject = new FigText(this.P1, "", this.editor.getCurrentAttribs(), this.objectCanvas.getTrafo());
            this.textObject.showCursor(true);
            this.editor.addTmpObject(this.textObject);
        }
    }

    public void executeAndStartNewText() {
        this.newString = new String(this.textObject.getText());
        this.execute();
        this.notifyEditor();
        Command command = this.editor.getCurrentCommand();
        if (command instanceof CreateTextCommand) {
            Point point = this.getOriginOfNextLine(this.textObject);
            int n = point.x;
            int n2 = point.y;
            int n3 = this.objectCanvas.getTrafo().wc_to_screen_x(n);
            int n4 = this.objectCanvas.getTrafo().wc_to_screen_x(n2);
            command.mousePressed(FigCanvasEvent.fakeMousePressed(this.objectCanvas, new Point(n3, n4), new Point(n, n2), 0));
        }
    }

    public Point getOriginOfNextLine(FigText figText) {
        FigAttribs figAttribs = figText.getAttributes();
        FigTrafo2D figTrafo2D = this.objectCanvas.getTrafo();
        FontMetrics fontMetrics = FontCache.getFontCache().getFontMetrics(figAttribs.fig_font, (int)((double)figAttribs.fontSize * figTrafo2D.getZoom()));
        double d = 1.2 * (double)figTrafo2D.screen_to_wc(fontMetrics.getHeight());
        double d2 = 0.0;
        double d3 = figAttribs.fig_angle;
        double d4 = figText.getPosition().x;
        double d5 = figText.getPosition().y;
        double d6 = d4 + d2 * Math.cos(-d3) - d * Math.sin(-d3) + 0.5;
        double d7 = d5 + d2 * Math.sin(-d3) + d * Math.cos(-d3) + 0.5;
        return new Point((int)d6, (int)d7);
    }

    public void executeAndStartNewText(FigCanvasEvent figCanvasEvent) {
        this.newString = new String(this.textObject.getText());
        this.execute();
        this.notifyEditor();
        Command command = this.editor.getCurrentCommand();
        if (command instanceof CreateTextCommand) {
            command.mousePressed(figCanvasEvent);
        }
    }

    private FigText findTextAt(Point point) {
        FigObject figObject = this.editor.findObjectAt(point);
        if (figObject == null) {
            return null;
        }
        if (figObject instanceof FigText) {
            return (FigText)figObject;
        }
        return null;
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (this.textObject == null) {
            this.statusMessage("Click to specify a position for the text first!");
            return;
        }
        char c = keyEvent.getKeyChar();
        int n = keyEvent.getKeyCode();
        boolean bl = false;
        String string = this.textObject.getText();
        this.str = this.textObject.getText();
        if (keyEvent.isActionKey()) {
            if (n == 37) {
                --this.textCursorIndex;
                if (this.textCursorIndex < 0) {
                    this.textCursorIndex = 0;
                }
                bl = true;
            } else if (n == 39) {
                ++this.textCursorIndex;
                if (this.textCursorIndex >= this.str.length()) {
                    this.textCursorIndex = this.str.length();
                }
                bl = true;
            } else if (n != 38 && n != 40) {
                if (n == 10) {
                    this.executeAndStartNewText();
                } else if (n == 127) {
                    this.deleteChar();
                    bl = true;
                } else {
                    this.message("-#- CTC: ignoring action key: " + keyEvent);
                }
            }
        } else if (c == '\b' || c == '\b' || c == '\uff08') {
            if (this.str.length() == 0) {
                return;
            }
            if (this.textCursorIndex > 0) {
                this.str = this.str.substring(0, this.textCursorIndex - 1) + this.str.substring(this.textCursorIndex, this.str.length());
                --this.textCursorIndex;
                bl = true;
            }
        } else if (c == '\u007f' || c == '\uffff' || n == 127) {
            this.deleteChar();
            bl = true;
        } else {
            if (c == '\n' || c == '\r') {
                this.executeAndStartNewText();
                return;
            }
            if (c >= ' ' && c <= '\u00ff') {
                if (MouseMapper.isRightClick(keyEvent)) {
                    int n2 = c == 'a' ? 228 : (c == 'A' ? 196 : (c == 'o' ? 246 : (c == 'O' ? 214 : (c == 'u' ? 252 : (c == 'U' ? 220 : (c == 's' ? 223 : (int)c))))));
                    this.str = this.str.substring(0, this.textCursorIndex) + (char)n2 + this.str.substring(this.textCursorIndex, this.str.length());
                    ++this.textCursorIndex;
                } else {
                    char c2 = c;
                    this.str = this.str.substring(0, this.textCursorIndex) + c2 + this.str.substring(this.textCursorIndex, this.str.length());
                    ++this.textCursorIndex;
                }
            }
        }
        this.textObject.moveCursorTo(this.textCursorIndex);
        this.textObject.setText(this.str);
        this.textObject.update_bbox();
        this.textObject.build_sc_bbox();
        this.objectCanvas.doTextRedraw();
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    void deleteChar() {
        if (this.str.length() == 0) {
            return;
        }
        if (this.textCursorIndex < this.str.length() - 1) {
            this.str = this.str.substring(0, this.textCursorIndex) + this.str.substring(this.textCursorIndex + 1, this.str.length());
        } else if (this.textCursorIndex == this.str.length() - 1) {
            this.str = this.str.substring(0, this.textCursorIndex);
        } else {
            this.str = this.str.substring(0, this.str.length() - 1);
            this.textCursorIndex = this.str.length();
        }
    }

    public String getDescription() {
        return "create text";
    }

    public String toString() {
        return "jfig.commands.CreateTextCommand[]";
    }

    public CreateTextCommand(FigBasicEditor figBasicEditor, FigCanvas figCanvas) {
        super(figBasicEditor, figCanvas);
        this.statusMessage("L: base point of new text, R: edit existing text object");
        figBasicEditor.hideAllObjectCorners();
        figCanvas.changeRubberbandMode(1);
        this.textObject = null;
        this.oldString = null;
        this.newString = null;
        this.editExistingText = false;
        this.ready = false;
    }
}

