/*
 * Decompiled with CFR 0.152.
 */
package hades.utils;

import hades.models.Design;
import hades.signals.Signal;
import java.util.Enumeration;

public class SignalEnumerator
implements Enumeration {
    Enumeration activeEnum;
    Enumeration components;

    public SignalEnumerator(Design design) {
        this.activeEnum = design.getSignals();
        this.components = design.getComponents();
    }

    public boolean hasMoreElements() {
        if (this.activeEnum.hasMoreElements()) {
            return true;
        }
        this.getNextEnumeration();
        return this.activeEnum.hasMoreElements();
    }

    public Object nextElement() {
        if (this.activeEnum.hasMoreElements()) {
            return this.activeEnum.nextElement();
        }
        this.getNextEnumeration();
        return this.activeEnum.nextElement();
    }

    private void getNextEnumeration() {
        while (this.components.hasMoreElements()) {
            SignalEnumerator se;
            Object tmp = this.components.nextElement();
            if (!(tmp instanceof Design) || !(se = new SignalEnumerator((Design)tmp)).hasMoreElements()) continue;
            this.activeEnum = se;
            return;
        }
    }

    public static String printAllSignals(Design toplevel) {
        SignalEnumerator se = new SignalEnumerator(toplevel);
        StringBuffer buffer = new StringBuffer();
        buffer.append("Signals of Design " + toplevel + ":\n");
        while (se.hasMoreElements()) {
            Signal signal = (Signal)se.nextElement();
            buffer.append("" + signal + "\n");
        }
        return buffer.toString();
    }
}

