/*
 * Decompiled with CFR 0.152.
 */
package hades.utils;

import hades.gui.Editor;
import hades.models.Design;
import hades.models.io.Ipin;
import jfig.utils.SetupManager;

public class RunHadesDemo {
    public static void sleep(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (Exception e) {}
    }

    public static void main(String[] argv) {
        SetupManager.loadGlobalProperties("hades/.hadesrc");
        SetupManager.loadUserProperties(".hadesrc");
        SetupManager.loadLocalProperties(".hadesrc");
        SetupManager.setProperty("Hades.Editor.AutoStartSimulation", "false");
        Editor editor = new Editor();
        editor.getFrame().setBounds(100, 100, 700, 500);
        RunHadesDemo.sleep(2000);
        editor.doOpenDesign("/hades/examples/simple/dlatch.hds", true);
        Design design = editor.getDesign();
        String[] signalNames = new String[]{"D", "C", "Q", "NQ"};
        int i = 0;
        while (i < signalNames.length) {
            editor.addProbeToSignal(signalNames[i]);
            ++i;
        }
        editor.doShowWaves();
        editor.getWaveformViewer().setBounds(450, 50, 500, 400);
        editor.setGlowMode(true);
        design.getSignal("NQ").setGlowMode(false);
        editor.getSimulator().runForever();
        Ipin dataPin = (Ipin)design.getComponent("D");
        Ipin clkPin = (Ipin)design.getComponent("C");
        dataPin.assign("1", 1.0);
        clkPin.assign("0", 2.0);
        clkPin.assign("1", 2.5);
        dataPin.assign("0", 3.5);
        clkPin.assign("0", 4.0);
        clkPin.assign("1", 4.0000000001);
        RunHadesDemo.sleep(5000);
        editor.getWaveformViewer().updateTrafo();
        editor.getWaveformViewer().getWaveCanvas().zoomFit();
        editor.getWaveformViewer().redraw();
    }
}

