/*
 * Decompiled with CFR 0.152.
 */
package hades.symbols;

import hades.gui.Console;
import hades.simulator.SimObject;
import hades.symbols.Symbol;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

public class SymbolManager
implements Serializable {
    private static boolean debug = false;
    private static SymbolManager _symbolManager;
    private Hashtable _symbolCache;

    public static SymbolManager getSymbolManager() {
        if (_symbolManager == null) {
            _symbolManager = new SymbolManager();
            return _symbolManager;
        }
        return _symbolManager;
    }

    private SymbolManager() {
        if (debug) {
            this.message("-I- SymbolManager<init>: created the hashtable!");
        }
        this._symbolCache = new Hashtable();
    }

    public Symbol getSymbol(SimObject simObject) {
        if (simObject == null) {
            return null;
        }
        this.checkCreateSymbolCache();
        try {
            String key = simObject.getClass().getName() + "@" + simObject.getSymbolResourceName();
            if (debug) {
                this.message("-I- SM.getSymbol() for class " + simObject);
            }
            if (debug) {
                this.message("-I- SM: key is '" + key + "'");
            }
            if (simObject.needsDynamicSymbol()) {
                key = key + "@" + simObject.hashCode();
                if (debug) {
                    this.message("-I- SymbolManager: loading dynamic Symbol for '" + key + "'");
                }
                simObject.constructDynamicSymbol();
                Symbol tmp = simObject.getSymbol();
                if (tmp.getParent() == null) {
                    tmp.setParent(simObject);
                }
                this._symbolCache.put(key, tmp);
                return tmp;
            }
            if (this._symbolCache.containsKey(key)) {
                return this.getCachedSymbol(simObject, key);
            }
            this.initializeSymbol(simObject, key);
            return this.getCachedSymbol(simObject, key);
        }
        catch (RuntimeException re) {
            this.message("-E- SymbolManager: Internal error for class: " + simObject);
            return null;
        }
    }

    private void checkCreateSymbolCache() {
        if (this._symbolCache == null) {
            this._symbolCache = new Hashtable();
        }
    }

    private Symbol getCachedSymbol(SimObject simObject, String key) {
        Symbol master = (Symbol)this._symbolCache.get(key);
        Symbol carbon = (Symbol)master.copy();
        carbon.setParent(simObject);
        return carbon;
    }

    private Symbol initializeSymbol(SimObject simObject, String key) {
        Symbol tmp = null;
        if (simObject.needsDynamicSymbol()) {
            this.message("-E- internal: shouldn't load a 'dynamic symbol' for '" + key + "' from the symbol cache!");
            return null;
        }
        tmp = new Symbol();
        tmp.initializeFromResource(simObject);
        this._symbolCache.put(key, tmp);
        if (debug) {
            this.message("-I- getSymbol(): initialized Symbol is: " + tmp);
        }
        return tmp;
    }

    public Enumeration elements() {
        this.checkCreateSymbolCache();
        return this._symbolCache.elements();
    }

    public Enumeration keys() {
        this.checkCreateSymbolCache();
        return this._symbolCache.keys();
    }

    public void flushSymbolCache() {
        this._symbolCache = new Hashtable();
    }

    public void setDebug(boolean _debug) {
        debug = _debug;
    }

    public void message(String msg) {
        Console.getConsole().message(msg);
    }

    public String toString() {
        return "hades.symbols.SymbolManager";
    }
}

