/*
 * Decompiled with CFR 0.152.
 */
package hades.symbols;

import hades.symbols.Polyline;
import java.awt.Color;
import java.awt.Point;
import java.io.PrintWriter;
import java.io.Serializable;
import jfig.objects.FigAttribs;
import jfig.utils.SetupManager;

public class HighlightWireSegment
extends Polyline
implements Serializable {
    public HighlightWireSegment() {
        this.build_attribs();
    }

    protected void build_attribs() {
        Color highlightColor;
        FigAttribs attribs = new FigAttribs();
        attribs.lineColor = highlightColor = SetupManager.getColor("Hades.Editor.HighlightColor", Color.cyan);
        attribs.fillColor = highlightColor;
        attribs.fig_fill_color = 1;
        attribs.fig_line_color = 1;
        attribs.fillStyle = 2;
        attribs.currentLayer = 1;
        attribs.lineWidth = 200.0;
        attribs.arrowMode = 0;
        attribs.lineStyle = 0;
        attribs.cornerRadius = 0;
        super.setAttributes(attribs);
    }

    public double getEuclideanDistance(Point wp) {
        Point[] points = this.getPoints();
        int dx = points[1].x - points[0].x;
        int dy = points[1].y - points[0].y;
        int dx1 = wp.x - points[1].x;
        int dy1 = wp.y - points[1].y;
        int dx0 = wp.x - points[0].x;
        int dy0 = wp.y - points[0].y;
        double frac = Math.sqrt(dx0 * dx0 + dy0 * dy0) + Math.sqrt(dx1 * dx1 + dy1 * dy1);
        return frac /= Math.sqrt(dx * dx + dy * dy);
    }

    public void writeAsResource(PrintWriter ps) {
        Point[] pp = this.getPoints();
        String s = this.getClass().getName() + " " + pp.length;
        int i = 0;
        while (i < pp.length) {
            s = s + " " + pp[i].x + " " + pp[i].y;
            ++i;
        }
        ps.println(s);
    }

    public String toString() {
        return "HighlightWireSegment[" + super.toString() + "]";
    }
}

