/*
 * Decompiled with CFR 0.152.
 */
package hades.symbols;

import hades.gui.Console;
import hades.manager.DesignManager;
import hades.simulator.SimObject;
import java.awt.Point;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.StringTokenizer;
import jfig.gui.ConsoleMessage;
import jfig.objects.FigAttribs;
import jfig.objects.FigCompound;
import jfig.objects.FigObject;
import jfig.objects.FigParser;
import jfig.utils.ExceptionTracer;

public class FigWrapper
extends FigCompound
implements Serializable,
ConsoleMessage {
    public boolean debug = false;
    public static final int FIG_LAYER = 300;
    private Point position;
    private String filename;
    private SimObject parent;

    public FigWrapper() {
        this.setLayer(300);
    }

    public void setLayer(int layer) {
        FigAttribs attr = this.getAttributes();
        attr.currentLayer = layer;
        this.setAttributes(attr);
    }

    public void setSimObject(SimObject parent) {
        this.parent = parent;
    }

    public boolean initialize(String s) {
        int x = 0;
        int y = 0;
        String filename = null;
        try {
            StringTokenizer st = new StringTokenizer(s);
            x = Integer.parseInt(st.nextToken());
            y = Integer.parseInt(st.nextToken());
            this.position = new Point(x, y);
            filename = st.nextToken();
            this.parseFigFile(filename);
            this.update_bbox();
            this.setLayer(300);
        }
        catch (Exception e) {
            this.message("-E- FigWrapper.initialize: " + e);
            this.message("-E- offending String is: '" + s + "'");
            ExceptionTracer.trace(e);
        }
        this.move(x, y);
        return true;
    }

    public void update_bbox() {
        super.update_bbox();
        this.setLayer(300);
    }

    public void parseFigFile(String filename) {
        if (filename == null) {
            this.message("-W- FigWrapper.parseFigFile: cannot parse null filename");
            return;
        }
        try {
            InputStream is = DesignManager.getDesignManager().getInputStream(this.parent, filename);
            if (is == null) {
                this.message(" -W- FigWrapper.parseFigFile: file not found: " + filename);
                return;
            }
            FigParser parser = new FigParser();
            parser.setConsole(this);
            parser.parse_fig_file(is, true, false, this.getAttributes(), this.getTrafo(), this.getMembers());
            is.close();
        }
        catch (Exception e) {
            this.message("-E- FigWrapper.parseFigFile(): " + e);
            ExceptionTracer.trace(e);
        }
    }

    public void writeAsResource(PrintWriter ps) {
        String s = this.getClass().getName() + " " + this.position.x + " " + this.position.y + " " + this.filename;
        ps.println(s);
    }

    public FigObject copy() {
        FigWrapper carbon = new FigWrapper();
        carbon.position = this.position;
        carbon.filename = this.filename;
        carbon.setTrafo(this.getTrafo());
        Enumeration e = this.getMembers().elements();
        while (e.hasMoreElements()) {
            FigObject tmp = (FigObject)e.nextElement();
            carbon.fastAddMember(tmp.copy());
        }
        carbon.update_bbox();
        carbon.setAttributes(this.getAttributes().getClone());
        if (carbon.getAttributes().currentLayer != 300) {
            System.err.println("-W- internal: FigWrapper has wrong layer: " + carbon.getAttributes().currentLayer);
        }
        return carbon;
    }

    public void consoleMessage(String msg) {
        if (this.debug) {
            Console.getConsole().println("FigWrapper: " + msg);
        }
    }

    public String toString() {
        return "FigWrapper[" + super.toString() + "]";
    }
}

