/*
 * Decompiled with CFR 0.152.
 */
package hades.symbols;

import hades.symbols.Label;
import java.awt.Point;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import jfig.gui.ColorCache;
import jfig.objects.FigAttribs;
import jfig.objects.FigObject;

public class FatLabel
extends Label {
    public FatLabel() {
        this.build_attribs();
    }

    protected void build_attribs() {
        FigAttribs attribs = this.getAttributes().getClone();
        attribs.lineColor = attribs.fillColor = ColorCache.getColorCache().get(0);
        attribs.fillStyle = 1;
        attribs.currentLayer = 10;
        attribs.fig_font = 16;
        this.setAttributes(attribs);
    }

    public boolean initialize(String s) {
        int x = 0;
        int y = 0;
        String label = null;
        try {
            StringTokenizer st = new StringTokenizer(s);
            int fontSize = 30;
            int align = 1;
            int n_tokens = st.countTokens();
            if (n_tokens == 5) {
                x = Integer.parseInt(st.nextToken());
                y = Integer.parseInt(st.nextToken());
                align = Integer.parseInt(st.nextToken());
                fontSize = Integer.parseInt(st.nextToken());
                label = st.nextToken();
            } else if (n_tokens == 4) {
                x = Integer.parseInt(st.nextToken());
                y = Integer.parseInt(st.nextToken());
                align = Integer.parseInt(st.nextToken());
                label = st.nextToken();
            } else if (n_tokens == 3) {
                x = Integer.parseInt(st.nextToken());
                y = Integer.parseInt(st.nextToken());
                label = st.nextToken();
            } else {
                throw new Exception("too few arguments to Label.initialize: " + s);
            }
            FigAttribs attr = this.getAttributes();
            attr.textAlign = align;
            attr.fontSize = fontSize;
            this.setAttributes(attr);
        }
        catch (Exception e) {
            System.err.println("" + e);
        }
        super.setText(label);
        this.move(x, y);
        return true;
    }

    public void writeAsResource(PrintWriter ps) {
        Point[] wcp = this.getPoints();
        int x = wcp[0].x;
        int y = wcp[0].y;
        String s = this.getClass().getName() + " " + x + " " + y + " ";
        int align = this.getAttributes().textAlign;
        if (align != 1) {
            s = s + align + " ";
        }
        int fontsize = this.getAttributes().fontSize;
        s = s + fontsize + " " + this.getText();
        ps.println(s);
    }

    public FigObject copy() {
        FatLabel carbon = new FatLabel();
        carbon.setAttributes(this.getAttributes().getClone());
        carbon.setText(this.getText());
        Point[] pp = this.getPoints();
        carbon.move(pp[0].x, pp[0].y);
        return carbon;
    }

    public String toString() {
        return "FatLabel[" + super.toString() + "]";
    }
}

