/*
 * Decompiled with CFR 0.152.
 */
package hades.symbols;

import java.awt.Color;
import java.awt.Point;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.StringTokenizer;
import jfig.gui.ColorCache;
import jfig.objects.FigAttribs;
import jfig.objects.FigObject;
import jfig.objects.FigPolyline;

public class ClockArm
extends FigPolyline
implements Serializable {
    protected int x;
    protected int y;
    protected int radius;
    protected double angle;

    public ClockArm() {
        this.build_attribs();
    }

    public boolean initialize(String s) {
        try {
            StringTokenizer st = new StringTokenizer(s);
            Point[] pp = new Point[2];
            this.x = Integer.parseInt(st.nextToken());
            this.y = Integer.parseInt(st.nextToken());
            pp[0] = new Point(this.x, this.y);
            this.radius = Integer.parseInt(st.nextToken());
            this.angle = new Double(st.nextToken());
            pp[1] = new Point(this.x + (int)((double)this.radius * Math.cos(this.angle)), this.y - (int)((double)this.radius * Math.sin(this.angle)));
            super.setPoints(pp);
        }
        catch (Exception e) {
            System.err.println(this.toString() + ".initialize():" + e);
        }
        return true;
    }

    protected void build_attribs() {
        FigAttribs attribs = new FigAttribs();
        attribs.lineColor = attribs.fillColor = ColorCache.getColorCache().get(12);
        attribs.fig_fill_color = 12;
        attribs.fig_line_color = 12;
        attribs.fillStyle = 1;
        attribs.fig_fill_color = 12;
        attribs.fig_line_color = 12;
        attribs.currentLayer = 15;
        attribs.lineWidth = 90.0;
        attribs.arrowMode = 0;
        attribs.lineStyle = 0;
        super.setAttributes(attribs);
    }

    public synchronized void setRotationAngle(double angle) {
        this.angle = angle;
        Point[] pp = super.getPoints();
        pp[0].x = this.x;
        pp[0].y = this.y;
        pp[1].x = this.x + (int)((double)this.radius * Math.cos(angle));
        pp[1].y = this.y - (int)((double)this.radius * Math.sin(angle));
        super.setPoints(pp);
    }

    public void setLineWidth(int width) {
        FigAttribs attribs = this.getAttributes();
        attribs.lineWidth = width;
        this.setAttributes(attribs);
    }

    public void setColor(Color c) {
        FigAttribs attribs = this.getAttributes();
        attribs.lineColor = c;
        attribs.fig_line_color = 12;
        this.setAttributes(attribs);
    }

    public void writeAsResource(PrintWriter ps) {
        String s = this.getClass().getName() + " " + this.x + " " + this.y + " " + this.radius + " " + this.angle;
        ps.println(s);
    }

    public FigObject copy() {
        ClockArm carbon = new ClockArm();
        carbon.setPoints(this.getPoints());
        carbon.setAttributes(this.getAttributes().getClone());
        carbon.x = this.x;
        carbon.y = this.y;
        carbon.radius = this.radius;
        carbon.angle = this.angle;
        return carbon;
    }

    public void move(int dx, int dy) {
        this.x += dx;
        this.y += dy;
        super.move(dx, dy);
    }

    public String toString() {
        return "ClockArm[" + super.toString() + "]";
    }
}

