/*
 * Decompiled with CFR 0.152.
 */
package hades.styx;

import hades.styx.Transformation;
import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jfig.utils.SetupManager;

public class TimePanel
extends JPanel {
    double deltat;
    double xMax;
    double tLeft;
    double tRight;
    double t;
    double t2;
    double xRes;
    double timestep;
    double timestep2;
    int x;
    int oldX;
    int i;
    int mark1;
    int mark2;
    Transformation trafo;
    String s;
    String Zeit;
    String str;
    private JLabel scaleLabel;

    public TimePanel(Transformation transformation) {
        this.trafo = transformation;
        this.scaleLabel = new JLabel();
        this.oldX = 0;
        this.str = "";
        this.setBackground(SetupManager.getColor("Hades.WaveformViewer.TimePanel.BackgroundColor", this.getBackground()));
    }

    public static void err(String string) {
        System.out.println("timepanel() -> " + string);
    }

    public void paint(Graphics graphics) {
        this.deltat = this.trafo.getDeltaT();
        this.xMax = this.trafo.getxMax();
        this.tLeft = this.trafo.getTLeft();
        this.tRight = this.trafo.getTRight();
        this.xRes = this.trafo.getXRes();
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
        graphics.setColor(Color.black);
        graphics.drawLine(0, 30, (int)this.xMax, 30);
        if (this.xRes > 1.3E8) {
            this.timestep = 1.0E-6;
            this.Zeit = "1 ns";
        } else if (this.xRes > 1.1E7) {
            this.timestep = 1.0E-5;
            this.Zeit = "10 ns";
        } else if (this.xRes > 800000.0) {
            this.timestep = 1.0E-4;
            this.Zeit = "100 ns";
        } else if (this.xRes > 60000.0) {
            this.timestep = 0.001;
            this.Zeit = "1 ms";
        } else if (this.xRes > 6000.0) {
            this.timestep = 0.01;
            this.Zeit = "10 ms";
        } else if (this.xRes > 500.0) {
            this.timestep = 0.1;
            this.Zeit = "100 ms";
        } else if (this.xRes > 30.0) {
            this.timestep = 1.0;
            this.Zeit = "1 s";
        } else if (this.xRes > 3.0) {
            this.timestep = 10.0;
            this.Zeit = "10 s";
        } else if (this.xRes > 0.3) {
            this.timestep = 100.0;
            this.Zeit = "100 s";
        }
        this.timestep2 = this.timestep / 10.0;
        this.t = Math.floor(this.tLeft / this.timestep) * this.timestep;
        while (this.tRight >= this.t) {
            this.t2 = this.t;
            while (this.t2 < this.t + this.timestep) {
                this.x = this.trafo.transformT(this.t2);
                if (this.x >= 0) {
                    graphics.drawLine(this.x, 25, this.x, 30);
                }
                this.t2 += this.timestep2;
            }
            this.x = this.trafo.transformT(this.t);
            if (this.x >= 0) {
                graphics.drawLine(this.x, 22, this.x, 30);
                this.s = String.valueOf(Math.floor(this.t / this.timestep));
                graphics.drawString(this.s, this.x - 3, 19);
            }
            this.t += this.timestep;
        }
        this.scaleLabel.setText("Timescale: " + this.Zeit);
        this.oldX = 0;
    }
}

