/*
 * Decompiled with CFR 0.152.
 */
package hades.simulator;

import hades.gui.Console;
import hades.gui.Editor;
import hades.gui.PropertySheet;
import hades.manager.DesignManager;
import hades.models.Design;
import hades.simulator.Port;
import hades.simulator.SimKernel;
import hades.simulator.Simulatable;
import hades.symbols.Symbol;
import hades.utils.ContextToolTip;
import hades.utils.NameMangler;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;

public class SimObject
implements Simulatable,
ContextToolTip,
Cloneable,
Serializable {
    protected Port[] ports = new Port[0];
    protected String name = "i0";
    protected long versionId = 1001L;
    protected SimObject parent = null;
    protected SimKernel simulator = null;
    protected Editor editor = null;
    protected ClassLoader classloader = null;
    protected Symbol symbol;
    protected boolean visible = false;
    protected Console console;
    protected PropertySheet propertySheet;
    protected static boolean debug = false;

    public ClassLoader getClassLoader() {
        return this.classloader;
    }

    public void setClassLoader(ClassLoader CL) {
        this.classloader = CL;
    }

    public InputStream getResourceAsStream(String s) {
        System.err.println("-#- SimObject.gRAS: " + s);
        String classname = this.getClass().getName();
        String qualifiedname = null;
        if (s.startsWith("/")) {
            qualifiedname = s;
        } else if (classname.indexOf(46) > 0) {
            qualifiedname = classname.substring(0, classname.lastIndexOf(46) + 1);
            qualifiedname = '/' + qualifiedname.replace('.', '/') + s;
        } else {
            qualifiedname = s;
        }
        InputStream IS = DesignManager.getDesignManager().getResourceAsStream(qualifiedname);
        if (IS == null) {
            System.err.println("-E- SimObject.getResourceAsStream failed for `" + s + "' `" + qualifiedname + "'");
        }
        return IS;
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        if (this.parent == null) {
            return "/" + this.name;
        }
        String tmp = this.parent.getFullName();
        if (tmp.equals("")) {
            return this.name;
        }
        return this.parent.getFullName() + "/" + this.name;
    }

    public void setName(String s) {
        if (s.equals(this.name)) {
            return;
        }
        s = NameMangler.getValidName(s);
        if (this.parent != null && this.parent instanceof Design) {
            Design design = (Design)this.parent;
            this.name = design.changeComponentName(this, s);
        } else {
            this.name = s;
        }
        this.name = this.name.intern();
        if (debug) {
            this.message(this.getClass().getName() + " setName: " + this.name);
        }
        if (this.getSymbol() != null) {
            this.getSymbol().setInstanceLabel(this.name);
        }
    }

    public SimObject getParent() {
        return this.parent;
    }

    public void setParent(SimObject parent) {
        this.parent = parent;
    }

    public Editor getEditor() {
        return this.editor;
    }

    public void setEditor(Editor editor) {
        this.editor = editor;
    }

    public SimKernel getSimulator() {
        return this.simulator;
    }

    public void setSimulator(SimKernel sim) {
        this.simulator = sim;
    }

    public Port[] getPorts() {
        return this.ports;
    }

    public void setPorts(Port[] ports) {
        this.ports = ports;
    }

    public Port getPort(String name) {
        int i = 0;
        while (i < this.ports.length) {
            if (this.ports[i].getName().equals(name)) {
                return this.ports[i];
            }
            ++i;
        }
        return null;
    }

    public boolean needsExternalResources() {
        return false;
    }

    public String[] getExternalResources() {
        return new String[0];
    }

    public String getSymbolResourceName() {
        String tmp = this.getClass().getName();
        return "/" + tmp.replace('.', '/') + ".sym";
    }

    public Symbol getSymbol() {
        return this.symbol;
    }

    public void setSymbol(Symbol symbol) {
        this.symbol = symbol;
        this.symbol.setInstanceLabel(this.getName());
    }

    public boolean needsDynamicSymbol() {
        return false;
    }

    public void constructDynamicSymbol() {
        this.message("-W- SimObject: you should not call constructDynamicSymbol()!");
    }

    public void setVisible(boolean v) {
        this.visible = v;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setDebug(boolean d) {
        debug = d;
    }

    public boolean getDebug() {
        return debug;
    }

    public long getVersionId() {
        return this.versionId;
    }

    public void setVersionId(long _id) {
        this.versionId = _id;
    }

    public boolean initialize(String s) {
        if (debug) {
            this.message("-W- SimObject: nothing to initialize...");
        }
        return true;
    }

    public void write(PrintWriter ps) {
        ps.print(" " + this.versionId);
    }

    public void elaborate(Object arg) {
        this.message("-W-" + this.toString() + ".elaborate() not implemented!");
    }

    public void evaluate(Object arg) {
        System.err.println(this.toString() + ".evaluate()");
    }

    public void tearDown() {
        if (debug) {
            System.err.println("-#- SimObject.tearDown: " + this.toString());
        }
        if (this.ports != null) {
            int i = 0;
            while (i < this.ports.length) {
                this.ports[i].tearDown();
                ++i;
            }
        }
        this.classloader = null;
        this.console = null;
        this.editor = null;
        if (this.symbol != null) {
            this.symbol.deleteAllMembers();
        }
        this.symbol = null;
        this.simulator = null;
        this.ports = null;
        this.parent = null;
        this.name = null;
        if (this.propertySheet != null) {
            this.propertySheet.tearDown();
        }
        this.propertySheet = null;
    }

    public void configure() {
        String[] fields = new String[]{"instance name:", "name"};
        this.propertySheet = PropertySheet.getPropertySheet(this, fields);
        this.propertySheet.setHelpText("");
        this.propertySheet.setVisible(true);
    }

    public Component getPropertySheet() {
        return this.propertySheet;
    }

    public void mousePressed(MouseEvent me) {
        this.message("-W- SimObject.mousePressed()... ignored.");
    }

    public void keyPressed(KeyEvent ke) {
        this.message("-W- SimObject.keyPressed()... ignored.");
    }

    public String getBindkey() {
        return null;
    }

    public SimObject copy() {
        SimObject tmp = null;
        try {
            tmp = (SimObject)this.getClass().newInstance();
            tmp.setEditor(this.getEditor());
            tmp.setVisible(this.isVisible());
            tmp.setName(this.getName());
            tmp.setClassLoader(this.getClassLoader());
            tmp.setVersionId(this.getVersionId());
            return tmp;
        }
        catch (Exception e) {
            this.message("-E- Internal error in SimObject.copy(): " + e);
            return null;
        }
    }

    public void message(String msg) {
        if (this.console == null) {
            this.console = Console.getConsole();
        }
        if (this.console != null) {
            this.console.message(msg);
        } else {
            System.err.println(msg);
        }
    }

    public void setConsole(Console console) {
        this.console = console;
    }

    public String getToolTip(Point position, long millis) {
        return this.getName() + "\n" + this.getClass().getName();
    }

    public String toString() {
        String className = this.getClass().getName();
        return className + ": " + this.getFullName();
    }
}

