/*
 * Decompiled with CFR 0.152.
 */
package hades.simulator;

import hades.models.Const1164;
import hades.models.StdLogic1164;
import hades.simulator.SimEvent;
import hades.simulator.Simulatable;
import hades.utils.TimeFormatter;
import java.io.Serializable;
import jfig.utils.ExceptionTracer;

public class SimEvent1164
extends SimEvent
implements Serializable {
    public static final Const1164[] __const1164 = new Const1164[]{Const1164.__U, Const1164.__X, Const1164.__0, Const1164.__1, Const1164.__Z, Const1164.__W, Const1164.__L, Const1164.__H, Const1164.__D};
    private boolean isActive = false;
    private static long global_id = 0L;
    private static boolean debug = false;
    public static boolean enable_recycling = true;
    public static int STACK_SIZE = 500;
    public static int STACK_SIZE_1 = STACK_SIZE - 1;
    private static SimEvent1164[] recycleStack = new SimEvent1164[STACK_SIZE];
    private static int stackPointer = 0;
    private static long n_recycled = 0L;
    private static long n_new = 0L;
    private static long n_available = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SimEvent1164 createNewSimEvent(Simulatable target, double time, StdLogic1164 arg, Object source) {
        SimEvent1164[] simEvent1164Array = recycleStack;
        synchronized (recycleStack) {
            if (enable_recycling && n_available > 0L) {
                try {
                    SimEvent1164 recycled = recycleStack[--stackPointer];
                    recycled.id = global_id++;
                    recycled.target = target;
                    recycled.time = time;
                    recycled.arg = __const1164[arg.intValue()];
                    recycled.source = source;
                    recycled.targetPort = null;
                    recycled.isActive = true;
                    ++n_recycled;
                    --n_available;
                    // ** MonitorExit[var5_4] (shouldn't be in output)
                    return recycled;
                }
                catch (Exception e) {
                    ExceptionTracer.message("-E- in SimEvent1164.createNewSimEvent: " + e + "\n" + "resetting the recycle stack");
                    n_available = 0L;
                    // ** MonitorExit[var5_4] (shouldn't be in output)
                    return new SimEvent1164(target, time, arg, source);
                }
            }
            SimEvent1164 tmp = new SimEvent1164(target, time, arg, source);
            if (debug) {
                SimEvent1164.msg("-#- SimEvent1164.create: creating new event");
                SimEvent1164.msg(tmp.toString());
            }
            // ** MonitorExit[var5_4] (shouldn't be in output)
            return tmp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void recycle() {
        if (!enable_recycling) return;
        if (!this.isActive) {
            SimEvent1164.msg("-E- SimEvent1164.recycle: internal error: double freed!");
            SimEvent1164.msg("..." + this.toString());
            Thread.dumpStack();
            return;
        }
        SimEvent1164[] simEvent1164Array = recycleStack;
        synchronized (recycleStack) {
            if (n_available >= (long)STACK_SIZE_1) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.isActive = false;
            SimEvent1164.recycleStack[SimEvent1164.stackPointer++] = this;
            ++n_available;
            if (!debug) return;
            SimEvent1164.msg("-#- SimEvent114.recycle: n_available=" + n_available);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public SimEvent1164(Simulatable target, double time, StdLogic1164 arg, Object source) {
        this.id = global_id++;
        ++n_new;
        this.source = source;
        this.target = target;
        this.time = time;
        this.arg = __const1164[arg.intValue()];
        this.isActive = true;
    }

    public SimEvent1164(Simulatable target, double time, Object arg, Object source) {
        SimEvent1164.msg("-W- wrong constructor!");
        this.id = global_id++;
        ++n_new;
        this.source = source;
        this.target = target;
        this.time = time;
        this.isActive = true;
        if (arg instanceof StdLogic1164) {
            this.arg = __const1164[((StdLogic1164)arg).intValue()];
        } else {
            this.arg = Const1164.__U;
            System.err.println("-E- <SimEvent1164>: arg is not of type StdLogic1164" + arg);
        }
    }

    public static long getNumberOfAvailableRecycledSimEvents() {
        return n_available;
    }

    public static long getNumberOfRecycledSimEvents() {
        return n_recycled;
    }

    public static long getNumberOfSimEvents() {
        return global_id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearRecycleStack() {
        SimEvent1164[] simEvent1164Array = recycleStack;
        synchronized (recycleStack) {
            int i = 0;
            while (i < STACK_SIZE) {
                SimEvent1164.recycleStack[i] = null;
                ++i;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static void msg(String s) {
        System.err.println(s);
    }

    public String toString() {
        return "SimEvent1164_" + this.id + "[" + "\n value: " + (this.arg != null ? this.arg : null) + "\n from:  " + this.source + "\n for:   " + this.target + "\n at:    " + TimeFormatter.format(this.time) + " sec." + "\n]";
    }

    static {
        if (!enable_recycling) {
            SimEvent1164.msg("\n\n-W- SimEvent1164: event recycling is disabled!");
        }
    }
}

