/*
 * Decompiled with CFR 0.152.
 */
package hades.simulator;

import hades.models.StdLogic1164;
import hades.signals.Signal;
import hades.simulator.Port;
import hades.simulator.Simulatable;
import hades.utils.TimeFormatter;
import java.io.Serializable;

public class SimEvent
implements Serializable {
    public static boolean enable_recycling = false;
    protected Object source;
    protected double time;
    protected Object arg;
    protected Simulatable target;
    protected Port targetPort;
    protected long id = 0L;
    private static long global_id = 0L;
    private static boolean debug = false;
    public static int STACK_SIZE = 2000;
    private static SimEvent[] recycleStack = new SimEvent[STACK_SIZE];
    private static int stackPointer = 0;
    private static long n_recycled = 0L;
    private static long n_available = 0L;

    public static SimEvent createNewSimEvent(Simulatable target, double time, Object arg) {
        return SimEvent.getRecycledSimEvent(target, time, arg);
    }

    public static SimEvent createNewSimEvent(Simulatable target, double time, Object arg, Object source) {
        return SimEvent.getRecycledSimEvent(target, time, arg, source);
    }

    public void recycle() {
        if (enable_recycling && n_available < (long)STACK_SIZE) {
            SimEvent.recycleStack[SimEvent.stackPointer++] = this;
            ++n_available;
        }
    }

    private static SimEvent getRecycledSimEvent(Simulatable target, double time, Object arg, Object source) {
        if (enable_recycling && n_available > 0L) {
            SimEvent recycled = recycleStack[--stackPointer];
            recycled.id = global_id++;
            recycled.target = target;
            recycled.time = time;
            recycled.arg = arg;
            recycled.source = source;
            recycled.targetPort = null;
            ++n_recycled;
            --n_available;
            return recycled;
        }
        return new SimEvent(target, time, arg, source);
    }

    private static SimEvent getRecycledSimEvent(Simulatable target, double time, Object arg) {
        return SimEvent.getRecycledSimEvent(target, time, arg, null);
    }

    public SimEvent() {
        this.source = null;
        this.target = null;
        this.time = 0.0;
        this.arg = null;
    }

    public SimEvent(Simulatable target, double time, Object arg) {
        this.id = global_id++;
        this.source = null;
        this.target = target;
        this.time = time;
        this.arg = arg;
    }

    public SimEvent(Simulatable target, double time, Object arg, Object source) {
        this.id = global_id++;
        this.source = source;
        this.target = target;
        this.time = time;
        this.arg = arg;
    }

    public static void setDebug(boolean d) {
        debug = d;
    }

    public static boolean getDebug() {
        return debug;
    }

    public final double getTime() {
        return this.time;
    }

    public final Object getArg() {
        return this.arg;
    }

    public final Object getSource() {
        return this.source;
    }

    public void setTargetPort(Port p) {
        this.targetPort = p;
    }

    public Port getTargetPort() {
        return this.targetPort;
    }

    public void evaluate() {
        if (debug) {
            System.err.println(this.toString() + ".evaluate()...");
        }
        try {
            this.target.evaluate(this);
        }
        catch (RuntimeException re) {
            System.err.println("-E- Internal error in SimEvent.evaluate: " + re);
            System.err.println("-E- Event is: " + this.toString());
            re.printStackTrace();
        }
    }

    public static long getNumberOfAvailableRecycledSimEvents() {
        return n_available;
    }

    public static long getNumberOfRecycledSimEvents() {
        return n_recycled;
    }

    public static long getNumberOfSimEvents() {
        return global_id;
    }

    public String toShortString() {
        String value = null;
        String signalname = "";
        signalname = this.target instanceof Signal ? ((Signal)this.target).getFullName() : this.target.toString();
        value = this.arg instanceof StdLogic1164 ? "" + ((StdLogic1164)this.arg).getChar() : this.arg.toString();
        return TimeFormatter.format(this.time) + " signal: " + signalname + " value: " + value;
    }

    public String toString() {
        return "SimEvent_" + this.id + "[" + "\n value: " + (this.arg != null ? this.arg : null) + "\n from:  " + this.source + "\n for:   " + this.target + "\n at:    " + TimeFormatter.format(this.time) + " sec." + "\n]";
    }
}

