/*
 * Decompiled with CFR 0.152.
 */
package hades.simulator;

import hades.signals.Signal;
import hades.signals.SignalStdLogic1164;
import hades.simulator.SimObject;
import hades.utils.ContextToolTip;
import java.awt.Point;
import java.io.Serializable;

public class Port
implements ContextToolTip,
Serializable {
    protected SimObject parent;
    protected SimObject handler;
    protected String name;
    protected int type;
    protected Signal signal;
    protected Class signalClass;
    protected Object optArg;
    protected Object value;
    public final Class class1164 = new SignalStdLogic1164("__dummy__").getClass();
    public static final int IN = 0;
    public static final int OUT = 1;
    public static final int INOUT = 2;
    public static final int BIDIR = 2;
    public static final int PASSIVE_IN = 3;
    public static final int VCC = 4;
    public static final int GND = 5;
    public static final int TOPLEVEL_IN = 6;
    public static final int UNUSED = 7;

    public Port(SimObject parent, String name, int type, Signal signal) {
        this.parent = parent;
        this.handler = parent;
        this.name = name;
        this.type = type;
        this.signal = signal;
        this.signalClass = this.class1164;
        this.optArg = null;
    }

    public Port(SimObject parent, String name, int type, Signal signal, Class signalClass) {
        this.parent = parent;
        this.handler = parent;
        this.name = name;
        this.type = type;
        this.signal = signal;
        this.signalClass = signalClass;
        this.optArg = null;
    }

    public Port(SimObject parent, String name, int type, Signal signal, Class signalClass, Object optArg) {
        this(parent, name, type, signal, signalClass);
        this.optArg = optArg;
    }

    public SimObject getParent() {
        return this.parent;
    }

    public SimObject getHandler() {
        return this.handler;
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public Signal getSignal() {
        return this.signal;
    }

    public Class getSignalClass() {
        return this.signalClass;
    }

    public Object getOptArg() {
        return this.optArg;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object o) {
        this.value = o;
    }

    public void setSignal(Signal s) {
        this.signal = s;
    }

    public void setName(String name) {
        this.name = name.intern();
    }

    public void setHandler(SimObject s) {
        this.handler = s;
    }

    public void setParent(SimObject s) {
        this.parent = s;
    }

    public void setOptArg(Object o) {
        this.optArg = o;
    }

    public boolean isInputPort() {
        return this.type == 0 || this.type == 3;
    }

    public boolean isPowerPort() {
        return this.type == 4 || this.type == 5;
    }

    public void tearDown() {
        this.parent = null;
        this.handler = null;
        this.name = null;
        this.signal = null;
        this.optArg = null;
        this.value = null;
    }

    public String getToolTip(Point position, long millis) {
        String s = "Port  " + this.getName() + "    type=" + this.getTypeString();
        if (this.getSignal() != null) {
            s = s + "\n" + this.getSignal().getToolTip(position, millis);
        } else {
            s = s + "\n" + this.signalClass.getName();
            if (this.optArg != null) {
                s = s + "   " + this.optArg;
            }
        }
        return s;
    }

    public String getTypeString() {
        String s = this.type == 0 ? "IN" : (this.type == 1 ? "OUT" : (this.type == 2 ? "INOUT" : (this.type == 3 ? "PASSIVE_IN" : (this.type == 4 ? "VCC" : (this.type == 5 ? "GND" : (this.type == 6 ? "TOPLEVEL_IN" : "<UNKNOWN>"))))));
        return s;
    }

    public String toStringVerbose() {
        String s = this.getClass().getName() + "[" + this.name + ",type=";
        s = s + this.getTypeString();
        s = this.parent != null ? s + this.parent.getName() : s + "no parent";
        s = s + "]";
        return s;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Port[");
        if (this.parent != null) {
            sb.append(this.parent.getName());
        } else {
            sb.append("no parent");
        }
        sb.append(".");
        sb.append(this.name);
        sb.append(",");
        sb.append("type=");
        sb.append(this.getTypeString());
        sb.append("]");
        return sb.toString();
    }
}

