/*
 * Decompiled with CFR 0.152.
 */
package hades.models.ttl74;

import hades.gui.MemoryEditorFrame;
import hades.gui.PropertySheet;
import hades.manager.DesignManager;
import hades.models.Const1164;
import hades.models.PortStdLogic1164;
import hades.models.StdLogic1164;
import hades.models.memory.Memory;
import hades.models.memory.MemoryListener;
import hades.signals.Signal;
import hades.simulator.Port;
import hades.simulator.SimEvent1164;
import hades.simulator.SimObject;
import hades.simulator.Simulatable;
import hades.utils.NameMangler;
import hades.utils.StringTokenizer;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import jfig.utils.ExceptionTracer;

public class SN74189
extends SimObject
implements Memory {
    public static final long serialVersionUID = 8890410336729416659L;
    private StdLogic1164 output_0;
    private StdLogic1164 output_1;
    private StdLogic1164 output_X;
    private StdLogic1164 output_Z;
    private PortStdLogic1164 port_nCS;
    private PortStdLogic1164 port_RnW;
    private int index_A0;
    private int index_DI0;
    private int index_Q0;
    private int n_words = 16;
    private int address;
    private long[] data;
    private Hashtable _listenerTable;
    protected MemoryEditorFrame MEF;
    public static final int TRISTATED = -2;
    public static final int UNDEFINED = -1;
    public static final int N_ADDRESS_INPUTS = 4;
    public static final int N_DATA_INPUTS = 4;
    public static final double t_access = 3.0E-8;
    public static final double t_tristate = 5.0E-9;
    public static final double t_undefined = 6.0E-9;
    String resourcename = "/hades/models/rtl/empty.rom";

    public SN74189() {
        int n;
        this.ports = new Port[14];
        this.index_A0 = n = 0;
        int i = 0;
        while (i < 4) {
            this.ports[n] = new PortStdLogic1164(this, "A" + i, 0, null);
            ++n;
            ++i;
        }
        this.index_DI0 = n;
        int i2 = 0;
        while (i2 < 4) {
            this.ports[n] = new PortStdLogic1164(this, "D" + i2, 0, null);
            ++n;
            ++i2;
        }
        this.index_Q0 = n;
        int i3 = 0;
        while (i3 < 4) {
            this.ports[n] = new PortStdLogic1164(this, "Q" + i3, 1, null);
            ++n;
            ++i3;
        }
        this.port_nCS = new PortStdLogic1164(this, "NCS", 0, null);
        this.ports[n] = this.port_nCS;
        this.port_RnW = new PortStdLogic1164(this, "R/NW", 0, null);
        this.ports[++n] = this.port_RnW;
        ++n;
        this.data = new long[this.n_words];
        this.address = -1;
        this.output_X = Const1164.__X;
        this.output_0 = Const1164.__0;
        this.output_1 = Const1164.__1;
        this.output_Z = Const1164.__Z;
        this.initRAM();
    }

    public boolean needsExternalResources() {
        return true;
    }

    public String[] getExternalResources() {
        String[] externals = new String[]{this.getResourcename()};
        return externals;
    }

    public void initRAM() {
        int i = 0;
        while (i < this.data.length) {
            this.data[i] = -1L;
            ++i;
        }
    }

    public void printSramContent() {
        StringBuffer sb = new StringBuffer();
        sb.append("-I- " + this.toString() + "contents:");
        int i = 0;
        while (i < this.data.length) {
            sb.append("   " + i + " ");
            if (this.data[i] == -1L) {
                sb.append("XXXX");
            } else {
                sb.append("" + Long.toString(this.data[i], 16));
            }
            sb.append("\n");
            ++i;
        }
        this.message(sb.toString());
    }

    public String getResourcename() {
        return this.resourcename;
    }

    public void setResourcename(String s) {
        this.resourcename = s;
        this.initialize("" + this.versionId + " " + NameMangler.encodeWithUnicodeEscapes(s));
    }

    public boolean initialize(String s) {
        this.resourcename = "";
        try {
            StringTokenizer st = new StringTokenizer(s);
            int n_tokens = st.countTokens();
            if (n_tokens == 1) {
                this.versionId = 1001L;
                this.resourcename = NameMangler.decodeUnicodeEscapes(st.nextToken());
            } else if (n_tokens == 2) {
                this.versionId = Integer.parseInt(st.nextToken());
                this.resourcename = NameMangler.decodeUnicodeEscapes(st.nextToken());
            } else {
                throw new Exception("need 1 or 2 args, but got: " + s);
            }
            this.parseRAM(this.resourcename);
        }
        catch (Exception e) {
            this.message("-E- SN74189.initialize(): " + e);
            this.message("-E- offending input is '" + s + "'");
            ExceptionTracer.trace(e);
        }
        return true;
    }

    public void write(PrintWriter ps) {
        ps.print(" " + this.versionId + " " + NameMangler.encodeWithUnicodeEscapes(this.resourcename));
    }

    public void parseRAM(String resourcename) {
        block3: {
            InputStream is = null;
            BufferedReader br = null;
            try {
                is = DesignManager.getDesignManager().getInputStream(this, resourcename);
                if (is != null) {
                    this.message("-I- " + this.toString() + ": parsing '" + resourcename + "'");
                    br = new BufferedReader(new InputStreamReader(is));
                    this.parse(br);
                    break block3;
                }
                this.message("-W- " + this.toString() + ": initialization file not found: '" + resourcename + "'");
            }
            catch (Exception e) {
                this.message("-E- in SN74189.parseRAM(): " + e);
                ExceptionTracer.trace(e);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean parse(BufferedReader br) {
        line = null;
        valueString = null;
        addr = 0;
        row = 0L;
        try {
            while ((line = br.readLine()) != null) {
                if (line.startsWith("#")) continue;
                st = new StringTokenizer(line, " \t:");
                addr = Integer.parseInt(st.nextToken(), 16);
                valueString = st.nextToken();
                if (valueString.length() != 2) ** GOTO lbl19
                row = this.parseLongOrXXX(valueString);
                this.setDataAt(addr, row);
                continue;
lbl-1000:
                // 1 sources

                {
                    row = this.parseLongOrXXX(valueString.substring(0, 2));
                    this.setDataAt(addr, row);
                    ++addr;
                    valueString = valueString.substring(2, valueString.length());
lbl19:
                    // 2 sources

                    ** while (valueString.length() >= 2)
                }
lbl20:
                // 1 sources

            }
        }
        catch (Exception e) {
            this.message("-E- in SN74189.parseRAM(): " + e);
            this.message("-I- last line was '" + line + "'");
            ExceptionTracer.trace(e);
            return false;
        }
        return true;
    }

    public long parseLongOrXXX(String s) {
        try {
            if (s == null) {
                return -1L;
            }
            if ("XX".equals(s)) {
                return -1L;
            }
            return Long.parseLong(s, 16);
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public void setDataAt(int address, long value) {
        if (address < 0 || address > this.data.length - 1) {
            this.message("-E- RAM.setDataAt(): out-of-range address: " + address);
            this.message("-W- address and data ignored!");
            return;
        }
        if (value != -1L) {
            value &= 0xFL;
        }
        this.data[address] = value;
        if (this.MEF != null && this.MEF.isShowing()) {
            this.MEF.repaint();
        }
    }

    public long getDataAt(int address) {
        return this.data[address];
    }

    public int getAddrOffset() {
        return 0;
    }

    public int getBitsPerWord() {
        return 4;
    }

    public void setBitsPerWord(int n_bits) throws Exception {
        throw new Exception("Cannot change the SN74189 width!");
    }

    public int getSize() {
        return this.data.length;
    }

    public void setSize(int n_words) throws Exception {
        throw new Exception("Cannot change the SN74189 size!");
    }

    public boolean resize(int n_words, int n_bits_per_word) throws Exception {
        throw new Exception("Cannot change the SN74189  size!");
    }

    public boolean canChangeSize() {
        return false;
    }

    public long[] getDataArray() {
        return this.data;
    }

    public void setDataArray(long[] data) {
        this.data = data;
    }

    public boolean merge(BufferedReader reader) {
        return this.parse(reader);
    }

    public void addMemoryListener(MemoryListener ML) {
        try {
            if (this._listenerTable == null) {
                this._listenerTable = new Hashtable();
            }
            this._listenerTable.put(ML, ML);
        }
        catch (Exception e) {
            this.message("-E- failed to add MemoryListener: " + e);
        }
    }

    public void removeMemoryListener(MemoryListener ML) {
        try {
            this._listenerTable.remove(ML);
        }
        catch (Exception e) {
            this.message("-E- failed to remove MemoryListener: " + e);
        }
    }

    protected String getHexString(long value, int n_chars) {
        String raw;
        if (value < 0L) {
            StringBuffer tmp = new StringBuffer();
            int i = 0;
            while (i < n_chars) {
                tmp.append('X');
                ++i;
            }
            raw = tmp.toString();
        } else {
            raw = Long.toHexString(value);
        }
        StringBuffer sb = new StringBuffer();
        int n_zeroes = n_chars - raw.length();
        int i = 0;
        while (i < n_zeroes) {
            sb.append('0');
            ++i;
        }
        sb.append(raw);
        return sb.toString();
    }

    public boolean save(PrintWriter PW) {
        int i = 0;
        while (i < this.data.length) {
            String addrString = this.getHexString(i, 4);
            String valueString = this.getHexString(this.data[i], 2);
            PW.println(addrString + ":" + valueString);
            ++i;
        }
        PW.flush();
        return false;
    }

    public PropertySheet getConfigDialog() {
        return null;
    }

    public void configure() {
        if (this.MEF == null) {
            this.MEF = new MemoryEditorFrame(this, 16, 1, "Edit " + this.toString());
            this.addMemoryListener(this.MEF);
        }
        this.MEF.pack();
        this.MEF.setVisible(true);
    }

    public Component getPropertySheet() {
        return this.MEF;
    }

    public void elaborate(Object arg) {
        if (SimObject.debug) {
            this.message(this.toString() + ".elaborate()");
        }
        this.simulator = this.parent.getSimulator();
        if (this.simulator != null) {
            this.scheduleOutputs(-1, 6.0E-9);
        }
    }

    public void evaluate(Object arg) {
        if (SimObject.debug) {
            System.err.println(this.toString() + ".evaluate()");
        }
        StdLogic1164 value_nCS = this.port_nCS.getValueOrU();
        StdLogic1164 value_RnW = this.port_RnW.getValueOrU();
        if (value_nCS.is_1()) {
            this.scheduleOutputs(-2, 5.0E-9);
        } else if (!value_nCS.is_0()) {
            this.scheduleOutputs(-1, 6.0E-9);
        } else if (value_RnW.is_0()) {
            this.getAdress();
            this.writeRAM();
            this.scheduleOutputs(this.address, 3.0E-8);
        } else if (value_RnW.is_1()) {
            this.getAdress();
            this.scheduleOutputs(this.address, 3.0E-8);
        } else {
            this.scheduleOutputs(-1, 6.0E-9);
        }
    }

    protected void getAdress() {
        int index = 0;
        int mask = 1;
        int i = 0;
        while (i < 4) {
            Signal signal_A = this.ports[this.index_A0 + i].getSignal();
            if (signal_A != null) {
                StdLogic1164 value_A = (StdLogic1164)signal_A.getValue();
                if (value_A.is_1()) {
                    index += mask;
                } else if (!value_A.is_0()) {
                    index = -1;
                    break;
                }
            } else {
                index = -1;
                break;
            }
            mask += mask;
            ++i;
        }
        this.address = index;
    }

    private void writeRAM() {
        long new_value;
        if (this.address < 0) {
            this.message("-E- invalid RAM address: " + this.address + ", write ignored!");
            return;
        }
        int row = 0;
        int mask = 1;
        int i = 0;
        while (i < 4) {
            Signal signal = this.ports[this.index_DI0 + i].getSignal();
            if (signal == null) {
                row = -1;
                break;
            }
            StdLogic1164 value = (StdLogic1164)signal.getValue();
            if (!value.is_0()) {
                if (value.is_1()) {
                    row += mask;
                } else {
                    row = -1;
                    break;
                }
            }
            mask += mask;
            ++i;
        }
        long old_value = this.data[this.address];
        this.data[this.address] = new_value = (long)row;
        this.notifyWriteListeners(this.address, old_value, new_value);
    }

    private void notifyWriteListeners(int address, long old_value, long new_value) {
        if (this._listenerTable != null) {
            Enumeration E = this._listenerTable.keys();
            while (E.hasMoreElements()) {
                ((MemoryListener)E.nextElement()).memoryWrite(address, old_value, new_value);
            }
        }
    }

    private void notifyReadListeners(int address, long value) {
        if (this._listenerTable != null) {
            if (address < 0) {
                return;
            }
            Enumeration E = this._listenerTable.keys();
            while (E.hasMoreElements()) {
                ((MemoryListener)E.nextElement()).memoryRead(address, value);
            }
        }
    }

    private void scheduleOutputs(int index, double t_delay) {
        double time = this.simulator.getSimTime() + t_delay;
        long row = index >= 0 ? this.data[index] : 0L;
        this.notifyReadListeners(index, row);
        long mask = 1L;
        int i = 0;
        while (i < 4) {
            Port port = this.ports[this.index_Q0 + i];
            Signal signal = port.getSignal();
            if (signal != null) {
                StdLogic1164 value = index == -1 ? this.output_X : (index == -2 ? this.output_Z : (row == -1L ? this.output_X : ((row & mask) > 0L ? this.output_0 : this.output_1)));
                this.simulator.scheduleEvent(SimEvent1164.createNewSimEvent((Simulatable)signal, time, value, (Object)port));
            }
            mask += mask;
            ++i;
        }
    }

    public void dbg(String msg) {
        System.out.println(msg);
    }

    public String toString() {
        return "SN74189: " + this.getFullName();
    }
}

