/*
 * Decompiled with CFR 0.152.
 */
package hades.models.switched;

import hades.gui.PropertySheet;
import hades.models.Const1164;
import hades.models.PortStdLogic1164;
import hades.models.StdLogic1164;
import hades.models.gates.GenericGate;
import hades.signals.Signal;
import hades.signals.SignalStdLogicSwitched;
import hades.simulator.GenericSwitch;
import hades.simulator.Port;
import hades.simulator.SimObject;
import hades.simulator.Wakeable;
import hades.symbols.Polyline;
import hades.symbols.Symbol;
import hades.utils.StringTokenizer;
import java.awt.Point;
import java.io.PrintWriter;
import java.io.Serializable;

public class Relay2
extends GenericGate
implements GenericSwitch,
Wakeable,
Serializable {
    private static final long serialVersionUID = 5388569312726152510L;
    public static final int STATE_OPEN = 0;
    public static final int STATE_CLOSED = 1;
    public static final int STATE_UNDEFINED = 2;
    protected int state;
    protected PortStdLogic1164 port_A;
    protected PortStdLogic1164 port_A0;
    protected PortStdLogic1164 port_A1;
    protected PortStdLogic1164 port_B;
    protected PortStdLogic1164 port_B0;
    protected PortStdLogic1164 port_B1;
    protected PortStdLogic1164 port_X;
    protected PortStdLogic1164 port_Y;
    protected StdLogic1164 startValue;
    protected double delay = 0.1 + 0.001 * Math.random();
    protected Polyline animatedOpenA;
    protected Polyline animatedClosedA;
    protected Polyline animatedOpenB;
    protected Polyline animatedClosedB;
    protected Polyline animatedOpenRod1;
    protected Polyline animatedClosedRod1;
    protected Polyline animatedOpenRod2;
    protected Polyline animatedClosedRod2;
    static /* synthetic */ Class class$hades$signals$SignalStdLogicSwitched;

    public Relay2() {
        this.constructPorts();
        this.state = 0;
    }

    public void constructPorts() {
        this.port_A = new PortStdLogic1164(this, "A", 2, null);
        this.port_A0 = new PortStdLogic1164(this, "A0", 2, null);
        this.port_A1 = new PortStdLogic1164(this, "A1", 2, null);
        this.port_B = new PortStdLogic1164(this, "B", 2, null);
        this.port_B0 = new PortStdLogic1164(this, "B0", 2, null);
        this.port_B1 = new PortStdLogic1164(this, "B1", 2, null);
        this.port_X = new PortStdLogic1164(this, "X", 0, null);
        this.port_Y = new PortStdLogic1164(this, "Y", 0, null);
        this.ports = new Port[8];
        this.ports[0] = this.port_A;
        this.ports[1] = this.port_A0;
        this.ports[2] = this.port_A1;
        this.ports[3] = this.port_B;
        this.ports[4] = this.port_B0;
        this.ports[5] = this.port_B1;
        this.ports[6] = this.port_X;
        this.ports[7] = this.port_Y;
    }

    public Port[] getAllSwitchedPorts() {
        return new Port[]{this.port_A, this.port_A0, this.port_A1, this.port_B, this.port_B0, this.port_B1};
    }

    public boolean isSwitchedPort(Port p) {
        int i = 0;
        while (i < 6) {
            if (p == this.ports[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Port[] getConnectedPorts(Port p) {
        if (this.state == 1) {
            if (p == this.port_A) {
                return new Port[]{this.port_A1};
            }
            if (p == this.port_A1) {
                return new Port[]{this.port_A};
            }
            if (p == this.port_B) {
                return new Port[]{this.port_B1};
            }
            if (p == this.port_B1) {
                return new Port[]{this.port_B};
            }
            return new Port[0];
        }
        if (this.state == 0) {
            if (p == this.port_A) {
                return new Port[]{this.port_A0};
            }
            if (p == this.port_A0) {
                return new Port[]{this.port_A};
            }
            if (p == this.port_B) {
                return new Port[]{this.port_B0};
            }
            if (p == this.port_B0) {
                return new Port[]{this.port_B};
            }
            return new Port[0];
        }
        return new Port[0];
    }

    public int getState() {
        return this.state;
    }

    public void setState(int i) {
        if (i == 0) {
            this.state = i;
        } else if (i == 1) {
            this.state = i;
        } else if (i == 2) {
            this.state = i;
        } else {
            throw new IllegalArgumentException("hades.models.switched.Relay2.setState: Unknown state: " + i);
        }
        this.showState();
    }

    public double getDelay() {
        return this.delay;
    }

    public void setDelay(String s) {
        try {
            this.delay = Double.valueOf(s);
        }
        catch (Exception e) {
            this.message("-E- Illegal delay value '" + s + "', using 0.0 sec...");
            this.delay = 0.0;
        }
    }

    public boolean initialize(String s) {
        try {
            StringTokenizer st = new StringTokenizer(s);
            this.versionId = Integer.parseInt(st.nextToken());
            this.delay = Double.parseDouble(st.nextToken());
        }
        catch (Exception e) {
            this.message("-E- Relay2.initialize(): " + e + " " + s);
        }
        return true;
    }

    public void write(PrintWriter ps) {
        ps.print(" " + this.versionId + " " + this.delay);
    }

    public void setSymbol(Symbol s) {
        this.symbol = s;
        this.symbol.setInstanceLabel(this.name);
        this.initDisplay();
    }

    protected void initDisplay() {
        try {
            Object tmp = null;
            if (this.symbol == null) {
                return;
            }
            this.animatedOpenA = new Polyline();
            this.animatedClosedA = new Polyline();
            this.animatedOpenB = new Polyline();
            this.animatedClosedB = new Polyline();
            this.animatedOpenRod1 = new Polyline();
            this.animatedClosedRod1 = new Polyline();
            this.animatedOpenRod2 = new Polyline();
            this.animatedClosedRod2 = new Polyline();
            this.animatedOpenA.initialize("2 1000 3000 2700 3450");
            this.animatedClosedA.initialize("2 1000 3000 2700 2400");
            this.animatedOpenB.initialize("2 1000 5400 2700 5850");
            this.animatedClosedB.initialize("2 1000 5400 2700 4800");
            this.animatedOpenRod1.initialize("2 1700 1800 1700 5650");
            this.animatedOpenRod2.initialize("2 1900 1800 1900 5700");
            this.animatedClosedRod1.initialize("2 1700 1800 1700 5100");
            this.animatedClosedRod2.initialize("2 1900 1800 1900 5050");
            this.animatedOpenRod1.getAttributes().lineStyle = 1;
            this.animatedOpenRod2.getAttributes().lineStyle = 1;
            this.animatedClosedRod1.getAttributes().lineStyle = 1;
            this.animatedClosedRod2.getAttributes().lineStyle = 1;
            this.symbol.fastAddMember(this.animatedOpenA);
            this.symbol.fastAddMember(this.animatedClosedA);
            this.symbol.fastAddMember(this.animatedOpenB);
            this.symbol.fastAddMember(this.animatedClosedB);
            this.symbol.fastAddMember(this.animatedOpenRod1);
            this.symbol.fastAddMember(this.animatedClosedRod1);
            this.symbol.fastAddMember(this.animatedOpenRod2);
            this.symbol.fastAddMember(this.animatedClosedRod2);
            this.symbol.update_bbox();
            this.showState();
        }
        catch (Exception e) {
            this.message("-E- Relay2.initDisplay(): " + e);
            e.printStackTrace();
        }
    }

    public void showState() {
        if (!this.visible) {
            return;
        }
        try {
            if (this.state == 1) {
                this.animatedOpenA.setVisible(false);
                this.animatedOpenB.setVisible(false);
                this.animatedOpenRod1.setVisible(false);
                this.animatedOpenRod2.setVisible(false);
                this.animatedClosedA.setVisible(true);
                this.animatedClosedB.setVisible(true);
                this.animatedClosedRod1.setVisible(true);
                this.animatedClosedRod2.setVisible(true);
            } else if (this.state == 0) {
                this.animatedOpenA.setVisible(true);
                this.animatedOpenB.setVisible(true);
                this.animatedOpenRod1.setVisible(true);
                this.animatedOpenRod2.setVisible(true);
                this.animatedClosedA.setVisible(false);
                this.animatedClosedB.setVisible(false);
                this.animatedClosedRod1.setVisible(false);
                this.animatedClosedRod2.setVisible(false);
            } else {
                this.animatedOpenA.setVisible(false);
                this.animatedOpenB.setVisible(false);
                this.animatedOpenRod1.setVisible(false);
                this.animatedOpenRod2.setVisible(false);
                this.animatedClosedA.setVisible(false);
                this.animatedClosedB.setVisible(false);
                this.animatedClosedRod1.setVisible(true);
                this.animatedClosedRod2.setVisible(true);
            }
            if (this.symbol.painter != null) {
                this.symbol.painter.paint(this.symbol);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void elaborate(Object arg) {
        if (SimObject.debug) {
            this.message(this.toString() + ".elaborate()");
        }
        this.simulator = this.parent.getSimulator();
        this.assertIsSignalStdLogicSwitched(this.port_A.getSignal());
        this.assertIsSignalStdLogicSwitched(this.port_A0.getSignal());
        this.assertIsSignalStdLogicSwitched(this.port_A1.getSignal());
        this.assertIsSignalStdLogicSwitched(this.port_B.getSignal());
        this.assertIsSignalStdLogicSwitched(this.port_B0.getSignal());
        this.assertIsSignalStdLogicSwitched(this.port_B1.getSignal());
        this.showState();
    }

    public void evaluate(Object arg) {
        this.assertIsSignalStdLogicSwitched(this.port_A.getSignal());
        this.assertIsSignalStdLogicSwitched(this.port_A0.getSignal());
        this.assertIsSignalStdLogicSwitched(this.port_A1.getSignal());
        this.assertIsSignalStdLogicSwitched(this.port_B.getSignal());
        this.assertIsSignalStdLogicSwitched(this.port_B0.getSignal());
        this.assertIsSignalStdLogicSwitched(this.port_B1.getSignal());
        try {
            StdLogic1164 coil_X = this.port_X.getValueOrU();
            StdLogic1164 coil_Y = this.port_Y.getValueOrU();
            this.state = coil_X.is_1() && coil_Y.is_0() ? 1 : (coil_X.is_0() && coil_Y.is_1() ? 1 : (coil_X.is_1() && coil_Y.is_1() ? 0 : (coil_X.is_0() && coil_Y.is_0() ? 0 : 0)));
            this.showState();
            if (this.state == 2) {
                this.scheduleOutputValueAfter(this.port_A, Const1164.__W, this.delay);
                this.scheduleOutputValueAfter(this.port_A0, Const1164.__W, this.delay);
                this.scheduleOutputValueAfter(this.port_A1, Const1164.__W, this.delay);
                this.scheduleOutputValueAfter(this.port_B, Const1164.__W, this.delay);
                this.scheduleOutputValueAfter(this.port_B0, Const1164.__W, this.delay);
                this.scheduleOutputValueAfter(this.port_B1, Const1164.__W, this.delay);
            } else if (this.state == 0) {
                this.scheduleOutputValueAfter(this.port_A, Const1164.__Z, this.delay);
                this.scheduleOutputValueAfter(this.port_A0, Const1164.__Z, this.delay);
                this.scheduleOutputValueAfter(this.port_A1, Const1164.__Z, this.delay);
                this.scheduleOutputValueAfter(this.port_B, Const1164.__Z, this.delay);
                this.scheduleOutputValueAfter(this.port_B0, Const1164.__Z, this.delay);
                this.scheduleOutputValueAfter(this.port_B1, Const1164.__Z, this.delay);
            } else if (this.state == 1) {
                this.scheduleOutputValueAfter(this.port_A, Const1164.__Z, this.delay);
                this.scheduleOutputValueAfter(this.port_A0, Const1164.__Z, this.delay);
                this.scheduleOutputValueAfter(this.port_A1, Const1164.__Z, this.delay);
                this.scheduleOutputValueAfter(this.port_B, Const1164.__Z, this.delay);
                this.scheduleOutputValueAfter(this.port_B0, Const1164.__Z, this.delay);
                this.scheduleOutputValueAfter(this.port_B1, Const1164.__Z, this.delay);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void assertIsSignalStdLogicSwitched(Signal victim) {
        if (victim == null) {
            return;
        }
        if (victim.getClass() == (class$hades$signals$SignalStdLogicSwitched == null ? (class$hades$signals$SignalStdLogicSwitched = Relay2.class$("hades.signals.SignalStdLogicSwitched")) : class$hades$signals$SignalStdLogicSwitched)) {
            return;
        }
        SignalStdLogicSwitched.assertIsSignalStdLogicSwitched(victim);
    }

    public void wakeup(Object arg) {
        try {
            Thread.dumpStack();
            this.state = 2;
            this.showState();
        }
        catch (Exception e) {
            System.err.println("-E- " + this.toString() + ".wakeup: " + e);
        }
    }

    public void configure() {
        if (SimObject.debug) {
            this.message("-I- starting to configure this " + this.toString());
        }
        String[] fields = new String[]{"instance name:", "name"};
        this.propertySheet = PropertySheet.getPropertySheet(this, fields);
        this.propertySheet.setHelpText("Specify instance name, and delay:");
        this.propertySheet.setVisible(true);
    }

    public String getToolTip(Point position, long millis) {
        String s = this.getBindkey();
        return this.getName() + "\n" + this.getClass().getName() + "\n" + "delay= " + this.delay + " [sec]\n" + "bindkey= " + (s == null ? "None" : s);
    }

    public void dbg(String s) {
        System.out.println(s);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

