/*
 * Decompiled with CFR 0.152.
 */
package hades.models.switched;

import hades.gui.PropertySheet;
import hades.models.Const1164;
import hades.models.PortStdLogic1164;
import hades.models.StdLogic1164;
import hades.models.gates.GenericGate;
import hades.signals.Signal;
import hades.signals.SignalStdLogicSwitched;
import hades.simulator.GenericSwitch;
import hades.simulator.Port;
import hades.simulator.SimObject;
import hades.simulator.Wakeable;
import hades.symbols.ColoredRectangle;
import hades.symbols.Symbol;
import hades.utils.StringTokenizer;
import java.awt.Color;
import java.awt.Point;
import java.io.PrintWriter;
import java.util.Enumeration;
import jfig.gui.ColorCache;
import jfig.objects.FigObject;

public class NTRAN
extends GenericGate
implements GenericSwitch,
Wakeable {
    private static final long serialVersionUID = 4694763993458756689L;
    public static final int STATE_OPEN = 0;
    public static final int STATE_CLOSED = 1;
    public static final int STATE_UNDEFINED = 2;
    protected int state;
    protected PortStdLogic1164 port_A = new PortStdLogic1164(this, "A", 2, null);
    protected PortStdLogic1164 port_B = new PortStdLogic1164(this, "B", 2, null);
    protected PortStdLogic1164 port_C = new PortStdLogic1164(this, "C", 0, null);
    protected StdLogic1164 startValue;
    protected double delay = 6.0E-9;
    protected ColoredRectangle animatedGate;
    static /* synthetic */ Class class$hades$signals$SignalStdLogicSwitched;

    public NTRAN() {
        this.ports = new Port[3];
        this.ports[0] = this.port_A;
        this.ports[1] = this.port_B;
        this.ports[2] = this.port_C;
        this.state = 2;
    }

    public Port[] getAllSwitchedPorts() {
        return new Port[]{this.port_A, this.port_B};
    }

    public boolean isSwitchedPort(Port p) {
        return p == this.port_A || p == this.port_B;
    }

    public Port[] getConnectedPorts(Port p) {
        if (this.state == 1) {
            if (p == this.port_A) {
                return new Port[]{this.port_B};
            }
            if (p == this.port_B) {
                return new Port[]{this.port_A};
            }
            return new Port[0];
        }
        if (this.state == 0) {
            return new Port[0];
        }
        return new Port[0];
    }

    public int getState() {
        return this.state;
    }

    public void setState(int i) {
        if (i == 0) {
            this.state = i;
        } else if (i == 1) {
            this.state = i;
        } else if (i == 2) {
            this.state = i;
        } else {
            throw new IllegalArgumentException("hades.models.switched.NTRAN.setState: Unknown state: " + i);
        }
        this.showState();
    }

    public double getDelay() {
        return this.delay;
    }

    public void setDelay(String s) {
        try {
            this.delay = Double.valueOf(s);
        }
        catch (Exception e) {
            this.message("-E- Illegal delay value '" + s + "', using 0.0 sec...");
            this.delay = 0.0;
        }
    }

    public boolean initialize(String s) {
        try {
            StringTokenizer st = new StringTokenizer(s);
            this.versionId = Integer.parseInt(st.nextToken());
            this.delay = Double.parseDouble(st.nextToken());
        }
        catch (Exception e) {
            this.message("-E- NTRAN.initialize(): " + e + " " + s);
        }
        return true;
    }

    public void write(PrintWriter ps) {
        ps.print(" " + this.versionId + " " + this.delay);
    }

    public void setSymbol(Symbol s) {
        this.symbol = s;
        this.symbol.setInstanceLabel(this.name);
        this.initDisplay();
    }

    protected void initDisplay() {
        try {
            FigObject tmp = null;
            if (this.symbol == null) {
                return;
            }
            Enumeration e = this.symbol.elements();
            while (e.hasMoreElements()) {
                tmp = (FigObject)e.nextElement();
                if (!(tmp instanceof ColoredRectangle)) continue;
                this.animatedGate = (ColoredRectangle)tmp;
            }
            this.showState();
        }
        catch (Exception e) {
            this.message("-E- NTRAN.initDisplay(): " + e);
            e.printStackTrace();
        }
    }

    public void showState() {
        if (!this.visible) {
            return;
        }
        try {
            Color c = Color.cyan;
            Color d = ColorCache.getColorCache().get(12);
            c = this.state == 1 ? d : (this.state == 0 ? Color.white : Color.cyan);
            this.animatedGate.setLineColor(d);
            this.animatedGate.setFillColor(c);
            if (this.symbol.painter != null) {
                this.symbol.painter.paint(this.symbol);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void elaborate(Object arg) {
        if (SimObject.debug) {
            this.message(this.toString() + ".elaborate()");
        }
        this.simulator = this.parent.getSimulator();
        this.assertIsSignalStdLogicSwitched(this.port_A.getSignal());
        this.assertIsSignalStdLogicSwitched(this.port_B.getSignal());
        this.scheduleOutputValueAfter(this.port_A, Const1164.__W, this.delay);
        this.scheduleOutputValueAfter(this.port_B, Const1164.__W, this.delay);
        this.showState();
    }

    public void evaluate(Object arg) {
        this.assertIsSignalStdLogicSwitched(this.port_A.getSignal());
        this.assertIsSignalStdLogicSwitched(this.port_B.getSignal());
        try {
            StdLogic1164 value_C = this.port_C.getValueOrU();
            this.state = value_C.isHigh_1H() ? 1 : (value_C.isLow_0L() ? 0 : 2);
            this.showState();
            if (this.state == 2) {
                this.scheduleOutputValueAfter(this.port_A, Const1164.__W, this.delay);
                this.scheduleOutputValueAfter(this.port_B, Const1164.__W, this.delay);
            } else if (this.state == 0) {
                this.scheduleOutputValueAfter(this.port_A, Const1164.__Z, this.delay);
                this.scheduleOutputValueAfter(this.port_B, Const1164.__Z, this.delay);
            } else if (this.state == 1) {
                this.scheduleOutputValueAfter(this.port_A, Const1164.__Z, this.delay);
                this.scheduleOutputValueAfter(this.port_B, Const1164.__Z, this.delay);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void assertIsSignalStdLogicSwitched(Signal victim) {
        if (victim == null) {
            return;
        }
        if (victim.getClass() == (class$hades$signals$SignalStdLogicSwitched == null ? (class$hades$signals$SignalStdLogicSwitched = NTRAN.class$("hades.signals.SignalStdLogicSwitched")) : class$hades$signals$SignalStdLogicSwitched)) {
            return;
        }
        SignalStdLogicSwitched.assertIsSignalStdLogicSwitched(victim);
    }

    public void wakeup(Object arg) {
        try {
            Thread.dumpStack();
            this.state = 2;
            this.showState();
        }
        catch (Exception e) {
            System.err.println("-E- " + this.toString() + ".wakeup: " + e);
        }
    }

    public void configure() {
        if (SimObject.debug) {
            this.message("-I- starting to configure this " + this.toString());
        }
        String[] fields = new String[]{"instance name:", "name"};
        this.propertySheet = PropertySheet.getPropertySheet(this, fields);
        this.propertySheet.setHelpText("Specify instance name, and delay:");
        this.propertySheet.setVisible(true);
    }

    public String getToolTip(Point position, long millis) {
        String s = this.getBindkey();
        return this.getName() + "\n" + this.getClass().getName() + "\n" + "delay= " + this.delay + " [sec]\n" + "bindkey= " + (s == null ? "None" : s);
    }

    public void dbg(String s) {
        System.out.println(s);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

