/*
 * Decompiled with CFR 0.152.
 */
package hades.models.switched;

import hades.gui.PropertySheet;
import hades.models.Const1164;
import hades.models.PortStdLogic1164;
import hades.models.StdLogic1164;
import hades.models.gates.GenericGate;
import hades.signals.Signal;
import hades.signals.SignalStdLogicSwitched;
import hades.simulator.GenericSwitch;
import hades.simulator.Port;
import hades.simulator.SimObject;
import hades.simulator.Wakeable;
import hades.symbols.ClockArm;
import hades.symbols.ColoredCircle;
import hades.symbols.Polyline;
import hades.symbols.Symbol;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Enumeration;
import jfig.objects.FigObject;

public class ISwitch
extends GenericGate
implements GenericSwitch,
Wakeable,
Serializable {
    private static final long serialVersionUID = -7524128732032111006L;
    public static final int STATE_OPEN = 0;
    public static final int STATE_CLOSED = 1;
    public static final int STATE_UNDEFINED = 2;
    protected int state;
    protected PortStdLogic1164 port_A = new PortStdLogic1164(this, "A", 2, null);
    protected PortStdLogic1164 port_A0 = new PortStdLogic1164(this, "A0", 2, null);
    protected PortStdLogic1164 port_A1 = new PortStdLogic1164(this, "A1", 2, null);
    protected StdLogic1164 startValue;
    protected double delay = 6.0E-9;
    protected ColoredCircle animatedCircle;
    protected Polyline animatedOpen;
    protected Polyline animatedClosed;
    static /* synthetic */ Class class$hades$signals$SignalStdLogicSwitched;

    public ISwitch() {
        this.ports = new Port[3];
        this.ports[0] = this.port_A;
        this.ports[1] = this.port_A0;
        this.ports[2] = this.port_A1;
        this.state = 0;
    }

    public Port[] getAllSwitchedPorts() {
        return new Port[]{this.port_A, this.port_A0, this.port_A1};
    }

    public boolean isSwitchedPort(Port p) {
        return p == this.port_A || p == this.port_A0 || p == this.port_A1;
    }

    public Port[] getConnectedPorts(Port p) {
        if (this.state == 1) {
            if (p == this.port_A) {
                return new Port[]{this.port_A1};
            }
            if (p == this.port_A1) {
                return new Port[]{this.port_A};
            }
            return new Port[0];
        }
        if (this.state == 0) {
            if (p == this.port_A) {
                return new Port[]{this.port_A0};
            }
            if (p == this.port_A0) {
                return new Port[]{this.port_A};
            }
            return new Port[0];
        }
        return new Port[0];
    }

    public int getState() {
        return this.state;
    }

    public void setState(int i) {
        if (i == 0) {
            this.state = i;
        } else if (i == 1) {
            this.state = i;
        } else if (i == 2) {
            this.state = i;
        } else {
            throw new IllegalArgumentException("ISwitch.setState: Unknown state: " + i);
        }
        this.showState();
    }

    public double getDelay() {
        return this.delay;
    }

    public void setDelay(String s) {
        try {
            this.delay = Double.valueOf(s);
        }
        catch (Exception e) {
            this.message("-E- Illegal delay value '" + s + "', using 0.0 sec...");
            this.delay = 0.0;
        }
    }

    public boolean initialize(String s) {
        return true;
    }

    public void write(PrintWriter ps) {
        ps.print(" " + this.versionId);
    }

    public void setSymbol(Symbol s) {
        this.symbol = s;
        this.symbol.setInstanceLabel(this.name);
        this.initDisplay();
    }

    protected void initDisplay() {
        try {
            FigObject tmp = null;
            if (this.symbol == null) {
                return;
            }
            Enumeration e = this.symbol.elements();
            while (e.hasMoreElements()) {
                tmp = (FigObject)e.nextElement();
                if (tmp instanceof ClockArm) {
                    // empty if block
                }
                if (!(tmp instanceof ColoredCircle)) continue;
                this.animatedCircle = (ColoredCircle)tmp;
            }
            this.animatedOpen = new Polyline();
            this.animatedClosed = new Polyline();
            this.animatedOpen.initialize("2 1000 1800 2700 2250");
            this.animatedClosed.initialize("2 1000 1800 2700 1200");
            this.symbol.fastAddMember(this.animatedOpen);
            this.symbol.fastAddMember(this.animatedClosed);
            this.symbol.update_bbox();
            this.showState();
        }
        catch (Exception e) {
            this.message("-E- Switch.initDisplay(): " + e);
            e.printStackTrace();
        }
    }

    public void showState() {
        if (!this.visible) {
            return;
        }
        try {
            if (this.state == 1) {
                this.animatedOpen.setVisible(false);
                this.animatedClosed.setVisible(true);
            } else if (this.state == 0) {
                this.animatedOpen.setVisible(true);
                this.animatedClosed.setVisible(false);
            } else {
                this.animatedOpen.setVisible(false);
                this.animatedClosed.setVisible(false);
            }
            Color c = null;
            c = this.state == 1 ? Const1164.__1.getColor() : (this.state == 0 ? Const1164.__0.getColor() : Const1164.__U.getColor());
            this.animatedCircle.getAttributes().fillStyle = 2;
            this.animatedCircle.getAttributes().fillColor = c;
            if (this.symbol.painter != null) {
                this.symbol.painter.paint(this.symbol);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void mousePressed(MouseEvent me) {
        if (this.state == 2) {
            this.state = 0;
        } else if (this.state == 0) {
            this.state = 1;
        } else if (this.state == 1) {
            this.state = 0;
        }
        this.showState();
        this.scheduleOutputValueAfter(this.port_A, Const1164.__Z, this.delay);
        this.scheduleOutputValueAfter(this.port_A0, Const1164.__Z, this.delay);
        this.scheduleOutputValueAfter(this.port_A1, Const1164.__Z, this.delay);
    }

    public void elaborate(Object arg) {
        if (SimObject.debug) {
            this.message(this.toString() + ".elaborate()");
        }
        this.simulator = this.parent.getSimulator();
        this.assertIsSignalStdLogicSwitched(this.port_A.getSignal());
        this.assertIsSignalStdLogicSwitched(this.port_A0.getSignal());
        this.assertIsSignalStdLogicSwitched(this.port_A1.getSignal());
        this.scheduleOutputValueAfter(this.port_A, Const1164.__W, this.delay);
        this.scheduleOutputValueAfter(this.port_A0, Const1164.__W, this.delay);
        this.scheduleOutputValueAfter(this.port_A1, Const1164.__W, this.delay);
        this.showState();
    }

    public void evaluate(Object arg) {
        this.assertIsSignalStdLogicSwitched(this.port_A.getSignal());
        this.assertIsSignalStdLogicSwitched(this.port_A0.getSignal());
        this.assertIsSignalStdLogicSwitched(this.port_A1.getSignal());
        if (this.state == 2) {
            this.scheduleOutputValueAfter(this.port_A, Const1164.__W, this.delay);
            this.scheduleOutputValueAfter(this.port_A0, Const1164.__W, this.delay);
            this.scheduleOutputValueAfter(this.port_A1, Const1164.__W, this.delay);
        } else if (this.state == 0) {
            this.scheduleOutputValueAfter(this.port_A, Const1164.__Z, this.delay);
            this.scheduleOutputValueAfter(this.port_A0, Const1164.__Z, this.delay);
            this.scheduleOutputValueAfter(this.port_A1, Const1164.__Z, this.delay);
        } else if (this.state == 1) {
            this.scheduleOutputValueAfter(this.port_A, Const1164.__Z, this.delay);
            this.scheduleOutputValueAfter(this.port_A0, Const1164.__Z, this.delay);
            this.scheduleOutputValueAfter(this.port_A1, Const1164.__Z, this.delay);
        }
    }

    public void assertIsSignalStdLogicSwitched(Signal victim) {
        if (victim == null) {
            return;
        }
        if (victim.getClass() == (class$hades$signals$SignalStdLogicSwitched == null ? (class$hades$signals$SignalStdLogicSwitched = ISwitch.class$("hades.signals.SignalStdLogicSwitched")) : class$hades$signals$SignalStdLogicSwitched)) {
            return;
        }
        SignalStdLogicSwitched.assertIsSignalStdLogicSwitched(victim);
    }

    public void wakeup(Object arg) {
        try {
            Thread.dumpStack();
            this.state = 2;
            this.showState();
        }
        catch (Exception e) {
            System.err.println("-E- " + this.toString() + ".wakeup: " + e);
        }
    }

    public void configure() {
        if (SimObject.debug) {
            this.message("-I- starting to configure this " + this.toString());
        }
        String[] fields = new String[]{"instance name:", "name", "gate delay:", "delay"};
        this.propertySheet = PropertySheet.getPropertySheet(this, fields);
        this.propertySheet.setHelpText("Specify instance name, start value, and delay:");
        this.propertySheet.setVisible(true);
    }

    public String getToolTip(Point position, long millis) {
        String s = this.getBindkey();
        return this.getName() + "\n" + this.getClass().getName() + "\n" + "delay= " + this.delay + " [sec]\n" + "bindkey= " + (s == null ? "None" : s);
    }

    public void dbg(String s) {
        System.out.println(s);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

