/*
 * Decompiled with CFR 0.152.
 */
package hades.models.stimuli;

import hades.gui.PropertySheet;
import hades.manager.DesignManager;
import hades.models.Design;
import hades.models.stimuli.StimuliParser;
import hades.simulator.SimObject;
import hades.simulator.Simulatable;
import hades.utils.ContextToolTip;
import hades.utils.NameMangler;
import hades.utils.StringTokenizer;
import java.awt.Point;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;

public class StimuliGenerator
extends SimObject
implements Simulatable,
ContextToolTip,
Serializable {
    protected String stimuliFileName = "/hades/models/stimuli/dummy.sti";
    protected boolean enabled = true;

    public String getStimuliFileName() {
        return this.stimuliFileName;
    }

    public void setStimuliFileName(String s) {
        this.stimuliFileName = s;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean b) {
        this.enabled = b;
    }

    public void setEnabled(String s) {
        this.enabled = "true".equals(s);
    }

    public void configure() {
        String[] fields = new String[]{"instance name:", "name", "enabled [true/false]:", "enabled", "stimuli file:", "stimuliFileName"};
        this.propertySheet = PropertySheet.getPropertySheet(this, fields);
        this.propertySheet.setHelpText("Specify name and stimuli filename:");
        this.propertySheet.setVisible(true);
    }

    public boolean initialize(String s) {
        StringTokenizer st = new StringTokenizer(s);
        try {
            this.versionId = Integer.parseInt(st.nextToken());
            this.enabled = Integer.parseInt(st.nextToken()) == 1;
            this.stimuliFileName = NameMangler.decodeUnicodeEscapes(st.nextToken());
        }
        catch (Exception e) {
            this.message("-E- StimuliGenerator.initialize(): " + e + " " + s);
        }
        return true;
    }

    public void write(PrintWriter ps) {
        ps.print(" " + this.versionId + " " + (this.enabled ? "1" : "0") + " " + NameMangler.encodeWithUnicodeEscapes(this.stimuliFileName));
    }

    public void elaborate(Object arg) {
        block3: {
            if (SimObject.debug) {
                this.message("-I- " + this.toString() + ".elaborate()");
            }
            this.simulator = this.parent.getSimulator();
            if (!this.enabled || this.simulator == null) break block3;
            try {
                InputStream IS = DesignManager.getDesignManager().getInputStream(this, this.stimuliFileName);
                StimuliParser parser = new StimuliParser(IS);
                parser.setDesign((Design)this.parent);
                parser.setSimulator(this.simulator);
                parser.stimuli_file();
                IS.close();
            }
            catch (Throwable e) {
                System.err.println("-E- StimuliGenerator: " + e);
                e.printStackTrace();
            }
        }
    }

    public SimObject copy() {
        StimuliGenerator clone = (StimuliGenerator)super.copy();
        clone.setStimuliFileName(this.getStimuliFileName());
        return clone;
    }

    public String getToolTip(Point position, long millis) {
        return this.getName() + "\n" + this.getClass().getName() + "\n" + "file=" + this.stimuliFileName;
    }
}

