/*
 * Decompiled with CFR 0.152.
 */
package hades.models.special;

import hades.models.StdLogic1164;
import hades.signals.Signal;
import hades.simulator.Port;
import hades.simulator.SimEvent1164;
import hades.simulator.SimObject;
import hades.simulator.Simulatable;
import hades.symbols.Label;
import hades.symbols.Symbol;
import hades.utils.StringTokenizer;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.io.PrintWriter;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jfig.utils.ExceptionTracer;

public class HazardTrigger
extends SimObject
implements Simulatable,
ItemListener {
    private Port port_A;
    private Port port_Q;
    StdLogic1164 previousValue;
    StdLogic1164 currentValue;
    StdLogic1164 value_0;
    StdLogic1164 value_1;
    public static final int _U = 0;
    public static final int _X = 1;
    public static final int _0 = 2;
    public static final int _1 = 3;
    public static final int _Z = 4;
    public static final int _L = 5;
    public static final int _H = 6;
    public static final int _W = 7;
    public static final int _D = 8;
    public static final int _0L = 9;
    public static final int _1H = 10;
    public static final int _UX = 11;
    public static final int _ZWLHD = 12;
    public static final int _ANY = 13;
    public static final int _NONE = 14;
    protected String[] valueNames = new String[]{"U", "X", "0", "1", "Z", "L", "H", "W", "D", "0 or L (low)", "1 or H (high)", "U or X", "Z,W,H,L,D", "any", "none"};
    protected int activeValue;
    protected double duration;
    protected double maxDuration;
    protected double currentTime;
    protected double previousTime;
    protected boolean pauseSimulationFlag;
    protected boolean beepFlag;
    protected boolean logMessageFlag;
    protected Label symbolTypeLabel;
    JFrame topFrame;
    JPanel valuePanel;
    JPanel buttonPanel;
    JPanel actionPanel;
    JComboBox valueChoice;
    JTextField durationTF;
    JButton closeButton;
    JCheckBox beepCB;
    JCheckBox pauseSimulationCB;
    JCheckBox logMessageCB;

    public HazardTrigger() {
        this.ports = new Port[2];
        this.ports[0] = new Port(this, "A", 0, null);
        this.ports[1] = new Port(this, "Q", 1, null);
        this.port_A = this.ports[0];
        this.port_Q = this.ports[1];
        this.value_0 = new StdLogic1164(2);
        this.value_1 = new StdLogic1164(3);
        this.previousValue = new StdLogic1164(0);
        this.currentValue = new StdLogic1164(0);
        this.activeValue = 0;
        this.previousTime = 0.0;
        this.duration = 0.0;
        this.maxDuration = 1.0E-9;
        this.pauseSimulationFlag = false;
        this.beepFlag = true;
        this.logMessageFlag = true;
    }

    public void setSymbol(Symbol s) {
        this.symbol = s;
        this.symbol.setInstanceLabel(this.name);
        this.initDisplay();
    }

    private void initDisplay() {
        this.symbolTypeLabel = new Label();
        this.symbolTypeLabel.initialize("3300 500 3 any");
        this.symbolTypeLabel.setText("" + this.valueNames[this.activeValue] + " hazard");
        this.symbol.addMember(this.symbolTypeLabel);
        this.updateSymbol();
    }

    void buildValuePanel() {
        this.valuePanel = new JPanel(new FlowLayout(0));
        this.valueChoice = new JComboBox();
        int i = 0;
        while (i < this.valueNames.length) {
            this.valueChoice.addItem(this.valueNames[i]);
            ++i;
        }
        this.valueChoice.setSelectedIndex(this.activeValue);
        this.durationTF = new JTextField("" + this.maxDuration, 10);
        this.valuePanel.add(new JLabel("trigger on value:"));
        this.valuePanel.add(this.valueChoice);
        this.valuePanel.add(new JLabel("with duration <="));
        this.valuePanel.add(this.durationTF);
        this.valuePanel.add(new JLabel("sec."));
    }

    void buildActionPanel() {
        this.actionPanel = new JPanel(new FlowLayout(0));
        this.pauseSimulationCB = new JCheckBox("pause simulation", this.pauseSimulationFlag);
        this.beepCB = new JCheckBox("beep", this.beepFlag);
        this.logMessageCB = new JCheckBox("log message", this.logMessageFlag);
        this.actionPanel.add(new JLabel("trigger action:"));
        this.actionPanel.add(this.pauseSimulationCB);
        this.actionPanel.add(this.beepCB);
        this.actionPanel.add(this.logMessageCB);
    }

    void buildButtonPanel() {
        this.buttonPanel = new JPanel(new FlowLayout(0));
        this.closeButton = new JButton("close");
        this.buttonPanel.add(this.closeButton);
    }

    public void buildGUI() {
        this.topFrame = new JFrame("HazardTrigger " + this.getName());
        this.topFrame.setDefaultCloseOperation(1);
        this.buildValuePanel();
        this.buildActionPanel();
        this.buildButtonPanel();
        this.topFrame.getContentPane().setLayout(new GridLayout(3, 1));
        this.topFrame.getContentPane().add(this.valuePanel);
        this.topFrame.getContentPane().add(this.actionPanel);
        this.topFrame.getContentPane().add(this.buttonPanel);
        this.topFrame.pack();
    }

    public void buildGUICallbacks() {
        this.beepCB.addItemListener(this);
        this.pauseSimulationCB.addItemListener(this);
        this.logMessageCB.addItemListener(this);
        this.valueChoice.addItemListener(this);
        this.durationTF.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HazardTrigger.this.itemStateChanged(null);
            }
        });
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HazardTrigger.this.topFrame.setVisible(false);
            }
        });
    }

    public void itemStateChanged(ItemEvent evt) {
        if (SimObject.debug) {
            this.message("-I- itemStateChanged: " + evt);
        }
        this.activeValue = this.valueChoice.getSelectedIndex();
        try {
            this.maxDuration = Double.valueOf(this.durationTF.getText());
        }
        catch (Exception e) {
            this.message("-E- HazardTrigger: wrong number format, resetting to default!");
            this.maxDuration = 1.0E-9;
            this.durationTF.setText("" + this.maxDuration);
        }
        this.pauseSimulationFlag = this.pauseSimulationCB.isSelected();
        this.beepFlag = this.beepCB.isSelected();
        this.logMessageFlag = this.logMessageCB.isSelected();
        this.updateSymbol();
    }

    public void changeName() {
        this.message("-E- HazardTrigger.changeName(): NOT IMPLEMENTED YET!");
    }

    public void write(PrintWriter ps) {
        ps.print(" " + this.versionId + " " + this.activeValue + " " + this.maxDuration + " " + this.pauseSimulationFlag + " " + this.beepFlag + " " + this.logMessageFlag);
    }

    public boolean initialize(String s) {
        StringTokenizer st = new StringTokenizer(s);
        try {
            this.versionId = Integer.parseInt(st.nextToken());
            this.activeValue = Integer.parseInt(st.nextToken());
            this.maxDuration = Double.valueOf(st.nextToken());
            this.pauseSimulationFlag = st.nextToken().equals("true");
            this.beepFlag = st.nextToken().equals("true");
            this.logMessageFlag = st.nextToken().equals("true");
            if (SimObject.debug) {
                this.message("HazardTrigger.initialize: " + this.toString());
            }
        }
        catch (Exception e) {
            ExceptionTracer.trace(e);
            ExceptionTracer.message("-E- HazardTrigger.initialize(): " + s);
        }
        return true;
    }

    public void configure() {
        if (this.topFrame == null) {
            this.buildGUI();
            this.buildGUICallbacks();
        }
        this.topFrame.setVisible(true);
    }

    public Component getPropertySheet() {
        return this.topFrame;
    }

    public void mousePressed(MouseEvent me) {
        this.activeValue = (this.activeValue + 1) % this.valueNames.length;
        this.updateSymbol();
        if (this.valueChoice != null) {
            this.valueChoice.setSelectedIndex(this.activeValue);
        }
    }

    public void elaborate(Object arg) {
        if (SimObject.debug) {
            this.message(this.toString() + ".elaborate()");
        }
        this.simulator = this.parent.getSimulator();
        if (this.simulator == null) {
            return;
        }
        Signal signal_Q = this.port_Q.getSignal();
        double time = this.simulator.getSimTime();
        if (signal_Q != null) {
            this.simulator.scheduleEvent(SimEvent1164.createNewSimEvent((Simulatable)signal_Q, time, this.value_0, (Object)this.port_Q));
        }
    }

    public StdLogic1164 getInputValue(Port p) {
        Signal signal = p.getSignal();
        if (signal == null) {
            return new StdLogic1164();
        }
        StdLogic1164 value = (StdLogic1164)signal.getValue();
        if (value == null) {
            return new StdLogic1164();
        }
        return value;
    }

    public void evaluate(Object arg) {
        if (SimObject.debug) {
            System.err.println(this.toString() + ".evaluate()");
        }
        this.currentValue = this.getInputValue(this.port_A);
        this.currentTime = this.simulator.getSimTime();
        this.duration = this.currentTime - this.previousTime;
        if (this.match(this.previousValue, this.activeValue) && this.duration <= this.maxDuration) {
            this.trigger(arg);
        }
        this.previousValue = this.currentValue.copy();
        this.previousTime = this.currentTime;
    }

    public boolean match(StdLogic1164 value_A, int intValue) {
        switch (intValue) {
            case 0: {
                if (!value_A.is_U()) break;
                return true;
            }
            case 1: {
                if (!value_A.is_X()) break;
                return true;
            }
            case 2: {
                if (!value_A.is_0()) break;
                return true;
            }
            case 3: {
                if (!value_A.is_1()) break;
                return true;
            }
            case 4: {
                if (!value_A.is_Z()) break;
                return true;
            }
            case 5: {
                if (!value_A.is_L()) break;
                return true;
            }
            case 6: {
                if (!value_A.is_H()) break;
                return true;
            }
            case 7: {
                if (!value_A.is_W()) break;
                return true;
            }
            case 8: {
                if (!value_A.is_D()) break;
                return true;
            }
            case 9: {
                if (!value_A.isLow_0L()) break;
                return true;
            }
            case 10: {
                if (!value_A.isHigh_1H()) break;
                return true;
            }
            case 11: {
                if (!value_A.is_U() && !value_A.is_X()) break;
                return true;
            }
            case 12: {
                if (!value_A.is_Z() && !value_A.is_W() && !value_A.is_L() && !value_A.is_H() && !value_A.is_D()) break;
                return true;
            }
            case 14: {
                return false;
            }
            default: {
                return true;
            }
        }
        return false;
    }

    public void trigger(Object arg) {
        Signal signal_Q = this.port_Q.getSignal();
        double time = this.simulator.getSimTime();
        System.out.println(this.toString() + " triggered at t=" + time);
        if (signal_Q != null) {
            this.simulator.scheduleEvent(SimEvent1164.createNewSimEvent((Simulatable)signal_Q, time, this.value_1, (Object)this.port_Q));
            this.simulator.scheduleEvent(SimEvent1164.createNewSimEvent((Simulatable)signal_Q, time += 1.0E-9, this.value_0, (Object)this.port_Q));
        }
        if (this.beepFlag) {
            Toolkit.getDefaultToolkit().beep();
        }
        if (this.pauseSimulationFlag) {
            this.simulator.pauseSimulation();
        }
        if (this.logMessageFlag) {
            this.message("-T- " + this.toString() + " triggered at t= " + time + " by event: " + arg);
        }
    }

    public static String formatPaddedLong(long value, int n_chars) {
        String raw = Long.toString(value);
        StringBuffer sb = new StringBuffer();
        int n_zeroes = n_chars - raw.length();
        int i = 0;
        while (i < n_zeroes) {
            sb.append('0');
            ++i;
        }
        sb.append(raw);
        return sb.toString();
    }

    private void updateSymbol() {
        if (SimObject.debug) {
            this.message("-I- " + this.toString() + ".updateSymbol: ");
        }
        if (this.symbol == null || !this.symbol.isVisible()) {
            return;
        }
        if (this.symbol.painter == null) {
            return;
        }
        this.symbolTypeLabel.setText("" + this.valueNames[this.activeValue] + " hazard");
        this.symbol.painter.paint(this.symbol, 100);
    }

    public SimObject copy() {
        HazardTrigger tmp = null;
        try {
            tmp = (HazardTrigger)this.getClass().newInstance();
            tmp.setEditor(this.getEditor());
            tmp.setVisible(this.isVisible());
            tmp.setName(this.getName());
            tmp.setClassLoader(this.getClassLoader());
            tmp.activeValue = this.activeValue;
            return tmp;
        }
        catch (Exception e) {
            this.message("-E- Internal error in SimObject.copy(): " + e);
            return null;
        }
    }

    public String getToolTip(Point position, long millis) {
        return this.getName() + "\n" + this.getClass().getName() + "\n" + "value: " + this.valueNames[this.activeValue] + "\n" + "duration: " + this.duration;
    }

    public String toString() {
        return "HazardTrigger: " + this.getFullName();
    }

    public static void main(String[] argv) {
        HazardTrigger cc = new HazardTrigger();
        cc.buildGUI();
        cc.buildGUICallbacks();
        cc.topFrame.setVisible(true);
    }
}

