/*
 * Decompiled with CFR 0.152.
 */
package hades.models.special;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import jfig.gui.ImageHelper;
import jfig.utils.SetupManager;

public class GraphicsLCDCanvasuniv
extends Canvas {
    private BufferedImage bufferImage;
    private Graphics bufferGraphics;
    private boolean[][] bufferMemory;
    private Color lcdBackground;
    private int n_rows = 128;
    private int n_columns = 480;
    private int left_border = 5;
    private int top_border = 5;
    private int pixel_size = 1;
    private int pixel_spacer = 0;
    private int width = 100;
    private int height = 100;
    private int row = 0;
    private int col = 0;
    private boolean display_enable = true;

    public GraphicsLCDCanvasuniv() {
        this.setDefaultSize();
        this.createDefaultColors();
        this.createBufferImage();
        this.initializeBufferMemory();
    }

    public void setDefaultSize() {
        this.setSize(this.n_columns, this.n_rows);
    }

    public void setSize(int n_columns, int n_rows) {
        this.n_columns = n_columns;
        this.n_rows = n_rows;
    }

    public void createDefaultColors() {
        this.lcdBackground = SetupManager.getColor("Hades.GraphicsLCDCanvasuniv.lcdBackground33", new Color(181, 200, 10));
        this.setBackground(this.lcdBackground);
    }

    public void createBufferImage() {
        this.width = this.left_border * 2 + this.n_columns * this.pixel_size + (this.n_columns - 1) * this.pixel_spacer;
        this.height = this.top_border * 2 + this.n_rows * this.pixel_size + (this.n_rows - 1) * this.pixel_spacer;
        int type = 1;
        this.bufferImage = new BufferedImage(this.width, this.height, type);
        this.bufferGraphics = this.bufferImage.getGraphics();
        this.bufferGraphics.setColor(this.lcdBackground);
        this.bufferGraphics.fillRect(0, 0, this.width, this.height);
    }

    public void drawIntoBuffer(int data, int number_of_bits) {
        boolean dark = false;
        int mask = 1;
        if (this.col > this.n_columns) {
            // empty if block
        }
        int d = 0;
        while (d < number_of_bits) {
            if (this.col <= this.n_columns / 2) {
                int j = 0;
                while (j < 4) {
                    int part_col = (j & 1) > 0 ? this.col + this.n_columns / 2 : this.col;
                    int part_row = (j & 2) > 0 ? this.row + this.n_rows / 2 : this.row;
                    int x0 = this.left_border + (part_col - 1) * this.pixel_size + (part_col - 1) * this.pixel_spacer;
                    int y0 = this.top_border + (part_row - 1) * this.pixel_size + (part_row - 1) * this.pixel_spacer;
                    boolean bl = dark = (data & mask) > 0;
                    if (x0 < this.width && y0 < this.height) {
                        if (dark) {
                            this.bufferImage.setRGB(x0, y0, 32512);
                        } else {
                            this.bufferImage.setRGB(x0, y0, 0xFF0000);
                        }
                        mask <<= 1;
                    }
                    ++j;
                }
                ++this.col;
            }
            ++d;
        }
    }

    public void newLine() {
        this.repaint(100L);
        this.col = 1;
        ++this.row;
    }

    public void newFrame() {
        this.col = 1;
        this.row = 1;
    }

    public void initializeBufferMemory() {
        this.bufferMemory = new boolean[this.n_rows][this.n_columns];
        int p = 0;
        while (p < this.n_rows) {
            int c = 0;
            while (c < this.n_columns) {
                this.bufferMemory[p][c] = false;
                ++c;
            }
            ++p;
        }
    }

    public void write(int data, int number_of_bits) {
        this.drawIntoBuffer(data, number_of_bits);
    }

    public int read(int page, int col) {
        return 0;
    }

    public void clearDisplay() {
        this.newFrame();
        int p = 0;
        while (p < this.n_rows / 2) {
            int c = 0;
            while (c < this.n_columns / 2) {
                this.bufferMemory[p][c] = false;
                this.drawIntoBuffer(0, 1);
                ++c;
            }
            this.bufferGraphics.setColor(Color.white);
            this.bufferGraphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            this.repaint();
            ++p;
        }
    }

    public void enableDisplay(boolean b) {
        this.display_enable = b;
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        if (this.display_enable) {
            if (this.bufferImage != null) {
                g.drawImage(this.bufferImage, 0, 0, this);
            } else {
                GraphicsLCDCanvasuniv.msg("-E- " + this.toString() + " internal: bufferImage null!");
            }
        } else {
            g.clearRect(0, 0, this.width, this.height);
        }
        g.dispose();
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.width, this.height);
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public static void msg(String msg) {
        System.out.println(msg);
    }

    public static void main(String[] argv) {
        System.out.println("GraphicsLCDCanvasuniv selftest, please wait...ssss");
        Frame frame = new Frame("GraphicsLCDCanvasuniv selftestss");
        frame.setSize(100, 50);
        frame.setVisible(true);
        ImageHelper.setVisibleParent(frame);
        GraphicsLCDCanvasuniv lcd = new GraphicsLCDCanvasuniv();
        frame.add("Center", lcd);
        frame.pack();
        frame.setVisible(true);
        try {
            Thread.sleep(300L);
        }
        catch (Exception e) {
            // empty catch block
        }
        System.out.println("...starting random write...");
        int test = 0;
        while (test <= 5) {
            lcd.newFrame();
            int p = 0;
            while (p < lcd.n_rows / 2) {
                int c = 0;
                while (c < lcd.n_columns / 2) {
                    lcd.write(c, 1);
                    ++c;
                }
                lcd.newLine();
                ++p;
            }
            lcd.repaint(50L);
            try {
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                // empty catch block
            }
            ++test;
        }
    }
}

